<?php
//3 -------------------------------
//3 da ora in avanti edit solo qui!
//3 -------------------------------
//0 XMIND: [NUOVO ORAZIO]: aggiungo la funzione set (chiama la insert e update (con le _prepare) invece delle vecchie funzioni, mette dentro db in chiaro) 
//2 XMIND: [NUOVO ORAZIO]: //inversione dei parametri nella setcharset, correggo, no, ricorreggo era giusto
//1 XMIND: [NUOVO ORAZIO]: //porto il file negli originali [NUOVO ORAZIO]. Funziona con charset utf-8 di default, attento!
//0 XMIND: [TEST EMEDITALIA]: //aggiungo parametro opzionale alla update (nome campo da comparare)
/// XMIND: [TEST EMEDITALIA]: //correzione errno con un parametro (deve essere zero)
/// XMIND: [TALKINGNATURE]:/var/www/html/0998989273/libs/dbClass.inc.php - incorpora charset per DB
/// XMIND: [TALKINGNATURE]:/var/www/html/0998989273/libs/dbClass.inc.php
//0 incorpora la correzione della set_safe (chiamata a $this-> e non senza (chiamava quella di funzioni.inc.php!!!!!))
//1 incorpora la modifica per talkingnature con il set a utf8mb4
/// XMIND: [da EMA SUPERCENTRO A]:/home/admin/GRTU/newHostPrg/libs/dbClass.inc.php
// Revisione con set_safe added

class dbClass {

	private $db_sql_host;
	private $db_sql_user;
	private $db_sql_password;
	private $db_sql_name;
	private $db_sql_result;
	private $db_sql;
	private $charset;

	function createNewDatabase( $databaseName )
	{
		if(! mysqli_query($this->db_sql, "CREATE DATABASE " . $databaseName))
			return "failed to create database " . $databaseName . ":" . mysqli_error($this->db_sql);
		return "";
	}

	public function addUser($user, $passwd)
	{
		if(! mysqli_query($this->db_sql, "CREATE USER '" . $user . "'@'localhost' IDENTIFIED BY '" . $passwd . "';"))
			return "failed to create user:" . mysqli_error($this->db_sql);

		return "";
	}

	public function connectUser($user, $database)
	{
		if(! mysqli_query($this->db_sql, "GRANT ALL ON " . $database . ".* TO '" . $user . "'@'localhost'"))
			return "failed assigning db to user:" . mysqli_error($this->db_sql);

		return "";
	}

	public function __destruct()
	{
		if( $this->db_sql != NULL )
			mysqli_close ( $this->db_sql );
	}

	public function __construct( $host, $dbName, $usName, $psswd, $ilCharset="utf8mb4" ) 
	{
		$this->db_sql_host = $host;
		$this->db_sql_user = $usName;
		$this->db_sql_password = $psswd;
		$this->db_sql_name = $dbName;
		$this->db_sql_result = NULL;
		$this->db_sql = NULL;
		$this->charset = $ilCharset;
		$this->ck();
	} 

	public function getName()
	{
		return $this->db_sql_name;
	}

	public function isok() /// checkisok
	{
		if( $this->db_sql == NULL )
			return false;

		if (!mysqli_ping($this->db_sql) || mysqli_connect_errno()) 
			return false;
		
		return true;
	}

	public function ck() /// check and reconnect, in case  
	{
		if( !isset( $this->db_sql) || ($this->db_sql == NULL))
		{
			@$this->db_sql = mysqli_connect($this->db_sql_host, $this->db_sql_user, $this->db_sql_password, $this->db_sql_name);
			$this->db_sql_result = NULL;
			if($this->db_sql == FALSE)
				return false;
			mysqli_set_charset($this->db_sql, $this->charset);
		}
		else
		{
			// verifico che il db_sql sia collegato
			if (!mysqli_ping($this->db_sql) || mysqli_connect_errno()) 
			{
				$this->db_sql = mysqli_connect($this->db_sql_host, $this->db_sql_user, $this->db_sql_password, $this->db_sql_name);
				$this->db_sql_result = NULL;
				if($this->db_sql == FALSE)
					return false;
			}
		}
		
		return true;
	}

	function _prepare( $stringa)
	{
		return mysqli_real_escape_string( $this->db_sql, $stringa);
	}

	function _coded( $stringa) 
	{
		if( !is_string( $stringa))
			return $stringa;
		
		$len = strlen($stringa);
		$output = "";
		for( $t=0; $t<$len; $t++) 
		{
			if( /*($stringa[$t] != "'") && ($stringa[$t] != '"') && ($stringa[$t] != '@')*/
			(($stringa[$t] >= '0') && ($stringa[$t] <= '9') ) ||
			(($stringa[$t] >= 'a') && ($stringa[$t] <= 'z') ) ||
			(($stringa[$t] >= 'A') && ($stringa[$t] <= 'Z') ) 
			)
				$output .= $stringa[$t];
			else
				$output .= "@" . bin2hex($stringa[$t]);
		}

		return $output;
	}

	private function _clear( $stringa)
	{
		if( !is_string( $stringa))
			return $stringa;
		
		$len = strlen($stringa);
		$output = "";
		for( $t=0; $t<$len; $t++)
		{
			if( $stringa[$t] != '@')
				$output .= $stringa[$t];
			else
			{
				if( $t <= ($len-3))
				{
					$asome = substr( $stringa , $t+1, 2);
					if (ctype_xdigit ( $asome ))
					{
						$output .= hex2bin( $asome );
						$t+=2;
					}
					else
						$output .= $stringa[$t];
				}
				else
					$output .= $stringa[$t];
			}
		}
		return $output;
	}

	function tV( $stringa)
	{
		return $this->_coded( $stringa);
	}

	function mV( $stringa)
	{
		if( !is_string( $stringa))
			return $stringa;

		return $this->_clear( $stringa);
	}

	function set( $nomeTabella, $record, $campo, $valoreComp) // where $campo == $valoreComp
	{
		if( !$this->ck()) return -1;
		if( !isset( $record) || !is_array($record)) return -2;
		if($campo == "") return -23;
		if($nomeTabella == "") return -26;

		if( isset( $record['id']))
			unset( $record['id']);

		if( $this->db_sql_get( $nomeTabella, $campo, $valoreComp) )
			return $this->update( $nomeTabella, $record, $campo, $valoreComp);

		return $this->insert($nomeTabella, $record);
	}

	//2 ---------------------------------------------------------------------------------
	//2 update cruda
	//2 ---------------------------------------------------------------------------------
	function simpleUpdate( $nomeTabella, $record, $condizione )
	{
		if( !$this->ck()) return -1;
		if( !isset( $record) || !is_array($record)) return -2;
		if($nomeTabella == "") return -26;
		if($condizione == NULL || $condizione == "")
			$condizione = "1=1";

		$q = "UPDATE " . trim($nomeTabella) . " SET ";
		$t = 0;
		foreach($record as $chiave=>$valore) 
		{
			if($t++)
				$q .= "," . $chiave . "='" . $valore . "' ";
			else
				$q .= $chiave . "='" . $valore . "' ";
		}

		$q .= " WHERE {$condizione};";

		if (!mysqli_query($this->db_sql, $q))
			return -33;

		return 0;
	}
	//2 ---------------------------------------------------------------------------------

	function db_sql_insert( $nomeTabella, $record) // record singolo
	{
		if( !$this->ck()) return -1;

		if( !isset( $record) || !is_array($record))
			return -2;

		if($nomeTabella == "") return -26;
	
		//
		// a scanso di equivoci, id  sempre e solo in lettura
		//
		if( isset( $record['id']))
			unset( $record['id']);

		$q = "INSERT INTO " . trim($nomeTabella) . " (";

		$t = 0;
		foreach($record as $chiave=>$valore) 
		{
			if( $chiave == "")
				return -4;

			if($t++)
				$q .= "," . $chiave;
			else
				$q .= $chiave;
		}


		$q .= ") VALUES ('";

		$t = 0;
		foreach($record as $valore) {

			if($t++)
				$q .= "','" . $this->_coded($valore);
			else
				$q .= $this->_coded($valore);
		}

		$q .= "')";

		if (!mysqli_query($this->db_sql, $q))
			return -30;

		return mysqli_insert_id($this->db_sql);

	}

	function db_sql_update( $nomeTabella, $record, $campo, $valoreComp) // where $campo == $valoreComp
	{
		if( !$this->ck()) return -1;

		if( !isset( $record) || !is_array($record)) return -2;

		if($campo == "") return -23;

		if($nomeTabella == "") return -26;

		// a scanso di equivoci, id solo in lettura
		if( isset( $record['id']))
			unset( $record['id']);
	
		$q = "UPDATE " . trim($nomeTabella) . " SET ";

		$t = 0;
		foreach($record as $chiave=>$valore) {
			if($t++)
				$q .= "," . $chiave . "='" . $this->_coded($valore) . "' ";
			else
				$q .= $chiave . "='" . $this->_coded($valore) . "' ";
		}

		$q .= " WHERE " . $campo . "='" . $this->_coded($valoreComp) . "'";

		if (!mysqli_query($this->db_sql, $q))
			return -33;

		return 0;
	}
	//0 ---------------------------------------------------------------------------------
	//0 LA FUNZIONE NON USA LA GESTIONE ESPANSA DI tV mV -> usa _prepare invece di _coded
	//0 UPDATE secondo campo specifico
	//0 ---------------------------------------------------------------------------------
	function update( $nomeTabella, $record, $nomeCampo ) /// sulla base del nome campo
	{
		if( !$this->ck()) return -1;
		if( !isset( $record) || !is_array($record)) return -2;
		if($nomeTabella == "") return -26;
		if($nomeCampo == NULL || $nomeCampo == "")
			$nomeCampo = "id";

		if( !isset( $record[ $nomeCampo]))
			return -555; /// deve esistere ID

		$valoreCampo = $record[$nomeCampo];

		$q = "UPDATE " . trim($nomeTabella) . " SET ";

		$t = 0;
		foreach($record as $chiave=>$valore) {
			if($t++)
				$q .= "," . $chiave . "='" . $this->_prepare($valore) . "' ";
			else
				$q .= $chiave . "='" . $this->_prepare($valore) . "' ";
		}

		$q .= " WHERE {$nomeCampo}='" . $this->_prepare($valoreCampo) . "'";

		if (!mysqli_query($this->db_sql, $q))
			return -33;

		return 0;
	}
	//// ---------------------------------------------------------------------------------
	//// LA FUNZIONE NON USA LA GESTIONE ESPANSA DI tV mV -> usa _prepare invece di _coded
	//// INSERT
	//// ---------------------------------------------------------------------------------
	function insert( $nomeTabella, $record) // record singolo
	{
		if( !$this->ck()) return -1;

		if( !isset( $record) || !is_array($record))
			return -2;

		if($nomeTabella == "") return -26;
	
		//
		// a scanso di equivoci, id  sempre e solo in lettura
		//
		if( isset( $record['id']))
			unset( $record['id']);

		$q = "INSERT INTO " . trim($nomeTabella) . " (";

		$t = 0;
		foreach($record as $chiave=>$valore) 
		{
			if( $chiave == "")
				return -4;

			if($t++)
				$q .= "," . $chiave;
			else
				$q .= $chiave;
		}

		$q .= ") VALUES ('";

		$t = 0;
		foreach($record as $valore) {

			if($t++)
				$q .= "','" . $this->_prepare($valore);
			else
				$q .= $this->_prepare($valore);
		}

		$q .= "')";

		if (!mysqli_query($this->db_sql, $q))
			return -30;

		return mysqli_insert_id($this->db_sql);
	}
	//// ---------------------------------------------------------------------------------
	//// LA FUNZIONE NON USA LA GESTIONE ESPANSA DI tV mV -> usa _prepare invece di _coded
	//// GET (come dbGet ma senza la _clear())
	//// ---------------------------------------------------------------------------------
	function get($q=NULL) // tutta la query incluso select
	{
		if( !$this->ck()) return NULL;

		$tb_record = array();

		if( $q ) {
			if( $this->db_sql_result )
				mysqli_free_result($this->db_sql_result);
			$this->db_sql_result = @mysqli_query($this->db_sql, $q);
		}

		if($aRecord = @mysqli_fetch_assoc($this->db_sql_result)) 
		{
			if( isset($aRecord) && is_array($aRecord)) {
				foreach( $aRecord as $chiave=>$valore)
					$tb_record[$chiave] = $valore;
			}
		} 
		else 
		{
			if( $this->db_sql_result)
				mysqli_free_result($this->db_sql_result);
			$this->db_sql_result = NULL;
		}

		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	function db_sql_get( $nomeTabella, $campo, $valoreComp) // where $campo == $valoreComp > tutti i record
	{
		if( !$this->ck()) return NULL;
		if($campo == "") return NULL;
		if($nomeTabella == "") return NULL;

		$q = "SELECT * FROM " . $nomeTabella . " WHERE " . $campo . " = '" . $this->_coded($valoreComp) ."'";

		unset($tb_record);
	
		$result = @mysqli_query($this->db_sql, $q);
		while($aRecord = @mysqli_fetch_assoc($result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				$nuovo = array();
				foreach( $aRecord as $chiave=>$valore)
					$nuovo[$chiave] = $this->_clear($valore);
				$tb_record[$nuovo['id']] = $nuovo; // ASSUMPTION: ID EXISTS
			}
		}

		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!

	function db_sql_get_check( $nomeTabella, $campo, $valoreComp, &$err) // where $campo == $valoreComp > tutti i record
	{
		if( !$this->ck()) {$err=-1; return NULL;};

		if($campo == "") {$err=-2; return NULL;};
		if($nomeTabella == "") {$err=-3; return NULL;};

		$q = "SELECT * FROM " . $nomeTabella . " WHERE " . $campo . " = '" . $this->_coded($valoreComp) ."'";

		unset($tb_record);
	
		$result = @mysqli_query($this->db_sql, $q);
		while($aRecord = @mysqli_fetch_assoc($result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				$nuovo = array();
				foreach( $aRecord as $chiave=>$valore)
					$nuovo[$chiave] = $this->_clear($valore);
				$tb_record[$nuovo['id']] = $nuovo; // ASSUMPTION: ID EXISTS
			}
		}

		if( isset( $tb_record))
			return $tb_record;

		$err = 0;
		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!
	// attenzione alla gestione delle virgolette nel comporre la select (vanno tolte dalle stringhe)
	function db_sql_get_select( $nomeTabella, $select) //  proprio la select subito dopo "WHERE "
	{
		if( !$this->ck()) return NULL;
		if($select == "") return NULL;
		if($nomeTabella == "") return NULL;

		$q = "SELECT * FROM " . $nomeTabella . " WHERE " . $select; // OCCHIO, togliere le virgolette dove serve, altrimenti potrebbe non funzionare la select!!!!!

		unset($tb_record);
	
		$result = @mysqli_query($this->db_sql, $q);
		while($aRecord = @mysqli_fetch_assoc($result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				$nuovo = array();
				foreach( $aRecord as $chiave=>$valore)
					$nuovo[$chiave] = $this->_clear($valore);
				$tb_record[$nuovo['id']] = $nuovo; // ASSUMPTION: ID EXISTS
			}
		}


		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!
	function db_sql_set( $nomeTabella, $record, $campo, $valoreComp) // where $campo == $valoreComp
	{
		if( !$this->ck()) return -1;
		if( !isset( $record) || !is_array($record)) return -2;
		if($campo == "") return -23;
		if($nomeTabella == "") return -26;

		if( isset( $record['id']))
			unset( $record['id']);

		if( $this->db_sql_get( $nomeTabella, $campo, $valoreComp) )
			return $this->db_sql_update( $nomeTabella, $record, $campo, $valoreComp);

		return $this->db_sql_insert($nomeTabella, $record);
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!
	function db_sql_set_safe( $nomeTabella, $record, $campo ) // where $campo == $valoreComp
	{
		if( !$this->ck()) return -1;
		if( !isset( $record) || !is_array($record)) return -2;
		if($campo == "") return -23;
		if($nomeTabella == "") return -26;

		if( !isset( $record[$campo]) || $record[$campo] == "")
			return -88;

		if( isset( $record['id']))
			unset( $record['id']);

		if( $this->db_sql_get( $nomeTabella, $campo, $record[$campo]) )
			return $this->db_sql_update( $nomeTabella, $record, $campo, $record[$campo]);

		return $this->db_sql_insert($nomeTabella, $record);
	}


	function db_sql_delete( $nomeTabella, $campo, $valoreComp) // where $campo == $valoreComp > tutti i record
	{
		if( !$this->ck()) return -1;
		if($campo == "") return -2;
		if($nomeTabella == "") return -3;

		$q = "DELETE FROM " . $nomeTabella . " WHERE " . $campo . " = '" . $this->_coded($valoreComp) ."'";

		$rx = @mysqli_query($this->db_sql, $q);

		return mysqli_affected_rows($this->db_sql);
	}

	// ------------------------------------------------------------
	// ATTENZIONE: usare TOGLI VIRGOLETTE nei valori dei campi!!!
	// ------------------------------------------------------------
	function dbDelete( $nomeTabella, $whereClause) // where $campo == $valoreComp > tutti i record
	{
		if( !$this->ck()) return -1;
		if($nomeTabella == "") return -3;

		$q = "DELETE FROM " . $nomeTabella . " WHERE " . $whereClause . ";";

		$rx = @mysqli_query($this->db_sql, $q);

		return mysqli_affected_rows($this->db_sql);
	}

	function db_sql_get_first( $nomeTabella, $campo, $valoreComp) // where $campo == $valoreComp > tutti i record
	{
		if( !$this->ck()) return NULL;
		if($campo == "") return NULL;
		if($nomeTabella == "") return NULL;

		$q = "SELECT * FROM " . $nomeTabella . " WHERE " . $campo . " = '" . $this->_coded($valoreComp) ."'";

		unset($tb_record);
	
		$result = @mysqli_query($this->db_sql, $q);
		if($aRecord = @mysqli_fetch_assoc($result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				foreach( $aRecord as $chiave=>$valore)
					$tb_record[$chiave] = $this->_clear($valore);
			}
		}

		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!
	// attenzione alla gestione delle virgolette nel comporre la select (vanno tolte dalle stringhe prima di comporre la query)
	function db_sql_free_select( $select) //  proprio la select, tutta tutta
	{
		if( !$this->ck()) return NULL;
		if($select == "") return NULL;

		unset($tb_record);
	
		$result = @mysqli_query($this->db_sql, $select);
		while($aRecord = @mysqli_fetch_assoc($result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				$nuovo = array();
				foreach( $aRecord as $chiave=>$valore)
					$nuovo[$chiave] = $this->_clear($valore);
				$tb_record[$nuovo['id']] = $nuovo; // ASSUMPTION: ID EXISTS
			}
		}

		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!

	/* ------------------------------------------------------------------------------ 	*/
	/*						 				ATTENZIONE!!!									*/
	/* per questa funzione bisogna usare la "togliVirgolette" per il valore del campo 	*/
	/*						 				ATTENZIONE!!!									*/
	/* ------------------------------------------------------------------------------ 	*/
	function dbGet($q=NULL) // tutta la query incluso select
	{
		if( !$this->ck()) return NULL;

		$tb_record = array();

		if( $q ) {
			if( $this->db_sql_result )
				mysqli_free_result($this->db_sql_result);
			$this->db_sql_result = @mysqli_query($this->db_sql, $q);
		}

		if($aRecord = @mysqli_fetch_assoc($this->db_sql_result)) 
		{
			if( isset($aRecord) && is_array($aRecord)) {
				foreach( $aRecord as $chiave=>$valore)
					$tb_record[$chiave] = $this->_clear($valore);
			}
		} 
		else 
		{
			if( $this->db_sql_result)
				mysqli_free_result($this->db_sql_result);
			$this->db_sql_result = NULL;
		}


		if( isset( $tb_record))
			return $tb_record;

		return NULL;
	}

	// ATTENZIONE: qualsiasi tabella DEVE avere il campo ID!!!

	/* ------------------------------------------------------------------------------ */
	/* 				ATTENZIONE!!!					  */
	/* per questa funzione bisogna usare la "togliVirgolette" per il valore del campo */
	/* 				ATTENZIONE!!!					  */
	/* ------------------------------------------------------------------------------ */
	function dbQuery($q) // tutta la query incluso select
	{
		if( !$this->ck()) return -10001;
	
		if( $q == "" )
			return -10002;

		@mysqli_query($this->db_sql, $q);

		return mysqli_affected_rows ( $this->db_sql );
	}

	/* ------------------------------------------------------------------------------ */
	/* 				ATTENZIONE!!!					  */
	/* per questa funzione bisogna usare la "togliVirgolette" per il valore del campo */
	/* 				ATTENZIONE!!!					  */
	/* ------------------------------------------------------------------------------ */
	function dbGetParameter($name=NULL) // sulla tb_generali
	{
		if( !$this->ck()) return NULL;

		$q = "SELECT * FROM tb_generali WHERE nome='" . tV($name) . "';";

		$tb_record = array();

	/* INTERFERISCE CON LA dbGet? -> non sicuro!!! VELENO

		if( $this->db_sql_result)	
			mysqli_free_result($this->db_sql_result);
				$this->db_sql_result = @mysqli_query($this->db_sql, $q);
		} */

		$this->q_result = @mysqli_query($this->db_sql, $q);

		if($aRecord = @mysqli_fetch_assoc($this->q_result)) {
			if( isset($aRecord) && is_array($aRecord)) {
				foreach( $aRecord as $chiave=>$valore)
					$tb_record[$chiave] = $this->_clear($valore);
			}
		}


		if( isset( $tb_record['valore']))
			return $tb_record['valore'];

		return NULL;
	}

	// SISTEMA IN CENTESIMI (VECCHIO ENOENERGY)
	function calculateCreditFull( $cliente)
	{
		if( !$this->ck()) return NULL;

		if( !isset( $cliente['codiceFiscale']))
			return NULL;

		$allTrans = $this->db_sql_get( "tb_transazioni", "codiceFiscale", $cliente['codiceFiscale'] );
		$creditoTotale = 0;


		if( isset($allTrans) && (is_array( $allTrans)) )
		   foreach( $allTrans as $v)
		{
			$creditoTotale -= $v['centesimiSpesi'];
			$creditoTotale += $v['centesimiCaricati'];
		} // end foreach

		// modifica per accettare una transazione iniziale
		$credito_iniziale = $cliente['credito'];

		if( $credito_iniziale != "")
			$creditoTotale = $creditoTotale + intval( $credito_iniziale);

///		questa parte di programma serve per ricordare che hostProcess invia fino a 300 euro max (problema delle RTU)
///		echo "\n\rCredito:" . $creditoTotale; if( $creditoTotale < 0 ) $creditoTotale = 0; if( $creditoTotale > 30000 ) $creditoTotale = 30000;

		$cliente['credito'] = $creditoTotale . "";
		return $cliente;
	}

	// SISTEMA NUOVO IN MILLESIMI
	function getFullCreditMillesimiFree( $fiscalCode, $creditoInizialeInMillesimi )
	{
		if( !$this->ck()) return 0;

		$allTrans = $this->db_sql_get( "tb_transazioni", "codiceFiscale", $fiscalCode );

		$creditoTotale = 0;

		if( isset($allTrans) && (is_array( $allTrans)) )
		{
			foreach( $allTrans as $v)
			{
				$creditoTotale -= intval($v['millesimiSpesi']);
				$creditoTotale += intval($v['millesimiCaricati']);
			} // end foreach
		}

		$creditoTotale = $creditoTotale + intval( $creditoInizialeInMillesimi);
		return $creditoTotale;
	}

	// sorgente  una stringa formattata HEX, ma non sono tenuto a sapere cosa contenga, tanto la prendo e la salvo
	// per accedere uso memRead e memWrite
	function memWrite( $sourceMemory, $value, $position, $len) // ritorna la stringa correttamente aggiornata
	{
		if( strlen( $sourceMemory) && !ctype_xdigit( $sourceMemory )) return NULL; // la sorgente deve essere esadecimale corretta
		if( strlen( $value) > $len) return $sourceMemory; // se tento di scrivere un valore pi grande mi ritorna errore

		$binSourceMemory = "";
		if( strlen( $sourceMemory))
			$binSourceMemory = hex2bin($sourceMemory); // memoria in chiaro

		// preparo la stringa/memoria iniziale, potrebbe essere pi corta del necessario
		$binSourceMemory = str_pad($binSourceMemory, $position + $len, "\0");

	
		// preparo anche la stringa valore
		$value = str_pad($value . "", $len, "\0");


		$binSourceMemory = substr_replace( $binSourceMemory, $value, $position, $len);


		return bin2hex( $binSourceMemory);

	}

	function memRead( $sourceMemory, $position, $len)
	{
		if( !ctype_xdigit( $sourceMemory )) return NULL; // la sorgente deve essere esadecimale corretta

		$binSourceMemory = hex2bin($sourceMemory); // memoria in chiaro

		$retValue = substr( $binSourceMemory, $position, $len );

		return strtok( $retValue, "\0");
	}

}


?>
