/// _[PAGINE PROGETTO SPECIFICHE: PDTRENTO]
/// _[CLASSE PROGETTO] quella di PD TRENTO (temporaneamente nel direttorio 0002-octopus)
/// _[CLASSE PROGETTO: INTERVENTI] tipo 5, interventi
/// _[CLASSE PROGETTO: admin]

project data
	main-domain-name
		awgp.it
	relativeDirectory
		sia/octopus/assets
	getFavicon
		return "/images/favicon.png";

	getTitle
		<[
			$what = 'Ordine dei Geologi - Amministratore di sistema';
			return $what;
		]>

	getDescription
		<[
			$what = "Ordine dei Geologi - Amministratore di sistema";
			return $what;
		]>

	getKeywords
		<[
			return "System Admin - Creative Software Lab";
		]>

/// icona presente in login e main in alto a sx
	getMainIcon
		<[
			return "/images/ogtaa/ogtaa.png";
		]>

	menu info
		ADMIN
			Avvisi: edWelcome, fa fa-home
			Documenti: null_1, fa fa-key
				Documenti Pubblici: edPublicDocs_admin, fa fa-file-o
				Documenti per utente: edUser_admin, fa fa-users
			Admin: null_2, fa fa-cog
				Tipologia di Documenti: tbTipoDocumenti, fa fa-bars
				Gestisci avvisi: edMessaggi_admin, fa fa-bullhorn
			Logout: cmdLogout, fa fa-power-off

		ROOT
			Avvisi: edWelcome, fa fa-home
			Home: edUser_admin, fa fa-users
			Admin: null_1, fa fa-key
				Utenti: null_32, fa fa-users
					Utenti: tbEditUtenti, fa fa-users
					Log Accessi: tbUtentiLog, fa fa-bars
				Configurazione: null_43, fa fa-bars
					Tipologia di Documenti: tbTipoDocumenti, fa fa-bars
				Gestisci avvisi: edMessaggi_admin, fa fa-bullhorn
			Logout: cmdLogout, fa fa-power-off

		USER
			Avvisi: edWelcome, fa fa-home
			Documenti: null_123, fa fa-file-o
				Documenti pubblici: edUserShowPublicDocs, fa fa-file-pdf-o
				Documenti privati: edUserShowPrivateDocs, fa fa-key
			Logout: cmdLogout, fa fa-power-off

// _[VECCHIA ROBA sdfsfsf]



frameMain
	di tipo
		project data
	init
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		if( isset($gbl_userId ) && $gbl_userId!=0 && $gbl_idSessione!=0 )
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		]>
	_exe
		<[
		{{=init=}}
		$what = <<<EOT
		<!doctype html>
		<html class="fixed">
			<head>
		
				<!-- Basic -->
				<meta charset="UTF-8">
				<!-- <meta http-equiv="content-type" content="text/html; charset=utf-8"> -->
		
				<title>{{=getTitle=}}</title>
				<meta name="keywords" content="{{=getKeywords=}}" />
				<meta name="description" content="{{=getDescription=}}">
				<meta name="author" content="Orazio Rizzo - Creative Software Lab">
		
				<!-- Mobile Metas -->
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		
				<!-- FAVICON -->
				<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
		
				<!-- Web Fonts  -->
				<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		
				<!-- Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
		
				<!-- DATATABLES FILES -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/select2/select2.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/jquery-datatables-bs3/assets/css/datatables.css" />
		
				<!-- Specific Page Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/jquery-ui/css/ui-lightness/jquery-ui-1.10.4.custom.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-multiselect/bootstrap-multiselect.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/morris/morris.css" />
			
		///		non funziona correttamente, per ora lo elimino (checkbox delle righe)
		///		<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/select/1.3.1/css/select.dataTables.min.css">
		
				<!--ADDITIONAL CSS BARE FRAME-->
		
				<!-- Theme CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
		
				<!-- Skin CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
		
				<!-- Theme Custom CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
		
				<!-- Theme Orazio -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/orazio.css">
		
				<!-- Head Libs -->
				<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
		
			</head>
			<body>
					
							<section class="body">
								<!-- start: header -->
								<header class="header">
									
													<div class="logo-container">
														<a href="index.php?fx=main" class="logo">
															<img src="{{=getMainIcon=}}" height="35" alt="<!--main-domain-name-->" />
														</a>
														<div class="visible-xs toggle-sidebar-left" data-toggle-class="sidebar-left-opened" data-target="html" data-fire-event="sidebar-left-opened">
															<i class="fa fa-bars" aria-label="Toggle sidebar"></i>
														</div>
													</div>
												
													<!-- start: search & user box -->
													<div class="header-right">
												
									/// _[SEZIONE RICERCA IN ALTO A DESTRA]
									
														{{=getMainCustomerName=}}
									
														<span class="separator"></span>
												
														{{=getQuickNotifica=}}
									
									/// _[SEZIONE NOTIFICHE IN ALTO A DESTRA]
									///
									///					<span class="separator"></span>
												
														{{=getSezioneUserBox=}}
									
									///	_[SEZIONE USERBOX]
									
													</div>
													<!-- end: search & user box -->
									
								</header>
								<!-- end: header -->
					
								<div class="inner-wrapper" <!--innerWrapperStyle-->>
									<!-- start: sidebar -->
									<aside id="sidebar-left" class="sidebar-left">
					///					MENU LATERALE SINISTRO ED ALTRO
					///					_[OCTOPUS SIDEBAR CONTENT]
									{{=getMainMenu=}}
									</aside>
									<!-- end: sidebar -->
					
									<section role="main" class="content-body">
										{{=getBreadcrumbsLine=}}
										
										
										/// _[OCTOPUS CONTENT: TIPO DASHBOARD]
										
										/// _[OCTOPUS CONTENT: TIPO TABELLA EDITABILE]
										
										/// _[OCTOPUS CONTENT: MESSAGGI WELCOME]
										
										
										{{=getOctopusMainContent=}}
										
									</section>
								</div>
					
								<aside id="sidebar-right" class="sidebar-right">
									
													<div class="nano">
														<div class="nano-content">
															<a href="#" class="mobile-close visible-xs">
																Collapse <i class="fa fa-chevron-right"></i>
															</a>
												
															<div class="sidebar-right-wrapper">
												
																<div class="sidebar-widget widget-calendar">
																	<h6>Upcoming Tasks</h6>
																	<div data-plugin-datepicker data-plugin-skin="dark" ></div>
												
																	<ul>
																		<li>
																			<time datetime="2014-04-19T00:00+00:00">04/19/2014</time>
																			<span>Company Meeting</span>
																		</li>
																	</ul>
																</div>
												
																<div class="sidebar-widget widget-friends">
																	<h6>Friends</h6>
																	<ul>
																		<li class="status-online">
																			<figure class="profile-picture">
																				<img src="<!--relativeDirectory-->/images/!sample-user.jpg" alt="Joseph Doe" class="img-circle">
																			</figure>
																			<div class="profile-info">
																				<span class="name">Joseph Doe Junior</span>
																				<span class="title">Hey, how are you?</span>
																			</div>
																		</li>
																		<li class="status-online">
																			<figure class="profile-picture">
																				<img src="<!--relativeDirectory-->/images/!sample-user.jpg" alt="Joseph Doe" class="img-circle">
																			</figure>
																			<div class="profile-info">
																				<span class="name">Joseph Doe Junior</span>
																				<span class="title">Hey, how are you?</span>
																			</div>
																		</li>
																		<li class="status-offline">
																			<figure class="profile-picture">
																				<img src="<!--relativeDirectory-->/images/!sample-user.jpg" alt="Joseph Doe" class="img-circle">
																			</figure>
																			<div class="profile-info">
																				<span class="name">Joseph Doe Junior</span>
																				<span class="title">Hey, how are you?</span>
																			</div>
																		</li>
																		<li class="status-offline">
																			<figure class="profile-picture">
																				<img src="<!--relativeDirectory-->/images/!sample-user.jpg" alt="Joseph Doe" class="img-circle">
																			</figure>
																			<div class="profile-info">
																				<span class="name">Joseph Doe Junior</span>
																				<span class="title">Hey, how are you?</span>
																			</div>
																		</li>
																	</ul>
																</div>
												
															</div>
														</div>
													</div>
								</aside>
							</section>
					
							{{=getPopupDialogBox=}}
					
							<!-- Vendor -->
							<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
							<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
							<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
							<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
							<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
							<!-- Specific Page Vendor -->
							<script src="<!--relativeDirectory-->/vendor/jquery-ui/js/jquery-ui-1.10.4.custom.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-ui-touch-punch/jquery.ui.touch-punch.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-appear/jquery.appear.js"></script>
							<script src="<!--relativeDirectory-->/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-easypiechart/jquery.easypiechart.js"></script>
							<script src="<!--relativeDirectory-->/vendor/flot/jquery.flot.js"></script>
							<script src="<!--relativeDirectory-->/vendor/flot-tooltip/jquery.flot.tooltip.js"></script>
							<script src="<!--relativeDirectory-->/vendor/flot/jquery.flot.pie.js"></script>
							<script src="<!--relativeDirectory-->/vendor/flot/jquery.flot.categories.js"></script>
							<script src="<!--relativeDirectory-->/vendor/flot/jquery.flot.resize.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-sparkline/jquery.sparkline.js"></script>
							<script src="<!--relativeDirectory-->/vendor/raphael/raphael.js"></script>
							<script src="<!--relativeDirectory-->/vendor/morris/morris.js"></script>
							<script src="<!--relativeDirectory-->/vendor/gauge/gauge.js"></script>
							<script src="<!--relativeDirectory-->/vendor/snap-svg/snap.svg.js"></script>
							<script src="<!--relativeDirectory-->/vendor/liquid-meter/liquid.meter.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/jquery.vmap.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/data/jquery.vmap.sampledata.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/jquery.vmap.world.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.africa.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.asia.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.australia.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.europe.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.north-america.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jqvmap/maps/continents/jquery.vmap.south-america.js"></script>
							<!-- cose per le tabelle -->
							<script src="<!--relativeDirectory-->/vendor/select2/select2.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-datatables/media/js/jquery.dataTables.js"></script>
							<script src="<!--relativeDirectory-->/vendor/jquery-datatables-bs3/assets/js/datatables.js"></script>
					
							<!-- Specific Page Vendor: pagina delle form -->
							<script src="<!--relativeDirectory-->/vendor/jquery-autosize/jquery.autosize.js"></script>
							<script src="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
					
							<!-- Theme Base, Components and Settings -->
							<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
							<!-- Theme Custom -->
							<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
							<!-- Theme Initialization Files -->
							<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
							<!-- Examples -->
					///		<script src="<!--relativeDirectory-->/javascripts/dashboard/examples.dashboard.js"></script>
					///		<script src="<!--relativeDirectory-->/javascripts/tables/examples.datatables.editable.js"></script>
							[[-javascriptInizializzazioneSpecifica-]]
					
					
			</body>
		
		
		</html>
EOT;
		return $what;
		]>
	getMainCustomerName
		<[
		
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
		
			$un_rec = _dbGet("SELECT table_name FROM information_schema.tables WHERE table_schema='$db_sql_name' AND table_name = 'tb_dati_aziendali';");
			if( $un_rec == NULL )
				return "";
		
			$nomeAzienda = _dbGet("SELECT nome FROM tb_dati_aziendali;")['nome'] ?? "";
			if( $nomeAzienda == "" )
				return "";
		
			$cosa = <<<EOT
				<span class="separator"></span>
				<div class="userbox flexbox flashMessage">
					<h3 style="font-size:1.4em;">{$nomeAzienda}</h3>
				</div>
			EOT;
		
			return $cosa;
		
		
		
		]>
	getMainIcon
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
			$default_pic = "<!--relativeDirectory-->//images/do0/do0116x50arancio.png";
		
			$un_rec = _dbGet("SELECT table_name FROM information_schema.tables WHERE table_schema='$db_sql_name' AND table_name = 'tb_dati_aziendali';");
			if( $un_rec == NULL )
				return $default_pic;
		
			$un_rec = _dbGet("SELECT id FROM tb_dati_aziendali;");
			if( $un_rec == NULL )
				return $default_pic;
		
			// ARRAY
			$dat = array();
			$dat['t'] = "tb_dati_aziendali";
			$dat['f'] = "logo";
			$dat['id'] = $un_rec['id'] ?? 0;
			// JSON
			$dat = json_encode( $dat );
			// ENCRYPT
			$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
			$dat = _encrypta( $dat, $key );
			// BASE64/BIN2HEX
			$dat = bin2hex( $dat );
			$picture = "index.php?fx=ixmage&data={$dat}&a=48";
		
			return $picture;
		
		
		]>
	resetStack
		false
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style="background-color:white;"
	getMainMenu
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$ruolo = $gbl_userData['ruolo'];
		
		if( !isset( $_t['menu info'][$ruolo]) || !is_array($_t['menu info'][$ruolo]))
			die("E-8897.10 - menu array undefined, please notify admin@awgp.it");
		
		// -----------------------------------------------------------------
		// TUTTO IL MENU
		$aM = $_t['menu info'][$ruolo];
		// -----------------------------------------------------------------
		// CARICO IL NOME DELLA FUNZIONE ATTUALE
		$currentFunction = "main";
		if( isset($_REQUEST['fx']) && $_REQUEST['fx'] != "" )
			$currentFunction = trim( $_REQUEST['fx'] );
		// -----------------------------------------------------------------
		// VERIFICO QUALI SONO I MENU CHE DEVONO RESTARE APERTI/SELEZIONATI
		
		// funzione che ritorna i nomi dei menu' selezionati
		//
		/*
				admin
					Dashboard: main, fa fa-home, alias1, alias2, alias3, alias4, alias5, alias6
					Tabella Utenti: showUserTable, fa fa-user
						Funzione 1: funzione1, fa fa-home
						Funzione 3: funzione3, fa fa-home
							Funzione 2: funzione2, fa fa-home
			
		se ho selezionato funzione2, mi ritorna un array che contiene: [0]=showUserTable, [1]=funzione3
		*/
		
		function _local_getOpenMenus( $branch, $functionName, $lista, &$functionHasBeenFound )
		{
			$fun_key = "";
			foreach( $branch as $key=>$leaf )
			{
				if( is_numeric($key))
				{
					if( $key == "1" ) // è l'icona
						continue;
		
					if( $key == "0" ) 
						$fun_key = $leaf;
		
					if( is_array($leaf)) /// qualcosa non va, e' stato messo un indice interno numerico con un sottomenu, non e' permesso!!!
					{
						if( $key == "0" )
							$fun_key = ""; /// resetto per sicurezza la function key
						continue;
					}
		
					if( trim($functionName) == trim($leaf) ) /// FUNZIONE TROVATA!
					{
						$functionHasBeenFound = true;
						return $lista;
					}
				}
				else
				{
					if( is_array( $leaf))
					{
						/// la fun_key potrebbe anche essere vuota, per esempio all'inizio, leggendo il menu' principale
						$newList = $lista;
						if( $fun_key != "" )
							$newList[] = $fun_key;
						$newList = _local_getOpenMenus( $leaf, $functionName, $newList, $functionHasBeenFound);
						if( $functionHasBeenFound )
							return $newList;
					}
				}
		
			}
			return $lista;
		}
		
		if( is_array($aM))
		{
			$lista = array();
			$functionHasBeenFound = false;
			$expanded = _local_getOpenMenus( $aM, trim($currentFunction), $lista, $functionHasBeenFound);
		}
		// -----------------------------------------------------------------
		// SE NON TROVA NIENTE, POTREBBE ESSERE UNA FUNZIONE INTERNA
		// PROVO A LEGGERE IL NOME DELLA FUNZIONE PRINCIPALE DAI PARAMETRI
		// DI SESSIONE.
		if( count( $expanded) <= 0 )
		{
			// ------------------------------------------
			// vediamo se si tratta di un menu principale
			$found = false;
			foreach( $aM as $menu )
				if( $menu[0] == $currentFunction )
					{$found = true; break;}
			// ------------------------------------------
			if( !$found )
			{
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
				{
					$lista = array();
					$functionHasBeenFound = false;
					$expanded = _local_getOpenMenus( $aM, trim($rec['valore']), $lista, $functionHasBeenFound); // MASTER FUNCTION FOUND!
					// -------------------------------------------------------------
					// FORZIAMO LA FUNZIONE CORRENTE ALLA MASTER FUNCTION
					$currentFunction = $rec['valore'];
				}
			}
		}
		// -----------------------------------------------------------------
		// COSTRUISCO IL MENU
		$ilMenu = "";
		$gbl_infoMenu = array(); // aggiunto 24 nov 2022 ... potrebbe servire
		foreach( $aM as $nomeMenu=>$menu )
		{
			
				if( !isset( $menu[0]))
				{
					echo "menu error add not found";
					continue;		
				}
			
				if( !isset( $menu[1]))
				{
					echo "menu error icon not found";
					continue;		
				}
			
				if( $menu[1] == "hidden" )
					continue;
			
				// -------------------------------------------
				// SET STATO MENU
				$active = "";
				$aliasFunctionName = isset( $menu[2] ) ? $menu[2] : "*INVALID MENU NAME*";
				$aliasFunctionName2 = isset( $menu[3] ) ? $menu[3] : "*INVALID MENU NAME*";
				$aliasFunctionName3 = isset( $menu[4] ) ? $menu[4] : "*INVALID MENU NAME*";
				if( $currentFunction == $menu[0] || $currentFunction == $aliasFunctionName || $currentFunction == $aliasFunctionName2 || $currentFunction == $aliasFunctionName3 )
			///	if( $currentFunction == $menu[0] )
				{
					$gbl_infoMenu[0]['function'] = $menu[0];
					$gbl_infoMenu[0]['icon'] = $menu[1];
					$gbl_infoMenu[0]['titolo'] = $nomeMenu;
					$active = " nav-active ";
				}
			
				if( in_array( $menu[0], $expanded ) || in_array( $aliasFunctionName, $expanded ) || in_array( $aliasFunctionName2, $expanded ) || in_array( $aliasFunctionName3, $expanded ))
			///	if( in_array( $menu[0], $expanded ))
				{
					$gbl_infoMenu[0]['function'] = $menu[0];
					$gbl_infoMenu[0]['icon'] = $menu[1];
					$gbl_infoMenu[0]['titolo'] = $nomeMenu;
					$active .= " nav-expanded ";
				}
				// -------------------------------------------
			
				if( count( $menu ) <= 2 || 
				( count( $menu ) == 3 && isset($menu[2]) && !is_array($menu[2]) ) || 
				( count( $menu ) == 4 && isset($menu[3]) && !is_array($menu[3]) ) || 
				( count( $menu ) == 5 && isset($menu[4]) && !is_array($menu[4]) )) // NO SUBMENU(s)
			///	if( count( $menu) <= 2 )
				{
					$ilMenu .= <<<EOT
						<li class="{$active}">
							<a href="index.php?fx={$menu[0]}">
								<i class="{$menu[1]}" aria-hidden="true"></i>
								<span>{$nomeMenu}</span>
							</a>
						</li>
					EOT;
					continue;
				}
			
				// ------------------------------------------
				// carico tutti i sottomenu del primo livello
				// ------------------------------------------
				$theSubmenu = "";
				foreach( $menu as $subname=>$submenu )
				{
					if( $subname == "0" || $subname == "1" || $subname == "2" || $subname == "3" || $subname == "4" ) // skip address (che sarà vuoto) e icona
						continue;
			
					if( !is_array($submenu))
						continue;
			
					if( count( $submenu) < 2 )
						continue;
			
					if( !isset( $submenu[0]) || !isset( $submenu[1]))
						continue;
			
					if( !( count( $submenu ) <= 2 || 
					( count( $submenu ) == 3 && isset($submenu[2]) && !is_array($submenu[2]) ) || 
					( count( $submenu ) == 4 && isset($submenu[3]) && !is_array($submenu[3]) ) || 
					( count( $submenu ) == 5 && isset($submenu[4]) && !is_array($submenu[4]) ))) // SUBMENU(s)
			///		if( count( $submenu) > 2 )
					{
						$theSubsubmenu = "";
			
						foreach( $submenu as $subsubname=>$subsubmenu )
						{
							if( $subsubname == "0" || $subsubname == "1" || $subsubname == "2" || $subsubname == "3" || $subsubname == "4" ) // skip address (che sarà vuoto) e icona
								continue;		
			
							if( !is_array($subsubmenu))
								continue;
			
							if( count( $subsubmenu) < 2 )
								continue;
			
							if( !isset( $subsubmenu[0]) || !isset( $subsubmenu[1]))
								continue;
			
							if( !( count( $subsubmenu ) <= 2 || 
							( count( $subsubmenu ) == 3 && isset($subsubmenu[2]) && !is_array($subsubmenu[2]) ) || 
							( count( $subsubmenu ) == 4 && isset($subsubmenu[3]) && !is_array($subsubmenu[3]) ) || 
							( count( $subsubmenu ) == 5 && isset($subsubmenu[4]) && !is_array($subsubmenu[4]) ))) // SUBMENU(s)
			///				if( count( $subsubmenu) > 2 )
							{	//2 ATTUALMENTE NON GESTITO!
								
							}
							else
							{
								$active = "";
								$aliasFunctionName = isset( $subsubmenu[2] ) ? $subsubmenu[2] : "*INVALID MENU NAME*";
								$aliasFunctionName2= isset( $subsubmenu[3] ) ? $subsubmenu[3] : "*INVALID MENU NAME*";
								$aliasFunctionName3= isset( $subsubmenu[4] ) ? $subsubmenu[4] : "*INVALID MENU NAME*";
								if( $currentFunction == $subsubmenu[0] || $currentFunction == $aliasFunctionName  || $currentFunction == $aliasFunctionName2 || $currentFunction == $aliasFunctionName3)
			///					if( $currentFunction == $subsubmenu[0] )
								{
									$gbl_infoMenu[2]['function'] = $subsubmenu[0];
									$gbl_infoMenu[2]['icon'] = $subsubmenu[1];
									$gbl_infoMenu[2]['titolo'] = $subsubname;
									$active = " nav-active ";
								}
								if( in_array( $subsubmenu[0], $expanded ) || in_array( $aliasFunctionName, $expanded) || in_array( $aliasFunctionName2, $expanded) || in_array( $aliasFunctionName3, $expanded ))
								{
									$gbl_infoMenu[2]['function'] = $subsubmenu[0];
									$gbl_infoMenu[2]['icon'] = $subsubmenu[1];
									$gbl_infoMenu[2]['titolo'] = $subsubname;
									$active .= " nav-expanded ";
								}
								$theSubsubmenu .= <<<EOT
									<li class="{$active}">
										<a href="index.php?fx={$subsubmenu[0]}">
											{$subsubname}
										</a>
									</li>
								EOT;
							}
						}
						$active = "";
						$aliasFunctionName = isset( $submenu[2] ) ? $submenu[2] : "*INVALID MENU NAME*";
						$aliasFunctionName2= isset( $submenu[3] ) ? $submenu[3] : "*INVALID MENU NAME*";
						$aliasFunctionName3= isset( $submenu[4] ) ? $submenu[4] : "*INVALID MENU NAME*";
						if( $currentFunction == $submenu[0] || $currentFunction == $aliasFunctionName || $currentFunction == $aliasFunctionName2 || $currentFunction == $aliasFunctionName3 )
			///			if( $currentFunction == $submenu[0] )
						{
							$gbl_infoMenu[1]['function'] = $submenu[0];
							$gbl_infoMenu[1]['icon'] = $submenu[1];
							$gbl_infoMenu[1]['titolo'] = $subname; 
							$active = " nav-active ";
						}
						if( in_array( $submenu[0], $expanded ) || in_array( $aliasFunctionName, $expanded ) || in_array( $aliasFunctionName2, $expanded ) || in_array( $aliasFunctionName3, $expanded ))
			///			if( in_array( $submenu[0], $expanded ))
						{
							$gbl_infoMenu[1]['function'] = $submenu[0];
							$gbl_infoMenu[1]['icon'] = $submenu[1];
							$gbl_infoMenu[1]['titolo'] = $subname; 
							$active .= " nav-expanded ";
						}
						$theSubmenu .= <<<EOT
							<li class="nav-parent {$active}">
								<a>
									{$subname}
								</a>
								<ul class="nav nav-children">
									{$theSubsubmenu}
								</ul>
							</li>
						EOT;
					}
					else
					{
						$active = "";
						$aliasFunctionName = isset( $submenu[2] ) ? $submenu[2] : "*INVALID MENU NAME*";
						$aliasFunctionName2= isset( $submenu[3] ) ? $submenu[3] : "*INVALID MENU NAME*";
						$aliasFunctionName3= isset( $submenu[4] ) ? $submenu[4] : "*INVALID MENU NAME*";
						if( $currentFunction == $submenu[0] || $currentFunction == $aliasFunctionName || $currentFunction == $aliasFunctionName2 || $currentFunction == $aliasFunctionName3 )
			///			if( $currentFunction == $submenu[0] )
						{
							$gbl_infoMenu[1]['function'] = $submenu[0];
							$gbl_infoMenu[1]['icon'] = $submenu[1];
							$gbl_infoMenu[1]['titolo'] = $subname;
							$active = " nav-active ";
						}
						if( in_array( $submenu[0], $expanded ) || in_array( $aliasFunctionName, $expanded ) || in_array( $aliasFunctionName2, $expanded ) || in_array( $aliasFunctionName3, $expanded ))
			///			if( in_array( $submenu[0], $expanded ))
						{
							$gbl_infoMenu[1]['function'] = $submenu[0];
							$gbl_infoMenu[1]['icon'] = $submenu[1];
							$gbl_infoMenu[1]['titolo'] = $subname;
							$active .= " nav-expanded ";
						}
						$theSubmenu .= <<<EOT
							<li class="{$active}">
								<a href="index.php?fx={$submenu[0]}">
									{$subname}
								</a>
							</li>
						EOT;
					}
				}
			
				// MENU PRINCIPALE CON SOTTOMENU(s)
				// -------------------------------------------
				// SET STATO MENU
				$active = "";
				$aliasFunctionName = isset( $menu[2] ) ? $menu[2] : "*INVALID MENU NAME*";
				$aliasFunctionName2= isset( $menu[3] ) ? $menu[3] : "*INVALID MENU NAME*";
				$aliasFunctionName3= isset( $menu[4] ) ? $menu[4] : "*INVALID MENU NAME*";
				if( $currentFunction == $menu[0] || $currentFunction == $aliasFunctionName || $currentFunction == $aliasFunctionName2 || $currentFunction == $aliasFunctionName3 )
			///	if( $currentFunction == $menu[0] )
				{
					$gbl_infoMenu[0]['function'] = $menu[0];
					$gbl_infoMenu[0]['icon'] = $menu[1];
					$gbl_infoMenu[0]['titolo'] = $nomeMenu;
					$active = " nav-active ";
				}
			
				if( in_array( $menu[0], $expanded ) || in_array( $aliasFunctionName, $expanded ) || in_array( $aliasFunctionName2, $expanded ) || in_array( $aliasFunctionName3, $expanded ))
			///	if( in_array( $menu[0], $expanded ))
				{
					$gbl_infoMenu[0]['function'] = $menu[0];
					$gbl_infoMenu[0]['icon'] = $menu[1];
					$gbl_infoMenu[0]['titolo'] = $nomeMenu;
					$active = " nav-active nav-expanded ";
				}
				// -------------------------------------------
				$ilMenu .= <<<EOT
						<li class="nav-parent {$active}">
							<a>
								<i class="{$menu[1]}" aria-hidden="true"></i>
								<span>{$nomeMenu}</span>
							</a>
							<ul class="nav nav-children">
								{$theSubmenu}
							</ul>
						</li>
				EOT;
			
			
		}
		
		$what = <<<EOT
		
				<div class="sidebar-header">
					<div class="sidebar-title" style="padding:10px;">
						<p style="font-size:11px;line-height:13px; color:lightgray;font-weight:700;text-transform: uppercase;">
							$gbl_subDomain <br /> ($gbl_nomeTipo)
						</p>
					</div>
					<div class="sidebar-toggle hidden-xs" data-toggle-class="sidebar-left-collapsed" data-target="html" data-fire-event="sidebar-left-toggle">
						<i class="fa fa-bars" aria-label="Toggle sidebar"></i>
					</div>
				</div>
				<div class="nano">
					<div class="nano-content">
						<nav id="menu" class="nav-main" role="navigation">
							<ul class="nav nav-main">
								{$ilMenu}				
							</ul>
						</nav>
		///				_[MENU CONTESTUALE] futuro
					</div>
				</div>
		EOT;
		// -----------------------------------------------------------------
		return $what;
			
		
		]>
	getSezioneUserBox
		<[
		
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$nome = $gbl_userData['nome'];
		$ruolo = $gbl_userData['ruolo'];
		$email = $gbl_userData['email'];
		
		if( !isset( $_t['menu info'][$ruolo]) || !is_array($_t['menu info'][$ruolo]))
			die("E-5897.10 - menu array undefined, please notify admin@awgp.it");
		
		// -----------------------------------------------------------------
		
		
		
		/// ---------------------------------------------------------------------
		/// è possibile disabilitare l'item menu della gestione cambio password
		/// mettendo $gbl_changePasswordDisabled a TRUE da index.php per alcuni
		/// sistemi (dove ad esempio si entra con SPID)
		$cambiaPassword = <<<EOT
										<li>
											<a role="menuitem" tabindex="-1" href="index.php?fx=updatePasswordUser"><i class="fa fa-lock"></i> Cambia Password</a>
										</li>
		EOT;
		if( $gbl_changePasswordDisabled ?? FALSE )
			$cambiaPassword = "";
		/// ---------------------------------------------------------------------
		
		// ARRAY
		$dat = array();
		$dat['t'] = "tb_utente";
		$dat['f'] = "i_avatar";
		$dat['id'] = $gbl_userId;
		// JSON
		$dat = json_encode( $dat );
		// ENCRYPT
		$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
		$dat = _encrypta( $dat, $key );
		// BASE64/BIN2HEX
		$dat = bin2hex( $dat );
		$picture = "index.php?fx=ixmage&data={$dat}&a=50";
		
		$what = <<<EOT
							<div id="userbox" class="userbox">
								<a href="#" data-toggle="dropdown">
									<figure class="profile-picture">
										<img style="height:35px;width:35px;" src="{$picture}" alt="{$nome}" class="img-circle" data-lock-picture="{$picture}" />
									</figure>
									<div style="padding-left:7px;" class="profile-info" data-lock-name="{$nome}" data-lock-email="{$email}">
										<span class="name">{$nome}</span>
										<span class="role">{$ruolo}</span>
									</div>
					
									<i class="fa custom-caret"></i>
								</a>
					
								<div class="dropdown-menu">
									<ul class="list-unstyled">
										<li class="divider"></li>
										{$cambiaPassword}
		///								<li>
		///									<a role="menuitem" tabindex="-1" href="#" data-lock-screen="true"><i style="margin-left:1px; margin-right:5px;" class="fa fa-lock"></i> Blocca Schermo</a>
		///								</li>
										<li>
											<a role="menuitem" tabindex="-1" href="index.php?fx=cmdLogout"><i class="fa fa-power-off"></i> Logout</a>
										</li>
									</ul>
								</div>
							</div>
		
		EOT;
		
		
		return $what;
		
		
		]>
	getOctopusMainContent
		<[
		/// _[OCTOPUS CONTENT: TIPO DASHBOARD]
		
		/// _[OCTOPUS CONTENT: TIPO TABELLA EDITABILE]
		
		/// _[OCTOPUS CONTENT: MESSAGGI WELCOME]
		
		return "";
		
		
		
		
		]>
	getBreadcrumbsLine
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
		/// _[COME PRIMA ...]
		
		global $gbl_infoMenu;
		$mainName = "Home";
		
		$aggiuntivi = "";
		if( is_array($gbl_infoMenu))
		{
			$totale = count($gbl_infoMenu);
			$contatore = 0;
		
			foreach($gbl_infoMenu as $menu )
			{
				$t = isset($gbl_infoMenu[$contatore]['titolo']) ? $gbl_infoMenu[$contatore]['titolo'] : "";
				$f = isset($gbl_infoMenu[$contatore]['function']) && !startsWith($gbl_infoMenu[$contatore]['function'], "null") ? "index.php?fx=" . $gbl_infoMenu[$contatore]['function'] : "#";
				$i = isset($gbl_infoMenu[$contatore]['icon']) ? $gbl_infoMenu[$contatore]['icon'] : "null";
		
				$contatore++;
				if( $i == "null" ) /// || $t=="" ) // 24 nov 2022 -> era vuoto perché non correttamente inizializzato!!! 
										/// adesso $gbl_infoMenu è inizializzato in _[COSTRUZIONE MENU IN BASE AL RUOLO UTENTE]
					continue;
		
				$mainName = $t;
		
				if( $totale == $contatore ) // ULTIMO, diamo per scontato che come ultimo elemento non ci sia una funzione null, non avrebbe senso
				{							// perché la funzione null serve per i menù che contengono sottomenù. Se succedesse, l'ultimo
											// menù sarebbe il precedente e sarebbe un'icona
					$aggiuntivi .= <<<EOT
						<li>
							<a title="{$t}" href="{$f}">
								<span>{$t}</span>
							</a>
						</li>
					EOT;
				}
				else
				{
					$aggiuntivi .= <<<EOT
						<li>
							<a title="{$t}" href="{$f}">
								<i class="{$i}"></i>
							</a>
						</li>
					EOT;
				}
			}
		}
		
		if( isset( $_t["ancillary"]['headerTitle'][0]))
			$mainName = $_t["ancillary"]['headerTitle'][0];
		
		$breadcrumbsLine = <<<EOT
		
							<header class="page-header">
								<h2>{$mainName}</h2>
							
								<div class="right-wrapper pull-right">
									<ol class="breadcrumbs">
										<li>
											<a title="Home" href="index.php?fx=main">
												<i class="fa fa-home"></i>
											</a>
										</li>
										{$aggiuntivi}
									</ol>
		
									<a class="sidebar-right-toggle" data-open=""><i class="fa fa-chevron-left"></i></a>
		
								</div>
							</header>
		EOT;
		
		
		return $breadcrumbsLine;
		
		
		
		
		
		]>
	getQuickNotifica
		<[
		
		$what = <<<EOT
			<div class="userbox flexbox flashMessage">
			</div>
			<span class="separator"></span>
		EOT;
		
		if( ! isset( $_REQUEST['i'] ))
			return $what;
		
		$info = intval($_REQUEST['i']);
		
		$notifica = "";
		
		if( ! $info )
			$notifica = '<i style="font-size:16px; display: inline-block; color:green; margin-right: 7px;" class="fa fa-info-circle"></i><p style="display: inline-block;">Operazione conclusa correttamente</p>';
		else
			$notifica = '<i style="font-size:16px; display: inline-block; color:red; margin-right: 7px;" class="fa fa-exclamation-triangle"></i><p style="display: inline-block;">L\'operazione si è conclusa con l\'errore:' . $info . '</p>';
		
		$what = <<<EOT
			<div class="userbox flexbox flashMessage">
				{$notifica}
			</div>
			<span class="separator"></span>
		EOT;
		
		return $what;
		
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		]>
	getPopupDialogBox
		return "";
	ADDITIONAL CSS BARE FRAME
		<!--niente-->
	title
		return "";
	

/// ---------------------
/// PAGINA MESSAGGI: user
main
	di tipo
		frameMain
	permessi
		USER
	getOctopusMainContent
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		/// _[OCTOPUS CONTENT: MESSAGGI WELCOME]
		// -------------------------------------
		// RACCOLTA PARAMETRI IN INGRESSO,
		// NUMERO DI PAGINA (ix)
		// -------------------------------------
		$ix = 0;
		if( isset($_REQUEST["ix"]))
			$ix = intval($_REQUEST["ix"]);
		// -------------------------------------
		// RACCOLTA PARAMETRI IN INGRESSO,
		// stringa di ricerca (s)
		// -------------------------------------
		$st = "";
		if( isset($_REQUEST["s"]))
			$st = $_REQUEST["s"];
		// --------------------------------------------
		// CARICO TUTTI I MESSAGGI LETTI DA QUESTO
		// UTENTE
		// --------------------------------------------
		$rec = _dbGet("SELECT * FROM tb_messaggioVisualizzato WHERE tb_utente='". sanitize($gbl_userId,"sql",$db_sql) ."'");
		$messaggiLetti = array();
		while( $rec != NULL )
		{
			$messaggiLetti[] = $rec['tb_messaggio'];
			$rec = _dbGet();
		}
		// --------------------------------------------
		// CARICO 5 MESSAGGI
		// --------------------------------------------
		$elencoDeiMessaggi = "";
		$recMessaggi = array();
		$rec = _dbGet("SELECT * FROM tb_messaggio WHERE 1=1 ORDER BY datetime DESC LIMIT 5 OFFSET $ix;");
		while( $rec != NULL )
		{
			if( !isset($rec['tb_tipoMessaggio'] ))
			{
				$rec = _dbGet();
				continue;
			}
		
			if( $st != "" )
			{
				if( !contains(strtolower($rec['titolo']),strtolower($st)) && 
						!contains(strtolower($rec['testo']),strtolower($st)) )
				{
					$rec = _dbGet();
					continue;
				}
			}
		
			$recMessaggi[] = $rec;
			$rec = _dbGet();
		}
		
		foreach( $recMessaggi as $rec )
		{
			$dataOra = dataItaliana2($rec['datetime'], 1);
		
			$isNewMessage = "";
			if( !in_array( $rec['id'], $messaggiLetti))
			{
				$isNewMessage = <<<EOT
					<p class="result-type">
						<span class="label label-primary">New!</span>
					</p>
		EOT;
				$unr = array();
				$unr['tb_messaggio'] = $rec['id'];
				$unr['tb_utente'] = $gbl_userId;
				db_sql_insert_2("tb_messaggioVisualizzato", $unr);
			}
		
			switch( $rec['tb_tipoMessaggio'] )
			{
				case 1:
					
					
					$elencoDeiMessaggi .= <<<EOT
														<li>
															{$isNewMessage}
															<a href="#" class="has-thumb">
																<div class="result-thumb">
																	<i class="{$rec['icona']}"></i>
																</div>
																<div class="result-data">
																	<p class="h3 title text-primary">{$rec['titolo']}</p>
																	<p class="description">
																		<span style="color:#999;"><small>{$dataOra}</small></span>
																		<br/>
																		{$rec['testo']}
																	</p>
																</div>
															</a>
														</li>
					
					EOT;
					
				break;
				case 2:
					
					
					$elencoDeiMessaggi .= <<<EOT
					
														<li>
															{$isNewMessage}
															<a href="#">
																<div class="result-data">
																	<p class="h3 title text-primary">{$rec['titolo']}</p>
																	<p class="description">
																		<span style="color:#999;"><small>{$dataOra}</small></span><br />
																		{$rec['testo']}
																	</p>
																</div>
															</a>
														</li>
					
					EOT;
					
				break;
				default:
				break;
			}
		
			$rec = _dbGet();
		}
		
		$pagination = "";
		// --------------------------------------------
		// CONTO I MESSAGGI
		// --------------------------------------------
		if( $st == "" )
			$numMessaggi = dbQuery("SELECT * FROM tb_messaggio WHERE 1=1;");
		else
			$numMessaggi = dbQuery("SELECT * FROM tb_messaggio WHERE (LOWER(titolo) LIKE LOWER('%" . sanitize($st,"sql",$db_sql) . "%') OR LOWER(testo) LIKE LOWER('%" . sanitize($st,"sql",$db_sql) . "%'));");
		
		if( $ix > ($numMessaggi-1))
			$ix = ($numMessaggi-1);
		
		$numPages = intval($numMessaggi / 5);
		if( intval($numMessaggi % 5))
			$numPages++;
		$numPage = intval($ix / 5);
		
		if( !$numPage )
		{
			$pagination = <<<EOT
				<li class="prev disabled">
					<a href="#">
						<i class="fa fa-chevron-left"></i>
					</a>
				</li>
		EOT;
		}
		else
		{
			$prevPage = ($numPage-1) * 5;
			$pagination = <<<EOT
				<li class="prev">
					<a href="index.php?ix={$prevPage}&s={$st}">
						<i class="fa fa-chevron-left"></i>
					</a>
				</li>
		EOT;
		}	
		
		for( $t=0; $t<$numPages; $t++ )
		{
			$indice = $t * 5;
			$pagina = $t+1;
			if( $t == $numPage )
			{
				$pagination .= <<<EOT
					<li class="active">
						<a href="index.php?ix={$indice}&s={$st}">{$pagina}</a>
					</li>
		EOT;
			}
			else
			{
				$pagination .= <<<EOT
					<li>
						<a href="index.php?ix={$indice}&s={$st}">{$pagina}</a>
					</li>
		EOT;
			}
		}
		
		if( $numPage < ($numPages-1) )
		{
			$nextPage = ($numPage+1) * 5;
			$pagination .= <<<EOT
			<li class="next">
				<a href="index.php?ix={$nextPage}&s={$st}">
					<i class="fa fa-chevron-right"></i>
				</a>
			</li>
		EOT;
		}
		else
		{
			$pagination .= <<<EOT
			<li class="next disabled">
				<a href="#">
					<i class="fa fa-chevron-right"></i>
				</a>
			</li>
		EOT;
		}
		
		
		if( $elencoDeiMessaggi == "" )
			if( $st == "" )
				$elencoDeiMessaggi = "<p>Nessun messaggio presente</p>";
			else
				$elencoDeiMessaggi = "<p>Nessun messaggio selezionato</p>";
		
		$what = <<<EOT
		
							<div class="search-content">
								<div class="search-control-wrapper">
									<form action="index.php?ix={$ix}">
										<div class="form-group">
											<div class="input-group">
												<input type="text" name="s" class="form-control" value="{$st}">
												<span class="input-group-btn">
													<button class="btn btn-primary" type="button">Cerca</button>
												</span>
											</div>
										</div>
									</form>
								</div>
								<div class="tab-content">
									<div id="everything" class="tab-pane active">
										<ul class="list-unstyled search-results-list" style="padding-top: 16px;">
		
										{$elencoDeiMessaggi}				
		
										</ul>
		
										<hr class="solid mb-none" />
		
										<ul class="pagination">
										{$pagination}
										</ul>
									</div>
								</div>
							</div>
							<!-- end: page -->
		EOT;
		
		return $what;
		
		
		
		]>
	innerWrapperStyle
		style="background-color:white;"

///0 ------------------------------------
// ---------------------------------------
// EDITING, CLASSE BASE (accesso user di base)
//0											------------------------------------------------------------------------------------------------------------------
//0																						EDIT E' LA MASTER PAGE
//0 										LE FUNZIONI INTERNE (FRMADDRECORD FRMDELETERECORD FRMEDITRECORD) USANO DATI DI SESSIONE IMPOSTATI DALLA EDIT PAGE.
//0											NON SI POSSONO CHIAMARE QUESTE FUNZIONI SE NON VENGONO PRIMA IMPOSTATI I DATI DI SESSIONE.
//0											------------------------------------------------------------------------------------------------------------------
//1 MODIFICHE ALLA CODIFICA IMMAGINI E FILE:
//1 _[SALVO TEMPORANEAMENTE IL FILE NEL SISTEMA]
//1 _[VISUALIZZA IMMAGINE DA BASE64]
//1 --------------------------------------------
tbEdit

	di tipo
		frameMain
	getCheckboxColumn
		return "false";
	getQueryRequested
		return "false";
	resetStack
		true
	permessi
		USER
	title
		return "";
	getTableName
		return "tb_utente";
	backAddress
		<[
		return "index.php";
		]>
	getSelectors
		<[
			return "";	
		]>
	getActionsPage
		<[
			return "";
		]>
	getPulsanteIndietro
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		//1 -----------------------------------------------------------------------
		//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
		//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
		//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
		//1 -----------------------------------------------------------------------
		if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
		{
			// -----------------------------------------------------------------------
			// CARICO IL MIO STACK
			// -----------------------------------------------------------------------
			$gbl_stack = array();
			$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
			{
				// -------------------------------------------------------------------
				// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
				// -------------------------------------------------------------------
				$stack = array();
				$e = array();
				$e['tabella'] = '{{=getTableName=}}';
				$e['pagina'] = $gbl_fx;
				$e['titolo'] = '{{=title=}}';
				$e['icona'] = '{{=getIcon=}}';
				$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
				$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$stack[] = $e;
				$stack = json_encode( $stack );
				$stack = bin2hex( $stack );
				$r = array();
				$r['tb_utente'] = $gbl_userId;
				$r['tb_sessione'] = $gbl_idSessione;
				$r['pagina'] = "";
				$r['nome'] = "stack";
				$r['valore'] = $stack;
				$idStack = db_sql_insert_2("tb_parametro", $r );
			}
			else
			{
				$idStack = $rec['id'];
				$stack = $rec['valore'];
			}
			// -----------------------------------------------------------------------
			// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
			// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
			// -----------------------------------------------------------------------
			$stack = hex2bin( $stack );
			$stack = json_decode( $stack, true );
			if( $stack != NULL )
			{
				if( is_array($stack) && count( $stack) > 0)
				{
					// echo "\n -PRIMA ----------------------\n";
					// var_dump ($stack);
					if( !<!--resetStack--> )
					{
						foreach( $stack as $s )
						{
							if( $s['pagina'] == $gbl_fx )
								break;
							$gbl_stack[] = $s;
						}
					}
			
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$gbl_stack[] = $e;
					// echo "\n - DOPO ----------------------\n";
					// var_dump ($gbl_stack);
					$stack = json_encode( $gbl_stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['id'] = $idStack;
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					db_sql_update_2("tb_parametro", $r,"id",$idStack);
				}
			}
			
			/// echo "\n -STACK ----------------------\n";
			/// var_dump ($gbl_stack);
			
			
		}
		
		
		
		
		if( !is_array($gbl_stack) || count($gbl_stack)<2 ) // se nello stack c'è unicamente la mia pagina
			return "";
		
		$prevIdx	= count( $gbl_stack) - 2;
		$function	= isset($gbl_stack[$prevIdx]['pagina']) ? $gbl_stack[$prevIdx]['pagina'] : "";
		$query		= isset($gbl_stack[$prevIdx]['query']) && $gbl_stack[$prevIdx]['query'] != "" ? "&q=" . $gbl_stack[$prevIdx]['query'] : "";
		$father		= isset($gbl_stack[$prevIdx]['father']) && $gbl_stack[$prevIdx]['father'] != "" ? "&f=" . $gbl_stack[$prevIdx]['father'] : "";
		$add		= "index.php?fx={$function}{$query}{$father}";
		
		$what = <<<EOT
								<a href="{$add}" class="mb-xs mt-xs mr-xs btn btn-default" role="button" aria-pressed="true"><i class="fa fa-arrow-left"></i> Indietro</a>
		///						<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-arrow-left"></i> Indietro</button>
		
		EOT;
		
		return $what;
		
		
		
		]>
	getBreadcrumbsLine
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
		//1 -----------------------------------------------------------------------
		//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
		//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
		//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
		//1 -----------------------------------------------------------------------
		if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
		{
			// -----------------------------------------------------------------------
			// CARICO IL MIO STACK
			// -----------------------------------------------------------------------
			$gbl_stack = array();
			$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
			{
				// -------------------------------------------------------------------
				// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
				// -------------------------------------------------------------------
				$stack = array();
				$e = array();
				$e['tabella'] = '{{=getTableName=}}';
				$e['pagina'] = $gbl_fx;
				$e['titolo'] = '{{=title=}}';
				$e['icona'] = '{{=getIcon=}}';
				$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
				$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$stack[] = $e;
				$stack = json_encode( $stack );
				$stack = bin2hex( $stack );
				$r = array();
				$r['tb_utente'] = $gbl_userId;
				$r['tb_sessione'] = $gbl_idSessione;
				$r['pagina'] = "";
				$r['nome'] = "stack";
				$r['valore'] = $stack;
				$idStack = db_sql_insert_2("tb_parametro", $r );
			}
			else
			{
				$idStack = $rec['id'];
				$stack = $rec['valore'];
			}
			// -----------------------------------------------------------------------
			// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
			// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
			// -----------------------------------------------------------------------
			$stack = hex2bin( $stack );
			$stack = json_decode( $stack, true );
			if( $stack != NULL )
			{
				if( is_array($stack) && count( $stack) > 0)
				{
					// echo "\n -PRIMA ----------------------\n";
					// var_dump ($stack);
					if( !<!--resetStack--> )
					{
						foreach( $stack as $s )
						{
							if( $s['pagina'] == $gbl_fx )
								break;
							$gbl_stack[] = $s;
						}
					}
			
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$gbl_stack[] = $e;
					// echo "\n - DOPO ----------------------\n";
					// var_dump ($gbl_stack);
					$stack = json_encode( $gbl_stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['id'] = $idStack;
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					db_sql_update_2("tb_parametro", $r,"id",$idStack);
				}
			}
			
			/// echo "\n -STACK ----------------------\n";
			/// var_dump ($gbl_stack);
			
			
		}
		
		
		
		if( !is_array($gbl_stack) || count($gbl_stack)<2 ) // se nello stack c'è unicamente la mia pagina
		{
		///	echo "senza stack:" . count($gbl_stack);
			
			/// _[COME PRIMA ...]
			
			global $gbl_infoMenu;
			$mainName = "Home";
			
			$aggiuntivi = "";
			if( is_array($gbl_infoMenu))
			{
				$totale = count($gbl_infoMenu);
				$contatore = 0;
			
				foreach($gbl_infoMenu as $menu )
				{
					$t = isset($gbl_infoMenu[$contatore]['titolo']) ? $gbl_infoMenu[$contatore]['titolo'] : "";
					$f = isset($gbl_infoMenu[$contatore]['function']) && !startsWith($gbl_infoMenu[$contatore]['function'], "null") ? "index.php?fx=" . $gbl_infoMenu[$contatore]['function'] : "#";
					$i = isset($gbl_infoMenu[$contatore]['icon']) ? $gbl_infoMenu[$contatore]['icon'] : "null";
			
					$contatore++;
					if( $i == "null" ) /// || $t=="" ) // 24 nov 2022 -> era vuoto perché non correttamente inizializzato!!! 
											/// adesso $gbl_infoMenu è inizializzato in _[COSTRUZIONE MENU IN BASE AL RUOLO UTENTE]
						continue;
			
					$mainName = $t;
			
					if( $totale == $contatore ) // ULTIMO, diamo per scontato che come ultimo elemento non ci sia una funzione null, non avrebbe senso
					{							// perché la funzione null serve per i menù che contengono sottomenù. Se succedesse, l'ultimo
												// menù sarebbe il precedente e sarebbe un'icona
						$aggiuntivi .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<span>{$t}</span>
								</a>
							</li>
						EOT;
					}
					else
					{
						$aggiuntivi .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<i class="{$i}"></i>
								</a>
							</li>
						EOT;
					}
				}
			}
			
			if( isset( $_t["ancillary"]['headerTitle'][0]))
				$mainName = $_t["ancillary"]['headerTitle'][0];
			
			$breadcrumbsLine = <<<EOT
			
								<header class="page-header">
									<h2>{$mainName}</h2>
								
									<div class="right-wrapper pull-right">
										<ol class="breadcrumbs">
											<li>
												<a title="Home" href="index.php?fx=main">
													<i class="fa fa-home"></i>
												</a>
											</li>
											{$aggiuntivi}
										</ol>
			
										<a class="sidebar-right-toggle" data-open=""><i class="fa fa-chevron-left"></i></a>
			
									</div>
								</header>
			EOT;
			
			
			return $breadcrumbsLine;
			
			
		}
		else
		{
		///	echo "con stack:" . count($gbl_stack);
			
			/// DA QUI fino a 
			
			global $gbl_infoMenu;
			
			$iniziali = "";
			
			if( is_array($gbl_infoMenu))
			{
				$totale = count($gbl_infoMenu);
				$contatore = 0;
			
				foreach($gbl_infoMenu as $menu )
				{
					$t = isset($gbl_infoMenu[$contatore]['titolo']) ? $gbl_infoMenu[$contatore]['titolo'] : "";
					$f = isset($gbl_infoMenu[$contatore]['function']) && !startsWith($gbl_infoMenu[$contatore]['function'], "null") ? "index.php?fx=" . $gbl_infoMenu[$contatore]['function'] : "#";
					$i = isset($gbl_infoMenu[$contatore]['icon']) ? $gbl_infoMenu[$contatore]['icon'] : "null";
			
					$contatore++;
					if( $i == "null" )
						continue;
			
					$mainName = $t;
			
					if( $totale == $contatore ) // ULTIMO, diamo per scontato che come ultimo elemento non ci sia una funzione null, non avrebbe senso
					{							// perché la funzione null serve per i menù che contengono sottomenù. Se succedesse, l'ultimo
												// menù sarebbe il precedente e sarebbe un'icona
						$iniziali .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<span>{$t}</span>
								</a>
							</li>
						EOT;
					}
					else
					{
						$iniziali .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<i class="{$i}"></i>
								</a>
							</li>
						EOT;
					}
				}
			}
			
			if( isset( $_t["ancillary"]['headerTitle'][0]))
				$mainName = $_t["ancillary"]['headerTitle'][0];
			
			/// qui, è uguale alla versione SENZA STACK
			$aggiuntivi = "";
			
			$lastOneIdx = count( $gbl_stack ) - 1;
			
			$fname = "{{=getFatherName=}}";
			
			$idx = 0;
			foreach( $gbl_stack as $elem )
			{
				$function	= isset($elem['pagina']) ? $elem['pagina'] : "";
				$query		= isset($elem['query']) ? $elem['query'] : "";
				$add		= "index.php?fx={$function}&q={$query}";
				$icon		= isset($elem['icona']) ? $elem['icona'] : "fa window-close";
				$titolo		= isset($elem['titolo']) ? $elem['titolo'] . ': <span style="font-weight:700;">' . $fname . '</span>' : 'Inizio';
				$simple 	= isset($elem['titolo']) ? strip_tags($elem['titolo']) : 'Inizio';
			
				if( $idx != $lastOneIdx )
				{
					$aggiuntivi .= <<<EOT
			
						<li>
							<a title="{$simple}" href="{$add}">
								<i class="{$icon}"></i>
							</a>
						</li>
			
					EOT;
				}
				else
				{
					$mainName = $titolo;
			
					$aggiuntivi .= <<<EOT
			
						<li>
							<a title="{$simple}" href="{$add}">
								<span>{$mainName}</span>
							</a>
						</li>
			
					EOT;
			
				}
				$idx ++;
			}
			
			
			
			/// qui torna ad essere invece come quella con lo STACK (ma penso sia uguale in entrambe le versioni)
			
			$breadcrumbsLine = <<<EOT
			
								<header class="page-header">
									<h2>{$mainName}</h2>
								
									<div class="right-wrapper pull-right">
										<ol class="breadcrumbs">
											<li>
												<a title="Home" href="index.php?fx=main">
													<i class="fa fa-home"></i>
												</a>
											</li>
											{$iniziali}
											{$aggiuntivi}
										</ol>
			
										<a class="sidebar-right-toggle" data-open=""><i class="fa fa-chevron-left"></i></a>
			
									</div>
								</header>
			EOT;
			
			
			return $breadcrumbsLine;
			
			
		}
		
		
		
		
		
		
		]>
	getFParameter
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			if( $gbl_father )
				return "&f=" . $gbl_father;
		]>
	getAddFunctionName
		<[

		if( isset( $_t['ancillary']['addressNew'][0]))
			return $_t['ancillary']['addressNew'][0];

		return "index.php?fx=frmAddRecord";

		]>
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
// GESTIONE DELLA PERSISTENZA -------------------------------------------
	getSavedSearchString
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:search string' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "";
		
		
		
		]>
	getSavedPageNumber
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:page number' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "0";
		
		
		
		]>
	getSavedPageLength
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:page length' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return 10;
		
		
		
		]>
	getSavedSorting
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:sorting' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "[0, 'asc']";
		
		
		
		]>
	getNumberOfFields
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		
		return count( $struct );
		
		]>
// ----------------------------------------------------------------------
	getPopupDialogBox
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$c = isset($_t['ancillary']['removeWin'][0]) ? sanitize($_t['ancillary']['removeWin'][0], "sql", $db_sql) : "";
		$t1 = isset($_t['ancillary']['removeWin'][1]) ? $_t['ancillary']['removeWin'][1] : "";
		$t2 = isset($_t['ancillary']['removeWin'][2]) ? $_t['ancillary']['removeWin'][2] : "";
		
		$what = <<<EOT
		
		<div id="dialog" class="modal-block mfp-hide">
			<section class="panel">
				<header class="panel-heading">
					<h2 class="panel-title">{$t1}: <span style="color:red;font-width:700;" class="eToDelete"></span></h2>
				</header>
				<div class="panel-body">
					<div class="modal-wrapper">
						<div class="modal-text">
							<p>{$t2}: <span style="color:red;font-width:700;" class="eToDelete"></span>?</p>
						</div>
					</div>
				</div>
				<footer class="panel-footer">
					<div class="row">
						<div class="col-md-12 text-right">
							<button id="dialogConfirm" class="btn btn-danger">CONFERMA CANCELLAZIONE</button>
							<button id="dialogCancel" class="btn btn-default">NO</button>
						</div>
					</div>
				</footer>
			</section>
		</div>
		
		EOT;
		
		return $what;
		
		
		]>
	getOctopusMainContent
		<[
//2 ------- QUERY MANAGEMENT OVER HERE
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// controllo del parametro q
		
		$gbl_query = "";
		if( {{=getQueryRequested=}} )
		{
			// ---------------------------
			// RECUPERO LA QUERY
			if( !isset($_REQUEST['q']))
				return "Parameter invalid. Report: 0x9983.98 q";
		
			$query = hex2bin( $_REQUEST['q'] );
			$key = "AZ$9099" . $gbl_idSessione . $gbl_userId;
			$query = _decrypta( $query, $key );
		
			if( $query == "***" )
				return "Parameter invalid. Report: 0x9983.99";
		
			$gbl_query = $query; 
		}
		
			
		
		
		// preparo i parametri f e q se presenti, da aggiungere eventualmente a pagine interne (per export al momento)
		$getFandQ = "";
		if( isset($_REQUEST['f']))
			$getFandQ = "&f=" . $_REQUEST['f'];
		if( isset($_REQUEST['q']))
			$getFandQ .= "&q=" . $_REQUEST['q'];
		
		/// _[PRECEDENTE ALLE VARIABILI GLOBAL help e help2]
		
		// ----------------------------------------------
		$headers = "";
		foreach($gbl_struct as $field)
		{
			if( isset( $field['nome']))
			{
				$caption = $field['nome'];
				if( !isset( $_t['info'][ $caption][4]))
					continue;
				if( $_t['info'][ $caption][4] != "frontpage")
					continue;
				if( isset( $_t['info'][ $caption][0]) )
					$caption = $_t['info'][ $caption][0];
		
				$headers .= "<th>{$caption}</th>\n";
			}
		}
		
		$headers .= "<th>Opzioni</th>\n";
		
		// GESTIONE DELLA COLONNA di CHECKBOX: WIP
		if( {{=getCheckboxColumn=}} )
			$headers = '<th class="manina"><input type="checkbox" class="manina xSelectorMain"></th>' . "\n" . $headers;
		
		$content = "";
		
		// --------------------------------------------------------------------------------------------
		// SOLO QUELLI CHE SI POSSONO EDITARE "inline" e QUELLI CHE SONO "FRONT PAGE"
		// --------------------------------------------------------------------------------------------
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$filters = "";
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		if(	isset( $gbl_session['filter']) && is_array( $gbl_session['filter']) &&
			isset( $gbl_session['filter_type']) && is_array( $gbl_session['filter_type']) )
		{
			foreach( $gbl_session['filter'] as $nn=>$vv )
			{
				$nn = sanitize($nn, "sql", $db_sql);
				$vv = sanitize($vv, "sql", $db_sql);
				$mode = isset( $gbl_session['filter_type'][ $nn ] ) ? $gbl_session['filter_type'][ $nn ] : 1;
		
				if( $vv == "" )
					continue;
		
				if( $vv == "-1" )
					continue;
		
				if( $filters != "" )
					$filters .= " AND ";
		
				switch( $mode )
				{
					case 1:
						$filters .= " LOWER({$nn})=LOWER('{$vv}') ";
						$gbl_anyFilterOn = true;
						break;
					case 2:
						$allElements = explode(",", $vv);
						if( is_array( $allElements))
						{
							$filters .= " (";
							$first = true;
							foreach( $allElements as $single )
							{
								if( $first )
								{
									$filters .= " LOWER({$nn})=LOWER('{$single}') ";
									$first = false;
								}
								else
									$filters .= " OR LOWER({$nn})=LOWER('{$single}') ";
							}
							$filters .= ") ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 99:
						// Vediamo se è un filtro data (potrebbe essere doppio con la virgola, con o senza ora)
						$isDataora = false;
						
							// vediamo se c'è inizio e fine
							$_ar = explode( ",", $vv );
						
							$iii = $_ar[0] ?? "";
							$fff = $_ar[1] ?? "";
						
							if( DateTime::createFromFormat('d-m-Y H:i:s', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data-ora di inizio
								if( DateTime::createFromFormat('d-m-Y H:i:s', $fff) !== false)
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data-ora di fine pure
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d H:i:s', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$isDataora = true;
							}
							elseif( DateTime::createFromFormat('d-m-Y', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data di inizio
								if( DateTime::createFromFormat('d-m-Y', $fff) !== false)	
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data di fine pure
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$dt_start .= " 00:00:00";
								$dt_end .= " 23:59:59";
								$isDataora = true;
							}
						
						//
						if( $isDataora )
						{
							$filters .= " (LOWER({$nn}) >= '{$dt_start}' AND LOWER({$nn}) <= '{$dt_end}') ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 0:
					default:
						$filters .= " LOWER({$nn}) LIKE LOWER('%{$vv}%') ";
						$gbl_anyFilterOn = true;
						break;
				}
			}
		}
		
		// --------------------------------------------------------------------------------------------
		// se questo campo è NULL, non ci sono restrizioni, se è "" significa che nessun
		// elemento può essere visualizzato
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		
		$forcedWhiteListQuery = "";
		if( isset($_t['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $_t['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( isset($gbl_session['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $gbl_session['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( $forcedWhiteListQuery != "" )
		{
		///	$forcedWhiteListQuery = addslashes( $forcedWhiteListQuery );
			$forcedWhiteListQuery = str_replace('$gbl_userId', $gbl_userId, $forcedWhiteListQuery);
			$xxx = _dbGet($forcedWhiteListQuery);
			while( isset($xxx['id']))
			{
				$restrictedList[$xxx['id']] = true;
				$xxx = _dbGet();
			}
		}
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		// --------------------------------------------------------------------------------------------
		
		$hiddenFilter = "";
		if( isset($_t['ancillary']['hidden filter'][0]))
			$hiddenFilter = $_t['ancillary']['hidden filter'][0];
		
		if( isset($gbl_session['ancillary']['hidden filter'][0]))
			$hiddenFilter = $gbl_session['ancillary']['hidden filter'][0];
		
		if( $hiddenFilter != "" )
		{
			if( $filters != "" )
				$filters .= " AND ";
		
			$filters .= " " . $hiddenFilter . " ";
		}
		
		if( $filters != "" )
		{
			if( $gbl_query == "" )
				$filters = " WHERE " . $filters;
			else
				$filters = " AND " . $filters;
		}
		
		// anticipo sessione ----------------------
		if(	isset( $gbl_session['filter_wl'] ) && 
			is_array( $gbl_session['filter_wl']) &&
			count( $gbl_session['filter_wl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		
		if(	isset( $gbl_session['filter_bl'] ) && 
			is_array( $gbl_session['filter_bl']) &&
			count( $gbl_session['filter_bl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		// <------------------- sessione anticipata
		
		if(	isset( $gbl_session['filter_up']['field']) &&
			isset( $gbl_session['filter_up']['ord']) &&
			isset( $gbl_session['filter_up']['max']) )
		{
			$field = sanitize( $gbl_session['filter_up']['field'], "sql", $db_sql );
			$ord   = sanitize( $gbl_session['filter_up']['ord'], "sql", $db_sql );
			$max   = sanitize( $gbl_session['filter_up']['max'], "sql", $db_sql );
		
			// 3 giugno 2022 non metto il max, se ho già una query impostata 
			if( !$gbl_anyFilterOn )
				$filters .= " ORDER BY {$field} {$ord} LIMIT {$max}";
			else
				$filters .= " ORDER BY {$field} {$ord} ";
		
			$gbl_anyFilterOn = true;
		}
		else /// aggiunto 3 giugno 2022
		{
			$max = isset( $_t['ancillary']['forced max rows'][0] ) ? $_t['ancillary']['forced max rows'][0] : 0;
			if( $max == 0 )
				$max = isset( $gbl_session['ancillary']['forced max rows'][0] ) ? $gbl_session['ancillary']['forced max rows'][0] : 0;
		
			if( !$gbl_anyFilterOn && $max )
			{
				$filters .= " LIMIT {$max} ";
				$gbl_anyFilterOn = true;
			}
		}
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		
		
		
		
		$rec = _dbGet("SELECT $listaCampi FROM $gbl_tableName $gbl_query $filters;"); /// $gbl_query, se richiesto
		
		/// $forcedMaxRows = isset( $_t['ancillary']['forced max rows'][0] ) ? $_t['ancillary']['forced max rows'][0] : 0;
		
		$counter = 0;
		while($rec != NULL )
		{
		///	// -----------------------------------------------------------
		///	// SE RISCHIO DI AVERE TROPPE RIGHE ...
		///	if( $forcedMaxRows )
		///		if( ++$counter > $forcedMaxRows )
		///			break;
			// -----------------------------------------------------------
			// FILTRO FORCED WHITE LIST
			// se c'è una lista bianca obbligatoria e non fa parte della 
			// lista bianca: continue!
			if( $forcedWhiteList && !isset( $restrictedList[ $rec['id']] ))
			{
				$rec = _dbGet();
				continue;
			}
			
			// -----------------------------------------------------------
			// FILTRO WHITE LIST
			if( isset( $gbl_session['filter_wl']) && is_array( $gbl_session['filter_wl']) && count( $gbl_session['filter_wl']))
			{
				if( !in_array( $rec['id'], $gbl_session['filter_wl'] ))
				{
					$rec = _dbGet();
					continue;
				}
			}
			// -----------------------------------------------------------
			// FILTRO BLACK LIST
			if( isset( $gbl_session['filter_bl']) && is_array( $gbl_session['filter_bl']) && count( $gbl_session['filter_bl']))
			{
				if( in_array( $rec['id'], $gbl_session['filter_bl'] ))
				{
					$rec = _dbGet();
					continue;
				}
			}
			// -----------------------------------------------------------
			$idCode = "invalid";
			if( isset($rec["id"]))
			{
				$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
				$idCode = bin2hex(_encrypta( $rec['id'], $key ));
			}
			$content .= '<tr code="' . $idCode . '" class="editableRow gradeA">' . "\n";
		
			// GESTIONE DELLA COLONNA di CHECKBOX
			if( {{=getCheckboxColumn=}} && isset($rec["id"]) )
				$content .= '<td class="manina"><input iC="' . $rec["id"] . '" type="checkbox" class="manina xSelector"></td>' . "\n";
		
			foreach( $rec as $fieldName=>$field )
			{
				$field = $field != NULL && $field != "" ? htmlentities($field) : "";
				$type = "";
				if( isset($_t['info'][$fieldName][2]) )
					$type = trim($_t['info'][$fieldName][2]);
				
				
				switch( $type )
				{
					case "psw_":
						$content .= "<td>***</td>" . "\n";
						break;
					case "sel_":
						
						// la select id preleva sempre il titolo dalla tabella indicata nel nome stesso
						// se però vengono definite: tabella oppure titolo allora uso questi valori
						$table = isset( $_t['info'][$fieldName]['tabella'][0] ) ? $_t['info'][$fieldName]['tabella'][0] : $fieldName;
						$titolo = isset( $_t['info'][$fieldName]['titolo'][0] ) ? $_t['info'][$fieldName]['titolo'][0] : "titolo";
						$titolo2 = isset( $_t['info'][$fieldName]['titolo'][1] ) ? $_t['info'][$fieldName]['titolo'][1] : "";
						$titolo3 = isset( $_t['info'][$fieldName]['titolo'][2] ) ? $_t['info'][$fieldName]['titolo'][2] : "";
						$titolo4 = isset( $_t['info'][$fieldName]['titolo'][3] ) ? $_t['info'][$fieldName]['titolo'][3] : "";
						
						$campi = "id," . $titolo;
						if( $titolo2 != "" ) $campi .= ",".$titolo2;
						if( $titolo3 != "" ) $campi .= ",".$titolo3;
						if( $titolo4 != "" ) $campi .= ",".$titolo4;
						
						$other = new dbClass($db_sql_host, $db_sql_name, $db_sql_user, $db_sql_password);
						
						if( $other->isok())
						{
							$unrec = $other->get("SELECT {$campi} FROM {$table} WHERE id='{$field}';");
							$testo = isset( $unrec[$titolo] ) ? $unrec[$titolo] : "";
							$testo .= isset( $unrec[$titolo2] ) ? " " . $unrec[$titolo2] : "";
							$testo .= isset( $unrec[$titolo3] ) ? " " . $unrec[$titolo3] : "";
							$testo .= isset( $unrec[$titolo4] ) ? " " . $unrec[$titolo4] : "";
							if( $testo == "" )
								$testo = "";
						
							$content .= "<td>" . htmlentities( $testo ) . "</td>" . "\n";
						}
						
						
						
						
						
						break;
					case "sel1_":
						
						// la select id preleva sempre il titolo dalla tabella indicata nel nome stesso
						// se però vengono definite: tabella oppure titolo allora uso questi valori
						$table = isset( $_t['info'][$fieldName]['tabella'][0] ) ? $_t['info'][$fieldName]['tabella'][0] : $fieldName;
						$titolo = isset( $_t['info'][$fieldName]['titolo'][0] ) ? $_t['info'][$fieldName]['titolo'][0] : "titolo";
						
						$other = new dbClass($db_sql_host, $db_sql_name, $db_sql_user, $db_sql_password);
						
						unset($additional);
						
						if( $other->isok())
						{
							$allSelections = explode(",", $field);
							$additional = "";
							foreach( $allSelections as $sel )
							{
								if( $additional == "" )
									$additional = " WHERE id='{$sel}'";
								else		
									$additional .= " OR id='{$sel}'";
							}
							$unrec = $other->get("SELECT {$titolo} FROM {$table} {$additional};");
							$additional = "";
							while( isset( $unrec[ $titolo]))
							{
								if( $additional == "" )
									$additional = $unrec[ $titolo];
								else		
									$additional .= "," . $unrec[ $titolo];
						
								$unrec = $other->get();
							} 
						}
						
						$content .= isset( $additional ) ? "<td>" . htmlentities( $additional ) . "</td>" . "\n" : "<td>?</td>" . "\n";
						
						
						
						
						
						break;
					case "anx_":
						
						if( isset($rec['id']))
						{
							// ARRAY
							$dat = array();
							$dat['t'] = $gbl_tableName;
							$dat['f'] = $fieldName;
							$dat['id'] = $rec['id'];
							// JSON
							$dat = json_encode( $dat );
							// ENCRYPT
							$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
							$dat = _encrypta( $dat, $key );
							// BASE64/BIN2HEX
							$dat = bin2hex( $dat );
							$onClick = "";
							$disabled = "";
						
							if( $field == NULL )
							{
								$onClick = ' onclick="return false" ';
								$disabled = "color:gray";
							}
						
							$content .= <<<EOT
										<td>
											<a {$onClick} href="index.php?fx=dlanx&data={$dat}"><i class="fa fa-download" noExpansion="true" style="{$disabled};display:block; float:left; font-size:20px; margin-left:7px;"></i></a>
										</td>
							EOT;
						}
						else
							$content .= "<td>*_i-id*</td>" . "\n";
						
						
						
						break;
					case "i_":
						
						if( isset($rec['id']))
						{
							// ARRAY
							$dat = array();
							$dat['t'] = $gbl_tableName;
							$dat['f'] = $fieldName;
							$dat['id'] = $rec['id'];
							// JSON
							$dat = json_encode( $dat );
							// ENCRYPT
							$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
							$dat = _encrypta( $dat, $key );
							// BASE64/BIN2HEX
							$dat = bin2hex( $dat );
							$onClick = "";
							$disabled = "";
						
							if( $field == NULL )
							{
								$onClick = ' onclick="return false" ';
								$disabled = "color:gray";
							}
						
							$content .= <<<EOT
										<td>
											<a href="index.php?fx=ixmage&data={$dat}" data-plugin-lightbox data-plugin-options='{ "type":"image" }' title="">
												<img class="img-responsive" style="display:block; float:left; height:20px;" src="index.php?fx=ixmage&data={$dat}&l=50&a=50"></img>
											</a>
											<a {$onClick} href="index.php?fx=dlanx&data={$dat}"><i class="fa fa-download" noExpansion="true" style="{$disabled}display:block; float:left; font-size:20px; margin-left:7px;"></i></a>
										</td>
							EOT;
						}
						else
							$content .= "<td>*_i-id*</td>" . "\n";
						
						
						
						break;
					case "dt_":
						
								if( $field != "" && $field != NULL )
								{
									$field = intval( $field );
									$tempus = date( "d/m/Y", $field );
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dtt_":
						
								if( $field != "" && $field != NULL )
								{
									$field = intval( $field );
									$tempus = date( "d/m/Y G:i:s", $field);
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dts_":
								if( $field != "" && $field != NULL )
								{
									$field = strtotime( $field ); // da stringa a intero oppure ""
									$tempus = date( "d/m/Y", $field );
									if( $field == "" ) $field = 0;
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dtts_":
						
								if( $field != "" && $field != NULL )
								{
									$field = strtotime( $field ); // da stringa a intero oppure ""
									$tempus = date( "d/m/Y G:i:s", $field);
									if( $field == "" ) $field = 0;
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "ck_":
						// CARICO I NOMI DI DEFAULT
						$nomeVero = isset( $_t['info'][$fieldName]['TRUE'][0] ) ? $_t['info'][$fieldName]['TRUE'][0] : "TRUE";
						$nomeFalso = isset( $_t['info'][$fieldName]['FALSE'][0] ) ? $_t['info'][$fieldName]['FALSE'][0] : "FALSE";
						// -----------------------------------------------------------------------------------------------------
						if( is_int($field) && $field == 1 )
							$field = "true";
						if( is_int($field) && $field == 0 )
							$field = "false";
						$field = strtolower( $field );
						if( $field == "true" || $field == "ok" || $field == "yes" || $field == "sì" || $field == "si" || $field == "vero" )
							$field = $nomeVero;
						else
							$field = $nomeFalso;
						$content .= "<td>{$field}</td>\n";
						break;
					case "tx_":
					case "mm_":
					default:
						if( !isset($buttonActions ) || $buttonActions == "" )
							$content .= "<td>{$field}</td>" . "\n";
						else
						{
							$content .= str_replace("[[sostituisciQui]]", $field, $buttonActions);
							$buttonActions = "";
						}
						break;
				}
				
				
				
				
				
				
			}
		
			
			$pulsanteModify = "";
			
			if( !isset( $_t['ancillary']['disabled']) ||
				!in_array( "MODIFY", $_t['ancillary']['disabled']))
			{
				$pulsanteModify = <<<EOT
					<a href="#" class="on-default edit-row"><i class="fa fa-pencil"></i></a>
				EOT;
			}
			
			
			$pulsanteDelete = "";
			
			if( !isset( $_t['ancillary']['disabled']) ||
				!in_array( "DELETE", $_t['ancillary']['disabled']))
			{
				$pulsanteDelete = <<<EOT
					<a href="#" class="on-default remove-row"><i class="fa fa-trash-o"></i></a>
				EOT;
			}
			
			$pulsanteOpt1 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt1'][3]) ? 'title="' . $_t['ancillary']['buttonOpt1'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt1'][0]) && isset( $_t['ancillary']['buttonOpt1'][1]) && isset( $_t['ancillary']['buttonOpt1'][2]))
			{
				$pulsanteOpt1 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt1'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt1'][1]}" class="optionButton {$_t['ancillary']['buttonOpt1'][0]}"></i></a>
				EOT;
			}
			
			$pulsanteOpt2 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt2'][3]) ? 'title="' . $_t['ancillary']['buttonOpt2'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt2'][0]) && isset( $_t['ancillary']['buttonOpt2'][1]) && isset( $_t['ancillary']['buttonOpt2'][2]))
			{
				$pulsanteOpt2 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt2'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt2'][1]}" class="optionButton {$_t['ancillary']['buttonOpt2'][0]}"></i></a>
				EOT;
			}
			
			$pulsanteOpt3 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt3'][3]) ? 'title="' . $_t['ancillary']['buttonOpt3'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt3'][0]) && isset( $_t['ancillary']['buttonOpt3'][1]) && isset( $_t['ancillary']['buttonOpt3'][2]))
			{
				$pulsanteOpt3 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt3'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt3'][1]}" class="optionButton {$_t['ancillary']['buttonOpt3'][0]}"></i></a>
				EOT;
			}
			
			
		
			$content .= <<<EOT
				<td class="actions">
					<a href="#" class="hidden on-editing save-row"><i class="fa fa-save"></i></a>
					<a href="#" class="hidden on-editing cancel-row"><i class="fa fa-times"></i></a>
					{$pulsanteModify}
					{$pulsanteDelete}
					{$pulsanteOpt1}
					{$pulsanteOpt2}
					{$pulsanteOpt3}
				</td>
			</tr>
		EOT;
		
			$rec = _dbGet();
		}
		
		
		
		if( $gbl_anyFilterOn )
		{
			$testoFiltro = "Filtri Attivi";
			$tipoFiltro = "btn-warning";
		}
		else
		{
			$testoFiltro = "Filtra";
			$tipoFiltro = "btn-default";
		}
		
		
		$pulsanteAdd = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "ADD", $_t['ancillary']['disabled']))
		{
			$pulsanteAdd = <<<EOT
				<button id="<!--addFunctionId-->" type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-plus"></i> Aggiungi</button>
			EOT;
		}
		
		
		$pulsanteFilter = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "FILTER", $_t['ancillary']['disabled']))
		{
			$pulsanteFilter= <<<EOT
				<a class="mb-xs mt-xs mr-xs btn {$tipoFiltro}" href="index.php?fx=frmFilterRecord" role="button"><i class="fa fa-filter"></i> {$testoFiltro}</a>
			EOT;
		}
		
		
		$pulsanteExport = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "EXPORT", $_t['ancillary']['disabled']))
		{
			$pulsanteExport = <<<EOT
				<a class="mb-xs mt-xs mr-xs btn btn-default" href="index.php?fx=frmExportRecord{$getFandQ}" role="button"><i class="fa fa-file-excel-o"></i> Esporta</a>
			EOT;
		}
		
		
		
		
		
		
		
		$headingStyle = "";
		
		$t6 = $_t['ancillary']['header color'][0] ?? "";
		
		if( $t6 != "" )
			$headingStyle = ' style="background-color:' . $t6 . ';"';
		
		
		$headingTitle = "";
		
		$t6 = $_t['ancillary']['header title'][0] ?? "";
		
		if( $t6 != "" )
			$headingTitle = $t6;
		
		
		
		$what = <<<EOT
		
		
							<!-- start: page -->
		
								{{=getSelectors=}}
		
								<section class="panel">
									<header {$headingStyle} class="panel-heading">
										<div class="panel-actions">
											<a href="#" class="fa fa-caret-down"></a>
											<a href="#" class="close-all fa fa-times"></a>
										</div>
											{$pulsanteAdd}
											{$pulsanteFilter}
											{$pulsanteExport}
											{{=getPulsanteIndietro=}}
											<h2 style="display: inline-block; width:40%; text-align:center;" class="panel-title">{$headingTitle}</h2>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-file-excel-o"></i> Esporta</button>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-filter"></i> Filtra</button>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-info"><i class="fa fa-thumbs-up"></i> </button>
									</header>
									<div class="panel-body">
		///								<div class="row">
		///									<div class="col-sm-6">
		///										<div class="mb-md">
		///											<button id="<!--addFunctionId-->" style="text-shadow:none;" class="btn btn-success">Aggiungi <i class="fa fa-plus"></i></button>
		///										</div>
		///									</div>
		///								</div>
										<table class="table table-bordered table-striped mb-none" id="datatable-editable">
											<thead>
												<tr>
													{$headers}
												</tr>
											</thead>
											<tbody>
												{$content}
											</tbody>
										</table>
									</div>
								</section>
		
								{{=getActionsPage=}}
		
							<!-- end: page -->
		
		
		EOT;
		
		return $what;
		
		]>
	getFieldsConfiguration
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		// ----------------------------------------------
		$configs = "";
		
		// GESTIONE DELLA COLONNA di CHECKBOX
		if( {{=getCheckboxColumn=}} )
			$configs .= '\n{ "bSortable": false },';
		
		foreach($struct as $fieldName)
		{
			// ------------------------------------------------------------------------------------------------------------------------
			// ottengo $type dal database oppure da info, devo capire se è un numero, un testo oppure altro da ordinare opportunamente
			// per datatables
			// per ora la verifica la facciamo unicamente sul tipo reale nel database, in un secondo tempo potrebbe anche andare 
			// su 	if( !isset( $_t['info'][ $field['nome']][8]) )
			$tipo = "undefined";
			
			
			$tipo = isset($gbl_struct[$fieldName]["real_type"]) ? $gbl_struct[$fieldName]["real_type"] : "STRING";
			
			if( isset($_t['info'][$fieldName][8] ))
				$tipo = $_t['info'][$fieldName][8];
			
			if( $tipo == "int" || $tipo == "bigint" || $tipo == "integer" )
				$tipo = "INTEGER";
			elseif( $tipo == "currency" )
				$tipo = "CURRENCY";
			else
				$tipo = "STRING";
			
			
			
			
			// ------------------------------------------------------------------------------------------------------------------------
			switch( $tipo ) //1 ATTENZIONE, NON FUNZIONA IN DATATABLES -> VEDI columnDefs in buildTableFunction (gestione tasti veloce e javascript specifico, quello funziona)
			{
				case "INTEGER":
					$configs .= '\n{ "sType": "num" },';
				break;
				case "CURRENCY":
					$configs .= '\n{ "sType": "currency" },';
				break;
				case "STRING":
				default:
					$configs .= "\nnull,"; // per ora, sempre standard
				break;
			}
		}
		
		return $configs . "\n";
		
		
		]>
	getEmptyFields
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		// ----------------------------------------------
		$configs = "";
		
		// GESTIONE DELLA COLONNA di CHECKBOX
		if( {{=getCheckboxColumn=}} )
			$configs .= "''";
		
		foreach($struct as $field)
		{
			if( $configs == "" )
				$configs .= "''";
			else
				$configs .= ",''";
		}
		
		return $configs;
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<script src="<!--relativeDirectory-->/javascripts/tables/examples.datatables.editable.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/forms/examples.advanced.form.js" /></script>
		<script>
		var oTableStaticFlow;
		
		function dammiIlNumeroDiElementiSelezionati()
		{
			/// oTableStaticFlow è una variabile globale della tbEdit
			var cols = oTableStaticFlow.column(0).nodes();
			var count = 0;
			for (var i = 0; i < cols.length; i += 1) 
			{
				if(	$(cols[i].querySelector("input[type='checkbox']")).prop("checked"))
					count++;;
			}
			return count;
		}
		
		function aggiornaNumeroElementiSelezionati()
		{
			var n = dammiIlNumeroDiElementiSelezionati();
			$(".numeroElementiSelezionati").html(n + "");
			$(document).trigger("checkedElements:", n);
		}
		
		// ----------------------------------------------------------------------
		// FUNZIONE OPZIONALE PER L'INSERIMENTO DI UN RECORD CON LA FORM COMPLETA
		// ----------------------------------------------------------------------
		$( document ).ready(function() {
		    $('#addToTableAsForm').on("click", function(){window.location.href = "{{=getAddFunctionName=}}{{=getFParameter=}}";});
			/// -------------------------------------------------------------
			/// Per la barra di selezione in alto, per consentire lo scroll 
			/// delle selezioni
		///	$(".multiselect-container.dropdown-menu").css("overflow", "auto");
		///	$(".multiselect-container.dropdown-menu").css("max-height", "300px");
			/// -------------------------------------------------------------
		});
		// ----------------------------------------------------------------------
		
		$(".multiSelect").multiselect({
		  nonSelectedText:'Nessuno'
		});
		
		// ITALIAN PLUGIN CURRENCY, modificata da me
		// FUNZIONA SIA CON IL PUNTO CHE CON LA VIRGOLA
		
		jQuery.extend( jQuery.fn.dataTableExt.oSort, {
		    "currency-pre": function ( a ) {
				a = a.replace( /[\,]/g, "." );
				a = (a==="-") ? 0 : a.replace( /[^\d\-\.]/g, "" );
				return parseFloat( a );
		    },
		 
		    "currency-asc": function ( a, b ) {
		        return a - b;
		    },
		 
		    "currency-desc": function ( a, b ) {
		        return b - a;
		    }
		} );
		
		
		function buildTableFunction(me) 
		{
			me.datatable = me.\$table.DataTable({
		
				"order": [{{=getSavedSorting=}}],
				language: {
					url: '<!--relativeDirectory-->/javascripts/tables/dataTables.italian.json'
				},
				"search": {
					"search": "{{=getSavedSearchString=}}"
				},
				"pageLength": {{=getSavedPageLength=}},
				"fnInitComplete": function(oSettings, json) {
					// ------------------------------------------------------------------------
					// COMPLETO INIZIALIZZAZIONE, ALTRIMENTI LA GRAFICA SI CORROMPE
					// ------------------------------------------------------------------------
					$.fn.dataTable.defaults.fnInitComplete(oSettings, json);
					// ------------------------------------------------------------------------
					// CALLBACK GESTIONE DELLE PERSISTENZE
					// ------------------------------------------------------------------------
					
						// ------------------------------------------------------------------------
						// COLLEGO IL CAMBIO SEARCH CON IL SUO SALVATAGGIO
						// ------------------------------------------------------------------------
						$('#datatable-editable_filter input').on("keyup", function () {
					
							var valore = $(this).val();
								
							if( valore == "" )
							{
								$('.table-responsive').css("border-color", "");
								$('.table-responsive').css("border-width", "0px");
								$(this).css("border-color", "");
							}
							else
							{
								$('.table-responsive').css("border-color", "orange");
								$('.table-responsive').css("border-width", "1px");
								$('.table-responsive').css("border-style", "solid");
								$(this).css("border-color", "orange");
							}
					
							var reply = ajaxCall( "ajaxSavePersValue", "pers:search string", valore, "", null );
							var table = $('#datatable-editable').DataTable();
							var info = table.page.info();
					
						});
					
						// ------------------------------------------------------------------------
						// cambio il colore della tabella se la search seleziona qualcosa
						// ------------------------------------------------------------------------
						if( $('#datatable-editable_filter label input').val() != "" )
						{
							$('.table-responsive').css("border-color", "orange");
							$('.table-responsive').css("border-width", "1px");
							$('.table-responsive').css("border-style", "solid");
							$('#datatable-editable_filter label input').css("border-color", "orange");
						}
					
						// ------------------------------------------------------------------------
						// AJAX -> salvo il valore del numero di pagina attuale nel DB tb_sessione
						// ------------------------------------------------------------------------
						$('#datatable-editable').on( 'draw.dt', function () {
							var table = $('#datatable-editable').DataTable();
							var info = table.page.info();
							var reply = ajaxCall( "ajaxSavePersValue", "pers:page number", info.page, "", null );
						});
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL NUMERO DELLA PAGINA
						// ------------------------------------------------------------------------
						$('#datatable-editable').DataTable().page({{=getSavedPageNumber=}}).draw(false);
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL NUMERO DELLA PAGINA
						// ------------------------------------------------------------------------
						$('#datatable-editable').on( 'length.dt', function ( e, settings, len ) {
							var reply = ajaxCall( "ajaxSavePersValue", "pers:page length", len, "", null );
						} );
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL SORTING PREGRESSO
						// ------------------------------------------------------------------------
						function sortingFun ( e ) {
					
							var what = "";
					
							if( $(e.target).hasClass("sorting_asc"))
								what = "["+ $(this).index() + ", 'asc']";
							
							if( $(e.target).hasClass("sorting_desc"))
								what = "["+ $(this).index() + ", 'desc']";
					
							var reply = ajaxCall( "ajaxSavePersValue", "pers:sorting", what, "", null );
					
						}
					
						$(".sorting").on( 'click', sortingFun );
						$(".sorting_asc").on( 'click', sortingFun );
						$(".sorting_desc").on( 'click', sortingFun );
					
					///	$('#datatable-editable').order("{{=getSavedSorting=}}").draw();
					
		///	eraser->		$('.dataTables_filter').append('<button class="btn btn-default mr-xs pull-right searchTextEraser" type="button"><i class="fa fa-eraser searchTextEraser" aria-hidden="true"></i></button>');
				},
				"aoColumns": [
						{{=getFieldsConfiguration=}}
						{ "bSortable": false }
					]
				});
		
			window.dt = me.datatable;
			/// SALVO LA TABELLA STATICA per GESTIONE CHECKBOX -----
			oTableStaticFlow = me.datatable;
			/// ----------------------------------------------------
			return me;
		}
		
		// -----------------------------------------------------------
		
		//1 CONDIVISA, NON MODIFICARE: FUNZIONI E VARIABILI STATICHE, AJAXCALL E CONVERSIONE BASE64
		
		var theEmptyRow = [ {{=getEmptyFields=}} ];
		var theTableName = "{{=getTableName=}}";
		
		function utf8ToHex(str) {
			return Array.from(str).map(c => 
				c.charCodeAt(0) < 128 ? c.charCodeAt(0).toString(16) : 
				encodeURIComponent(c).replace(/\%/g,'').toLowerCase()
			).join('');
		}
		
		function hexToUtf8(hex) {
			return decodeURIComponent('%' + hex.match(/.{1,2}/g).join('%'));
		}
		
		function utf8_to_b64( str ) {
			return window.btoa(unescape(encodeURIComponent( str )));
		}
		
		function b64_to_utf8( str ) {
			return decodeURIComponent(escape(window.atob( str )));
		}
		
		function ajaxCall( funzione, nome, valore, tipo, callback ) {
		
			/// nome = JSON.stringify(nome + "." + funzione ); // to JSON
			var name = utf8_to_b64( nome ); // to BASE64
			/// valore = JSON.stringify(valore); // to JSON
			var value = utf8_to_b64( valore ); // to BASE64
			var type = utf8_to_b64( tipo ); // to BASE64
		
			var jqxhr = $.post( "index.php?fx=" + funzione, { nome: name, valore: value, tipo: type }, function(data) {
		///			alert( "success:" + data );
				})
				.done(function(data) {
		///			alert( "second success:" + data );
				})
				.fail(function(data) {
		///			alert( "error:" + data );
				})
				.always(function(data) {
		
					if( callback !== null )
						callback(data);
				});
		}
		
		
		//1 CONDIVISA, NON MODIFICARE: FUNZIONI E VARIABILI STATICHE, AJAXCALL E CONVERSIONE BASE64
		
		// -----------------------------------------------------------
		
		// -------------------------------------------------------------
		
		//0 -----------------------------------------------------------------------------
		//0 format function for row details
		function fnFormatDetails( datatable, tr, callback ) 
		{
			// --------------------------------------------------------------------------------------
			// RECUPERO L'ID CRIPTATO DELL'ELEMENTO
			var data = datatable.row( tr ).data();
			var code = $(tr).attr("code");
			if( code == undefined || code == "")
				return "";
			// --------------------------------------------------------------------------------------
			// RACCOLGO LE INFORMAZIONI DAL SERVER
			ajaxCall( "getElementDetails", "tb_utente", code, "", function(info) {
		
				var retValue = [
					'<table style="background-color:#fee;" class="table mb-none">',
						'<tr class="b-top-none">',
							'<td>Nessun dettaglio</td>',
						'</tr>',
					'</table>'
					].join(''); 
		
				if( info != "" )
				{
					// --------------------------------------------------------------------------------------
					// CONVERSIONE DA BASE64 a BINARIO
					info = b64_to_utf8( info );
					if( info != "" )
					{
						// --------------------------------------------------------------------------------------
						// CONVERSIONE DA JSON A STRUTTURA
						info = JSON.parse(info);
						if( info != undefined )
							retValue = info['html'];
					}
				}
				// --------------------------------------------------------------------------------------
				if( callback != null )
					callback(retValue);
		
			});
		}
		
		/// _[VECCHIA RETURN]
		
		// -------------------------------------------------------------
		
		var globalSelectedElement = "";
		
		$( document ).ready(function() {
		
			$(document).on('keypress', function(e){	
				
				if(e.which === 43)
				{
					window.location.href = "{{=getAddFunctionName=}}{{=getFParameter=}}";
				}
				
				
			});
			
			$(document).on("click", function(e){
				
						// CANCELLAZIONE TESTO SEARCH BOX
						if( $(e.target).hasClass("searchTextEraser"))
						{
							$('.dataTables_filter input').val('');
							var table = $("#datatable-editable").DataTable();
							table.search('').draw(); //required after
							$('#datatable-editable_filter input').trigger("keyup");
							return false;
						}
						// PULSANTE DI CHIUSURA E X
						if( $(e.target).hasClass("close-all"))
						{
							window.location.href='{{=backAddress=}}';
							return false;
						}
				
						if( $(e.target).hasClass("fa-trash-o"))
						{
							var parent = e.target.closest('tr');
							var text = jQuery(parent).find("td:eq(1)").text();
							$(".eToDelete").text(text);
							// non fermare lo script, deve andare a settare il globalSelectedElement element
						}
				
						/// ------------------------------
						/// GESTIONE SELETTORI MULTI LINEA
						if( $(e.target).hasClass("xSelectorMain"))
						{
							var cols = oTableStaticFlow.column(0).nodes(),
							state = $(e.target).is(':checked');
							for (var i = 0; i < cols.length; i += 1) {
								cols[i].querySelector("input[type='checkbox']").checked = state;
							}
							aggiornaNumeroElementiSelezionati();
							return true; 
						}
				///		_[vecchia gestione: sdfg]
				
						if( $(e.target).hasClass("xSelector"))
						{
							aggiornaNumeroElementiSelezionati();
							return true; 
						}
				
						var cella = e.target.closest('td');
						var cbPotenziale = $(cella).find(':checkbox');
				
						if( $(cbPotenziale).hasClass("xSelector") )
						{
							$(cbPotenziale).trigger("click");
							return true; // true: lascia correre la catena degli eventi
						}
				
						var cella = e.target.closest('th');
						var cbPotenziale = $(cella).find(':checkbox');
				
						if( $(cbPotenziale).hasClass("xSelectorMain") )
						{
							$(cbPotenziale).trigger("click");
							return true; // true: lascia correre la catena degli eventi
						}
						/// ------------------------------
				
						if( $(e.target).hasClass("optionButton"))
							return true;
				
						if( $(e.target).closest('td').hasClass("actions") &&
							!$(e.target).closest('a').hasClass("edit-row"))
						{
							var me = e.target.closest('tr');
							globalSelectedElement = $(me).attr("code");
							return false;
						}
				
						if( $(e.target).hasClass("actions"))
							return true;
				
						var me = e.target.closest('tr');
				
						if( ! $(me).hasClass("editableRow"))
							return true;
				
						// ------------------------------
						// riga cliccata da qualche parte 
						// ------------------------------
						var code = $(me).attr("code");
						if( code != "invalid" )
						{
							if( $(e.target).hasClass("fa fa-pencil"))
								window.location.href = "index.php?fx=frmEditRecord&e=" + code;
							else {
								
									var cella = e.target.closest('td');
									var immaginePotenziale = $(cella).find("a:first");
									var attr = $(immaginePotenziale ).attr("data-plugin-lightbox");
								
									if (attr != undefined )
										return true;
								
									var icona = $(cella).find("i:first");
									attr = $(icona).attr("noExpansion");
								
									if (attr != undefined )
										return true;
									
									
								
								
				///				_[VERIFICO SE SI TRATTA DI UN CAMPO CHECKBOX]
								
								
								
										var table = $("#datatable-editable").DataTable();
										var tr = $(e.target).closest( 'tr' ).get(0);
										var row = table.row( tr );
								
										if( row.child.isShown())
										{
											// This row is already open - close it
											row.child.hide();
										}
										else
										{
											// Open this row (the format() function would return the data to be shown)
											fnFormatDetails( table, tr, function(formattedDetails) {
												row.child( formattedDetails ).show();
											});
										}
								
								
				///				_[COMPILA IL CONTEXT MENU' LATERALE]
							}
						}
						else
							console.log("row click invalid!"); 
				
						return true;
				
			});
		
			aggiornaNumeroElementiSelezionati();
		});
		
		</script>
		
		<script>
		
		let fxName = "{{=getFxName=}}";
		let sys_value = "";
		
		$(document).ready( function() {
			setInterval( function () {
				$.post( "index.php?fx=ajax_sys", { caller: fxName }).done( function( data ) {
		
					if( data == "" )
						return;
		
					if( sys_value == "" )
						sys_value = data;
					else
					{
						if( data != sys_value )
							location.reload();
					}
				});
			}, 5000);
		});
		</script>
		
		
		{{=getAltroJavascript=}}
		]>
	getAltroJavascript
		return "";
	getFxName
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			return	 $gbl_fx;
		]>
	ADDITIONAL CSS BARE FRAME
		<[
			<style>
				.manina {
					cursor: pointer;
				}
			</style>
		]>
	init
		<[
		/// INIZIALIZZO LE VARIABILI GLOBALI
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		//1 BOLLA CONDIVISA
		
		$fil = array();
		$paginaMaster = trim(sanitize( $gbl_fx, "sql", $db_sql));
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		
		if( isset($rec['valore']))
		{
			$fil = hex2bin($rec['valore']);
			$fil = json_decode( $fil, true);
			if( isset( $fil['filter']) && is_array( $fil['filter']))
				$gbl_session['filter'] = $fil['filter'];		
			if( isset( $fil['filter_type']) && is_array( $fil['filter_type']))
				$gbl_session['filter_type'] = $fil['filter_type'];
			if( isset( $fil['filter_up']) && is_array( $fil['filter_up']))
				$gbl_session['filter_up'] = $fil['filter_up'];
			if( isset( $fil['filter_custom']) && is_array( $fil['filter_custom']))
				$gbl_session['filter_custom'] = $fil['filter_custom'];
			if( isset( $fil['filter_wl']) && is_array( $fil['filter_wl']))
				$gbl_session['filter_wl'] = $fil['filter_wl'];
			if( isset( $fil['filter_bl']) && is_array( $fil['filter_bl']))
				$gbl_session['filter_bl'] = $fil['filter_bl'];
		}
		
		//1 BOLLA CONDIVISA
		
		
		$keepValues = "AND nome NOT LIKE 'value:%'";
		if( isset($_REQUEST['clean']) || TRUE ) //1 PULISCO SEMPRE I VALORI ALL'INGRESSO E STOP
			$keepValues = "";
		
		if( $gbl_userId != 0 && $gbl_idSessione != 0 )
		{
			//2 LO STACK NON VIENE CANCELLATO PERCHE' HA pagina == ""
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx' {$keepValues} AND nome NOT LIKE 'pers:%' AND nome <> 'filters';");
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND nome='nome funzione';");
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND nome='nome tabella';");
			// ------------------------------------------------------------------
			// CREO IL RECORD
			$r = array();
			$r['tb_utente'] = $gbl_userId;
			$r['tb_sessione'] = $gbl_idSessione;
			$r['pagina'] = $gbl_fx;
			// ------------------------------------------------------------------
			// SALVO IL NOME DELLA FUNZIONE
			$r['nome'] = 'nome funzione'; 
			$r['valore'] = $gbl_fx;
			db_sql_insert_2("tb_parametro", $r );
			// ------------------------------------------------------------------
			// SALVO IL NOME DELLA TABELLA
			$r['nome'] = 'nome tabella';
			$r['valore'] = '{{=getTableName=}}';
			db_sql_insert_2("tb_parametro", $r );
			// ------------------------------------------------------------------
			// SALVO GLI EVENTUALI SUGGERIMENTI INSERIMENTO CAMPI
			if( isset($_t['info']) && is_array( $_t['info']))
			{
				$aS = json_encode($_t['info']);
				$r['nome'] = 'omnia.info';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO GLI ELEMENTI ADDIZIONALI DELLA TABELLA
			if( isset($_t['ancillary']) && is_array( $_t['ancillary']))
			{
				$aS = json_encode($_t['ancillary']);
				$r['nome'] = 'omnia.ancillary';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO LA DESCRIZIONE DEI DETTAGLI
			if( isset($_t['details']) && is_array( $_t['details']))
			{
				$aS = json_encode($_t['details']);
				$r['nome'] = 'omnia.details';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO GLI ELEMENTI SOTTOPAGINE
			if( isset($_t['subpages']) && is_array( $_t['subpages']))
			{
				$aS = json_encode($_t['subpages']);
				$r['nome'] = 'omnia.subpages';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
		}
		
		
		
		
		if( !isset( $gbl_session['filter_up']) && 
			isset( $_t['ancillary']['defaults'][0]) &&
			isset( $_t['ancillary']['defaults'][1]) &&
			isset( $_t['ancillary']['defaults'][2]) )
		{
			$gbl_session['filter_up']['max'] = $_t['ancillary']['defaults'][0];
			$gbl_session['filter_up']['field'] = $_t['ancillary']['defaults'][1];
			$gbl_session['filter_up']['ord'] = $_t['ancillary']['defaults'][2];
		}
		
		
		
///		_[SALVO I DATI NELLO STACK PER POSIZIONE E NOME PAGINA]
		]>
	info
//		field1: Inserire il campo 1
//		field2: Inserire il campo 2
	addFunctionId
//	addToTable oppure addToTableAsForm
		addToTableAsForm
	getFatherName
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			$nomePadre = "";
			
			//1 -----------------------------------------------------------------------
			//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
			//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
			//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
			//1 -----------------------------------------------------------------------
			if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
			{
				// -----------------------------------------------------------------------
				// CARICO IL MIO STACK
				// -----------------------------------------------------------------------
				$gbl_stack = array();
				$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
				{
					// -------------------------------------------------------------------
					// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
					// -------------------------------------------------------------------
					$stack = array();
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$stack[] = $e;
					$stack = json_encode( $stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					$idStack = db_sql_insert_2("tb_parametro", $r );
				}
				else
				{
					$idStack = $rec['id'];
					$stack = $rec['valore'];
				}
				// -----------------------------------------------------------------------
				// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
				// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
				// -----------------------------------------------------------------------
				$stack = hex2bin( $stack );
				$stack = json_decode( $stack, true );
				if( $stack != NULL )
				{
					if( is_array($stack) && count( $stack) > 0)
					{
						// echo "\n -PRIMA ----------------------\n";
						// var_dump ($stack);
						if( !<!--resetStack--> )
						{
							foreach( $stack as $s )
							{
								if( $s['pagina'] == $gbl_fx )
									break;
								$gbl_stack[] = $s;
							}
						}
				
						$e = array();
						$e['tabella'] = '{{=getTableName=}}';
						$e['pagina'] = $gbl_fx;
						$e['titolo'] = '{{=title=}}';
						$e['icona'] = '{{=getIcon=}}';
						$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
						$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
						$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
						$gbl_stack[] = $e;
						// echo "\n - DOPO ----------------------\n";
						// var_dump ($gbl_stack);
						$stack = json_encode( $gbl_stack );
						$stack = bin2hex( $stack );
						$r = array();
						$r['id'] = $idStack;
						$r['tb_utente'] = $gbl_userId;
						$r['tb_sessione'] = $gbl_idSessione;
						$r['pagina'] = "";
						$r['nome'] = "stack";
						$r['valore'] = $stack;
						db_sql_update_2("tb_parametro", $r,"id",$idStack);
					}
				}
				
				/// echo "\n -STACK ----------------------\n";
				/// var_dump ($gbl_stack);
				
				
			}
			
			
			// -----------------------------------------------------------------------
			// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
			// QUI SONO IN UNA tbEdit chiamata da una tbEdit
			// mi aspetto di avere nello stack 2 elementi: mio padre e me stesso
			// -----------------------------------------------------------------------
			if( !isset( $_REQUEST['f']))
				return "";
			
			$passedFather = $_REQUEST['f'];
			// --------------------------------------------------------
			// DECRITTO PASSED FATHER
			$passedFather = hex2bin( $passedFather);
			$passedFather = _decrypta($passedFather, "AZ$9099" . $gbl_idSessione . $gbl_userId);
			
			if( $passedFather == "***" )
				return "";
			
			/// _[CARICO SOLO LA VARIABILE STACK, SENZA SCRIVERE I MIEI DATI]
			/// var_dump( $gbl_stack );
			// --------------------------------------------------------
			if( !isset( $gbl_stack) || !is_array($gbl_stack) || (count( $gbl_stack)<2))
				return "";
			
			// PRENDO il PENULTIMO ELEMENTO
			$recFather = $gbl_stack[ count($gbl_stack)-2];
			$dbTitle = $recFather['dbTitolo'];
			$tableName = $recFather['tabella'];
			
			$dat = _dbGet("SELECT {$dbTitle} FROM {$tableName} WHERE id='{$passedFather}';");
			
			if( $dat == NULL || !is_array( $dat))
				return "";
			
			$nomePadre = isset($dat[$dbTitle])?$dat[$dbTitle]:"";
			
			
			
			return htmlentities($nomePadre);
		]>

tbTreeEdit

	di tipo
		frameMain
	permessi
		USER
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
	getDirectory
		return "backup/weekly";
	getTitle
		return "Elenco Backup Automatici";
	getSubTitle
		return "Elenco dei Backup Disponibili. Cliccare sul nome per scaricare il file";
	getOctopusMainContent
		<[
		
		
		
		$treeContent = "";
		
		
		function scan_dir($dir) {
		    $ignored = array('.', '..', '.svn', '.htaccess');
		
		    $files = array();    
		    foreach (@scandir($dir) as $file) {
		        if (in_array($file, $ignored)) continue;
		        $files[$file] = filemtime($dir . '/' . $file);
		    }
		
		    arsort($files);
		    $files = array_keys($files);
		
		    return ($files) ? $files : false;
		}
		
		function getAllDirectories($what, $dir)
		{
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			$l = @scan_dir( $dir );
		
			if( !is_array( $l))
				return $what;
		
			foreach( $l as $e )
			{
				if( $e == "." || $e == ".." )
					continue;
		
				if( is_dir( $dir . "/" . $e ))
				{
					if( count( @scandir($dir . "/" . $e) ) > 2)
					{
						$what .= <<<EOT
									<li class="folder">
										{$e}
										<ul>
						EOT;
						$what = getAllDirectories( $what, $dir . "/" . $e );
						$what .= <<<EOT
										</ul>
									</li>
						EOT;
					}
					else
					{
						$what .= <<<EOT
									<li data-jstree='{ "disabled" : true }'>
										{$e}
									</li>
						EOT;
					}
				}
				else
				{
					// --------------------------------------------------------
					// DECRITTO PASSED FileName
					$fn = _encrypta($dir . "/" . $e, "AZ$9099" . $gbl_idSessione . $gbl_userId);
					$fn = bin2hex( $fn );
					$add = "index.php?fx=fupload&fn=" . $fn;
					$what .= <<<EOT
									<li data-jstree='{ "type" : "file" }' class="colored" onclick="window.location.href='{$add}';">
											{$e}
									</li>
					EOT;
				}
			}
			return $what;
		}
		
		$treeContent = getAllDirectories( "", "{{=getDirectory=}}");
		
		
		/// _[MODI DI VISUALIZZARE 345345]
		
		/// window.location.href = "http://www.w3schools.com";
		
		
		$what = <<<EOT
		
									<section class="panel">
										<header class="panel-heading">
											<div class="panel-actions">
												<a href="#" class="fa fa-caret-down"></a>
												<a href="#" class="fa fa-times"></a>
											</div>
		
											<h2 class="panel-title">{{=getTitle=}}</h2>
											<p class="panel-subtitle">{{=getSubTitle=}}</p>
										</header>
										<div class="panel-body">
											<div id="treeBasic">
												<ul>
												{$treeContent}
												</ul>
											</div>
										</div>
									</section>
		EOT;
		
		return $what;
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<!-- TreeView -->
		<!-- Specific Page Vendor -->
		<script src="<!--relativeDirectory-->/vendor/jstree/jstree.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/ui-elements/examples.treeview.js"></script>
		]>
	init
		return "";
	ADDITIONAL CSS BARE FRAME
		<[
		<!-- Specific Page Vendor CSS -->
		<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/jstree/themes/default/style.css" />
		]>

tbEditSpecial

// ATTENZIONE, LAVORI IN CORSO, NON SOVRASCRIVERE I DIRETTORI INTERNI!!!




















	di tipo
		tbEdit
	getQueryRequested
		return "false";
	resetStack
		true
	permessi
		USER
	title
		return "";
	getTableName
		return "tb_utente";
	backAddress
		<[
		return "index.php";
		]>
	getSelectors
		<[
			return "";	
		]>
	getPulsanteIndietro
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		//1 -----------------------------------------------------------------------
		//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
		//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
		//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
		//1 -----------------------------------------------------------------------
		if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
		{
			// -----------------------------------------------------------------------
			// CARICO IL MIO STACK
			// -----------------------------------------------------------------------
			$gbl_stack = array();
			$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
			{
				// -------------------------------------------------------------------
				// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
				// -------------------------------------------------------------------
				$stack = array();
				$e = array();
				$e['tabella'] = '{{=getTableName=}}';
				$e['pagina'] = $gbl_fx;
				$e['titolo'] = '{{=title=}}';
				$e['icona'] = '{{=getIcon=}}';
				$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
				$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$stack[] = $e;
				$stack = json_encode( $stack );
				$stack = bin2hex( $stack );
				$r = array();
				$r['tb_utente'] = $gbl_userId;
				$r['tb_sessione'] = $gbl_idSessione;
				$r['pagina'] = "";
				$r['nome'] = "stack";
				$r['valore'] = $stack;
				$idStack = db_sql_insert_2("tb_parametro", $r );
			}
			else
			{
				$idStack = $rec['id'];
				$stack = $rec['valore'];
			}
			// -----------------------------------------------------------------------
			// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
			// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
			// -----------------------------------------------------------------------
			$stack = hex2bin( $stack );
			$stack = json_decode( $stack, true );
			if( $stack != NULL )
			{
				if( is_array($stack) && count( $stack) > 0)
				{
					// echo "\n -PRIMA ----------------------\n";
					// var_dump ($stack);
					if( !<!--resetStack--> )
					{
						foreach( $stack as $s )
						{
							if( $s['pagina'] == $gbl_fx )
								break;
							$gbl_stack[] = $s;
						}
					}
			
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$gbl_stack[] = $e;
					// echo "\n - DOPO ----------------------\n";
					// var_dump ($gbl_stack);
					$stack = json_encode( $gbl_stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['id'] = $idStack;
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					db_sql_update_2("tb_parametro", $r,"id",$idStack);
				}
			}
			
			/// echo "\n -STACK ----------------------\n";
			/// var_dump ($gbl_stack);
			
			
		}
		
		
		
		
		if( !is_array($gbl_stack) || count($gbl_stack)<2 ) // se nello stack c'è unicamente la mia pagina
			return "";
		
		$prevIdx	= count( $gbl_stack) - 2;
		$function	= isset($gbl_stack[$prevIdx]['pagina']) ? $gbl_stack[$prevIdx]['pagina'] : "";
		$query		= isset($gbl_stack[$prevIdx]['query']) && $gbl_stack[$prevIdx]['query'] != "" ? "&q=" . $gbl_stack[$prevIdx]['query'] : "";
		$father		= isset($gbl_stack[$prevIdx]['father']) && $gbl_stack[$prevIdx]['father'] != "" ? "&f=" . $gbl_stack[$prevIdx]['father'] : "";
		$add		= "index.php?fx={$function}{$query}{$father}";
		
		$what = <<<EOT
								<a href="{$add}" class="mb-xs mt-xs mr-xs btn btn-default" role="button" aria-pressed="true"><i class="fa fa-arrow-left"></i> Indietro</a>
		///						<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-arrow-left"></i> Indietro</button>
		
		EOT;
		
		return $what;
		
		
		
		]>
	getBreadcrumbsLine
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
		//1 -----------------------------------------------------------------------
		//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
		//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
		//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
		//1 -----------------------------------------------------------------------
		if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
		{
			// -----------------------------------------------------------------------
			// CARICO IL MIO STACK
			// -----------------------------------------------------------------------
			$gbl_stack = array();
			$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
			{
				// -------------------------------------------------------------------
				// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
				// -------------------------------------------------------------------
				$stack = array();
				$e = array();
				$e['tabella'] = '{{=getTableName=}}';
				$e['pagina'] = $gbl_fx;
				$e['titolo'] = '{{=title=}}';
				$e['icona'] = '{{=getIcon=}}';
				$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
				$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
				$stack[] = $e;
				$stack = json_encode( $stack );
				$stack = bin2hex( $stack );
				$r = array();
				$r['tb_utente'] = $gbl_userId;
				$r['tb_sessione'] = $gbl_idSessione;
				$r['pagina'] = "";
				$r['nome'] = "stack";
				$r['valore'] = $stack;
				$idStack = db_sql_insert_2("tb_parametro", $r );
			}
			else
			{
				$idStack = $rec['id'];
				$stack = $rec['valore'];
			}
			// -----------------------------------------------------------------------
			// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
			// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
			// -----------------------------------------------------------------------
			$stack = hex2bin( $stack );
			$stack = json_decode( $stack, true );
			if( $stack != NULL )
			{
				if( is_array($stack) && count( $stack) > 0)
				{
					// echo "\n -PRIMA ----------------------\n";
					// var_dump ($stack);
					if( !<!--resetStack--> )
					{
						foreach( $stack as $s )
						{
							if( $s['pagina'] == $gbl_fx )
								break;
							$gbl_stack[] = $s;
						}
					}
			
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$gbl_stack[] = $e;
					// echo "\n - DOPO ----------------------\n";
					// var_dump ($gbl_stack);
					$stack = json_encode( $gbl_stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['id'] = $idStack;
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					db_sql_update_2("tb_parametro", $r,"id",$idStack);
				}
			}
			
			/// echo "\n -STACK ----------------------\n";
			/// var_dump ($gbl_stack);
			
			
		}
		
		
		
		if( !is_array($gbl_stack) || count($gbl_stack)<2 ) // se nello stack c'è unicamente la mia pagina
		{
		///	echo "senza stack:" . count($gbl_stack);
			
			/// _[COME PRIMA ...]
			
			global $gbl_infoMenu;
			$mainName = "Home";
			
			$aggiuntivi = "";
			if( is_array($gbl_infoMenu))
			{
				$totale = count($gbl_infoMenu);
				$contatore = 0;
			
				foreach($gbl_infoMenu as $menu )
				{
					$t = isset($gbl_infoMenu[$contatore]['titolo']) ? $gbl_infoMenu[$contatore]['titolo'] : "";
					$f = isset($gbl_infoMenu[$contatore]['function']) && !startsWith($gbl_infoMenu[$contatore]['function'], "null") ? "index.php?fx=" . $gbl_infoMenu[$contatore]['function'] : "#";
					$i = isset($gbl_infoMenu[$contatore]['icon']) ? $gbl_infoMenu[$contatore]['icon'] : "null";
			
					$contatore++;
					if( $i == "null" ) /// || $t=="" ) // 24 nov 2022 -> era vuoto perché non correttamente inizializzato!!! 
											/// adesso $gbl_infoMenu è inizializzato in _[COSTRUZIONE MENU IN BASE AL RUOLO UTENTE]
						continue;
			
					$mainName = $t;
			
					if( $totale == $contatore ) // ULTIMO, diamo per scontato che come ultimo elemento non ci sia una funzione null, non avrebbe senso
					{							// perché la funzione null serve per i menù che contengono sottomenù. Se succedesse, l'ultimo
												// menù sarebbe il precedente e sarebbe un'icona
						$aggiuntivi .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<span>{$t}</span>
								</a>
							</li>
						EOT;
					}
					else
					{
						$aggiuntivi .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<i class="{$i}"></i>
								</a>
							</li>
						EOT;
					}
				}
			}
			
			if( isset( $_t["ancillary"]['headerTitle'][0]))
				$mainName = $_t["ancillary"]['headerTitle'][0];
			
			$breadcrumbsLine = <<<EOT
			
								<header class="page-header">
									<h2>{$mainName}</h2>
								
									<div class="right-wrapper pull-right">
										<ol class="breadcrumbs">
											<li>
												<a title="Home" href="index.php?fx=main">
													<i class="fa fa-home"></i>
												</a>
											</li>
											{$aggiuntivi}
										</ol>
			
										<a class="sidebar-right-toggle" data-open=""><i class="fa fa-chevron-left"></i></a>
			
									</div>
								</header>
			EOT;
			
			
			return $breadcrumbsLine;
			
			
		}
		else
		{
		///	echo "con stack:" . count($gbl_stack);
			
			/// DA QUI fino a 
			
			global $gbl_infoMenu;
			
			$iniziali = "";
			
			if( is_array($gbl_infoMenu))
			{
				$totale = count($gbl_infoMenu);
				$contatore = 0;
			
				foreach($gbl_infoMenu as $menu )
				{
					$t = isset($gbl_infoMenu[$contatore]['titolo']) ? $gbl_infoMenu[$contatore]['titolo'] : "";
					$f = isset($gbl_infoMenu[$contatore]['function']) && !startsWith($gbl_infoMenu[$contatore]['function'], "null") ? "index.php?fx=" . $gbl_infoMenu[$contatore]['function'] : "#";
					$i = isset($gbl_infoMenu[$contatore]['icon']) ? $gbl_infoMenu[$contatore]['icon'] : "null";
			
					$contatore++;
					if( $i == "null" )
						continue;
			
					$mainName = $t;
			
					if( $totale == $contatore ) // ULTIMO, diamo per scontato che come ultimo elemento non ci sia una funzione null, non avrebbe senso
					{							// perché la funzione null serve per i menù che contengono sottomenù. Se succedesse, l'ultimo
												// menù sarebbe il precedente e sarebbe un'icona
						$iniziali .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<span>{$t}</span>
								</a>
							</li>
						EOT;
					}
					else
					{
						$iniziali .= <<<EOT
							<li>
								<a title="{$t}" href="{$f}">
									<i class="{$i}"></i>
								</a>
							</li>
						EOT;
					}
				}
			}
			
			if( isset( $_t["ancillary"]['headerTitle'][0]))
				$mainName = $_t["ancillary"]['headerTitle'][0];
			
			/// qui, è uguale alla versione SENZA STACK
			$aggiuntivi = "";
			
			$lastOneIdx = count( $gbl_stack ) - 1;
			
			$fname = "{{=getFatherName=}}";
			
			$idx = 0;
			foreach( $gbl_stack as $elem )
			{
				$function	= isset($elem['pagina']) ? $elem['pagina'] : "";
				$query		= isset($elem['query']) ? $elem['query'] : "";
				$add		= "index.php?fx={$function}&q={$query}";
				$icon		= isset($elem['icona']) ? $elem['icona'] : "fa window-close";
				$titolo		= isset($elem['titolo']) ? $elem['titolo'] . ': <span style="font-weight:700;">' . $fname . '</span>' : 'Inizio';
				$simple 	= isset($elem['titolo']) ? strip_tags($elem['titolo']) : 'Inizio';
			
				if( $idx != $lastOneIdx )
				{
					$aggiuntivi .= <<<EOT
			
						<li>
							<a title="{$simple}" href="{$add}">
								<i class="{$icon}"></i>
							</a>
						</li>
			
					EOT;
				}
				else
				{
					$mainName = $titolo;
			
					$aggiuntivi .= <<<EOT
			
						<li>
							<a title="{$simple}" href="{$add}">
								<span>{$mainName}</span>
							</a>
						</li>
			
					EOT;
			
				}
				$idx ++;
			}
			
			
			
			/// qui torna ad essere invece come quella con lo STACK (ma penso sia uguale in entrambe le versioni)
			
			$breadcrumbsLine = <<<EOT
			
								<header class="page-header">
									<h2>{$mainName}</h2>
								
									<div class="right-wrapper pull-right">
										<ol class="breadcrumbs">
											<li>
												<a title="Home" href="index.php?fx=main">
													<i class="fa fa-home"></i>
												</a>
											</li>
											{$iniziali}
											{$aggiuntivi}
										</ol>
			
										<a class="sidebar-right-toggle" data-open=""><i class="fa fa-chevron-left"></i></a>
			
									</div>
								</header>
			EOT;
			
			
			return $breadcrumbsLine;
			
			
		}
		
		
		
		
		
		
		]>
	getFParameter
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			if( $gbl_father )
				return "&f=" . $gbl_father;
		]>
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
// GESTIONE DELLA PERSISTENZA -------------------------------------------
	getSavedSearchString
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:search string' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "";
		
		
		
		]>
	getSavedPageNumber
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:page number' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "0";
		
		
		
		]>
	getSavedPageLength
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:page length' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return 10;
		
		
		
		]>
	getSavedSorting
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='pers:sorting' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx';");
		if( isset( $rec['valore']))
			return $rec['valore'];
		
		return "[0, 'asc']";
		
		
		
		]>
	getNumberOfFields
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		
		return count( $struct );
		
		]>
// ----------------------------------------------------------------------
	getPopupDialogBox
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$c = isset($_t['ancillary']['removeWin'][0]) ? sanitize($_t['ancillary']['removeWin'][0], "sql", $db_sql) : "";
		$t1 = isset($_t['ancillary']['removeWin'][1]) ? $_t['ancillary']['removeWin'][1] : "";
		$t2 = isset($_t['ancillary']['removeWin'][2]) ? $_t['ancillary']['removeWin'][2] : "";
		
		$what = <<<EOT
		
		<div id="dialog" class="modal-block mfp-hide">
			<section class="panel">
				<header class="panel-heading">
					<h2 class="panel-title">{$t1}: <span style="color:red;font-width:700;" class="eToDelete"></span></h2>
				</header>
				<div class="panel-body">
					<div class="modal-wrapper">
						<div class="modal-text">
							<p>{$t2}: <span style="color:red;font-width:700;" class="eToDelete"></span>?</p>
						</div>
					</div>
				</div>
				<footer class="panel-footer">
					<div class="row">
						<div class="col-md-12 text-right">
							<button id="dialogConfirm" class="btn btn-danger">CONFERMA CANCELLAZIONE</button>
							<button id="dialogCancel" class="btn btn-default">NO</button>
						</div>
					</div>
				</footer>
			</section>
		</div>
		
		EOT;
		
		return $what;
		
		
		]>
	getOctopusMainContent
		<[
//2 ------- QUERY MANAGEMENT OVER HERE
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// controllo del parametro q
		
		$gbl_query = "";
		if( {{=getQueryRequested=}} )
		{
			// ---------------------------
			// RECUPERO LA QUERY
			if( !isset($_REQUEST['q']))
				return "Parameter invalid. Report: 0x9983.98 q";
		
			$query = hex2bin( $_REQUEST['q'] );
			$key = "AZ$9099" . $gbl_idSessione . $gbl_userId;
			$query = _decrypta( $query, $key );
		
			if( $query == "***" )
				return "Parameter invalid. Report: 0x9983.99";
		
			$gbl_query = $query; 
		}
		
			
		
		
		// preparo i parametri f e q se presenti, da aggiungere eventualmente a pagine interne (per export al momento)
		$getFandQ = "";
		if( isset($_REQUEST['f']))
			$getFandQ = "&f=" . $_REQUEST['f'];
		if( isset($_REQUEST['q']))
			$getFandQ .= "&q=" . $_REQUEST['q'];
		
		/// _[PRECEDENTE ALLE VARIABILI GLOBAL help e help2]
		
		// ----------------------------------------------
		$headers = "";
		foreach($gbl_struct as $field)
		{
			if( isset( $field['nome']))
			{
				$caption = $field['nome'];
				if( !isset( $_t['info'][ $caption][4]))
					continue;
				if( $_t['info'][ $caption][4] != "frontpage")
					continue;
				if( isset( $_t['info'][ $caption][0]) )
					$caption = $_t['info'][ $caption][0];
		
				$headers .= "<th>{$caption}</th>\n";
			}
		}
		
		$headers .= "<th>Opzioni</th>\n";
		
		// GESTIONE DELLA COLONNA di CHECKBOX: WIP
		if( {{=getCheckboxColumn=}} )
			$headers = '<th class="manina"><input type="checkbox" class="manina xSelectorMain"></th>' . "\n" . $headers;
		
		$content = "";
		
		// --------------------------------------------------------------------------------------------
		// SOLO QUELLI CHE SI POSSONO EDITARE "inline" e QUELLI CHE SONO "FRONT PAGE"
		// --------------------------------------------------------------------------------------------
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$filters = "";
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		if(	isset( $gbl_session['filter']) && is_array( $gbl_session['filter']) &&
			isset( $gbl_session['filter_type']) && is_array( $gbl_session['filter_type']) )
		{
			foreach( $gbl_session['filter'] as $nn=>$vv )
			{
				$nn = sanitize($nn, "sql", $db_sql);
				$vv = sanitize($vv, "sql", $db_sql);
				$mode = isset( $gbl_session['filter_type'][ $nn ] ) ? $gbl_session['filter_type'][ $nn ] : 1;
		
				if( $vv == "" )
					continue;
		
				if( $vv == "-1" )
					continue;
		
				if( $filters != "" )
					$filters .= " AND ";
		
				switch( $mode )
				{
					case 1:
						$filters .= " LOWER({$nn})=LOWER('{$vv}') ";
						$gbl_anyFilterOn = true;
						break;
					case 2:
						$allElements = explode(",", $vv);
						if( is_array( $allElements))
						{
							$filters .= " (";
							$first = true;
							foreach( $allElements as $single )
							{
								if( $first )
								{
									$filters .= " LOWER({$nn})=LOWER('{$single}') ";
									$first = false;
								}
								else
									$filters .= " OR LOWER({$nn})=LOWER('{$single}') ";
							}
							$filters .= ") ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 99:
						// Vediamo se è un filtro data (potrebbe essere doppio con la virgola, con o senza ora)
						$isDataora = false;
						
							// vediamo se c'è inizio e fine
							$_ar = explode( ",", $vv );
						
							$iii = $_ar[0] ?? "";
							$fff = $_ar[1] ?? "";
						
							if( DateTime::createFromFormat('d-m-Y H:i:s', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data-ora di inizio
								if( DateTime::createFromFormat('d-m-Y H:i:s', $fff) !== false)
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data-ora di fine pure
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d H:i:s', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$isDataora = true;
							}
							elseif( DateTime::createFromFormat('d-m-Y', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data di inizio
								if( DateTime::createFromFormat('d-m-Y', $fff) !== false)	
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data di fine pure
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$dt_start .= " 00:00:00";
								$dt_end .= " 23:59:59";
								$isDataora = true;
							}
						
						//
						if( $isDataora )
						{
							$filters .= " (LOWER({$nn}) >= '{$dt_start}' AND LOWER({$nn}) <= '{$dt_end}') ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 0:
					default:
						$filters .= " LOWER({$nn}) LIKE LOWER('%{$vv}%') ";
						$gbl_anyFilterOn = true;
						break;
				}
			}
		}
		
		// --------------------------------------------------------------------------------------------
		// se questo campo è NULL, non ci sono restrizioni, se è "" significa che nessun
		// elemento può essere visualizzato
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		
		$forcedWhiteListQuery = "";
		if( isset($_t['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $_t['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( isset($gbl_session['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $gbl_session['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( $forcedWhiteListQuery != "" )
		{
		///	$forcedWhiteListQuery = addslashes( $forcedWhiteListQuery );
			$forcedWhiteListQuery = str_replace('$gbl_userId', $gbl_userId, $forcedWhiteListQuery);
			$xxx = _dbGet($forcedWhiteListQuery);
			while( isset($xxx['id']))
			{
				$restrictedList[$xxx['id']] = true;
				$xxx = _dbGet();
			}
		}
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		// --------------------------------------------------------------------------------------------
		
		$hiddenFilter = "";
		if( isset($_t['ancillary']['hidden filter'][0]))
			$hiddenFilter = $_t['ancillary']['hidden filter'][0];
		
		if( isset($gbl_session['ancillary']['hidden filter'][0]))
			$hiddenFilter = $gbl_session['ancillary']['hidden filter'][0];
		
		if( $hiddenFilter != "" )
		{
			if( $filters != "" )
				$filters .= " AND ";
		
			$filters .= " " . $hiddenFilter . " ";
		}
		
		if( $filters != "" )
		{
			if( $gbl_query == "" )
				$filters = " WHERE " . $filters;
			else
				$filters = " AND " . $filters;
		}
		
		// anticipo sessione ----------------------
		if(	isset( $gbl_session['filter_wl'] ) && 
			is_array( $gbl_session['filter_wl']) &&
			count( $gbl_session['filter_wl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		
		if(	isset( $gbl_session['filter_bl'] ) && 
			is_array( $gbl_session['filter_bl']) &&
			count( $gbl_session['filter_bl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		// <------------------- sessione anticipata
		
		if(	isset( $gbl_session['filter_up']['field']) &&
			isset( $gbl_session['filter_up']['ord']) &&
			isset( $gbl_session['filter_up']['max']) )
		{
			$field = sanitize( $gbl_session['filter_up']['field'], "sql", $db_sql );
			$ord   = sanitize( $gbl_session['filter_up']['ord'], "sql", $db_sql );
			$max   = sanitize( $gbl_session['filter_up']['max'], "sql", $db_sql );
		
			// 3 giugno 2022 non metto il max, se ho già una query impostata 
			if( !$gbl_anyFilterOn )
				$filters .= " ORDER BY {$field} {$ord} LIMIT {$max}";
			else
				$filters .= " ORDER BY {$field} {$ord} ";
		
			$gbl_anyFilterOn = true;
		}
		else /// aggiunto 3 giugno 2022
		{
			$max = isset( $_t['ancillary']['forced max rows'][0] ) ? $_t['ancillary']['forced max rows'][0] : 0;
			if( $max == 0 )
				$max = isset( $gbl_session['ancillary']['forced max rows'][0] ) ? $gbl_session['ancillary']['forced max rows'][0] : 0;
		
			if( !$gbl_anyFilterOn && $max )
			{
				$filters .= " LIMIT {$max} ";
				$gbl_anyFilterOn = true;
			}
		}
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		
		
		
		
		$rec = _dbGet("SELECT $listaCampi FROM $gbl_tableName $gbl_query $filters;"); /// $gbl_query, se richiesto
		
		/// $forcedMaxRows = isset( $_t['ancillary']['forced max rows'][0] ) ? $_t['ancillary']['forced max rows'][0] : 0;
		
		$counter = 0;
		while($rec != NULL )
		{
		///	// -----------------------------------------------------------
		///	// SE RISCHIO DI AVERE TROPPE RIGHE ...
		///	if( $forcedMaxRows )
		///		if( ++$counter > $forcedMaxRows )
		///			break;
			// -----------------------------------------------------------
			// FILTRO FORCED WHITE LIST
			// se c'è una lista bianca obbligatoria e non fa parte della 
			// lista bianca: continue!
			if( $forcedWhiteList && !isset( $restrictedList[ $rec['id']] ))
			{
				$rec = _dbGet();
				continue;
			}
			
			// -----------------------------------------------------------
			// FILTRO WHITE LIST
			if( isset( $gbl_session['filter_wl']) && is_array( $gbl_session['filter_wl']) && count( $gbl_session['filter_wl']))
			{
				if( !in_array( $rec['id'], $gbl_session['filter_wl'] ))
				{
					$rec = _dbGet();
					continue;
				}
			}
			// -----------------------------------------------------------
			// FILTRO BLACK LIST
			if( isset( $gbl_session['filter_bl']) && is_array( $gbl_session['filter_bl']) && count( $gbl_session['filter_bl']))
			{
				if( in_array( $rec['id'], $gbl_session['filter_bl'] ))
				{
					$rec = _dbGet();
					continue;
				}
			}
			// -----------------------------------------------------------
			$idCode = "invalid";
			if( isset($rec["id"]))
			{
				$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
				$idCode = bin2hex(_encrypta( $rec['id'], $key ));
			}
			$content .= '<tr code="' . $idCode . '" class="editableRow gradeA">' . "\n";
		
			// GESTIONE DELLA COLONNA di CHECKBOX
			if( {{=getCheckboxColumn=}} && isset($rec["id"]) )
				$content .= '<td class="manina"><input iC="' . $rec["id"] . '" type="checkbox" class="manina xSelector"></td>' . "\n";
		
			foreach( $rec as $fieldName=>$field )
			{
				$field = $field != NULL && $field != "" ? htmlentities($field) : "";
				$type = "";
				if( isset($_t['info'][$fieldName][2]) )
					$type = trim($_t['info'][$fieldName][2]);
				
				
				switch( $type )
				{
					case "psw_":
						$content .= "<td>***</td>" . "\n";
						break;
					case "sel_":
						
						// la select id preleva sempre il titolo dalla tabella indicata nel nome stesso
						// se però vengono definite: tabella oppure titolo allora uso questi valori
						$table = isset( $_t['info'][$fieldName]['tabella'][0] ) ? $_t['info'][$fieldName]['tabella'][0] : $fieldName;
						$titolo = isset( $_t['info'][$fieldName]['titolo'][0] ) ? $_t['info'][$fieldName]['titolo'][0] : "titolo";
						$titolo2 = isset( $_t['info'][$fieldName]['titolo'][1] ) ? $_t['info'][$fieldName]['titolo'][1] : "";
						$titolo3 = isset( $_t['info'][$fieldName]['titolo'][2] ) ? $_t['info'][$fieldName]['titolo'][2] : "";
						$titolo4 = isset( $_t['info'][$fieldName]['titolo'][3] ) ? $_t['info'][$fieldName]['titolo'][3] : "";
						
						$campi = "id," . $titolo;
						if( $titolo2 != "" ) $campi .= ",".$titolo2;
						if( $titolo3 != "" ) $campi .= ",".$titolo3;
						if( $titolo4 != "" ) $campi .= ",".$titolo4;
						
						$other = new dbClass($db_sql_host, $db_sql_name, $db_sql_user, $db_sql_password);
						
						if( $other->isok())
						{
							$unrec = $other->get("SELECT {$campi} FROM {$table} WHERE id='{$field}';");
							$testo = isset( $unrec[$titolo] ) ? $unrec[$titolo] : "";
							$testo .= isset( $unrec[$titolo2] ) ? " " . $unrec[$titolo2] : "";
							$testo .= isset( $unrec[$titolo3] ) ? " " . $unrec[$titolo3] : "";
							$testo .= isset( $unrec[$titolo4] ) ? " " . $unrec[$titolo4] : "";
							if( $testo == "" )
								$testo = "";
						
							$content .= "<td>" . htmlentities( $testo ) . "</td>" . "\n";
						}
						
						
						
						
						
						break;
					case "sel1_":
						
						// la select id preleva sempre il titolo dalla tabella indicata nel nome stesso
						// se però vengono definite: tabella oppure titolo allora uso questi valori
						$table = isset( $_t['info'][$fieldName]['tabella'][0] ) ? $_t['info'][$fieldName]['tabella'][0] : $fieldName;
						$titolo = isset( $_t['info'][$fieldName]['titolo'][0] ) ? $_t['info'][$fieldName]['titolo'][0] : "titolo";
						
						$other = new dbClass($db_sql_host, $db_sql_name, $db_sql_user, $db_sql_password);
						
						unset($additional);
						
						if( $other->isok())
						{
							$allSelections = explode(",", $field);
							$additional = "";
							foreach( $allSelections as $sel )
							{
								if( $additional == "" )
									$additional = " WHERE id='{$sel}'";
								else		
									$additional .= " OR id='{$sel}'";
							}
							$unrec = $other->get("SELECT {$titolo} FROM {$table} {$additional};");
							$additional = "";
							while( isset( $unrec[ $titolo]))
							{
								if( $additional == "" )
									$additional = $unrec[ $titolo];
								else		
									$additional .= "," . $unrec[ $titolo];
						
								$unrec = $other->get();
							} 
						}
						
						$content .= isset( $additional ) ? "<td>" . htmlentities( $additional ) . "</td>" . "\n" : "<td>?</td>" . "\n";
						
						
						
						
						
						break;
					case "anx_":
						
						if( isset($rec['id']))
						{
							// ARRAY
							$dat = array();
							$dat['t'] = $gbl_tableName;
							$dat['f'] = $fieldName;
							$dat['id'] = $rec['id'];
							// JSON
							$dat = json_encode( $dat );
							// ENCRYPT
							$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
							$dat = _encrypta( $dat, $key );
							// BASE64/BIN2HEX
							$dat = bin2hex( $dat );
							$onClick = "";
							$disabled = "";
						
							if( $field == NULL )
							{
								$onClick = ' onclick="return false" ';
								$disabled = "color:gray";
							}
						
							$content .= <<<EOT
										<td>
											<a {$onClick} href="index.php?fx=dlanx&data={$dat}"><i class="fa fa-download" noExpansion="true" style="{$disabled};display:block; float:left; font-size:20px; margin-left:7px;"></i></a>
										</td>
							EOT;
						}
						else
							$content .= "<td>*_i-id*</td>" . "\n";
						
						
						
						break;
					case "i_":
						
						if( isset($rec['id']))
						{
							// ARRAY
							$dat = array();
							$dat['t'] = $gbl_tableName;
							$dat['f'] = $fieldName;
							$dat['id'] = $rec['id'];
							// JSON
							$dat = json_encode( $dat );
							// ENCRYPT
							$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
							$dat = _encrypta( $dat, $key );
							// BASE64/BIN2HEX
							$dat = bin2hex( $dat );
							$onClick = "";
							$disabled = "";
						
							if( $field == NULL )
							{
								$onClick = ' onclick="return false" ';
								$disabled = "color:gray";
							}
						
							$content .= <<<EOT
										<td>
											<a href="index.php?fx=ixmage&data={$dat}" data-plugin-lightbox data-plugin-options='{ "type":"image" }' title="">
												<img class="img-responsive" style="display:block; float:left; height:20px;" src="index.php?fx=ixmage&data={$dat}&l=50&a=50"></img>
											</a>
											<a {$onClick} href="index.php?fx=dlanx&data={$dat}"><i class="fa fa-download" noExpansion="true" style="{$disabled}display:block; float:left; font-size:20px; margin-left:7px;"></i></a>
										</td>
							EOT;
						}
						else
							$content .= "<td>*_i-id*</td>" . "\n";
						
						
						
						break;
					case "dt_":
						
								if( $field != "" && $field != NULL )
								{
									$field = intval( $field );
									$tempus = date( "d/m/Y", $field );
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dtt_":
						
								if( $field != "" && $field != NULL )
								{
									$field = intval( $field );
									$tempus = date( "d/m/Y G:i:s", $field);
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dts_":
								if( $field != "" && $field != NULL )
								{
									$field = strtotime( $field ); // da stringa a intero oppure ""
									$tempus = date( "d/m/Y", $field );
									if( $field == "" ) $field = 0;
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "dtts_":
						
								if( $field != "" && $field != NULL )
								{
									$field = strtotime( $field ); // da stringa a intero oppure ""
									$tempus = date( "d/m/Y G:i:s", $field);
									if( $field == "" ) $field = 0;
								}
								else
								{
									$field = 0;
									$tempus = "";
								}
						
						
						
						$content .= '<td><span style="display:none;">' . $field . "</span>{$tempus}</td>" . "\n";
						break;
					case "ck_":
						// CARICO I NOMI DI DEFAULT
						$nomeVero = isset( $_t['info'][$fieldName]['TRUE'][0] ) ? $_t['info'][$fieldName]['TRUE'][0] : "TRUE";
						$nomeFalso = isset( $_t['info'][$fieldName]['FALSE'][0] ) ? $_t['info'][$fieldName]['FALSE'][0] : "FALSE";
						// -----------------------------------------------------------------------------------------------------
						if( is_int($field) && $field == 1 )
							$field = "true";
						if( is_int($field) && $field == 0 )
							$field = "false";
						$field = strtolower( $field );
						if( $field == "true" || $field == "ok" || $field == "yes" || $field == "sì" || $field == "si" || $field == "vero" )
							$field = $nomeVero;
						else
							$field = $nomeFalso;
						$content .= "<td>{$field}</td>\n";
						break;
					case "tx_":
					case "mm_":
					default:
						if( !isset($buttonActions ) || $buttonActions == "" )
							$content .= "<td>{$field}</td>" . "\n";
						else
						{
							$content .= str_replace("[[sostituisciQui]]", $field, $buttonActions);
							$buttonActions = "";
						}
						break;
				}
				
				
				
				
				
				
			}
		
			
			$pulsanteModify = "";
			
			if( !isset( $_t['ancillary']['disabled']) ||
				!in_array( "MODIFY", $_t['ancillary']['disabled']))
			{
				$pulsanteModify = <<<EOT
					<a href="#" class="on-default edit-row"><i class="fa fa-pencil"></i></a>
				EOT;
			}
			
			
			$pulsanteDelete = "";
			
			if( !isset( $_t['ancillary']['disabled']) ||
				!in_array( "DELETE", $_t['ancillary']['disabled']))
			{
				$pulsanteDelete = <<<EOT
					<a href="#" class="on-default remove-row"><i class="fa fa-trash-o"></i></a>
				EOT;
			}
			
			$pulsanteOpt1 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt1'][3]) ? 'title="' . $_t['ancillary']['buttonOpt1'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt1'][0]) && isset( $_t['ancillary']['buttonOpt1'][1]) && isset( $_t['ancillary']['buttonOpt1'][2]))
			{
				$pulsanteOpt1 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt1'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt1'][1]}" class="optionButton {$_t['ancillary']['buttonOpt1'][0]}"></i></a>
				EOT;
			}
			
			$pulsanteOpt2 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt2'][3]) ? 'title="' . $_t['ancillary']['buttonOpt2'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt2'][0]) && isset( $_t['ancillary']['buttonOpt2'][1]) && isset( $_t['ancillary']['buttonOpt2'][2]))
			{
				$pulsanteOpt2 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt2'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt2'][1]}" class="optionButton {$_t['ancillary']['buttonOpt2'][0]}"></i></a>
				EOT;
			}
			
			$pulsanteOpt3 = "";
			$tooltip = isset($_t['ancillary']['buttonOpt3'][3]) ? 'title="' . $_t['ancillary']['buttonOpt3'][3] . '"' : "";
			
			if( isset( $_t['ancillary']['buttonOpt3'][0]) && isset( $_t['ancillary']['buttonOpt3'][1]) && isset( $_t['ancillary']['buttonOpt3'][2]))
			{
				$pulsanteOpt3 = <<<EOT
					<a {$tooltip} href="{$_t['ancillary']['buttonOpt3'][2]}&idCode={$idCode}" class="on-default"><i style="color:{$_t['ancillary']['buttonOpt3'][1]}" class="optionButton {$_t['ancillary']['buttonOpt3'][0]}"></i></a>
				EOT;
			}
			
			
		
			$content .= <<<EOT
				<td class="actions">
					<a href="#" class="hidden on-editing save-row"><i class="fa fa-save"></i></a>
					<a href="#" class="hidden on-editing cancel-row"><i class="fa fa-times"></i></a>
					{$pulsanteModify}
					{$pulsanteDelete}
					{$pulsanteOpt1}
					{$pulsanteOpt2}
					{$pulsanteOpt3}
				</td>
			</tr>
		EOT;
		
			$rec = _dbGet();
		}
		
		
		
		if( $gbl_anyFilterOn )
		{
			$testoFiltro = "Filtri Attivi";
			$tipoFiltro = "btn-warning";
		}
		else
		{
			$testoFiltro = "Filtra";
			$tipoFiltro = "btn-default";
		}
		
		
		$pulsanteAdd = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "ADD", $_t['ancillary']['disabled']))
		{
			$pulsanteAdd = <<<EOT
				<button id="<!--addFunctionId-->" type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-plus"></i> Aggiungi</button>
			EOT;
		}
		
		
		$pulsanteFilter = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "FILTER", $_t['ancillary']['disabled']))
		{
			$pulsanteFilter= <<<EOT
				<a class="mb-xs mt-xs mr-xs btn {$tipoFiltro}" href="index.php?fx=frmFilterRecord" role="button"><i class="fa fa-filter"></i> {$testoFiltro}</a>
			EOT;
		}
		
		
		$pulsanteExport = "";
		
		if( !isset( $_t['ancillary']['disabled']) ||
			!in_array( "EXPORT", $_t['ancillary']['disabled']))
		{
			$pulsanteExport = <<<EOT
				<a class="mb-xs mt-xs mr-xs btn btn-default" href="index.php?fx=frmExportRecord{$getFandQ}" role="button"><i class="fa fa-file-excel-o"></i> Esporta</a>
			EOT;
		}
		
		
		
		
		
		
		
		$headingStyle = "";
		
		$t6 = $_t['ancillary']['header color'][0] ?? "";
		
		if( $t6 != "" )
			$headingStyle = ' style="background-color:' . $t6 . ';"';
		
		
		$headingTitle = "";
		
		$t6 = $_t['ancillary']['header title'][0] ?? "";
		
		if( $t6 != "" )
			$headingTitle = $t6;
		
		
		
		$what = <<<EOT
		
		
							<!-- start: page -->
		
								{{=getSelectors=}}
		
								<section class="panel">
									<header {$headingStyle} class="panel-heading">
										<div class="panel-actions">
											<a href="#" class="fa fa-caret-down"></a>
											<a href="#" class="close-all fa fa-times"></a>
										</div>
											{$pulsanteAdd}
											{$pulsanteFilter}
											{$pulsanteExport}
											{{=getPulsanteIndietro=}}
											<h2 style="display: inline-block; width:40%; text-align:center;" class="panel-title">{$headingTitle}</h2>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-file-excel-o"></i> Esporta</button>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-filter"></i> Filtra</button>
		///									<button type="button" class="mb-xs mt-xs mr-xs btn btn-info"><i class="fa fa-thumbs-up"></i> </button>
									</header>
									<div class="panel-body">
		///								<div class="row">
		///									<div class="col-sm-6">
		///										<div class="mb-md">
		///											<button id="<!--addFunctionId-->" style="text-shadow:none;" class="btn btn-success">Aggiungi <i class="fa fa-plus"></i></button>
		///										</div>
		///									</div>
		///								</div>
										<table class="table table-bordered table-striped mb-none" id="datatable-editable">
											<thead>
												<tr>
													{$headers}
												</tr>
											</thead>
											<tbody>
												{$content}
											</tbody>
										</table>
									</div>
								</section>
		
								{{=getActionsPage=}}
		
							<!-- end: page -->
		
		
		EOT;
		
		return $what;
		
		]>
	getFieldsConfiguration
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		// ----------------------------------------------
		$configs = "";
		
		// GESTIONE DELLA COLONNA di CHECKBOX
		if( {{=getCheckboxColumn=}} )
			$configs .= '\n{ "bSortable": false },';
		
		foreach($struct as $fieldName)
		{
			// ------------------------------------------------------------------------------------------------------------------------
			// ottengo $type dal database oppure da info, devo capire se è un numero, un testo oppure altro da ordinare opportunamente
			// per datatables
			// per ora la verifica la facciamo unicamente sul tipo reale nel database, in un secondo tempo potrebbe anche andare 
			// su 	if( !isset( $_t['info'][ $field['nome']][8]) )
			$tipo = "undefined";
			
			
			$tipo = isset($gbl_struct[$fieldName]["real_type"]) ? $gbl_struct[$fieldName]["real_type"] : "STRING";
			
			if( isset($_t['info'][$fieldName][8] ))
				$tipo = $_t['info'][$fieldName][8];
			
			if( $tipo == "int" || $tipo == "bigint" || $tipo == "integer" )
				$tipo = "INTEGER";
			elseif( $tipo == "currency" )
				$tipo = "CURRENCY";
			else
				$tipo = "STRING";
			
			
			
			
			// ------------------------------------------------------------------------------------------------------------------------
			switch( $tipo ) //1 ATTENZIONE, NON FUNZIONA IN DATATABLES -> VEDI columnDefs in buildTableFunction (gestione tasti veloce e javascript specifico, quello funziona)
			{
				case "INTEGER":
					$configs .= '\n{ "sType": "num" },';
				break;
				case "CURRENCY":
					$configs .= '\n{ "sType": "currency" },';
				break;
				case "STRING":
				default:
					$configs .= "\nnull,"; // per ora, sempre standard
				break;
			}
		}
		
		return $configs . "\n";
		
		
		]>
	getEmptyFields
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$listaCampi = "";
		
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $gbl_struct as $field)
		{
			if( !isset( $field['nome']) || $field['nome'] == "" )
				continue;
		
			if( !isset( $_t['info'][ $field['nome']][4]) )
				continue;
		
			if( $_t['info'][ $field['nome']][4] != "frontpage" )
				continue;
		
			if( $listaCampi == "" )
				$listaCampi .= $field['nome'];
			else
				$listaCampi .= "," . $field['nome'];
		}
		
		
		
		$struct = explode(",", $listaCampi);
		// ----------------------------------------------
		$configs = "";
		
		// GESTIONE DELLA COLONNA di CHECKBOX
		if( {{=getCheckboxColumn=}} )
			$configs .= "''";
		
		foreach($struct as $field)
		{
			if( $configs == "" )
				$configs .= "''";
			else
				$configs .= ",''";
		}
		
		return $configs;
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<script src="<!--relativeDirectory-->/javascripts/tables/examples.datatables.editable.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/forms/examples.advanced.form.js" /></script>
		<script>
		var oTableStaticFlow;
		
		function dammiIlNumeroDiElementiSelezionati()
		{
			/// oTableStaticFlow è una variabile globale della tbEdit
			var cols = oTableStaticFlow.column(0).nodes();
			var count = 0;
			for (var i = 0; i < cols.length; i += 1) 
			{
				if(	$(cols[i].querySelector("input[type='checkbox']")).prop("checked"))
					count++;;
			}
			return count;
		}
		
		function aggiornaNumeroElementiSelezionati()
		{
			var n = dammiIlNumeroDiElementiSelezionati();
			$(".numeroElementiSelezionati").html(n + "");
			$(document).trigger("checkedElements:", n);
		}
		
		// ----------------------------------------------------------------------
		// FUNZIONE OPZIONALE PER L'INSERIMENTO DI UN RECORD CON LA FORM COMPLETA
		// ----------------------------------------------------------------------
		$( document ).ready(function() {
		    $('#addToTableAsForm').on("click", function(){window.location.href = "{{=getAddFunctionName=}}{{=getFParameter=}}";});
			/// -------------------------------------------------------------
			/// Per la barra di selezione in alto, per consentire lo scroll 
			/// delle selezioni
		///	$(".multiselect-container.dropdown-menu").css("overflow", "auto");
		///	$(".multiselect-container.dropdown-menu").css("max-height", "300px");
			/// -------------------------------------------------------------
		});
		// ----------------------------------------------------------------------
		
		$(".multiSelect").multiselect({
		  nonSelectedText:'Nessuno'
		});
		
		// ITALIAN PLUGIN CURRENCY, modificata da me
		// FUNZIONA SIA CON IL PUNTO CHE CON LA VIRGOLA
		
		jQuery.extend( jQuery.fn.dataTableExt.oSort, {
		    "currency-pre": function ( a ) {
				a = a.replace( /[\,]/g, "." );
				a = (a==="-") ? 0 : a.replace( /[^\d\-\.]/g, "" );
				return parseFloat( a );
		    },
		 
		    "currency-asc": function ( a, b ) {
		        return a - b;
		    },
		 
		    "currency-desc": function ( a, b ) {
		        return b - a;
		    }
		} );
		
		
		function buildTableFunction(me) 
		{
			me.datatable = me.\$table.DataTable({
		
				"order": [{{=getSavedSorting=}}],
				language: {
					url: '<!--relativeDirectory-->/javascripts/tables/dataTables.italian.json'
				},
				"search": {
					"search": "{{=getSavedSearchString=}}"
				},
				"pageLength": {{=getSavedPageLength=}},
				"fnInitComplete": function(oSettings, json) {
					// ------------------------------------------------------------------------
					// COMPLETO INIZIALIZZAZIONE, ALTRIMENTI LA GRAFICA SI CORROMPE
					// ------------------------------------------------------------------------
					$.fn.dataTable.defaults.fnInitComplete(oSettings, json);
					// ------------------------------------------------------------------------
					// CALLBACK GESTIONE DELLE PERSISTENZE
					// ------------------------------------------------------------------------
					
						// ------------------------------------------------------------------------
						// COLLEGO IL CAMBIO SEARCH CON IL SUO SALVATAGGIO
						// ------------------------------------------------------------------------
						$('#datatable-editable_filter input').on("keyup", function () {
					
							var valore = $(this).val();
								
							if( valore == "" )
							{
								$('.table-responsive').css("border-color", "");
								$('.table-responsive').css("border-width", "0px");
								$(this).css("border-color", "");
							}
							else
							{
								$('.table-responsive').css("border-color", "orange");
								$('.table-responsive').css("border-width", "1px");
								$('.table-responsive').css("border-style", "solid");
								$(this).css("border-color", "orange");
							}
					
							var reply = ajaxCall( "ajaxSavePersValue", "pers:search string", valore, "", null );
							var table = $('#datatable-editable').DataTable();
							var info = table.page.info();
					
						});
					
						// ------------------------------------------------------------------------
						// cambio il colore della tabella se la search seleziona qualcosa
						// ------------------------------------------------------------------------
						if( $('#datatable-editable_filter label input').val() != "" )
						{
							$('.table-responsive').css("border-color", "orange");
							$('.table-responsive').css("border-width", "1px");
							$('.table-responsive').css("border-style", "solid");
							$('#datatable-editable_filter label input').css("border-color", "orange");
						}
					
						// ------------------------------------------------------------------------
						// AJAX -> salvo il valore del numero di pagina attuale nel DB tb_sessione
						// ------------------------------------------------------------------------
						$('#datatable-editable').on( 'draw.dt', function () {
							var table = $('#datatable-editable').DataTable();
							var info = table.page.info();
							var reply = ajaxCall( "ajaxSavePersValue", "pers:page number", info.page, "", null );
						});
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL NUMERO DELLA PAGINA
						// ------------------------------------------------------------------------
						$('#datatable-editable').DataTable().page({{=getSavedPageNumber=}}).draw(false);
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL NUMERO DELLA PAGINA
						// ------------------------------------------------------------------------
						$('#datatable-editable').on( 'length.dt', function ( e, settings, len ) {
							var reply = ajaxCall( "ajaxSavePersValue", "pers:page length", len, "", null );
						} );
					
						// ------------------------------------------------------------------------
						// GESTIONE PERSISTENZA DEL SORTING PREGRESSO
						// ------------------------------------------------------------------------
						function sortingFun ( e ) {
					
							var what = "";
					
							if( $(e.target).hasClass("sorting_asc"))
								what = "["+ $(this).index() + ", 'asc']";
							
							if( $(e.target).hasClass("sorting_desc"))
								what = "["+ $(this).index() + ", 'desc']";
					
							var reply = ajaxCall( "ajaxSavePersValue", "pers:sorting", what, "", null );
					
						}
					
						$(".sorting").on( 'click', sortingFun );
						$(".sorting_asc").on( 'click', sortingFun );
						$(".sorting_desc").on( 'click', sortingFun );
					
					///	$('#datatable-editable').order("{{=getSavedSorting=}}").draw();
					
		///	eraser->		$('.dataTables_filter').append('<button class="btn btn-default mr-xs pull-right searchTextEraser" type="button"><i class="fa fa-eraser searchTextEraser" aria-hidden="true"></i></button>');
				},
				"aoColumns": [
						{{=getFieldsConfiguration=}}
						{ "bSortable": false }
					]
				});
		
			window.dt = me.datatable;
			/// SALVO LA TABELLA STATICA per GESTIONE CHECKBOX -----
			oTableStaticFlow = me.datatable;
			/// ----------------------------------------------------
			return me;
		}
		
		// -----------------------------------------------------------
		
		//1 CONDIVISA, NON MODIFICARE: FUNZIONI E VARIABILI STATICHE, AJAXCALL E CONVERSIONE BASE64
		
		var theEmptyRow = [ {{=getEmptyFields=}} ];
		var theTableName = "{{=getTableName=}}";
		
		function utf8ToHex(str) {
			return Array.from(str).map(c => 
				c.charCodeAt(0) < 128 ? c.charCodeAt(0).toString(16) : 
				encodeURIComponent(c).replace(/\%/g,'').toLowerCase()
			).join('');
		}
		
		function hexToUtf8(hex) {
			return decodeURIComponent('%' + hex.match(/.{1,2}/g).join('%'));
		}
		
		function utf8_to_b64( str ) {
			return window.btoa(unescape(encodeURIComponent( str )));
		}
		
		function b64_to_utf8( str ) {
			return decodeURIComponent(escape(window.atob( str )));
		}
		
		function ajaxCall( funzione, nome, valore, tipo, callback ) {
		
			/// nome = JSON.stringify(nome + "." + funzione ); // to JSON
			var name = utf8_to_b64( nome ); // to BASE64
			/// valore = JSON.stringify(valore); // to JSON
			var value = utf8_to_b64( valore ); // to BASE64
			var type = utf8_to_b64( tipo ); // to BASE64
		
			var jqxhr = $.post( "index.php?fx=" + funzione, { nome: name, valore: value, tipo: type }, function(data) {
		///			alert( "success:" + data );
				})
				.done(function(data) {
		///			alert( "second success:" + data );
				})
				.fail(function(data) {
		///			alert( "error:" + data );
				})
				.always(function(data) {
		
					if( callback !== null )
						callback(data);
				});
		}
		
		
		//1 CONDIVISA, NON MODIFICARE: FUNZIONI E VARIABILI STATICHE, AJAXCALL E CONVERSIONE BASE64
		
		// -----------------------------------------------------------
		
		// -------------------------------------------------------------
		
		//0 -----------------------------------------------------------------------------
		//0 format function for row details
		function fnFormatDetails( datatable, tr, callback ) 
		{
			// --------------------------------------------------------------------------------------
			// RECUPERO L'ID CRIPTATO DELL'ELEMENTO
			var data = datatable.row( tr ).data();
			var code = $(tr).attr("code");
			if( code == undefined || code == "")
				return "";
			// --------------------------------------------------------------------------------------
			// RACCOLGO LE INFORMAZIONI DAL SERVER
			ajaxCall( "getElementDetails", "tb_utente", code, "", function(info) {
		
				var retValue = [
					'<table style="background-color:#fee;" class="table mb-none">',
						'<tr class="b-top-none">',
							'<td>Nessun dettaglio</td>',
						'</tr>',
					'</table>'
					].join(''); 
		
				if( info != "" )
				{
					// --------------------------------------------------------------------------------------
					// CONVERSIONE DA BASE64 a BINARIO
					info = b64_to_utf8( info );
					if( info != "" )
					{
						// --------------------------------------------------------------------------------------
						// CONVERSIONE DA JSON A STRUTTURA
						info = JSON.parse(info);
						if( info != undefined )
							retValue = info['html'];
					}
				}
				// --------------------------------------------------------------------------------------
				if( callback != null )
					callback(retValue);
		
			});
		}
		
		/// _[VECCHIA RETURN]
		
		// -------------------------------------------------------------
		
		var globalSelectedElement = "";
		
		$( document ).ready(function() {
		
			$(document).on('keypress', function(e){	
				
				if(e.which === 43)
				{
					window.location.href = "{{=getAddFunctionName=}}{{=getFParameter=}}";
				}
				
				
			});
			
			$(document).on("click", function(e){
				
						// CANCELLAZIONE TESTO SEARCH BOX
						if( $(e.target).hasClass("searchTextEraser"))
						{
							$('.dataTables_filter input').val('');
							var table = $("#datatable-editable").DataTable();
							table.search('').draw(); //required after
							$('#datatable-editable_filter input').trigger("keyup");
							return false;
						}
						// PULSANTE DI CHIUSURA E X
						if( $(e.target).hasClass("close-all"))
						{
							window.location.href='{{=backAddress=}}';
							return false;
						}
				
						if( $(e.target).hasClass("fa-trash-o"))
						{
							var parent = e.target.closest('tr');
							var text = jQuery(parent).find("td:eq(1)").text();
							$(".eToDelete").text(text);
							// non fermare lo script, deve andare a settare il globalSelectedElement element
						}
				
						/// ------------------------------
						/// GESTIONE SELETTORI MULTI LINEA
						if( $(e.target).hasClass("xSelectorMain"))
						{
							var cols = oTableStaticFlow.column(0).nodes(),
							state = $(e.target).is(':checked');
							for (var i = 0; i < cols.length; i += 1) {
								cols[i].querySelector("input[type='checkbox']").checked = state;
							}
							aggiornaNumeroElementiSelezionati();
							return true; 
						}
				///		_[vecchia gestione: sdfg]
				
						if( $(e.target).hasClass("xSelector"))
						{
							aggiornaNumeroElementiSelezionati();
							return true; 
						}
				
						var cella = e.target.closest('td');
						var cbPotenziale = $(cella).find(':checkbox');
				
						if( $(cbPotenziale).hasClass("xSelector") )
						{
							$(cbPotenziale).trigger("click");
							return true; // true: lascia correre la catena degli eventi
						}
				
						var cella = e.target.closest('th');
						var cbPotenziale = $(cella).find(':checkbox');
				
						if( $(cbPotenziale).hasClass("xSelectorMain") )
						{
							$(cbPotenziale).trigger("click");
							return true; // true: lascia correre la catena degli eventi
						}
						/// ------------------------------
				
						if( $(e.target).hasClass("optionButton"))
							return true;
				
						if( $(e.target).closest('td').hasClass("actions") &&
							!$(e.target).closest('a').hasClass("edit-row"))
						{
							var me = e.target.closest('tr');
							globalSelectedElement = $(me).attr("code");
							return false;
						}
				
						if( $(e.target).hasClass("actions"))
							return true;
				
						var me = e.target.closest('tr');
				
						if( ! $(me).hasClass("editableRow"))
							return true;
				
						// ------------------------------
						// riga cliccata da qualche parte 
						// ------------------------------
						var code = $(me).attr("code");
						if( code != "invalid" )
						{
							if( $(e.target).hasClass("fa fa-pencil"))
								window.location.href = "index.php?fx=frmEditRecord&e=" + code;
							else {
								
									var cella = e.target.closest('td');
									var immaginePotenziale = $(cella).find("a:first");
									var attr = $(immaginePotenziale ).attr("data-plugin-lightbox");
								
									if (attr != undefined )
										return true;
								
									var icona = $(cella).find("i:first");
									attr = $(icona).attr("noExpansion");
								
									if (attr != undefined )
										return true;
									
									
								
								
				///				_[VERIFICO SE SI TRATTA DI UN CAMPO CHECKBOX]
								
								
								
										var table = $("#datatable-editable").DataTable();
										var tr = $(e.target).closest( 'tr' ).get(0);
										var row = table.row( tr );
								
										if( row.child.isShown())
										{
											// This row is already open - close it
											row.child.hide();
										}
										else
										{
											// Open this row (the format() function would return the data to be shown)
											fnFormatDetails( table, tr, function(formattedDetails) {
												row.child( formattedDetails ).show();
											});
										}
								
								
				///				_[COMPILA IL CONTEXT MENU' LATERALE]
							}
						}
						else
							console.log("row click invalid!"); 
				
						return true;
				
			});
		
			aggiornaNumeroElementiSelezionati();
		});
		
		</script>
		
		]>
	init
		<[
		/// INIZIALIZZO LE VARIABILI GLOBALI
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		//1 BOLLA CONDIVISA
		
		$fil = array();
		$paginaMaster = trim(sanitize( $gbl_fx, "sql", $db_sql));
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		
		if( isset($rec['valore']))
		{
			$fil = hex2bin($rec['valore']);
			$fil = json_decode( $fil, true);
			if( isset( $fil['filter']) && is_array( $fil['filter']))
				$gbl_session['filter'] = $fil['filter'];		
			if( isset( $fil['filter_type']) && is_array( $fil['filter_type']))
				$gbl_session['filter_type'] = $fil['filter_type'];
			if( isset( $fil['filter_up']) && is_array( $fil['filter_up']))
				$gbl_session['filter_up'] = $fil['filter_up'];
			if( isset( $fil['filter_custom']) && is_array( $fil['filter_custom']))
				$gbl_session['filter_custom'] = $fil['filter_custom'];
			if( isset( $fil['filter_wl']) && is_array( $fil['filter_wl']))
				$gbl_session['filter_wl'] = $fil['filter_wl'];
			if( isset( $fil['filter_bl']) && is_array( $fil['filter_bl']))
				$gbl_session['filter_bl'] = $fil['filter_bl'];
		}
		
		//1 BOLLA CONDIVISA
		
		
		$keepValues = "AND nome NOT LIKE 'value:%'";
		if( isset($_REQUEST['clean']) || TRUE ) //1 PULISCO SEMPRE I VALORI ALL'INGRESSO E STOP
			$keepValues = "";
		
		if( $gbl_userId != 0 && $gbl_idSessione != 0 )
		{
			//2 LO STACK NON VIENE CANCELLATO PERCHE' HA pagina == ""
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_fx' {$keepValues} AND nome NOT LIKE 'pers:%' AND nome <> 'filters';");
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND nome='nome funzione';");
			dbQuery("DELETE FROM tb_parametro WHERE tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND nome='nome tabella';");
			// ------------------------------------------------------------------
			// CREO IL RECORD
			$r = array();
			$r['tb_utente'] = $gbl_userId;
			$r['tb_sessione'] = $gbl_idSessione;
			$r['pagina'] = $gbl_fx;
			// ------------------------------------------------------------------
			// SALVO IL NOME DELLA FUNZIONE
			$r['nome'] = 'nome funzione'; 
			$r['valore'] = $gbl_fx;
			db_sql_insert_2("tb_parametro", $r );
			// ------------------------------------------------------------------
			// SALVO IL NOME DELLA TABELLA
			$r['nome'] = 'nome tabella';
			$r['valore'] = '{{=getTableName=}}';
			db_sql_insert_2("tb_parametro", $r );
			// ------------------------------------------------------------------
			// SALVO GLI EVENTUALI SUGGERIMENTI INSERIMENTO CAMPI
			if( isset($_t['info']) && is_array( $_t['info']))
			{
				$aS = json_encode($_t['info']);
				$r['nome'] = 'omnia.info';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO GLI ELEMENTI ADDIZIONALI DELLA TABELLA
			if( isset($_t['ancillary']) && is_array( $_t['ancillary']))
			{
				$aS = json_encode($_t['ancillary']);
				$r['nome'] = 'omnia.ancillary';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO LA DESCRIZIONE DEI DETTAGLI
			if( isset($_t['details']) && is_array( $_t['details']))
			{
				$aS = json_encode($_t['details']);
				$r['nome'] = 'omnia.details';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
			// ------------------------------------------------------------------
			// SALVO GLI ELEMENTI SOTTOPAGINE
			if( isset($_t['subpages']) && is_array( $_t['subpages']))
			{
				$aS = json_encode($_t['subpages']);
				$r['nome'] = 'omnia.subpages';
				$r['valore'] = sanitize($aS, "sql", $db_sql);
				db_sql_insert_2("tb_parametro", $r );
			}
		}
		
		
		
		
		if( !isset( $gbl_session['filter_up']) && 
			isset( $_t['ancillary']['defaults'][0]) &&
			isset( $_t['ancillary']['defaults'][1]) &&
			isset( $_t['ancillary']['defaults'][2]) )
		{
			$gbl_session['filter_up']['max'] = $_t['ancillary']['defaults'][0];
			$gbl_session['filter_up']['field'] = $_t['ancillary']['defaults'][1];
			$gbl_session['filter_up']['ord'] = $_t['ancillary']['defaults'][2];
		}
		
		
		
///		_[SALVO I DATI NELLO STACK PER POSIZIONE E NOME PAGINA]
		]>
	info
//		field1: Inserire il campo 1
//		field2: Inserire il campo 2
	addFunctionId
//	addToTable oppure addToTableAsForm
		addToTableAsForm
	getFatherName
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			$nomePadre = "";
			
			//1 -----------------------------------------------------------------------
			//1 LO STACK IN TEORIA DEVE ESSERE CARICATO UNA SOLA VOLTA
			//1 QUESTA BOLLA E' USATA IN PIU' PUNTI.
			//1 SE LO STACK E' GIA' STATO SISTEMATO, ESCO
			//1 -----------------------------------------------------------------------
			if( !isset($gbl_stack) || count($gbl_stack) <= 0 )
			{
				// -----------------------------------------------------------------------
				// CARICO IL MIO STACK
				// -----------------------------------------------------------------------
				$gbl_stack = array();
				$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( !isset($rec['valore']) || $rec['valore'] == "" || $rec['valore'] == NULL )
				{
					// -------------------------------------------------------------------
					// CREO L'ELEMENTO EX NOVO DENTRO LO STACK
					// -------------------------------------------------------------------
					$stack = array();
					$e = array();
					$e['tabella'] = '{{=getTableName=}}';
					$e['pagina'] = $gbl_fx;
					$e['titolo'] = '{{=title=}}';
					$e['icona'] = '{{=getIcon=}}';
					$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
					$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
					$stack[] = $e;
					$stack = json_encode( $stack );
					$stack = bin2hex( $stack );
					$r = array();
					$r['tb_utente'] = $gbl_userId;
					$r['tb_sessione'] = $gbl_idSessione;
					$r['pagina'] = "";
					$r['nome'] = "stack";
					$r['valore'] = $stack;
					$idStack = db_sql_insert_2("tb_parametro", $r );
				}
				else
				{
					$idStack = $rec['id'];
					$stack = $rec['valore'];
				}
				// -----------------------------------------------------------------------
				// VERIFICO SE LO STACK CONTIENE GIA' IL MIO NOME
				// TUTTO QUELLO CHE SEGUE VIENE ELIMINATO
				// -----------------------------------------------------------------------
				$stack = hex2bin( $stack );
				$stack = json_decode( $stack, true );
				if( $stack != NULL )
				{
					if( is_array($stack) && count( $stack) > 0)
					{
						// echo "\n -PRIMA ----------------------\n";
						// var_dump ($stack);
						if( !<!--resetStack--> )
						{
							foreach( $stack as $s )
							{
								if( $s['pagina'] == $gbl_fx )
									break;
								$gbl_stack[] = $s;
							}
						}
				
						$e = array();
						$e['tabella'] = '{{=getTableName=}}';
						$e['pagina'] = $gbl_fx;
						$e['titolo'] = '{{=title=}}';
						$e['icona'] = '{{=getIcon=}}';
						$e['dbTitolo'] = isset( $_t['ancillary']['dbTitle'][0]) ? $_t['ancillary']['dbTitle'][0] : "";
						$e['query'] = isset($_REQUEST['q']) ? $_REQUEST['q'] : ""; // prendo l'originale per non doverla criptare nuovamente
						$e['father'] = isset($_REQUEST['f']) ? $_REQUEST['f'] : ""; // prendo l'originale per non doverla criptare nuovamente
						$gbl_stack[] = $e;
						// echo "\n - DOPO ----------------------\n";
						// var_dump ($gbl_stack);
						$stack = json_encode( $gbl_stack );
						$stack = bin2hex( $stack );
						$r = array();
						$r['id'] = $idStack;
						$r['tb_utente'] = $gbl_userId;
						$r['tb_sessione'] = $gbl_idSessione;
						$r['pagina'] = "";
						$r['nome'] = "stack";
						$r['valore'] = $stack;
						db_sql_update_2("tb_parametro", $r,"id",$idStack);
					}
				}
				
				/// echo "\n -STACK ----------------------\n";
				/// var_dump ($gbl_stack);
				
				
			}
			
			
			// -----------------------------------------------------------------------
			// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
			// QUI SONO IN UNA tbEdit chiamata da una tbEdit
			// mi aspetto di avere nello stack 2 elementi: mio padre e me stesso
			// -----------------------------------------------------------------------
			if( !isset( $_REQUEST['f']))
				return "";
			
			$passedFather = $_REQUEST['f'];
			// --------------------------------------------------------
			// DECRITTO PASSED FATHER
			$passedFather = hex2bin( $passedFather);
			$passedFather = _decrypta($passedFather, "AZ$9099" . $gbl_idSessione . $gbl_userId);
			
			if( $passedFather == "***" )
				return "";
			
			/// _[CARICO SOLO LA VARIABILE STACK, SENZA SCRIVERE I MIEI DATI]
			/// var_dump( $gbl_stack );
			// --------------------------------------------------------
			if( !isset( $gbl_stack) || !is_array($gbl_stack) || (count( $gbl_stack)<2))
				return "";
			
			// PRENDO il PENULTIMO ELEMENTO
			$recFather = $gbl_stack[ count($gbl_stack)-2];
			$dbTitle = $recFather['dbTitolo'];
			$tableName = $recFather['tabella'];
			
			$dat = _dbGet("SELECT {$dbTitle} FROM {$tableName} WHERE id='{$passedFather}';");
			
			if( $dat == NULL || !is_array( $dat))
				return "";
			
			$nomePadre = isset($dat[$dbTitle])?$dat[$dbTitle]:"";
			
			
			
			return htmlentities($nomePadre);
		]>

// ---------------------------------------
// CRUD per gestione "inline"


ajax_dbInsert
	permessi
		admin
	_exec
		<[
			if( !isset( $_REQUEST['what']))
				return "";

			$what = base64_decode( $_REQUEST['what'] );
			$rec = json_decode( $what, true );

			return var_dump( $rec );
		]>



ajax_dbModify
	permessi
		admin
	_exec
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			

			if( !isset( $_REQUEST['what']))
				return "";
			if( !isset( $_REQUEST['wat']))
				return "";

			$what = "";


		]>

ajax_sys
	permessi
		ANY
	_exec
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			

			$caller = $_REQUEST['caller'] ?? "";
			if( $caller == "" )
				return "";
			try
			{  
				return _dbGet("SELECT value FROM tb_x_sys WHERE name='{$caller}:reload';")['value'] ?? "";
			}  
			catch(exception $e)
			{
				return "";
			}
		]>

// ---------------------------------------
tbEditUtenti
	di tipo
		tbEdit
	permessi
		ROOT
	getQueryRequested
		return "false";
	getUserId
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		return $gbl_userId;
		]>
	resetStack
		true
	getTableName
		return "tb_utente";
	info
//		nome campo: [0]Caption, [1]Testo Aiuto, [2]Tipo Campo (tx_, mm_, tb_, i_, tm_, dt_, dtt_, anx_, nn_, opt_, psw_), [3]readonly (readonly or "" or other), [4]frontpage (or "" or other)
//					, [5]minChars(0=anyLenght), [6]fa fa-user->icona a fianco testo, [7]masked oppure unmasked, [8]subtype ( any, text, integer, float, currency, date) per ordine in tabella
//					, [9]initialize with f parameter value (true/false)
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome utente, "Nome completo dell'utente, es: Paolo Rossi", tx_, no_readonly, frontpage, 1, fa fa-user, unmasked, text, false
		email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, no_readonly, frontpage, 0, null, unmasked, text, false
			deny duplication: true
		password_hash: Password, "Password utente", psw_, no_readonly, frontpage, 14, fa fa-key, unmasked, any, false
		qualifiche: Qualifiche, "Qualifiche utente separate da uno spazio (es: user, admin ...)", tx_, no_readonly, frontpage, 0, null, unmasked, text, false
		tb_role: Ruolo utente, "Ruolo definito per l'utente. Stabilisce il menù laterale. Es: admin, user", sel_, no_readonly, frontpage, 0, fa fa-bars, unmasked, text, false
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
///			titolo: titolo <- da definirsi se diverso da "titolo"
		tbs_qualifica: Qualifiche Utente, "Qualifiche Utente", sel1_, no_readonly, frontpage, 0, fa fa-bars, unmasked, text, false
			titolo: nome
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
		i_avatar: "Immagine utente", "Immagine dell'utente", i_, no_readonly, frontpage, 0, fa fa-file-image-o, unmasked, any, false
		dt_registrazione: Data di registrazione, "Data di registrazione iniziale", dt_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
		anx_annex: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
//		hidden filter
///		hidden filter: "email LIKE '%ora%'"
//		Indirizzo del pulsante "NEW" o AGGIUNGI
///		addressNew: index.php?fx=whatever
//		disabilita funzionalità. Posizione non rilevante. ["ADD","MODIFY","DELETE","FILTER","EXPORT"]
///		disabled: MODIFY, DELETE
		buttonSave: "Aggiungi", "Aggiungi un nuovo utente alla tabella", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: nome, "CANCELLAZIONE UTENTE", "Vuoi cancellare i dati per l'utente"
//		nome del campo descrittivo principale della tabella
		dbTitle: nome
		buttonOpt1: fa fa-key, red, index.php?fx=frmPasswordReset, "Reset Password Utente"
//		serve per passare alle funzioni interne il parametro di queryRequested (getQueryRequested) ad esempio per la export. E' false di default
//		queryRequested: false
// [0]: default record numbers (-1 == all) [1]: default field; [2] default ord (DESC/ASC)
//		defaults: 100, id, ASC
///		Titolo della pagina al posto del nome in data project (menu) se presente		
//		headerTitle: "whatever"
//		buttonOpt1: fa fa-user, gray, index.php?fx=whateverFunction(viene aggiunto idCode=encryptedId)
///	details
///		Tabella Pagamenti: type_table, tb_pagamento, "Elenco Pagamenti Utente", tbEditPagamentiDiUtente, tb_utente
///		Tabella Presenze: type_table, tb_presenze, "Elenco Presenze Utente", tbEditPresenzeDiUtente, tb_utente
	subpages
		edit
			info
				email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, readonly, frontpage, 0, null, unmasked, text, false
				password_hash: Password, "La password non può essere modificata da pannello amministratore, l'utente deve attivare la procedura di recupero password.", psw_, readonly, frontpage, 14, fa fa-key, masked, text, false
	title
		return "Tabella Utenti";
	getIcon
		return "fa fa-users";

tbEditUtente

	di tipo
		tbEdit
	getQueryRequested
		return "true";
	resetStack
		false
	getTableName
		return "tb_utente";
	info
//		nome campo: [0]Caption, [1]Testo Aiuto, [2]Tipo Campo (tx_, mm_, tb_, i_, tm_, dt_, dtt_, anx_, nn_, opt_, psw_), [3]readonly (readonly or "" or other), [4]frontpage (or "" or other)
//					, [5]minChars(0=anyLenght), [6]fa fa-user->icona a fianco testo, [7]masked oppure unmasked, [8]subtype ( any, text, integer, float, currency, date) per ordine in tabella
//					, [9]initialize with f parameter value (true/false)
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome utente, "Nome completo dell'utente, es: Paolo Rossi", tx_, no_readonly, frontpage, 1, fa fa-user, unmasked, text, false
		email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, no_readonly, frontpage, 0, null, unmasked, text, false
			deny duplication: true
		password_hash: Password, "Password utente", psw_, no_readonly, frontpage, 14, fa fa-key, unmasked, any, false
		qualifiche: Qualifiche, "Qualifiche utente separate da uno spazio (es: user, admin ...)", tx_, no_readonly, frontpage, 0, null, unmasked, text, false
		tb_role: Ruolo utente, "Ruolo definito per l'utente. Stabilisce il menù laterale. Es: admin, user", sel_, no_readonly, frontpage, 0, fa fa-bars, unmasked, text, false
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
///			titolo: titolo <- da definirsi se diverso da "titolo"
		tbs_qualifica: Qualifiche Utente, "Qualifiche Utente", sel1_, no_readonly, frontpage, 0, fa fa-bars, unmasked, text, false
			titolo: nome
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
		i_avatar: "Immagine utente", "Immagine dell'utente", i_, no_readonly, frontpage, 0, fa fa-file-image-o, unmasked, any, false
		dt_registrazione: Data di registrazione, "Data di registrazione iniziale", dt_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
	ancillary
		buttonSave: "Aggiungi", "Aggiungi un nuovo utente alla tabella", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: nome, "CANCELLAZIONE UTENTE", "Vuoi cancellare i dati per l'utente"
//		nome del campo descrittivo principale della tabella
		dbTitle: nome
// [0]: default record numbers (-1 == all) [1]: default field; [2] default ord (DESC/ASC)
//		defaults: 100, id, ASC
///	details
///		Tabella Pagamenti: type_table, tb_pagamento, "Elenco Pagamenti Utente", tbEditPagamentiDiUtente, tb_utente
///		Tabella Presenze: type_table, tb_presenze, "Elenco Presenze Utente", tbEditPresenzeDiUtente, tb_utente
	subpages
		edit
			info
				email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, readonly, frontpage, 0, null, unmasked, text, false
				password_hash: Password, "La password non può essere modificata da pannello amministratore, l'utente deve attivare la procedura di recupero password.", psw_, readonly, frontpage, 14, fa fa-key, masked, text, false
	title
		return "Tabella Utenti";
	getIcon
		return "fa fa-users";


tbEditPagamentiDiUtente
	di tipo
		tbEdit
	getQueryRequested
		return "true";
	resetStack
		false
	getTableName
		return "tb_pagamento";
	info
//		nome campo: [0]Caption, [1]Testo Aiuto, [2]Tipo Campo (tx_, mm_, tb_, i_, tm_, dt_, dtt_, anx_, nn_, opt_, psw_), [3]readonly (readonly or "" or other), [4]frontpage (or "" or other)
//					, [5]minChars(0=anyLenght), [6]fa fa-user->icona a fianco testo, [7]masked oppure unmasked, [8]subtype ( any, text, integer, float, currency, date) per ordine in tabella
//					, [9]initialize with f parameter value (true/false)
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		titolo: Causale di Pagamento, "Inserire la causale del pagamento", tx_, no_readonly, frontpage, 1, fa fa-user, unmasked, text, false
		tb_utente: Nome Utente, "Utente che ha effettuato il pagamento", sel_, readonly, no_frontpage, 0, fa fa-bars, unmasked, text, true
			titolo: nome
	ancillary
		buttonSave: "Aggiungi", "Aggiungi un nuovo record di pagamento", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: titolo, "CANCELLAZIONE RECORD DI PAGAMENTO", "Vuoi cancellare i dati per l'utente"
		dbTitle: titolo
	title
		return "Tabella Pagamenti Utente";
	getIcon
		return "fa fa-user";

// ----------------------------------------------------------------
// RECUPERO I DATI SPECIFICI DELL'ELEMENTO DA VISUALIZZARE NEI
// RIQUADRI DEI DETTAGLI (ROSA)
getElementDetails
	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>
	getElement
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					$gbl_tableName = $rec['valore'];
		
		///		return "table name:" . $gbl_tableName;
		
		
		
			// ---------------------------
			// RECUPERO L'ID DELL'ELEMENTO
			if( !isset($_REQUEST['nome']))
				return "";
		
			$element = hex2bin( $_REQUEST['nome'] );
			$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
			$element = intval(_decrypta( $element, $key ));
		
			return $element;
		
		
		
		]>
	isEdit
		false
	_do
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		
			if( !isset( $_REQUEST['nome']))
				{echo "Errore sconosciuto 1"; return;}
		
			if( !isset( $_REQUEST['valore']))
				{echo "Errore sconosciuto 2"; return;}
		
			$nome = base64_decode( $_REQUEST['nome'] ); // NOME TABELLA
			$nome = trim(sanitize( $nome,"sql",$db_sql));
		
			$valore = base64_decode( $_REQUEST['valore'] ); 
			$element = hex2bin( $valore ); // ID CRIPTATO DELL'ELEMENTO
			$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
			$element = intval(_decrypta( $element, $key ));
			// ---------------------------
			$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
		
			$stru = array();
			
				$stru['html'] = <<<EOT
						<table style="background-color:#fee;" class="table mb-none">
							<tr class="b-top-none">
								<td><label class="mb-none">Nessuna tabella correlata</label></td>
							</tr>
						</table>
				EOT;
			
		
			// ELABORAZIONE ----------------------------------------------------------------------------------
			if( isset( $gbl_session['details']) && is_array( $gbl_session['details']))
			{
				/// prepariamo eventuali valori di sel_
				$titols = array();
				$o_fs = $gbl_session['info'];
				foreach($o_fs as $o_nome=>$o_valore)
				{
					$o_tipo = $o_valore[2] ?? "";
					if( $o_tipo == "sel_" )
					{
						$o_ncampo = $o_valore['titolo'][0] ?? "nome";
						$o_tabella = $o_valore['tabella'][0] ?? $o_nome;
						$o_cosa = _dbGet("SELECT id," . $o_ncampo . " FROM " . $o_tabella . ";");
						while( $o_cosa != NULL )
						{
							$titols[$o_nome][$o_cosa['id']] = $o_cosa[ $o_ncampo];
							$o_cosa = _dbGet();
						}
					}
				}
				/// -----------------------------------
				$gbl_table_index = 0;
				$content = "";
				$w = $gbl_session['details'];
				foreach($w as $detail) // non ci interessa il nome in questo caso
				{
					$gbl_table_index++;
					/// --------------------------------------------------------
					/// INSERISCO IL PARAMETRO QUERY NEL DETTAGLIO DELL'ELEMENTO
					/// --------------------------------------------------------
					/// INSERISCO IL PARAMETRO QUERY NEL DETTAGLIO DELL'ELEMENTO
					$query		= " WHERE $gbl_tableName='$element' ";
					$query		= _encrypta($query, "AZ$9099" . $gbl_idSessione . $gbl_userId);
					$query		= bin2hex( $query);
					
					/// --------------------------------------------------------
					/// INSERISCO IL PARAMETRO ELLEMENT
					/// --------------------------------------------------------
					/// INSERISCO IL PARAMETRO ELLEMENT
					$ellement = $element;
					$ellement = _encrypta($ellement, "AZ$9099" . $gbl_idSessione . $gbl_userId);
					$ellement = bin2hex( $ellement);
					
					/// --------------------------------------------------------
					$tipo = $detail[0] ?? "invalid";
					switch( trim($tipo) )
					{ // se è tipo tabella, per adesso non inserisce niente in caso di altro tipo sconosciuto
						case "type_info":
							$part = "";
							$max = count( $detail );
							for( $i=1; $i<$max; $i++)
							{
								if( $part == "" )
									$part = trim($detail[$i]);
								else
									$part .= "," . trim($detail[$i]);
							}
							$r_me = _dbGet("SELECT {$part} FROM $gbl_tableName WHERE id='$element';");
		
							for( $i=1; $i<$max; $i++)
							{
								$nome_campo = $detail[$i];
								$titolo_campo = $gbl_session['info'][$nome_campo][0] ?? $detail[$i];
								$valore_campo = $r_me[ $nome_campo] ?? "";
								$valore_campo = $titols[ $nome_campo][ $valore_campo] ?? $valore_campo;
								$valore_campo = str_replace("\t","&emsp;&emsp;&emsp;&emsp;",$valore_campo);
								$valore_campo = str_replace("\n","<br />\n",$valore_campo);
								$content .= <<<EOT
									<tr class="b-top-none">
										<td style="padding:7px 0 0 7px; border-left: 2px solid lightgray;">
											<p  style="border-bottom:2px solid lightgray; text-align:left; color: #34495e; font-family: courier new; font-weight:700;">{$titolo_campo}
												<i style="cursor: pointer;" nome_campo="{$nome_campo}" class="copier fa fa-copy"></i>
												<span id="copy_{$nome_campo}" style="visibility:hidden;top:-3px;position:relative;" class="label label-primary">Copied</span>
											</p>
											<p id="{$nome_campo}" style="text-align:left; font-family: courier new;">{$valore_campo}</p>
										</td>
									</tr>
								EOT;
							}
						break;
						case "type_table":
							$table		= isset( $detail[1]) ? $detail[1] : "xxxtb_invalid_name";
							$caption	= isset( $detail[2]) ? $detail[2] : "---";
							$additional = isset( $detail[5]) ? $detail[5] : "";
							//0 GESTIONE F -> PASSATO ALLA tbEdit quando vado nel dettaglio
							$indirizzo	= isset( $detail[3]) ? "index.php?fx=" . $detail[3] . "&q=" . $query . "&f=" . $ellement : "#";
							$count		= dbQuery("SELECT id FROM {$table} WHERE $gbl_tableName='$element' {$additional};");
							$content .= <<<EOT
								<tr class="b-top-none">
									<td><a href="{$indirizzo}" class="cliccabile"><label class="mb-none cliccabile"> {$caption}:</label></a> {$count}</td>
								</tr>
							EOT;
						break;
						case "type_custom":
							$program = $detail['program'] ?? "";
							$resultado = eval( $program );
							$content .= $resultado;
						break;
					}
				}
				// E COPY JAVASCRIPT --------
				
					$stru['html'] = <<<EOT
							<table style="background-color:#fee;" class="table mb-none">
								{$content}
							</table>
							<script>
								const copyToClipboard = str => {
									const el = document.createElement('textarea');
									console.log("prima:" + str);
									str.replace("&emsp;&emsp;&emsp;&emsp;","\t");
									console.log("dopo:" + str);
				///					str.replace("<br />","\n");
									el.value = str;
									el.setAttribute('readonly', '');
									el.style.position = 'absolute';
									el.style.left = '-9999px';
									document.body.appendChild(el);
									el.select();
									document.execCommand('copy');
									document.body.removeChild(el);
								};
								function resetBold(element)
								{
									$(element).css("font-weight","normal");
									$(element).prop("title","");
									$(element).trigger("mouseover");
									$("#copy_"+$(element).attr("nome_campo")).css("visibility","hidden");
								}
								$(".copier").each( function() {
				
									$(this).on('click', function(event) {
										try {
											copyToClipboard( $("#"+$(this).attr("nome_campo")).text() );
											$(this).css("font-weight","bold");
											$(this).prop("title","Copied");
											$(this).trigger("mouseover");
											$("#copy_"+$(this).attr("nome_campo")).css("visibility","visible");
											setTimeout( resetBold, 2000, this);
										} 
										catch (err) {
											console.log('Oops, unable to copy');
										}
									});
								});
				
							</script>
				
					EOT;
				
				// --------------------------
			}
			// TRASFORMAZIONE E INVIO -------------------------------------------------------------------------
			// -> $stru['html']
			$stru = json_encode( $stru );
			$stru = base64_encode( $stru );
			echo $stru;
			return;
		
		/// _[vecchia roba 23423423]
		
		
		
		
		]>
	permessi
		USER

// ----------------------------------------------------------------
//2 DELETE, UPLOAD, TEMPVALUES, FRM ADD RECORD EDIT RECORD
// FILTERS + EXPORTS

// FUNZIONE BASE PER ADD E MODIFY
frmAddRecord

	di tipo
		frameMain
	permessi
		USER
	isEdit
		false
	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>
	getElement
		<[
			// ---------------------------
			// RECUPERO L'ID DELL'ELEMENTO
			if( !isset($_REQUEST['e']))
				return "";
			return $_REQUEST['e'];
		]>
	backAddress
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			return "index.php?fx=" . $rec['valore'] . $query . $father;
		
		
		return "#";
		
		]>
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
	getOctopusMainContent
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
			function bin2pck2($v0)
			{
				$kT1="1q2w3e4r5t6y7u8i9o0pasdfghjklzxcvbnm";
				$kT2="qwertyuiopasdfghjklzxcvbnm";
				$rV = "";
				$first = true;
				while($v0>0)
				{
					if( $first )
					{
						$rV .= $kT2[($v0%26)];
						$v0 = intVal($v0/26);
						$first = false;
					}
					else
					{
						$rV .= $kT1[($v0%36)];
						$v0 = intVal($v0/36);
					}
				}
				return $rV;
			}
		
		
		$allFields = "";
		
		foreach( $gbl_struct as $field )
		{
			$fieldName = isset( $field['nome'] ) ? $field['nome'] : "";
		
			if( $fieldName == "" )
				continue;
		
			if( isset($gbl_session['info'][$fieldName][2]) && $gbl_session['info'][$fieldName][0] != "" )
				$field['tipo'] = $gbl_session['info'][$fieldName][2];
			else
				continue;
		
			// _[OVERWRITE_SUBPAGES_VALUES]
		
			$caption = isset($gbl_session['info'][$fieldName][0]) ? $gbl_session['info'][$fieldName][0] : "";
			$help = isset($gbl_session['info'][$fieldName][1]) ? $gbl_session['info'][$fieldName][1] : "";
			$maxLenText = isset( $field['len'] ) ? 'maxlength="' . $field['len'] . '"' : "";
			$readonly = isset($gbl_session['info'][$fieldName][3]) && $gbl_session['info'][$fieldName][3] == "readonly" ? ' readonly="' . $gbl_session['info'][$fieldName][3] . '" ' : "";
			$masked = isset($gbl_session['info'][$fieldName][7]) ? $gbl_session['info'][$fieldName][7] : "";
			$isOptional = isset($gbl_session['info'][$fieldName]["is optional"][0]) ? $gbl_session['info'][$fieldName]["is optional"][0] : false;
			$editMode = isset($gbl_session['info'][$fieldName]["edit mode"][0]) ? $gbl_session['info'][$fieldName]["edit mode"][0] : "";
			$numRows = $gbl_session['info'][$fieldName]["edit mode"][1] ?? 10;
			$theType = $field['tipo'];
			
				if( $field['tipo'] == "dt_" )
				{
					$prevval = isset($gbl_session['values'][$fieldName]) ?  htmlentities($gbl_session['values'][$fieldName]) : time();
					$prevval = date( "d/m/Y", $prevval );
				}
				elseif( $field['tipo'] == "dts_" && isset($gbl_session['values'][$fieldName]) && $gbl_session['values'][$fieldName] != "")
				{
					$prevval = $gbl_session['values'][$fieldName];
					$prevval = strtotime( $prevval );
					$prevval = date( "d/m/Y", $prevval );
				}
				else
					$prevval = isset($gbl_session['values'][$fieldName]) ?  htmlentities($gbl_session['values'][$fieldName]) : "";
			
			
			// PREVVAL: la parte di preset dei valori funziona su tutto, occhio a come però vengono inizializzati
			// sono da inizializzare RAW (esempio, tb_stato deve essere il valore 1 2 3: l'indice della tabella insomma.
			
			// --------------------------------------------------------------------------------------------------------------------
			// DA CONFIGURAZIONE, OVERRIDE GESTIONE AUTOMATICA DA STRUTTURA DATABASE
			$maxLenText = isset( $gbl_session['info'][$fieldName]['max chars'][0] ) ? 'maxlength="' . $gbl_session['info'][$fieldName]['max chars'][0] . '"' : $maxLenText;
			//2 --------------------------------------------------------------------------------------------------------------------
			//2 CONFIGURAZIONE DEI CAMPI DI INIZIALIZZAZIONE (SE PRESENTI): IN ADD
			//2 in add non visualizza ma deve mettere il campo per inizializzarlo
			$ini_type = isset( $gbl_session['info'][$fieldName]['init'][0] ) ? $gbl_session['info'][$fieldName]['init'][0] : "none";
			$ini_len_or_value = isset( $gbl_session['info'][$fieldName]['init'][1] ) ? $gbl_session['info'][$fieldName]['init'][1] : 0;
			$ini_show = isset( $gbl_session['info'][$fieldName]['init'][2] ) ? $gbl_session['info'][$fieldName]['init'][2] : "show";
			if( ! <!--isEdit--> )
			{
				
				// inizializzato ma modificabile
				if( $ini_type == "static" )
				{
					$prevval = $ini_len_or_value;
				}
				elseif( $ini_type == "fixed" ) // inizializzato e non modificabile
				{
					$prevval = $ini_len_or_value;
				}
				elseif( $ini_type == "unicode" )
				{
					// ritorna già il valore in minuscolo
					$prevval = bin2pck2(time()%1572000000);
				}
				elseif( $ini_type == "random" )
				{
					// un numero a caso, insieme al prossimo ID per renderlo univoco eventualmente servisse
					$next_id = _dbGet("SELECT MAX(id) as id FROM {{=getTableName=}};")['id'] ?? 0;
					$module = $ini_len_or_value ?? 0;
					$module = $module == 0 ? 1000 : $module;
					$prevval = (time() % $module) . ($next_id+1);
				}
				elseif( $ini_type == "variable" )
				{
					$prevval = $$ini_len_or_value;
				}
				elseif( $ini_type == "current" )
				{
					if( $ini_len_or_value == "datetime" )
					{
						$prevval = date("Y-m-d H:i:s", time());
					}
				}
				
				/*
				
				per il momento basta l'accesso alla variabile!
				
				elseif( $ini_type == "query" )
				{
					$prevval = "";
					$s = str_replace('$gbl_userId', $gbl_userId, $ini_len_or_value);
					$rec = _dbGet(addslashes($s));
					foreach($rec as $k=>$v)
					{
						if( $prevval == "" )
							$prevval .= $v;
						else
							$prevval .= "," . $v;
					}
				}
				
				*/
				
				
				if( $ini_show == "hide" )
					$theType = "real_hidden_"; // nascosto per inizializzarlo comunque, ma non skippato come "hid_"
			}
			//1 --------------------------------------------------------------------------------------------------------------------
			//1 MODIFY
			$mod_modify = isset( $gbl_session['info'][$fieldName]['modify'][0] ) ? $gbl_session['info'][$fieldName]['modify'][0] : "true";
			if( <!--isEdit--> && $mod_modify == "false" )
				$readonly = ' readonly="readonly" ';
			if( <!--isEdit--> && $mod_modify == "hidden" )
				$theType = "hid_";
			//1 --------------------------------------------------------------------------------------------------------------------
			if(  $theType == "tx_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				if( $icon != "null")
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="input-group">
													<span class="input-group-addon">
														<i class="{$icon}"></i>
													</span>
													<input type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<input type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				
				
			}
			elseif( $theType == "real_hidden_" ) /// modificato qui sopra
			{
				
				/// NON VISUALIZZA NULLA, METTE SOLO UN VALORE PER QUALUNQUE TIPO DI ELEMENTO
				
				//0 revisione 19 maggio 2022 aggiunto:
					$toBeSaved = "toBeSaved";
					if($readonly != "" && $ini_type == "none")
						$toBeSaved = "";
				//0 per salvare il tipo hidden 
				
					$allFields .= <<<EOT
				
												<input type="hidden" tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} form-control" id="id_{$fieldName}" value="{$prevval}" >
				
					EOT;
				
				
			}
			elseif( $theType == "hid_" )
			{
				/// E' PROPRIO SKIPPATO QUESTO TIPO
			}
			elseif( $theType == "psw_" )
			{
				
				if( $prevval == "" )
					$prevval = bin2pck((time()%119000)*144003) . bin2pck((time()%119000)*114003) . bin2pck((time()%9000)*4003);
				
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				if( $masked == "masked" )
					$prevval = "******";
					
				$allFields .= <<<EOT
				
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="input-group">
													<span class="input-group-addon">
														<i class="fa fa-key"></i>
													</span>
													<input type="text" {$maxLenText} nome="{$fieldName}" tipo="psw_" class="{$toBeSaved} styleMono form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
				
				EOT;
				
				
				/// _[PREVIOUS 789789]
				
				
			}
			elseif( $theType == "mm_" )
			{
				
				
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				/// data-plugin-textarea-autosize eliminato dal textarea
				
				if( $editMode == "web" )
				{
					$allFields .= <<<EOT
				
								<div class="form-group" id="fgId_{$fieldName}">
									<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
									<div class="col-md-7">
										<textarea class="{$toBeSaved} form-control summernote" nome="{$fieldName}" tipo="mm_" data-plugin-summernote data-plugin-options='{"height": 180, "codemirror": { "theme": "ambiance"" }}' id="id_{$fieldName}" {$readonly}>{$prevval}</textarea>
				///						<div class="{$toBeSaved} form-control summernote" nome="{$fieldName}" tipo="mm_" data-plugin-summernote id="id_{$fieldName}" {$readonly}>{$prevval}</div>
										<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
									</div>
								</div>
					EOT;
				
				}
				elseif( $editMode == "code" )
				{
					$allFields .= <<<EOT
				
								<div class="form-group" id="fgId_{$fieldName}">
									<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
									<div class="col-md-7">
										<textarea spellcheck="false" style="white-space: pre; overflow-wrap: normal; overflow-x: scroll; font-size:0.85em; font-family:courier new; color:gray; resize:vertical;" class="{$toBeSaved} form-control codeEditor" nome="{$fieldName}" tipo="mm_" {$maxLenText} rows="{$numRows}" id="id_{$fieldName}" {$readonly}>{$prevval}</textarea>
										<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
									</div>
								</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
								<div class="form-group" id="fgId_{$fieldName}">
									<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
									<div class="col-md-7">
										<textarea style="resize:vertical;" class="{$toBeSaved} form-control" nome="{$fieldName}" tipo="mm_" {$maxLenText} rows="3" id="id_{$fieldName}" {$readonly}>{$prevval}</textarea>
										<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
									</div>
								</div>
					EOT;
				}
				
				
				
			}
			elseif( $theType == "em_" )
			{
				
				
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="input-group">
													<span class="input-group-addon">
														<i class="fa fa-envelope"></i>
													</span>
													<input type="text" nome="{$fieldName}" id="id_{$fieldName}" value="{$prevval}" tipo="em_" {$maxLenText} {$readonly} class="{$toBeSaved} form-control" placeholder="es.: email@email.com" />
												</div>
												<div class="col-sm-12" style="padding:0;">
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
				
				EOT;
				
				/// style="color:#737373;" 
				
				
			}
			if( $theType == "sel_" )
			{
				
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				
				if( !(<!--isEdit-->) ) // IN AGGIUNTA ...
				{
					if($readonly != "" && $ini_type == "none")
					{
						$toBeSaved = "";
						$readonly = " disabled ";
					}
					if( $ini_type == "fixed" )
						$readonly = " disabled ";
				}
				else // IN MODIFICA ...
				{
					if($readonly != "")
					{
						$toBeSaved = "";
						$readonly = " disabled ";
					}
				}
				// GESTIONE DEL PARAMETRO F (DA STACK IN QUESTO CASO)
				// NON SERVE MODIFICARNE LA GESTIONE PER ADD/EDIT,
				// NEL CASO DI EDIT DEVE COINCIDERE
				// $disableAllTheRest = "";
				if($gbl_father != "" && intval( $gbl_father) > 0 )
				{
					if( isset($gbl_session['info'][$fieldName][9]) && $gbl_session['info'][$fieldName][9]=="true" )
					{
						$prevval = $gbl_father;
						if( !(<!--isEdit-->) )
							$toBeSaved = "toBeSaved";
				//		$disableAllTheRest = " disabled ";
					}
				}
				
				$opzioni = "";
				if( $isOptional ) // Se è opzionale in ogni caso (edit o add) devo poterlo mettere a "niente"
				{
					if( $prevval == "" || $prevval == 0 )
						$opzioni .= '<option value="0" selected></option>' . "\n";
					else
						$opzioni .= '<option value="0"></option>' . "\n";
				}
				
				// --------------------------------------------------------------------------------------------
				// se questo campo è NULL, non ci sono restrizioni, se è "" significa che nessun
				// elemento può essere visualizzato
				$forcedWhiteList = false;
				$restrictedList = array();
				
				
				$forcedWhiteListQuery = isset($gbl_session['info'][$fieldName]['forced white list query'][0]) ?  $gbl_session['info'][$fieldName]['forced white list query'][0] : NULL;
				
				if( $forcedWhiteListQuery != NULL )
				{
					$forcedWhiteList = true;
				///	$forcedWhiteListQuery = addslashes( $forcedWhiteListQuery );
					//0 NON FUNZIONA LA {{=getUserId=}} interna a info per qualche ragione ...
					$forcedWhiteListQuery = str_replace('$gbl_userId',$gbl_userId,$forcedWhiteListQuery);
					$xxx = _dbGet($forcedWhiteListQuery);
					while( isset($xxx['id']))
					{
						$restrictedList[$xxx['id']] = true;
						$xxx = _dbGet();
					}
				}
				
				
				// --------------------------------------------------------------------------------------------
				
				$table = isset($gbl_session['info'][$fieldName]['tabella'][0]) ?  $gbl_session['info'][$fieldName]['tabella'][0] : $fieldName;
				$titolo = isset($gbl_session['info'][$fieldName]['titolo'][0]) ?  $gbl_session['info'][$fieldName]['titolo'][0] : "titolo";
				$titolo2 = isset($gbl_session['info'][$fieldName]['titolo'][1]) ?  $gbl_session['info'][$fieldName]['titolo'][1] : "";
				$titolo3 = isset($gbl_session['info'][$fieldName]['titolo'][2]) ?  $gbl_session['info'][$fieldName]['titolo'][2] : "";
				$titolo4 = isset($gbl_session['info'][$fieldName]['titolo'][3]) ?  $gbl_session['info'][$fieldName]['titolo'][3] : "";
				
				$table = sanitize( $table, "sql", $db_sql);
				$titolo = sanitize( $titolo, "sql", $db_sql);
				$titolo2 = sanitize( $titolo2, "sql", $db_sql);
				$titolo3 = sanitize( $titolo3, "sql", $db_sql);
				$titolo4 = sanitize( $titolo4, "sql", $db_sql);
				
				$campi = $titolo;
				if( $titolo2 != "" ) $campi .= ",".$titolo2;
				if( $titolo3 != "" ) $campi .= ",".$titolo3;
				if( $titolo4 != "" ) $campi .= ",".$titolo4;
				
				$rec = _dbGet("SELECT id,{$campi} FROM {$table} ORDER BY {$titolo} ASC;");
				while( $rec != NULL )
				{
					if( !isset($rec[ $titolo]) || !isset($rec['id']))
						continue;
				
					// -----------------------------------------------------------
					// FILTRO FORCED WHITE LIST
					// se c'è una lista bianca obbligatoria e non fa parte della 
					// lista bianca: continue!
					if( $forcedWhiteList && !isset( $restrictedList[ $rec['id']] ))
					{
						$rec = _dbGet();
						continue;
					}
				
					$testo = $rec[ $titolo];
					$testo .= isset( $rec[$titolo2] ) ? " " . $rec[$titolo2] : "";
					$testo .= isset( $rec[$titolo3] ) ? " " . $rec[$titolo3] : "";
					$testo .= isset( $rec[$titolo4] ) ? " " . $rec[$titolo4] : "";
					if( $testo == "" )
						$testo = "?";
				
					if( $rec['id'] == $prevval )
						$opzioni .= '<option value="' . $rec['id'] . '" selected>' . htmlentities( $testo ) . '</option>' . "\n";
					else
						$opzioni .= '<option value="' . $rec['id'] . '">' . htmlentities( $testo ) . '</option>' . "\n";
				//		$opzioni .= '<option value="' . $rec['id'] . '"' . $disableAllTheRest . '>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				
					$rec = _dbGet();
				}
				
				
				
				
				
				
				
				
				if( $icon != "null")
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
													<div class="input-group btn-group">
													<span class="input-group-addon">
														<i class="{$icon}"></i>
													</span>
													<select data-plugin-selectTwo data-none-selected-text="NESSUNO" tipo="sel_" nome="{$fieldName}" class="{$toBeSaved} form-control populate" id="id_{$fieldName}" {$readonly}>
													{$opzioni}
													</select>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<select data-plugin-selectTwo data-none-selected-text="NESSUNO" tipo="sel_" nome="{$fieldName}" class="{$toBeSaved} form-control populate" id="id_{$fieldName}" {$readonly}>
													{$opzioni}
												</select>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				
				
				/// _[ESEMPIO CON ANCHE TUTTI I SOTTO GRUPPI]
				
				
			}
			if( $theType == "sel1_" )
			{
					
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				
				// vecchio -----------------------------------
				// $toBeSaved = "toBeSaved";
				// if($readonly != "" && $ini_type == "none")
				//	$toBeSaved = "";
				// -------------------------------------------
				
				/// nuovo ------------------------------------
				$toBeSaved = "toBeSaved";
				
				if( !(<!--isEdit-->) ) // IN AGGIUNTA ...
				{
					if($readonly != "" && $ini_type == "none")
					{
						$toBeSaved = "";
						$readonly = " disabled ";
					}
					if( $ini_type == "fixed" )
						$readonly = " disabled ";
				}
				else // IN MODIFICA ...
				{
					if($readonly != "")
					{
						$toBeSaved = "";
						$readonly = " disabled ";
					}
				}
				// -------------------------------------------
				
				$opzioni = "";
				
				$table = isset($gbl_session['info'][$fieldName]['tabella'][0]) ?  $gbl_session['info'][$fieldName]['tabella'][0] : $fieldName;
				$titolo = isset($gbl_session['info'][$fieldName]['titolo'][0]) ?  $gbl_session['info'][$fieldName]['titolo'][0] : "titolo";
				
				$table = sanitize( $table, "sql", $db_sql);
				$titolo = sanitize( $titolo, "sql", $db_sql);
				
				$eleSelected = explode(",", $prevval);
				
				if( !is_array($eleSelected)) // se non c'è nulla di selezionato, deve andare comunque
					$eleSelected = array();
				
				$rec = _dbGet("SELECT id,{$titolo} FROM {$table} ORDER BY {$titolo} ASC;");
				while( $rec != NULL )
				{
					if( !isset($rec[ $titolo]) || !isset($rec['id']))
						continue;
				
					if( in_array($rec['id'], $eleSelected))
						$opzioni .= '<option value="' . $rec['id'] . '" selected>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
					else
						$opzioni .= '<option value="' . $rec['id'] . '">' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				
					$rec = _dbGet();
				}
				
				
				
				
				
				
				
				
				if( $icon != "null")
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
													<div class="input-group btn-group">
													<span class="input-group-addon">
														<i class="{$icon}"></i>
													</span>
													<select data-plugin-multiselect multiple="multiple" data-plugin-options='{ "maxHeight": 300, "nonSelectedText": "Nessun Elemento"}' tipo="sel1_" nome="{$fieldName}" class="{$toBeSaved} form-control populate" id="id_{$fieldName}" {$readonly}>
													{$opzioni}
													</select>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<select data-plugin-multiselect multiple="multiple" data-plugin-options='{ "maxHeight": 300, "nonSelectedText": "Nessun Elemento"}' tipo="sel1_" nome="{$fieldName}" class="{$toBeSaved} form-control populate" id="id_{$fieldName}" {$readonly}>
													{$opzioni}
												</select>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				
				
				/// _[ESEMPIO CON ANCHE TUTTI I SOTTO GRUPPI]
				
			}
			if( $theType == "i_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				// il campo di configurazione ICON è discalculato
				
				$icon = <<<EOT
						<a tabindex="-1" id="idSImg_{$fieldName}" style="display:block;height:20px;width:20px;" href="index.php?fx=ixmage&tmp=2&a=2000" data-plugin-lightbox data-plugin-options='{ "type":"image" }' title="">
							<img id="idImg_{$fieldName}" class="img-responsive" style="display:block;height:20px;width:20px;" src="index.php?fx=ixmage&tmp=2&l=20&a=20">
						</a>
				EOT;
				
				
				if( <!--isEdit--> )
				{
					$lid = "{{=getElement=}}";
					if( $lid == "" )
						return "Invalid id, notify admin@awgp.it: 0.88973.998";
				
					$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
					$idCode = _decrypta( hex2bin( $lid), $key );
					// ARRAY
					$dat = array();
					$dat['t'] = $gbl_tableName;
					$dat['f'] = $fieldName;
					$dat['id'] = $idCode;
					// JSON
					$dat = json_encode( $dat );
					// ENCRYPT
					$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
					$dat = _encrypta( $dat, $key );
					// BASE64/BIN2HEX
					$dat = bin2hex( $dat );
				//	$icon = '<img id="idImg_' . $fieldName . '" style="display:block;height:20px;" src="index.php?fx=ixmage&data=' . $dat . '&l=20&a=20"></img>' . "\n";
					$icon = <<<EOT
									<a id="idSImg_{$fieldName}" tabindex="-1" style="display:block;height:20px;width:20px;" href="index.php?fx=ixmage&data={$dat}&a=2000" data-plugin-lightbox data-plugin-options='{ "type":"image" }' title="">
										<img id="idImg_{$fieldName}" class="img-responsive" style="display:block;height:20px;width:20px;" src="index.php?fx=ixmage&data={$dat}&l=20&a=20">
									</a>
					EOT;
				
				}
				else
					$prevval = "";
				
				$allFields .= <<<EOT
				
									<div class="form-group" id="fgId_{$fieldName}">
										<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
										<div class="col-md-7">
											<div style="width:100%;" class="input-group">
												<span style="padding:6px 9px;" class="input-group-addon">
													{$icon}
												</span>
												<div style="width:100%;" class="fileupload fileupload-new" data-provides="fileupload">
													<div style="width:100%; display:flex;" class="input-append">
														<div style="width:100%;" class="uneditable-input">
															<span id="idN_{$fieldName}" style="padding:0;" class="fileupload-preview">{$prevval}</span>
														</div>
														<span style="width:105px;" class="btn btn-default btn-file">
															<span class="fileupload-exists">Cambia</span>
															<span class="fileupload-new">Scegli</span>
															<input tabindex="-1" tipo="i_" nome="{$fieldName}" class="{$toBeSaved}" type="file" id="id_{$fieldName}" {$readonly} />
														</span>
														<a href="#" forElement="{$fieldName}" style="width:105px;" class="btn btn-default tastoRimuovi" data-dismiss="fileupload">Rimuovi</a>
													</div>
												</div>
											</div>
											<div class="progress-wrp" id="progress-wrp-{$fieldName}">
												<div class="progress-bar"></div>
												<div class="status">0%</div>
											</div>
											<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
										</div>
									</div>
				EOT;
				
				
			}
			if( $theType == "anx_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				if( <!--isEdit--> )
				{
					$lid = "{{=getElement=}}";
					if( $lid == "" )
						return "Invalid id, notify admin@awgp.it: 0.88973.994";
				
					$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
					$idCode = _decrypta( hex2bin( $lid), $key );
					// ARRAY
					$dat = array();
					$dat['t'] = $gbl_tableName;
					$dat['f'] = $fieldName;
					$dat['id'] = $idCode;
					// JSON
					$dat = json_encode( $dat );
					// ENCRYPT
					$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
					$dat = _encrypta( $dat, $key );
					// BASE64/BIN2HEX
					$dat = bin2hex( $dat );
				}
				else
					$prevval = "";
				
				$allFields .= <<<EOT
				
									<div class="form-group" id="fgId_{$fieldName}">
										<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
										<div class="col-md-7">
											<div style="width:100%;" class="input-group">
												<span style="padding:6px 9px;" class="input-group-addon">
													<i class="{$icon}"></i>
												</span>
												<div style="width:100%;" class="fileupload fileupload-new" data-provides="fileupload">
													<div style="width:100%; display:flex;" class="input-append">
														<div style="width:100%;" class="uneditable-input">
															<span id="idN_{$fieldName}" style="padding:0;" class="fileupload-preview">{$prevval}</span>
														</div>
														<span style="width:105px;" class="btn btn-default btn-file">
															<span class="fileupload-exists">Cambia</span>
															<span class="fileupload-new">Scegli</span>
															<input tabindex="-1" tipo="i_" nome="{$fieldName}" class="{$toBeSaved}" type="file" id="id_{$fieldName}" {$readonly} />
														</span>
														<a href="#" forElement="{$fieldName}" style="width:105px;" class="btn btn-default tastoRimuovi" data-dismiss="fileupload">Rimuovi</a>
													</div>
												</div>
											</div>
											<div class="progress-wrp" id="progress-wrp-{$fieldName}">
												<div class="progress-bar"></div>
												<div class="status">0%</div>
											</div>
											<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
										</div>
									</div>
				EOT;
				
				
			}
			if( $theType == "dt_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				if( $icon != "null")
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="input-group">
													<span class="input-group-addon">
														<i class="{$icon}"></i>
													</span>
													<input data-plugin-datepicker data-date-language="it" data-date-format="dd/mm/yyyy" type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} datePicker form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<input data-plugin-datepicker data-date-language="it" data-date-format="dd/mm/yyyy" type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} datePicker form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				
				
				
				
			}
			if( $theType == "dts_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "" && $ini_type == "none")
					$toBeSaved = "";
				
				if( $icon != "null")
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="input-group">
													<span class="input-group-addon">
														<i class="{$icon}"></i>
													</span>
													<input data-plugin-datepicker data-date-language="it" data-date-format="dd/mm/yyyy" type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} datePicker form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												</div>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				else
				{
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<input data-plugin-datepicker data-date-language="it" data-date-format="dd/mm/yyyy" type="text" {$maxLenText} tipo="tx_" nome="{$fieldName}" class="{$toBeSaved} datePicker form-control" id="id_{$fieldName}" value="{$prevval}" {$readonly}>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
					EOT;
				}
				
				
				
				
			}
			if( $theType == "ck_" )
			{
				
				$icon = isset($gbl_session['info'][$fieldName][6]) ?  $gbl_session['info'][$fieldName][6] : "null";
				$toBeSaved = "toBeSaved";
				if($readonly != "")
				{
					if( $ini_type != "none")
						$toBeSaved = "";
					$readonly = " disabled ";
				}
				
				$checked = "";
				if( strtolower($prevval) == "true")
					$checked = "checked";
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<input style="width:30px; height:30px;" class="{$toBeSaved}" type="checkbox" tipo="ck_" nome="{$fieldName}" id="id_{$fieldName}" {$readonly} {$checked}>
												<span id="lblId_{$fieldName}" previous="{$help}" class="help-block">{$help}</span>
											</div>
										</div>
				EOT;
				
				
				/// _[ESEMPIO CON ANCHE TUTTI I SOTTO GRUPPI]
				
				
			}
		}
		
		
		
		
		$buttonCancelCaption = isset($gbl_session['ancillary']["buttonCancel"][0]) ? $gbl_session['ancillary']["buttonCancel"][0] : "CANCEL";
		$buttonSaveCaption	= isset($gbl_session['ancillary']["buttonSave"][0]) ? $gbl_session['ancillary']["buttonSave"][0] : "SAVE";
		$buttonSaveHelp 	= isset($gbl_session['ancillary']["buttonSave"][1]) ? $gbl_session['ancillary']["buttonSave"][1] : "";
		$buttonSaveType	= isset($gbl_session['ancillary']["buttonSave"][2]) ? $gbl_session['ancillary']["buttonSave"][2] : "btn-success";
		
		$pulsanti = <<<EOT
		
					<div class="form-group">
						<div class="col-md-3"></div>
		///				<label class="col-md-3 control-label" for="id_saveButton"></label>
						<div class="col-md-6">
							<button id="id_saveButton" style="text-shadow:none;" type="button" class="saveAllButton btn {$buttonSaveType}"><i class="fa fa-save"></i> {$buttonSaveCaption}</button>
							<button type="button" style="text-shadow:none;" class="close-all mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-times"></i> {$buttonCancelCaption}</button>
							<span id="saveAllHelpId" class="help-block">{$buttonSaveHelp}</span>
						</div>
					</div>
		
		EOT;
		
		
		$what = <<<EOT
		
		<!-- start: page -->
			<div class="row">
				<div class="col-lg-12">
					<section class="panel">
						<header class="panel-heading">
							<div class="panel-actions">
								<a href="#" class="fa fa-caret-down"></a>
								<a href="#" class="close-all fa fa-times"></a>
							</div>
			
							<h2 class="panel-title">{{=title=}}</h2>
						</header>
						<div class="panel-body">
							<form class="form-horizontal form-bordered" id="form" action="index.php?fx=cmdAddNewRecord" method="post">
		
								{$allFields}
		
								{$pulsanti}
		
							</form>
						</div>
					</section>
				</div>
			</div>
		EOT;
		
		
		
		return $what;
		
		
		]>
	init
		<[
		/// INIZIALIZZO LE VARIABILI GLOBALI
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
///		_[CANCELLO I VALUES PER SICUREZZA]
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		
		if( <!--isEdit--> )
		{
			$fieldsToRead = "";
		
			foreach( $gbl_struct as $str )
			{
				if( isset( $str['nome']))
				{
					if(	!startswith( $str['nome'], "i_") && 
						!startswith( $str['nome'], "anx_") )
					{
						if( $fieldsToRead == "" )
							$fieldsToRead = $str['nome'];
						else
							$fieldsToRead .= "," . $str['nome'];
					}
					else // PER IL MOMENTO LEGGIAMO ANCHE I FILE BLOB
					{
						if( $fieldsToRead == "" )
							$fieldsToRead = $str['nome'];
						else
							$fieldsToRead .= "," . $str['nome'];
					}
				}
			}
		
			// ---------------------------
			// RECUPERO L'ID DELL'ELEMENTO
			if( !isset($_REQUEST['e']))
			{
				header("Location: index.php?fx=$gbl_masterFunction&i=9999");
				exit();
			}
			$element = hex2bin( $_REQUEST['e'] );
			$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
			$element = intval(_decrypta( $element, $key ));
			// ---------------------------
		
			$dat = _dbGet("SELECT {$fieldsToRead} FROM $gbl_tableName WHERE id='$element';");
		
			if( $dat != NULL && is_array( $dat))
			{
				foreach($dat as $n=>$v)
				{
					if( !isset($gbl_session['info'][$n][2]))
						continue;
					$tipo = $gbl_session['info'][$n][2];
					switch( $tipo)
					{
						case "i_":
						case "anx_":
							if( $v != "" && $v != NULL )
							{
								$v = json_decode( $v, true );
								if( isset( $v['nomefile']) )
								{
									$v = isset( $v['nomefile'] ) ? $v['nomefile'] : "";
									$gbl_session['values'][$n] = $v;
								}
							}
							break;
						default:
							$gbl_session['values'][$n] = $v;
							break;
					}
				}
			}
		
		}
		
		
		
		
			/// ------------------------------------------------------------------------------
			/// SOVRASCRIVO I DATI PASSATI DALLA EDIT STANDARD PER PERSONALIZZARE LE FUNZIONI
			/// INTERNE. INFO SPECIFICA DELLA FUNZIONE SOVRASCRIVE I DATI GLOBALI DI SESSIONE
			/// ------------------------------------------------------------------------------
			if( isset($_t['info']) && is_array( $_t['info']))
			{
				$aS = $_t['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			if( isset($_t['details']) && is_array( $_t['details']))
			{
				$aS = $_t['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
			if( isset($_t['ancillary']) && is_array( $_t['ancillary']))
			{
				$aS = $_t['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			if( isset($_t['subpages']) && is_array( $_t['subpages']))
			{
				$aS = $_t['subpages'];
				foreach( $aS as $info=>$data )
					$gbl_session['subpages'][$info] = $data;
			}
		
			$chiave = "add";
			if( <!--isEdit--> )
				$chiave = "edit";
		
			// OVERWRITING INFO ELEMENTS SPECIFIC FOR EDIT
			// INFO
			if( isset( $gbl_session['subpages'][$chiave]['info'] ) && is_array( $gbl_session['subpages'][$chiave]['info'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			/// ANCILLARY (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['ancillary'] ) && is_array( $gbl_session['subpages'][$chiave]['ancillary'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			/// DETAILS (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['details'] ) && is_array( $gbl_session['subpages'][$chiave]['details'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
		
		
///		_[RICARICO IL PARAMETRO F (FATHER)] -> no, nelle funzioni interne lo devo caricare da stack se presente
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		
		]>
	ADDITIONAL CSS BARE FRAME
		<[
		
		
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-multiselect/bootstrap-multiselect.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-tagsinput/bootstrap-tagsinput.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-timepicker/css/bootstrap-timepicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/basic.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/dropzone.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-markdown/css/bootstrap-markdown.min.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote-bs3.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/lib/codemirror.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/theme/monokai.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/theme/elegant.css" />
				<!-- Specific Page Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
		
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<!-- Specific Page Vendor -->
		<script src="<!--relativeDirectory-->/vendor/ios7-switch/ios7-switch.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-validation/jquery.validate.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/forms/examples.validation.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-autosize/jquery.autosize.js"></script>
		<script src="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
		<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/locales/bootstrap-datepicker.it.js"></script>
		<script src="<!--relativeDirectory-->/vendor/summernote/summernote.js"></script>
		
		<script>
		
			var lastEditedElement = null;
			var someFieldChanged = false;
			var waitToExit = false;
		
			
			$( document ).ready(function() {
			
				$(".codeEditor").each( function()
				{
					$(this).on('keydown', function(e) 
					{
						if (e.key == 'Tab')
						{
							e.preventDefault();
							var start = this.selectionStart;
							var end = this.selectionEnd;
			
							// set textarea value to: text before caret + tab + text after caret
							this.value = this.value.substring(0, start) + "\t" + this.value.substring(end);
			
							// put caret at right position again
							this.selectionStart = this.selectionEnd = start + 1;
						}
					});
				});
			});
			
			
			
			/*
			// SummerNote
			(function( $ ) {
			
				'use strict';
			
				if ( $.isFunction($.fn[ 'summernote' ]) ) {
			
					$(function() {
						$('[data-plugin-summernote]').each(function() {
							var opts = {};
							var pluginOptions = $(this).data('plugin-options');
							if (pluginOptions)
								opts = pluginOptions;
			
							$(this).themePluginSummerNote(opts);
						});
					});
			
				}
			
			}).apply(this, [ jQuery ]);
			*/
			
			/// data-plugin-summernote data-plugin-options='{"height": 180, "codemirror": { "theme": "ambiance"" }}'
			
			
			$( document ).ready(function() {
			
				$('.summernote').summernote({
					height: 300,                 // set editor height
					minHeight: null,             // set minimum height of editor
					maxHeight: null,             // set maximum height of editor
					codemirror: { 					// codemirror options
						theme: 'elegant'
					},
					onChange: function() {
						someFieldChanged = true;
			///			console.log("changed: " + $(event.target).parent().parent().children().first().attr("class"));
					}
			///,
			///		onBlur: function() {saveTheField( event.target, null );}
				});
			
				$('.summernote').each(function( index )
				{
					if( $(this).hasClass("toBeSaved"))
					{
						var real_one = $(this).parent().find(".note-editable").first();
						if( $(real_one).length && $(this).hasClass("toBeSaved"))
						{
							var tipo = $(this).attr("tipo");
							var nome = $(this).attr("nome");
							$(real_one).addClass("toBeSaved");
							$(real_one).attr("tipo", tipo);
							$(real_one).attr("nome", nome);
							$(this).removeClass("toBeSaved");
							$(this).removeAttr("tipo");
							$(this).removeAttr("nome");
						}
					}
				});
			
			});
			
			
		
			
			var Upload = function (file) {
				this.file = file;
			};
			
			Upload.prototype.getType = function() {
				return this.file.type;
			};
			Upload.prototype.getSize = function() {
				return this.file.size;
			};
			Upload.prototype.getName = function() {
				return this.file.name;
			};
			Upload.prototype.doUpload = function (nome, tipo) {
				var nomePuro = b64_to_utf8( nome );
				// update progressbars classes so it fits your code
				var percent = 0;
				var position = event.loaded || event.position;
				var total = event.total;
				var progress_bar_id = "#progress-wrp-" + nomePuro; // + nome;
				$(progress_bar_id + " .progress-bar").css("width", "0%");
				$(progress_bar_id + " .status").text("0%");
				$(".saveAllButton").prop("disabled", true);
				$(".close-all").prop("disabled", true);
				waitToExit = true;
			
				var that = this;
				var formData = new FormData();
			
				// add assoc key values, this will be posts values
				formData.append("file", this.file, this.getName());
				formData.append("upload_file", true);
				//0 Orazio
				formData.append("nome", nome);
				formData.append("tipo", tipo);
				//0 valore non viene inviato
				$.ajax({
					type: "POST",
					url: "index.php?fx=uploadFile",
					xhr: function () {
						$(progress_bar_id).css("display","block");
						var myXhr = $.ajaxSettings.xhr();
						if (myXhr.upload) {
							myXhr.upload.addEventListener('progress', that.progressHandling.bind(null, nomePuro), false);
						}
						return myXhr;
					},
					success: function (data) {
						$(progress_bar_id).css("display","none");
						$(".saveAllButton").prop("disabled", false);
						$(".close-all").prop("disabled", false);
						$("#idImg_" + nomePuro).attr("src", "index.php?fx=ixmage&tmp=1&n=" + nomePuro + "&a=50&l=50&tm=" + Math.random());
						$("#idSImg_" + nomePuro).attr("href", "index.php?fx=ixmage&tmp=1&n=" + nomePuro + "&a=2000&tm=" + Math.random());
						waitToExit = false;
						// your callback here
					},
					error: function (error) {
						// handle error
						$(".saveAllButton").prop("disabled", false);
						$(".close-all").prop("disabled", false);
						waitToExit = false;
					},
					async: true,
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					timeout: 6000000
				});
			};
			
			Upload.prototype.progressHandling = function (nome, event) {
				var percent = 0;
				var position = event.loaded || event.position;
				var total = event.total;
				var progress_bar_id = "#progress-wrp-" + nome;
				if (event.lengthComputable) {
					percent = Math.ceil(position / total * 100);
				}
				// update progressbars classes so it fits your code
				$(progress_bar_id + " .progress-bar").css("width", +percent + "%");
				$(progress_bar_id + " .status").text(percent + "%");
			};
			
			
		
			window.onbeforeunload = function(){
				if( someFieldChanged )
					return true;
				return null;
			};
		
			(function () {
		
				$(".close-all").on( 'click', function( e ) { 
					window.location.href='{{=backAddress=}}';
					return false;
				});
		
			})();
		
			function utf8_to_b64( str ) {
				return window.btoa(unescape(encodeURIComponent( str )));
			}
			function b64_to_utf8( str ) {
				return decodeURIComponent(escape(window.atob( str )));
			}
		
		function ajaxCall( funzione, nome, valore, tipo, callback )
		{
			/// nome = JSON.stringify(nome + "." + funzione ); // to JSON
			var name = utf8_to_b64( nome ); // to BASE64
			/// valore = JSON.stringify(valore); // to JSON
			var value = utf8_to_b64( valore ); // to BASE64
			var type = utf8_to_b64( tipo ); // to BASE64
		
			var jqxhr = $.post( "index.php?fx=" + funzione, { nome: name, valore: value, tipo: type, id: "{{=getElement=}}" }, function(data) {
		///			alert( "success:" + data );
				})
				.done(function(data) {
		///			alert( "second success:" + data );
				})
				.fail(function(data) {
		///			alert( "error:" + data );
				})
				.always(function(data) {
		
					if( data != "" )
					{
						if( data.startsWith("W:"))
						{
							$('#lblId_' + nome).html(data.replace("W:",""));
							$('#lblId_' + nome).css('color', "#d56d00");
							$('#fgId_' + nome).removeClass('has-error');
						}
						else
						{
							$('#lblId_' + nome).html(data);
							$('#lblId_' + nome).css('color', '#a94442;');
							$('#fgId_' + nome).addClass('has-error');
						}
					}
					else
					{
						var previous = $('#lblId_' + nome).attr("previous");
						$('#lblId_' + nome).html(previous);
						$('#lblId_' + nome).css('color', "#737373");
						$('#fgId_' + nome).removeClass('has-error');
					}
		
					if( callback !== null )
						callback(nome,valore,tipo);
				});
		}
		
		function saveTheField( target, callback )
		{
			// -----------------------------------------------------------------------------
			// Deve essere di tipo salvabile.
			// Anche il plugin summernote (web editor wysiwyg) verrà modificato a posteriori
			// per avere le caratteristiche giuste.
			if( ! $(target).hasClass("toBeSaved"))
				return;
			// -----------------------------------------------------------------------------
			var name = $(target).attr("nome");
			var type = $(target).attr("tipo");
			var value;
			// -----------------------------------------------------------------------------
			// Se è di tipo note-editable, il contenuto è nell'html
			if( $(target).hasClass("note-editable"))
				value = $(target).html();
			else
				value = $(target).val();
			// -----------------------------------------------------------------------------
			if( type == "i_" )
			{
				if( value == "" )
					return;
		
				if( name == "" || name == undefined )
					return;
		
			    var file = $(target)[0].files[0];
			    var upload = new Upload(file);
		
			    // maby check size or type here with upload.getSize() and upload.getType()
		
			    // execute upload
				name= utf8_to_b64( name); // to BASE64
				type = utf8_to_b64( type ); // to BASE64
		    	upload.doUpload(name,type);
				return;
			}
			if( type == "ck_" )
			{
				if( $(target).prop('checked'))
					value = "TRUE";
				else
					value = "FALSE";
			}
		
			if( name != undefined && type != undefined && value != undefined )
				ajaxCall( "ajaxSaveTempValue", name, value, type, callback );
		}
		
		function saveTheRecord()
		{
			var isOk = true;
			$(".form-group").each( function () {
				if ($(this).hasClass("has-error")) {
					$('#saveAllHelpId').html("Sono stati trovati errori nei dati inseriti, cortesemente ricontrolla.");
					$('#saveAllHelpId').css('color', 'red');
					isOk = false;
				}
			}).promise().done( function(){ 
				if( !isOk )
					return;
		
				if( <!--isEdit--> )
				{
					var jqxhr = $.post("index.php?fx=cmdModifyRecord", { nome: "{{=getElement=}}", valore: "" }, function(data) {}).always(function(data) {
						window.location.href='{{=backAddress=}}&i=' + data;
					});
				}
				else
				{
					var jqxhr = $.post("index.php?fx=cmdAddNewRecord", { nome: "", valore: "" }, function(data) {}).always(function(data) {
						window.location.href='{{=backAddress=}}&i=' + data;
					});
				}
			});
		}
		
		$( document ).ready(function() {
		
			$(document).focusout( function(event){
				if( $(event.target).hasClass("toBeSaved") )
				{
					var tipo = $(event.target).attr("tipo");
					if( tipo == "i_" || tipo == "anx_" )
						return;
					lastEditedElement = event.target;
					saveTheField( event.target, null );
				}
			});
		
			$('.datePicker').on('change', function(e) {
		
				if( waitToExit ) // sto facendo upload
					return;
		
				if( ! $(e.target).hasClass("toBeSaved") )
					return;
		
				someFieldChanged = true;	
				saveTheField( e.target, null);
				return;
			});
		
			/// ------------------------------------------------------------------------------------------
			/// PER LA summernote, la gestione viene fatta nella callback dichiarata nell'inizializzazione
		
			$('input:checkbox').on('change', function(e) {
		
				if( waitToExit ) // sto facendo upload
					return;
		
				if( ! $(e.target).hasClass("toBeSaved") )
					return;
		
				someFieldChanged = true;	
				saveTheField( e.target, null);
				return;
			});
		
			$('select').on('change', function(e) {
		
				if( waitToExit ) // sto facendo upload
					return;
		
				if( ! $(e.target).hasClass("toBeSaved") )
					return;
		
				someFieldChanged = true;	
				saveTheField( e.target, null);
				return;
			});
		
			$('.tastoRimuovi').on("click", function(e) {
				if( waitToExit ) // sto facendo upload
					return;
		
				someFieldChanged = true;
				var field = $(e.target).attr("forElement");
				ajaxCall( "ajaxSetFieldToNull", field, "", "", function(field) {
					$("#idImg_" + field).attr("src", "index.php?fx=ixmage&tmp=2&a=50&l=50&tm=" + Math.random());
					$("#idSImg_" + field).attr("href", "index.php?fx=ixmage&tmp=2&a=2000&tm=" + Math.random());
					$("#idN_" + field).html("");
				});
				return false;
			});
		
		///	$(document).on('DOMSubtreeModified', '.note-editable', function(we, contents, \$editable) {
		///		console.log('summernote\'s content is changed:.' + $('this').summernote('code'));
		///	});
		
			$('input:file').on('change', function(e) {
		
				if( waitToExit ) // sto facendo upload
					return;
		
				var tipo = $(e.target).attr("tipo");
				if( tipo != "i_" && tipo != "anx_" )
					return;
				someFieldChanged = true;	
				saveTheField( e.target, null);
				return;
			});
		
			$(document).on('keyup', function (e)
			{
				if( ! $(e.target).hasClass("toBeSaved") )
					return;
		
				if(e.key === "Enter")
				{
					if( waitToExit ) // sto facendo upload
						return false;;
		
					var tipo = $(e.target).attr("tipo");
					if( tipo == "i_" || tipo == "anx_" || tipo == "mm_" )
						return;
		
					someFieldChanged = false;	
					saveTheField( e.target, saveTheRecord);
					return;
				}
		
				if(e.key === "Escape")
				{
					if( !waitToExit ) 
						window.location.href='{{=backAddress=}}';
					return false;
				}
		///		console.log("something");
				// CAMBIATO QUALCOSA ...
				someFieldChanged = true;	
		
			});
		
			$(".saveAllButton").on("click", function(event) {
				if( waitToExit ) // sto facendo upload
					return false;
		
				someFieldChanged = false;	
				if( lastEditedElement !== null )
					saveTheField( lastEditedElement, saveTheRecord );
				else
					saveTheRecord();
			});
		
			// FORZIAMO LA VERIFICA DI TUTTI I CAMPI
			$(".toBeSaved").each( function(){
				$(this).trigger("focusout");
			});
		
			$("#form input:not([readonly='readonly']):not([disabled='disabled']):enabled:visible:text, #form textarea:not([readonly='readonly']):not([disabled='disabled']):enabled:visible").first().focus();
		
		});
		
		</script>
		
		]>
	title
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			//2 WIP WIP WIP WIP WIP WIP WIP WIP WIP WIP
			
			// WIP WIP WIP TBD
			
			return 'Nuovo elemento tabella: <span style="font-weight:550;">' . $gbl_tableName . "</span>";
		]>


frmFilterRecord

	di tipo
		frameMain
	permessi
		USER
	isEdit
		false
	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>
	backAddress
		<[
		
		//0 CONDIVISO TRA EXPORT E FILTER
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			return "index.php?fx=" . $rec['valore'] . $query . $father;
		
		
		return "#";
		
		//0 CONDIVISO TRA EXPORT E FILTER
		
		]>
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
	getOctopusMainContent
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
		//1 BOLLA CONDIVISA
		
		$fil = array();
		$paginaMaster = trim(sanitize( $gbl_fx, "sql", $db_sql));
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		
		if( isset($rec['valore']))
		{
			$fil = hex2bin($rec['valore']);
			$fil = json_decode( $fil, true);
			if( isset( $fil['filter']) && is_array( $fil['filter']))
				$gbl_session['filter'] = $fil['filter'];		
			if( isset( $fil['filter_type']) && is_array( $fil['filter_type']))
				$gbl_session['filter_type'] = $fil['filter_type'];
			if( isset( $fil['filter_up']) && is_array( $fil['filter_up']))
				$gbl_session['filter_up'] = $fil['filter_up'];
			if( isset( $fil['filter_custom']) && is_array( $fil['filter_custom']))
				$gbl_session['filter_custom'] = $fil['filter_custom'];
			if( isset( $fil['filter_wl']) && is_array( $fil['filter_wl']))
				$gbl_session['filter_wl'] = $fil['filter_wl'];
			if( isset( $fil['filter_bl']) && is_array( $fil['filter_bl']))
				$gbl_session['filter_bl'] = $fil['filter_bl'];
		}
		
		//1 BOLLA CONDIVISA
		
		
		$allFields = "";
		
		
		$options = "";
		
		$selected = isset( $gbl_session['filter_up']['field']) ? $gbl_session['filter_up']['field'] : "";
		
		foreach( $gbl_struct as $field )
		{
			$fieldName = isset( $field['nome'] ) ? $field['nome'] : "";
		
			if( $fieldName == "" )
				continue;
		
			if( $selected == "" ) // il primo a caso
				$selected = $fieldName;
		
			if( $fieldName == $selected )
				$options .= '<option value="' . $fieldName . '" selected>' . $fieldName . '</option>' . "\n";
			else
				$options .= '<option value="' . $fieldName . '">' . $fieldName . '</option>' . "\n";
		}
		
		
		
		
		
		$prevval = isset($gbl_session['filter_up']['max']) ? $gbl_session['filter_up']['max'] : 100000;
		$ord = isset($gbl_session['filter_up']['ord']) ? $gbl_session['filter_up']['ord'] : "DESC";
		
		if( $ord == "DESC" )
		{
			$ord = <<<EOT
				<option value="DESC" selected>DECRESCENTE</option>
				<option value="ASC">CRESCENTE</option>
			EOT;
		}
		else
		{
			$ord = <<<EOT
				<option value="DESC">DECRESCENTE</option>
				<option value="ASC" selected>CRESCENTE</option>
			EOT;
		}
		
		$allFields .= <<<EOT
								<div class="form-group" id="fgId__field_">
									<label class="col-md-3 control-label" for="id__field_">ORDINA PER:</label>
									<div class="col-md-7">
										<div class="row">
												<div class="col-sm-5">
													<select data-plugin-selectTwo name="_field_" class="form-control populate" id="t__field_">
														{$options}
													</select>
												</div>
												<div class="visible-xs mb-md"></div>
												<div class="col-sm-3">
													<select data-plugin-selectTwo name="_ord_" class="form-control populate" id="t__ord_">
														{$ord}
													</select>
												</div>
												<div class="col-sm-2" style="padding-top:5px;text-align:right;"">
													Max. righe:
												</div>
												<div class="col-sm-2">
													<input type="text" name="_max_" class="form-control" id="n__max_" value="{$prevval}">
												</div>
										</div>
									</div>
								</div>
		EOT;
		
		
		foreach( $gbl_struct as $field )
		{
			$fieldName = isset( $field['nome'] ) ? $field['nome'] : "";
		
			if( $fieldName == "" )
				continue;
		
			if( isset($gbl_session['info'][$fieldName][2]) && $gbl_session['info'][$fieldName][0] != "" )
				$field['tipo'] = $gbl_session['info'][$fieldName][2];
			else
				continue;
		
			$caption = isset($gbl_session['info'][$fieldName][0]) ? $gbl_session['info'][$fieldName][0] : "";
			$prevval = isset($gbl_session['filter'][$fieldName]) ? htmlentities($gbl_session['filter'][$fieldName]) : "";
			$filtype = isset($gbl_session['filter_type'][$fieldName]) ? htmlentities($gbl_session['filter_type'][$fieldName]) : "0";
			
			// per la revisione 3 feb 2022 -> gestione dei filtri per tipo sel1_ e ancillary.filterModifier
			$x_tip = isset($gbl_session['ancillary']['filterModifier'][$fieldName][0]) ? $gbl_session['ancillary']['filterModifier'][$fieldName][0] : $field['tipo'];
		
			if(
				( $x_tip == "tx_" ) || 
				( $x_tip == "mm_" ) ||
				( $x_tip == "em_" ) )
			{
				
				
				$options = "";
				
				//1 NON MODIFICARE: CONDIVISA DA SEL_ e SEL1_
				
				$opt = intval( $filtype );
				
				switch($opt)
				{
					case 0:
						$options = <<<EOT
							<option value="0" selected>contiene il testo:</option>
							<option value="1">è uguale a:</option>
						EOT;
						break;
					case 1:
						$options = <<<EOT
							<option value="0" >contiene il testo:</option>
							<option value="1" selected>è uguale a:</option>
						EOT;
						break;
					case -1:
						$options = <<<EOT
							<option value="0" >contiene il testo:</option>
							<option value="1" >è uguale a:</option>
						EOT;
						break;
					default:
						$options = <<<EOT
							<option value="0">contiene il testo:</option>
							<option value="1">è uguale a:</option>
						EOT;
						break;
				}
				
				//1 NON MODIFICARE: CONDIVISA DA SEL_ e SEL1_
				
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="row">
														<div class="col-sm-3">
															<select data-plugin-selectTwo name="_xyt_{$fieldName}" value="{$x_tip}" class="form-control populate" id="t_{$fieldName}">
																{$options}
															</select>
														</div>
														<div class="visible-xs mb-md"></div>
														<div class="col-sm-9">
															<input type="text" tipo="tx_" name="_xyn_{$fieldName}" class="form-control" id="n_{$fieldName}" value="{$prevval}">
														</div>
												</div>
											</div>
										</div>
				EOT;
				
				
				
			}
			elseif( $x_tip == "sel_" )
			{
				
				$filtype = 1; // forzato con il tipo sel_
				
				$options = "";
				
				//1 NON MODIFICARE: CONDIVISA DA SEL_ e SEL1_
				
				$opt = intval( $filtype );
				
				switch($opt)
				{
					case 0:
						$options = <<<EOT
							<option value="0" selected>contiene il testo:</option>
							<option value="1">è uguale a:</option>
						EOT;
						break;
					case 1:
						$options = <<<EOT
							<option value="0" >contiene il testo:</option>
							<option value="1" selected>è uguale a:</option>
						EOT;
						break;
					case -1:
						$options = <<<EOT
							<option value="0" >contiene il testo:</option>
							<option value="1" >è uguale a:</option>
						EOT;
						break;
					default:
						$options = <<<EOT
							<option value="0">contiene il testo:</option>
							<option value="1">è uguale a:</option>
						EOT;
						break;
				}
				
				//1 NON MODIFICARE: CONDIVISA DA SEL_ e SEL1_
				
				
				if( $prevval == -1 )
					$opzioni = '<option value="-1" selected>NESSUNA SELEZIONE</option>' . "\n";
				else
					$opzioni = '<option value="-1">NESSUNA SELEZIONE</option>' . "\n";
				
				
				$table = isset($gbl_session['info'][$fieldName]['tabella'][0]) ?  $gbl_session['info'][$fieldName]['tabella'][0] : $fieldName;
				$titolo = isset($gbl_session['info'][$fieldName]['titolo'][0]) ?  $gbl_session['info'][$fieldName]['titolo'][0] : "titolo";
				
				$table = sanitize( $table, "sql", $db_sql);
				$titolo = sanitize( $titolo, "sql", $db_sql);
				
				$rec = _dbGet("SELECT id,{$titolo} FROM {$table} ORDER BY {$titolo} ASC;");
				while( $rec != NULL )
				{
					if( !isset($rec[ $titolo]) || !isset($rec['id']))
						continue;
				
					if( $rec['id'] == $prevval )
						$opzioni .= '<option value="' . $rec['id'] . '" selected>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
					else
						$opzioni .= '<option value="' . $rec['id'] . '">' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				//		$opzioni .= '<option value="' . $rec['id'] . '"' . $disableAllTheRest . '>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				
					$rec = _dbGet();
				}
				
				
				
				
				
				
				
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="row">
														<div class="col-sm-3">
															<select data-plugin-selectTwo name="_xyt_{$fieldName}" class="form-control populate" id="t_{$fieldName}">
																{$options}
															</select>
														</div>
														<div class="visible-xs mb-md"></div>
														<div class="col-sm-9">
															<select data-plugin-selectTwo name="_xyn_{$fieldName}" class="form-control populate" id="n_{$fieldName}">
																{$opzioni}
															</select>
														</div>
												</div>
											</div>
										</div>
				EOT;
				
				
				
			}
			elseif( $x_tip == "sel1_" )
			{
				
				$prevval = explode(",", $prevval);
				
				$opzioni = "";
				
				
				$table = isset($gbl_session['info'][$fieldName]['tabella'][0]) ?  $gbl_session['info'][$fieldName]['tabella'][0] : $fieldName;
				$titolo = isset($gbl_session['info'][$fieldName]['titolo'][0]) ?  $gbl_session['info'][$fieldName]['titolo'][0] : "titolo";
				
				$table = sanitize( $table, "sql", $db_sql);
				$titolo = sanitize( $titolo, "sql", $db_sql);
				
				$rec = _dbGet("SELECT id,{$titolo} FROM {$table} ORDER BY {$titolo} ASC;");
				while( $rec != NULL )
				{
					if( !isset($rec[ $titolo]) || !isset($rec['id']))
						continue;
				
					if( is_array($prevval) && in_array($rec['id'],$prevval))
						$opzioni .= '<option value="' . $rec['id'] . '" selected>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
					else
						$opzioni .= '<option value="' . $rec['id'] . '">' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				//		$opzioni .= '<option value="' . $rec['id'] . '"' . $disableAllTheRest . '>' . htmlentities( $rec[$titolo] ) . '</option>' . "\n";
				
					$rec = _dbGet();
				}
				
				
				
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="row">
														<div class="col-sm-3">
															<select data-plugin-selectTwo name="_xyt_{$fieldName}" class="form-control populate" id="t_{$fieldName}">
																<option value="2" selected>Seleziona:</option>
															</select>
														</div>
														<div class="visible-xs mb-md"></div>
														<div class="col-sm-9">
															<select data-plugin-multiselect multiple="multiple" name="_xyn_{$fieldName}[]" class="scrollMultiple form-control populate" id="n_{$fieldName}">
																{$opzioni}
															</select>
														</div>
												</div>
											</div>
										</div>
				EOT;
				
				
				
			}
			elseif( 
				($x_tip == "dts_" ) ||
				($x_tip == "dtts_") )
			{
					
					// nel valore precedente ci sono le 2 date (inizio e fine) separate da una virgola
					$prevval = explode(",", $prevval);
				
					$dt_start = $prevval[0] ?? "";
					$dt_end = $prevval[1] ?? "";
				
					if( $dt_end == "" )
						$dt_end = $dt_start;
				
					$options = <<<EOT
							<option value="99" selected>nel periodo:</option>
					EOT;
				
				
					$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="row">
														<div class="col-sm-3">
															<select data-plugin-selectTwo name="_xyt_{$fieldName}" value="{$x_tip}" class="form-control populate" id="t_{$fieldName}">
																{$options}
															</select>
														</div>
														<div class="visible-xs mb-md"></div>
														<div class="col-sm-9">
															<div class="input-daterange input-group" data-date-language="it" data-date-autoclose="true" data-date-format="dd-mm-yyyy" data-plugin-datepicker>
																<span class="input-group-addon">
																	<i class="fa fa-calendar"></i>
																</span>
																<input id="n_s_{$fieldName}" type="text" tipo="dts_" class="form-control" name="_xyn_s_{$fieldName}" value="{$dt_start}">
																<span class="input-group-addon">a</span>
																<input id="n_e_{$fieldName}" type="text" class="form-control" name="_xyn_e_{$fieldName}" value="{$dt_end}">
															</div>
														</div>
												</div>
											</div>
										</div>
				
					EOT;
				
				
			}
		
		}
		
		
		
		
		$buttonCancelCaption = "ANNULLA";
		$buttonSaveCaption	= "FILTRA";
		$buttonSaveHelp 	= "Premi FILTRA per selezionare solo i record che soddisfano le condizioni indicate";
		$buttonSaveType	= "btn-warning";
		
		$pulsanti = <<<EOT
		
					<div class="form-group">
						<label class="col-md-3 control-label" for="id_saveButton"></label>
						<div class="col-md-6">
							<button id="id_saveButton" style="text-shadow:none;" type="submit" class="saveAllButton btn {$buttonSaveType}"><i class="fa fa-save"></i> {$buttonSaveCaption}</button>
		///					<a style="text-shadow:none;" class="close-all mb-xs mt-xs mr-xs btn btn-default" href="{{==backAddress=}}" role="button"><i class="fa fa-times"></i> {$buttonCancelCaption}</a>
							<button type="button" style="text-shadow:none;margin-left:6px;" class="close-all mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-times"></i> {$buttonCancelCaption}</button>
							<a style="text-shadow:none;" class="mb-xs mt-xs mr-xs btn btn-default" href="index.php?fx=cmdRemoveFilter" role="button"><i class="fa fa-trashr"></i> RIMUOVI FILTRI</a>
							<span id="saveAllHelpId" class="help-block">{$buttonSaveHelp}</span>
						</div>
					</div>
		
		EOT;
		
		
		$what = <<<EOT
		
		<!-- start: page -->
			<div class="row">
				<div class="col-lg-12">
					<section class="panel">
						<header class="panel-heading">
							<div class="panel-actions">
								<a href="#" class="fa fa-caret-down"></a>
								<a href="#" class="close-all fa fa-times"></a>
							</div>
			
							<h2 class="panel-title">{{=title=}}</h2>
						</header>
						<div class="panel-body">
							<form class="form-horizontal form-bordered" id="form" action="index.php?fx=cmdSaveFilter" method="post">
		
								{$allFields}
		
								{$pulsanti}
		
							</form>
						</div>
					</section>
				</div>
			</div>
		EOT;
		
		
		
		return $what;
		
		
		]>
	init
		<[
		/// INIZIALIZZO LE VARIABILI GLOBALI
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
			/// ------------------------------------------------------------------------------
			/// SOVRASCRIVO I DATI PASSATI DALLA EDIT STANDARD PER PERSONALIZZARE LE FUNZIONI
			/// INTERNE. INFO SPECIFICA DELLA FUNZIONE SOVRASCRIVE I DATI GLOBALI DI SESSIONE
			/// ------------------------------------------------------------------------------
			if( isset($_t['info']) && is_array( $_t['info']))
			{
				$aS = $_t['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			if( isset($_t['details']) && is_array( $_t['details']))
			{
				$aS = $_t['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
			if( isset($_t['ancillary']) && is_array( $_t['ancillary']))
			{
				$aS = $_t['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			if( isset($_t['subpages']) && is_array( $_t['subpages']))
			{
				$aS = $_t['subpages'];
				foreach( $aS as $info=>$data )
					$gbl_session['subpages'][$info] = $data;
			}
		
			$chiave = "add";
			if( <!--isEdit--> )
				$chiave = "edit";
		
			// OVERWRITING INFO ELEMENTS SPECIFIC FOR EDIT
			// INFO
			if( isset( $gbl_session['subpages'][$chiave]['info'] ) && is_array( $gbl_session['subpages'][$chiave]['info'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			/// ANCILLARY (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['ancillary'] ) && is_array( $gbl_session['subpages'][$chiave]['ancillary'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			/// DETAILS (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['details'] ) && is_array( $gbl_session['subpages'][$chiave]['details'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
		
		// -----------------------------------------------------------------------
		// CARICO TUTTI I FILTRI PER QUESTA PAGINA
		// -----------------------------------------------------------------------
		$gbl_session['filter'] = array();
		$gbl_session['filter_type'] = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='filters' AND pagina='$gbl_masterFunction' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{	
			// -----------------------------------------------------------------------
			// CONVERSIONE IN VARIABILE
			// -----------------------------------------------------------------------
			$filters = hex2bin( $rec['valore'] );
			$filters = json_decode( $filters, true );
			if( $filters != NULL )
			{
				if( isset( $filters['filter']) && is_array( $filters['filter']))
					$gbl_session['filter'] = $filters['filter'];
				if( isset( $filters['filter_type']) && is_array( $filters['filter_type']))
					$gbl_session['filter_type'] = $filters['filter_type'];
				if( isset( $filters['filter_up']) && is_array( $filters['filter_up']))
					$gbl_session['filter_up'] = $filters['filter_up'];
			}
		}
		
		
		]>
	ADDITIONAL CSS BARE FRAME
		<[
		
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-multiselect/bootstrap-multiselect.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-tagsinput/bootstrap-tagsinput.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-timepicker/css/bootstrap-timepicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/basic.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/dropzone.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-markdown/css/bootstrap-markdown.min.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote-bs3.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/lib/codemirror.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/theme/monokai.css" />
				<!-- Specific Page Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<!-- Specific Page Vendor -->
		<script src="<!--relativeDirectory-->/vendor/ios7-switch/ios7-switch.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-validation/jquery.validate.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/forms/examples.validation.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-autosize/jquery.autosize.js"></script>
		<script src="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
		<!--bootstrap datepicker locale-->
		<script src="<!--relativeDirectory-->/javascripts/bootstrap-datepicker.it.min.js"></script>

		
		<script>
		
			(function () {
		
				$(".close-all").on( 'click', function( e ) { 
					window.location.href='{{=backAddress=}}';
					return false;
				});
		
			})();
		
			$( document ).ready(function() {
		
				$(document).on('keyup', function (e)
				{
		
					if(e.key === "Escape")
					{
						if( !waitToExit ) 
							window.location.href='{{=backAddress=}}';
						return false;
					}
				});
			
				$(".multiselect-container.dropdown-menu").css("overflow", "auto");
				$(".multiselect-container.dropdown-menu").css("max-height", "300px");
		
		///		$('.scrollMultiple').multiselect({
		///		  maxHeight: 100
		///		});
		
		///		$('.modal').on('mousedown mouseup click', '.multiselect-container', function(e) {
		///		  e.preventDefault();
		///		});
		
			});
		
		</script>
		
		]>
	title
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			//2 WIP WIP WIP WIP WIP WIP WIP WIP WIP WIP
///			_[GET TABLE NAME OR STACK PAGE NAME] condiviso, attento (se lo recuperi)
			return 'Filtri applicati alla tabella: <span style="font-weight:550;">' . $gbl_tableName . "</span>";
		]>


cmdSaveFilter

	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		

		if( !isset( $_REQUEST) || !is_array( $_REQUEST))
		{
			echo "unexpected data received: 0x9983.89";
			exit();		
		}	

		$filtro = array();
		$filtro['filter'] = array();
		$filtro['filter_type'] = array();

		foreach($_REQUEST as $nome=>$valore)
		{
			if( startsWith( $nome, "_xyn_s_" ))
			{
				$nome = str_replace("_xyn_s_", "", $nome);
				if( isset($filtro['filter'][$nome]) && $filtro['filter'][$nome] != "" )
					$filtro['filter'][$nome] = $valore . "," . $filtro['filter'][$nome];
				else
					$filtro['filter'][$nome] = $valore;
			}

			if( startsWith( $nome, "_xyn_e_" ))
			{
				$nome = str_replace("_xyn_e_", "", $nome);
				if( isset($filtro['filter'][$nome]) && $filtro['filter'][$nome] != "" )
					$filtro['filter'][$nome] .= "," . $valore;
				else
					$filtro['filter'][$nome] = $valore;
			}

			if( startsWith( $nome, "_xyn_" ))
			{
				$nome = str_replace("_xyn_", "", $nome);
				if( !is_array( $valore))
					$filtro['filter'][$nome] = $valore;
				else
					$filtro['filter'][$nome] = implode(",", $valore);
			}

			if( startsWith( $nome, "_xyt_" ))
			{
				$nome = str_replace("_xyt_", "", $nome);
				$filtro['filter_type'][$nome] = $valore;
			}

			if(	$nome == "_field_" )
				$filtro['filter_up']['field'] = $valore;

			if(	$nome == "_ord_" )
				$filtro['filter_up']['ord'] = $valore;

			if( $nome == "_max_" )
				$filtro['filter_up']['max'] = $valore;
		}
		// -------------------------------------------------------------------
		// PREPARO I DATI DA SALVARE NEL PARAMETRO "FILTERS"
		// -------------------------------------------------------------------
		$filtro = json_encode( $filtro );
		$filtro = bin2hex( $filtro );

		$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		$res = 0;
		if( $rec == NULL )
		{
			$rec['nome'] = "filters";
			$rec['tb_sessione'] = $gbl_idSessione;
			$rec['tb_utente'] = $gbl_userId;
			$rec['pagina'] = $paginaMaster;
			$rec['valore'] = $filtro;
			$res = db_sql_insert_2("tb_parametro", $rec);
		}
		else
		{
			$rec['valore'] = $filtro;
			$res = db_sql_update_2("tb_parametro", $rec, "id", $rec['id']);
		}

		
		//1 CONDIVISA DA cmdRemoveFilter, cmdSaveFilter
		
		$back = "#";
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			$back = "index.php?fx=" . $rec['valore'] . $query . $father;
		
		//1 CONDIVISA DA cmdRemoveFilter, cmdSaveFilter
		
		

		header("Location: {$back}");
		exit();
		]>

	permessi
		USER


frmExportRecord

	di tipo
		frameMain
	permessi
		USER
	isEdit
		false
	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>
	backAddress
		<[
		
		//0 CONDIVISO TRA EXPORT E FILTER
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			return "index.php?fx=" . $rec['valore'] . $query . $father;
		
		
		return "#";
		
		//0 CONDIVISO TRA EXPORT E FILTER
		
		]>
	innerWrapperStyle
///		per la tabella dei messaggi, è più carina con il bianco
		style=""
	getOctopusMainContent
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// preparo i parametri f e q se presenti, da aggiungere eventualmente a pagine interne (per export al momento)
		$getFandQ = "";
		if( isset($_REQUEST['f']))
			$getFandQ = "&f=" . $_REQUEST['f'];
		if( isset($_REQUEST['q']))
			$getFandQ .= "&q=" . $_REQUEST['q'];
		
		$allFields = "";
		
		foreach( $gbl_struct as $field )
		{
			$fieldName = isset( $field['nome'] ) ? $field['nome'] : "";
		
			if( $fieldName == "" )
				continue;
		
			if( isset($gbl_session['info'][$fieldName][2]) && $gbl_session['info'][$fieldName][0] != "" )
				$field['tipo'] = $gbl_session['info'][$fieldName][2];
			else
				continue;
		
			$caption = isset($gbl_session['info'][$fieldName][0]) ? $gbl_session['info'][$fieldName][0] : "";
		
			if(
				( $field['tipo'] == "tx_" ) || 
				( $field['tipo'] == "mm_" ) ||
				( $field['tipo'] == "ck_" ) ||
				( $field['tipo'] == "dts_" ) ||
				( $field['tipo'] == "dtts_" ) ||
				( $field['tipo'] == "sel_" ) ||
				( $field['tipo'] == "em_" ) )
			{
				
				
				
				$allFields .= <<<EOT
										<div class="form-group" id="fgId_{$fieldName}">
											<label class="col-md-3 control-label" for="id_{$fieldName}">{$caption}</label>
											<div class="col-md-7">
												<div class="row">
														<div class="visible-xs mb-md"></div>
														<div class="col-sm-9">
															<input style="width:20px; height:20px;" type="checkbox" name="{$fieldName}" id="id_{$fieldName}" checked>
														</div>
												</div>
											</div>
										</div>
				EOT;
				
				
				
			}
		
		}
		
		
		
		
		$pulsanti = <<<EOT
		
								<div class="form-group" id="fgId_{$fieldName}">
									<label style="color:green;" class="col-md-3 control-label" for="id_yesnoheader">Includi prima riga di intestazione (nomi dei campi)</label>
									<div class="col-md-7">
										<div class="row">
		///										<div class="visible-xs mb-md"></div>
												<div class="col-sm-9">
													<input style="width:20px; height:20px;" type="checkbox" name="_yesnoheader_" id="id_yesnoheader_" checked>
												</div>
										</div>
									</div>
								</div>
		
		
					<div class="form-group">
						<label class="col-md-3 control-label" for="id_saveButton"></label>
						<div class="col-md-6">
									<button id="id_saveButton" style="text-shadow:none;" type="submit" class="saveAllButton btn btn-success"><i class="fa fa-save"></i> ESPORTA</button>
		///					<a style="text-shadow:none;" class="close-all mb-xs mt-xs mr-xs btn btn-default" href="{{==backAddress=}}" role="button"><i class="fa fa-times"></i> {$buttonCancelCaption}</a>
									<button type="button" style="text-shadow:none;margin-left:6px;" class="close-all mb-xs mt-xs mr-xs btn btn-default"><i class="fa fa-times"></i> ANNULLA</button>
		///					<a style="text-shadow:none;" class="mb-xs mt-xs mr-xs btn btn-default" href="index.php?fx=cmdRemoveFilter" role="button"><i class="fa fa-trashr"></i> RIMUOVI FILTRI</a>
									<span id="saveAllHelpId" class="help-block">Premi ESPORTA per esportare la tabella</span>
						</div>
					</div>
		
		EOT;
		
		
		$what = <<<EOT
		
		<!-- start: page -->
			<div class="row">
				<div class="col-lg-12">
					<section class="panel">
						<header class="panel-heading">
							<div class="panel-actions">
								<a href="#" class="fa fa-caret-down"></a>
								<a href="#" class="close-all fa fa-times"></a>
							</div>
			
							<h2 class="panel-title">{{=title=}}</h2>
						</header>
						<div class="panel-body">
							<form class="form-horizontal form-bordered" id="form" action="index.php?fx=cmdSaveExport{$getFandQ}" method="post">
		
								{$allFields}
		
								{$pulsanti}
		
							</form>
						</div>
					</section>
				</div>
			</div>
		EOT;
		
		
		
		
		return $what;
		
		
		]>
	init
		<[
		/// INIZIALIZZO LE VARIABILI GLOBALI
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
			/// ------------------------------------------------------------------------------
			/// SOVRASCRIVO I DATI PASSATI DALLA EDIT STANDARD PER PERSONALIZZARE LE FUNZIONI
			/// INTERNE. INFO SPECIFICA DELLA FUNZIONE SOVRASCRIVE I DATI GLOBALI DI SESSIONE
			/// ------------------------------------------------------------------------------
			if( isset($_t['info']) && is_array( $_t['info']))
			{
				$aS = $_t['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			if( isset($_t['details']) && is_array( $_t['details']))
			{
				$aS = $_t['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
			if( isset($_t['ancillary']) && is_array( $_t['ancillary']))
			{
				$aS = $_t['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			if( isset($_t['subpages']) && is_array( $_t['subpages']))
			{
				$aS = $_t['subpages'];
				foreach( $aS as $info=>$data )
					$gbl_session['subpages'][$info] = $data;
			}
		
			$chiave = "add";
			if( <!--isEdit--> )
				$chiave = "edit";
		
			// OVERWRITING INFO ELEMENTS SPECIFIC FOR EDIT
			// INFO
			if( isset( $gbl_session['subpages'][$chiave]['info'] ) && is_array( $gbl_session['subpages'][$chiave]['info'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['info'];
				foreach( $aS as $info=>$data )
					$gbl_session['info'][$info] = $data;
			}
			/// ANCILLARY (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['ancillary'] ) && is_array( $gbl_session['subpages'][$chiave]['ancillary'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['ancillary'];
				foreach( $aS as $info=>$data )
					$gbl_session['ancillary'][$info] = $data;
			}
			/// DETAILS (UNUSED FTTB)
			if( isset( $gbl_session['subpages'][$chiave]['details'] ) && is_array( $gbl_session['subpages'][$chiave]['details'] ))
			{
				$aS = $gbl_session['subpages'][$chiave]['details'];
				foreach( $aS as $info=>$data )
					$gbl_session['details'][$info] = $data;
			}
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		//0 CONDIVISA TRA FILTER ED EXPORT
		
///		_[FILTER: RICARICO I DATI DEI FILTRI ATTUALI]
		]>
	ADDITIONAL CSS BARE FRAME
		<[
		
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-multiselect/bootstrap-multiselect.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-tagsinput/bootstrap-tagsinput.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-timepicker/css/bootstrap-timepicker.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/basic.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/dropzone/css/dropzone.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-markdown/css/bootstrap-markdown.min.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/summernote/summernote-bs3.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/lib/codemirror.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/codemirror/theme/monokai.css" />
				<!-- Specific Page Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
		
		]>
	javascriptInizializzazioneSpecifica
		<[
		<!-- Specific Page Vendor -->
		<script src="<!--relativeDirectory-->/vendor/ios7-switch/ios7-switch.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-validation/jquery.validate.js"></script>
		<script src="<!--relativeDirectory-->/javascripts/forms/examples.validation.js"></script>
		<script src="<!--relativeDirectory-->/vendor/jquery-autosize/jquery.autosize.js"></script>
		<script src="<!--relativeDirectory-->/vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
		
		<script>
		
			(function () {
		
				$(".close-all").on( 'click', function( e ) { 
					window.location.href='{{=backAddress=}}';
					return false;
				});
		
			})();
		
			$( document ).ready(function() {
		
		
				$(document).on('keyup', function (e)
				{
		
					if(e.key === "Escape")
					{
						if( !waitToExit ) 
							window.location.href='{{=backAddress=}}';
						return false;
					}
				});
			});
		
		</script>
		
		]>
	title
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			//2 WIP WIP WIP WIP WIP WIP WIP WIP WIP WIP
///			_[GET TABLE NAME OR STACK PAGE NAME] condiviso, attento (se lo recuperi)
			return 'EXPORT: <span style="font-weight:550;">' . $gbl_tableName . "</span>";
		]>


cmdSaveExport

//1 PER WINDOWS IN ITALIA IL SEPARATORE DI DEFAULT, PER UN FILE CHE SI CHIAMA COMMA SEPARATED, E' IL PUNTO E VIRGOLA 
	separatore
		";"
	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		
		$gbl_tableName = "{{=getTableName=}}";
		if( !isset( $_REQUEST) || !is_array( $_REQUEST))
		{
			echo "unexpected data received: 0x9983.89";
			exit();		
		}	
		// -------------------------------------------------------------------
		// _REQUEST CONTIENE UN ELENCO DI CAMPI. SOLO I CAMPI SELEZIONATI
		// E I CAMPI SELEZIONATI CONTENGONO "ON" -> NOMI CAMPI DB
		// -------------------------------------------------------------------
		// RICARICO I FILTRI
		
		
		$fil = array();
		$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		
		if( isset($rec['valore']))
		{
			$fil = hex2bin($rec['valore']);
			$fil = json_decode( $fil, true);
			if( isset( $fil['filter']) && is_array( $fil['filter']))
				$gbl_session['filter'] = $fil['filter'];		
			if( isset( $fil['filter_type']) && is_array( $fil['filter_type']))
				$gbl_session['filter_type'] = $fil['filter_type'];
			if( isset( $fil['filter_up']) && is_array( $fil['filter_up']))
				$gbl_session['filter_up'] = $fil['filter_up'];
			if( isset( $fil['filter_custom']) && is_array( $fil['filter_custom']))
				$gbl_session['filter_custom'] = $fil['filter_custom'];
			if( isset( $fil['filter_wl']) && is_array( $fil['filter_wl']))
				$gbl_session['filter_wl'] = $fil['filter_wl'];
			if( isset( $fil['filter_bl']) && is_array( $fil['filter_bl']))
				$gbl_session['filter_bl'] = $fil['filter_bl'];
		}
		
		///		_[FILTERS: RICARICO DI DATI DA TB_PARAMETRO]
		
		
		// controllo del parametro Q, DA FARE SUCCESSIVAMENTE.
		$gbl_query = "";
		
		$gbl_query = "";
		
		$requested = isset( $gbl_session['ancillary']['queryRequested'][0]) ? $gbl_session['ancillary']['queryRequested'][0] : false;
		
		if( $requested )
		{
			// ---------------------------
			// RECUPERO LA QUERY
			if( !isset($_REQUEST['q']))
				return "Parameter invalid. Report: 0x9913.98 q";
		
			$query = hex2bin( $_REQUEST['q'] );
			$key = "AZ$9099" . $gbl_idSessione . $gbl_userId;
			$query = _decrypta( $query, $key );
		
			if( $query == "***" )
				return "Parameter invalid. Report: 0x9913.99";
		
			$gbl_query = $query; 
		}
		
			
		
		// -------------------------------------------------------------------
		// COMPILO LA LISTA DEI CAMPI
		$listaCampi = "";
		$includiHeader = false;
		//1 CONDIVISO, NON MODIFICARE
		
		foreach( $_POST as $field=>$valore)
		{
		//	if( $field == "fx" || $field=="f" || $field=="q" )
		//		continue;
		
			if( $field == "_yesnoheader_" )
			{
				$includiHeader = true;
				continue;
			}		
			if( $listaCampi == "" )
				$listaCampi .= $field;
			else
				$listaCampi .= "," . $field;
		}
		
		
		
		//  -------------------------------------------------------------------
		//1 ESEGUO LA QUERY CON I FILTRI COMPLETI (COME TB EDIT, INCLUSO Q)
		$filters = "";
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		if(	isset( $gbl_session['filter']) && is_array( $gbl_session['filter']) &&
			isset( $gbl_session['filter_type']) && is_array( $gbl_session['filter_type']) )
		{
			foreach( $gbl_session['filter'] as $nn=>$vv )
			{
				$nn = sanitize($nn, "sql", $db_sql);
				$vv = sanitize($vv, "sql", $db_sql);
				$mode = isset( $gbl_session['filter_type'][ $nn ] ) ? $gbl_session['filter_type'][ $nn ] : 1;
		
				if( $vv == "" )
					continue;
		
				if( $vv == "-1" )
					continue;
		
				if( $filters != "" )
					$filters .= " AND ";
		
				switch( $mode )
				{
					case 1:
						$filters .= " LOWER({$nn})=LOWER('{$vv}') ";
						$gbl_anyFilterOn = true;
						break;
					case 2:
						$allElements = explode(",", $vv);
						if( is_array( $allElements))
						{
							$filters .= " (";
							$first = true;
							foreach( $allElements as $single )
							{
								if( $first )
								{
									$filters .= " LOWER({$nn})=LOWER('{$single}') ";
									$first = false;
								}
								else
									$filters .= " OR LOWER({$nn})=LOWER('{$single}') ";
							}
							$filters .= ") ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 99:
						// Vediamo se è un filtro data (potrebbe essere doppio con la virgola, con o senza ora)
						$isDataora = false;
						
							// vediamo se c'è inizio e fine
							$_ar = explode( ",", $vv );
						
							$iii = $_ar[0] ?? "";
							$fff = $_ar[1] ?? "";
						
							if( DateTime::createFromFormat('d-m-Y H:i:s', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data-ora di inizio
								if( DateTime::createFromFormat('d-m-Y H:i:s', $fff) !== false)
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data-ora di fine pure
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d H:i:s', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d H:i:s', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$isDataora = true;
							}
							elseif( DateTime::createFromFormat('d-m-Y', $iii) !== false)
							{
								$buf = explode('-', $iii);
								$iii = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
								/// abbiamo una data di inizio
								if( DateTime::createFromFormat('d-m-Y', $fff) !== false)	
								{
									$buf = explode('-', $fff);
									$fff = $buf[2].'/'.$buf[1].'/'.$buf[0]; /// la sistemo per la strtotime
									/// abbiamo una data di fine pure
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = date('Y-m-d', strtotime($fff)); // CONVERTO DA UMANO A MYSQL
								}
								else
								{
									/// non abbiamo la data di fine, ma assumiamo sia uguale alla data di start
									/// quindi sto cercando un dato molto specifico, preciso al secondo.
									$dt_start = date('Y-m-d', strtotime($iii)); // CONVERTO DA UMANO A MYSQL
									$dt_end = $dt_start;
								}
								$dt_start .= " 00:00:00";
								$dt_end .= " 23:59:59";
								$isDataora = true;
							}
						
						//
						if( $isDataora )
						{
							$filters .= " (LOWER({$nn}) >= '{$dt_start}' AND LOWER({$nn}) <= '{$dt_end}') ";
							$gbl_anyFilterOn = true;
						}
						break;
					case 0:
					default:
						$filters .= " LOWER({$nn}) LIKE LOWER('%{$vv}%') ";
						$gbl_anyFilterOn = true;
						break;
				}
			}
		}
		
		// --------------------------------------------------------------------------------------------
		// se questo campo è NULL, non ci sono restrizioni, se è "" significa che nessun
		// elemento può essere visualizzato
		$forcedWhiteList = false;
		$restrictedList = array();
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		
		$forcedWhiteListQuery = "";
		if( isset($_t['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $_t['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( isset($gbl_session['ancillary']['forced white list query'][0]))
		{
			$forcedWhiteListQuery = $gbl_session['ancillary']['forced white list query'][0];
			$forcedWhiteList = true;
		}
		
		if( $forcedWhiteListQuery != "" )
		{
		///	$forcedWhiteListQuery = addslashes( $forcedWhiteListQuery );
			$forcedWhiteListQuery = str_replace('$gbl_userId', $gbl_userId, $forcedWhiteListQuery);
			$xxx = _dbGet($forcedWhiteListQuery);
			while( isset($xxx['id']))
			{
				$restrictedList[$xxx['id']] = true;
				$xxx = _dbGet();
			}
		}
		
		//1 CONDIVISA DA TBEDIT CMDSAVEEXPORT 
		// --------------------------------------------------------------------------------------------
		
		$hiddenFilter = "";
		if( isset($_t['ancillary']['hidden filter'][0]))
			$hiddenFilter = $_t['ancillary']['hidden filter'][0];
		
		if( isset($gbl_session['ancillary']['hidden filter'][0]))
			$hiddenFilter = $gbl_session['ancillary']['hidden filter'][0];
		
		if( $hiddenFilter != "" )
		{
			if( $filters != "" )
				$filters .= " AND ";
		
			$filters .= " " . $hiddenFilter . " ";
		}
		
		if( $filters != "" )
		{
			if( $gbl_query == "" )
				$filters = " WHERE " . $filters;
			else
				$filters = " AND " . $filters;
		}
		
		// anticipo sessione ----------------------
		if(	isset( $gbl_session['filter_wl'] ) && 
			is_array( $gbl_session['filter_wl']) &&
			count( $gbl_session['filter_wl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		
		if(	isset( $gbl_session['filter_bl'] ) && 
			is_array( $gbl_session['filter_bl']) &&
			count( $gbl_session['filter_bl'] ))
		{
			$gbl_anyFilterOn = true;
		}
		// <------------------- sessione anticipata
		
		if(	isset( $gbl_session['filter_up']['field']) &&
			isset( $gbl_session['filter_up']['ord']) &&
			isset( $gbl_session['filter_up']['max']) )
		{
			$field = sanitize( $gbl_session['filter_up']['field'], "sql", $db_sql );
			$ord   = sanitize( $gbl_session['filter_up']['ord'], "sql", $db_sql );
			$max   = sanitize( $gbl_session['filter_up']['max'], "sql", $db_sql );
		
			// 3 giugno 2022 non metto il max, se ho già una query impostata 
			if( !$gbl_anyFilterOn )
				$filters .= " ORDER BY {$field} {$ord} LIMIT {$max}";
			else
				$filters .= " ORDER BY {$field} {$ord} ";
		
			$gbl_anyFilterOn = true;
		}
		else /// aggiunto 3 giugno 2022
		{
			$max = isset( $_t['ancillary']['forced max rows'][0] ) ? $_t['ancillary']['forced max rows'][0] : 0;
			if( $max == 0 )
				$max = isset( $gbl_session['ancillary']['forced max rows'][0] ) ? $gbl_session['ancillary']['forced max rows'][0] : 0;
		
			if( !$gbl_anyFilterOn && $max )
			{
				$filters .= " LIMIT {$max} ";
				$gbl_anyFilterOn = true;
			}
		}
		
		//0 CONDIVISA CON TBEDIT E CMDSAVEEXPORT
		
		
		
		
		// -------------------------------------------------------------------
		// FUNZIONE EXPORT CSV SU STRINGA: function query_to_csv($db_conn, $query, $filename, $attachment = false, $headers = true) => video || => file
		
		   function query_to_csv($db_conn, $query, $filename, $forcedWhiteList, $restrictedList, $attachment = false, $headers = true) 
			{
				
				global $gbl_tableName;
				global $gbl_masterFunction;
				global $gbl_userId;
				global $gbl_struct; // info da database (real_type real_lenght)
				global $gbl_fx;
				global $gbl_session; // tb_parametro
				global $db_sql; // link database standard
				// -------------------------------------------
				// raccolta dati utente
				// -------------------------------------------
				global $gbl_url;
				global $db_sql_name;
				global $gbl_nomeTipo;
				global $gbl_infoMenu;
				global $gbl_idSessione;
				global $gbl_nomeCampoTitolo;
				global $db_sql_user;
				global $db_sql_password;
				global $db_sql_host;
				global $gbl_userData;
				global $gbl_query;
				global $gbl_stack;
				global $gbl_father;
				global $gbl_anyFilterOn;
				global $gbl_unicode;
				global $gbl_myFullUrl;
				global $gbl_mainDomain;
				global $gbl_subDomain;
				// ------------------------------
				// 0=devId; 1=validity in seconds
				// Array:
				global $gbl_xsm;
				global $gbl_changePasswordDisabled;
				
				if($attachment) 
				{
					// send response headers to the browser
					header( 'Content-Type: text/csv' );
					header( 'Content-Disposition: attachment;filename='.$filename);
					$fp = fopen('php://output', 'w');
				} 
				else 
				{
					$fp = fopen($filename, 'w');
				}
		
				$result = mysqli_query($db_conn, $query ) or die( mysqli_error( $db_conn ) );
		       
				if($headers) 
				{
					// output header row (if at least one row exists)
					$row = mysqli_fetch_assoc($result);
					if($row) 
					{
						// EXPORT: CONVERTO I TITOLI
						$titoli = array();
						foreach($row as $titolo=>$cosa)
							$titoli[] = isset( $gbl_session['info'][$titolo][0] ) ? $gbl_session['info'][$titolo][0] : $titolo;
						// --------------------------
						fputcsv($fp, $titoli,<!--separatore-->);
						// reset pointer back to beginning
						mysqli_data_seek($result, 0);
					}
				}
		
				// $support[ $nomeTabella ][id] = "ilNomeCompleto"
				$support = array();
				//0 I NOMI DI SUPPORTO LI METTO NEL NOME DEL CAMPO E NON NEL NOME DELLA TABELLA STESSA
				//0 QUESTO PER EVITARE IL PROBLEMA DELLA SOVRAPPOSIZIONE DI CAMPI CHE FANNO RIFERIMENTO
				//0 ALLA MEDESIMA TABELLA MA FACENDO RIFERIMENTO A CAMPI DIFFERENTI (caso tb_s_comune)
				
				$db = new dbClass( $db_sql_host, $db_sql_name, $db_sql_user, $db_sql_password );
				
				foreach( $gbl_struct as $nome=>$valore )
				{
					$tipo = isset( $gbl_session['info'][$nome][2] ) ? $gbl_session['info'][$nome][2] : "ukn_";
					$nomeTabella = isset( $gbl_session['info'][$nome]['tabella'][0] ) ? $gbl_session['info'][$nome]['tabella'][0] : $nome;
					$nomeTitolo1 = isset( $gbl_session['info'][$nome]['titolo'][0] ) ? $gbl_session['info'][$nome]['titolo'][0] : "titolo";
					$nomeTitolo2 = isset( $gbl_session['info'][$nome]['titolo'][1] ) ? $gbl_session['info'][$nome]['titolo'][1] : "";
					$nomeTitolo3 = isset( $gbl_session['info'][$nome]['titolo'][2] ) ? $gbl_session['info'][$nome]['titolo'][2] : "";
					$nomeTitolo4 = isset( $gbl_session['info'][$nome]['titolo'][3] ) ? $gbl_session['info'][$nome]['titolo'][3] : "";
				
					$campi = "id," . $nomeTitolo1;
					if( $nomeTitolo2 != "" ) $campi .= ",".$nomeTitolo2;
					if( $nomeTitolo3 != "" ) $campi .= ",".$nomeTitolo3;
					if( $nomeTitolo4 != "" ) $campi .= ",".$nomeTitolo4;
				
					if( $tipo == "sel_" )
					{
						$r = $db->get("SELECT {$campi} FROM {$nomeTabella};");
						while( $r != NULL )
						{
							// verifico se è richiesto più di un campo di testo (come nel caso di nome/cognome)
							$a = isset( $r[$nomeTitolo2] ) ? " " . $r[$nomeTitolo2] : "";
							$b = isset( $r[$nomeTitolo3] ) ? " " . $r[$nomeTitolo3] : "";
							$c = isset( $r[$nomeTitolo4] ) ? " " . $r[$nomeTitolo4] : "";
							$support[ $nome][ $r['id']] = $r[$nomeTitolo1] . $a . $b . $c;
							$r = $db->get();
						}
					}
				}
				
				
				
				
				while($row = mysqli_fetch_assoc($result)) 
				{
					
						// -----------------------------------------------------------
						// FILTRO FORCED WHITE LIST
						// se c'è una lista bianca obbligatoria e non fa parte della 
						// lista bianca: continue!
						if( $forcedWhiteList && !isset( $restrictedList[ $row['id']] ))
						{
							continue;
						}
					
					
					
					
					
						// -----------------------------------------------------------
						// FILTRO WHITE LIST
						if( isset( $gbl_session['filter_wl']) && is_array( $gbl_session['filter_wl']) && count( $gbl_session['filter_wl']))
						{
							if( !in_array( $row['id'], $gbl_session['filter_wl'] ))
								continue;
						}
						// -----------------------------------------------------------
						// FILTRO BLACK LIST
						if( isset( $gbl_session['filter_bl']) && is_array( $gbl_session['filter_bl']) && count( $gbl_session['filter_bl']))
						{
							if( in_array( $row['id'], $gbl_session['filter_bl'] ))
								continue;
						}
					
					
					$prev = $row;
					
					foreach($prev as $field=>$value)
					{
						$tipo = isset( $gbl_session['info'][$field][2] ) ? $gbl_session['info'][$field][2] : "ukn_";
					///	$nomeTabella = isset( $gbl_session['info'][$field]['tabella'][0] ) ? $gbl_session['info'][$field]['tabella'][0] : $field;
					
						if( $tipo == "ck_" )
						{
							// CARICO I NOMI DI DEFAULT
							$nomeVero = isset( $gbl_session['info'][$field]['TRUE'][0] ) ? $gbl_session['info'][$field]['TRUE'][0] : "TRUE";
							$nomeFalso = isset( $gbl_session['info'][$field]['FALSE'][0] ) ? $gbl_session['info'][$field]['FALSE'][0] : "FALSE";
							// -----------------------------------------------------------------------------------------------------
							if( is_int($value) && $value == 1 )
								$value = "true";
							if( is_int($value) && $value == 0 )
								$value = "false";
							$value = strtolower( $value );
							if( $value == "true" || $value == "ok" || $value == "yes" || $value == "sì" || $value == "si" || $value == "vero" )
								$value = $nomeVero;
							else
								$value = $nomeFalso;
					
							$row[ $field] = $value;
						}
					
						if( $tipo == "sel_" )
						{
							//0 IL SUPPORTO VIENE MESSO NEL NOME DEL CAMPO E NON NEL NOME DELLA TABELLA, PER EVITARE SOVRAPPOSIZIONI (caso tb_s_comune)
							if( isset( $support[ $field][ $value]))
								$row[ $field] = $support[ $field][ $value];
							else
								$row[ $field] = "";
						}
					
						if( $tipo == "dts_" ) // data stringa
						{
							if( $value != "" )
							{
								$dt = strtotime( $value );
								$row[ $field] = date( "d/m/Y", $dt );
							}
							else
								$row[ $field] = "";
						}
					
						if( $tipo == "dtts_" ) // data + time stringa
						{
							if( $value != "" )
							{
								$dt = strtotime( $value );
								$row[ $field] = date( "d/m/Y G:i:s", $dt );
							}
							else
								$row[ $field] = "";
						}
					
						//0 AGGIUNGERE ALTRE GESTIONI
					}
					
					
					fputcsv($fp, $row, <!--separatore-->);
				}
		       
				fclose($fp);
			}
		
		$export_file_name = $gbl_session['ancillary']['export file name'][0] ?? $gbl_tableName;

		query_to_csv( $db_sql, "SELECT id,$listaCampi FROM $gbl_tableName $gbl_query $filters;", $export_file_name . ".csv", $forcedWhiteList, $restrictedList, true, $includiHeader);
/*
		// SE SI TOGLIE QUESTO COMMENTO, SALVA IN AUTOMATICO ED ESCE DALLA PAGINA TORNANDO ALLA PAGINA PRINCIPALE
		_[CERCO L'INDIRIZZO DELLA PAGINA PRINCIPALE DALLO STACK]

		header("Location: {$back}");
		exit(); 
*/

		]>

	permessi
		USER

	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>


frmEditRecord
	di tipo
		frmAddRecord
	isEdit
		true
	ancillary
		buttonSave: "Salva", "", btn-primary
		buttonCancel: "Annulla"
	title
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			$nomeUtente = "";
			
				// ---------------------------
				// RECUPERO L'ID DELL'ELEMENTO
				if( !isset($_REQUEST['e']))
				{
					header("Location: index.php?fx=$gbl_masterFunction&i=9999");
					exit();
				}
				$element = hex2bin( $_REQUEST['e'] );
				$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
				$element = intval(_decrypta( $element, $key ));
				// ---------------------------
				$dat = _dbGet("SELECT $gbl_nomeCampoTitolo FROM $gbl_tableName WHERE id='$element';");
			
				if( $dat == NULL || !is_array( $dat))
				{
					header("Location: index.php?fx=$gbl_masterFunction&i=9998");
					exit();
				}
			
				$nomeUtente = isset($dat[$gbl_nomeCampoTitolo])?$dat[$gbl_nomeCampoTitolo]:"";
			
			return 'Modifica elemento: <span style="font-weight:550;">' . htmlentities($nomeUtente) . "</span>";
		]>


ajaxSaveTempValue
	_do
		<[
	
	global $gbl_tableName;
	global $gbl_masterFunction;
	global $gbl_userId;
	global $gbl_struct; // info da database (real_type real_lenght)
	global $gbl_fx;
	global $gbl_session; // tb_parametro
	global $db_sql; // link database standard
	// -------------------------------------------
	// raccolta dati utente
	// -------------------------------------------
	global $gbl_url;
	global $db_sql_name;
	global $gbl_nomeTipo;
	global $gbl_infoMenu;
	global $gbl_idSessione;
	global $gbl_nomeCampoTitolo;
	global $db_sql_user;
	global $db_sql_password;
	global $db_sql_host;
	global $gbl_userData;
	global $gbl_query;
	global $gbl_stack;
	global $gbl_father;
	global $gbl_anyFilterOn;
	global $gbl_unicode;
	global $gbl_myFullUrl;
	global $gbl_mainDomain;
	global $gbl_subDomain;
	// ------------------------------
	// 0=devId; 1=validity in seconds
	// Array:
	global $gbl_xsm;
	global $gbl_changePasswordDisabled;
	
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
	if( isset( $rec['valore']))
		$gbl_masterFunction = $rec['valore'];
	
	
			$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( isset($rec['valore']) && $rec['valore'] != "" )
				$gbl_tableName = $rec['valore'];
	
	///		return "table name:" . $gbl_tableName;
	
	
	
	$gbl_session = array();
	
	$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
	
	//2 omnia.info
	//2 omnia.ancillary
	//2 omnia.details
	//2 omnia.subpages
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
	while( $rec != NULL )
	{
		if( $rec['nome'] == "omnia.info" )
			$gbl_session['info'] = json_decode( $rec['valore'], true);
		if( $rec['nome'] == "omnia.ancillary" )
			$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
		if( $rec['nome'] == "omnia.details" )
			$gbl_session['details'] = json_decode( $rec['valore'], true);
		if( $rec['nome'] == "omnia.subpages" )
			$gbl_session['subpages'] = json_decode( $rec['valore'], true);
	
		$rec = _dbGet();
	}
	
	$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
	
	
	// TIPO i_ e TIPO anx_ -> uploadFile
	
	if( !isset( $_REQUEST['nome']))
		{echo "Errore sconosciuto 1"; return;}
	
	if( !isset( $_REQUEST['valore']))
		{echo "Errore sconosciuto 2"; return;}
	
	if( !isset( $_REQUEST['tipo'])) 
		{echo "Errore sconosciuto 3"; return;}
	
	// PER GESTIRE CORRETTAMENTE LA DUPLICAZIONE DELL'INDIRIZZO EMAIL (NEL CASO)
	$idElemento = 0;
	if( isset( $_REQUEST['id'] ) )
	{
		$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
		$element  = _decrypta(hex2bin( $_REQUEST['id'] ), $key );
		$element = intval( $element );
	}
	
	$tipo = base64_decode( $_REQUEST['tipo'] );
	$nome = base64_decode( $_REQUEST['nome'] );
	$valore = base64_decode( $_REQUEST['valore'] );
	
	$nome = trim(sanitize( $nome,"sql",$db_sql));
	$valore = trim(sanitize( $valore,"sql",$db_sql));
	$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='value:{$nome}' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
	$res = 0;
	if( $rec == NULL )
	{
		$rec['nome'] = "value:{$nome}";
		$rec['tb_sessione'] = $gbl_idSessione;
		$rec['tb_utente'] = $gbl_userId;
		$rec['pagina'] = $paginaMaster;
		
		//2 nuovo campo ------------------------------------------------------------------------------
		$warningString = $gbl_session['info'][$nome]["info"][0] ?? "Il valore del campo non è valido";
		//2 ------------------------------------------------------------------------------------------
		$denyDuplication = isset($gbl_session['info'][$nome]["deny duplication"][0]) ? $gbl_session['info'][$nome]["deny duplication"][0] : false;
		$len = isset($gbl_session['info'][$nome][5]) ? $gbl_session['info'][$nome][5] : 0;
		$ereg = isset($gbl_session['info'][$nome]["ereg"][0]) ? $gbl_session['info'][$nome]["ereg"][0] : "";
		$isOptional = isset($gbl_session['info'][$nome]["is optional"][0]) ? $gbl_session['info'][$nome]["is optional"][0] : false;
		
		if( $len ) // se abbiamo specificato una lunghezza minima
		{
			if( strlen( $valore) < $len ) // se la lunghezza è inferiore a quanto stabilito 
			{
				if( !$isOptional || $valore != "" ) // se la stringa è presente oppure non è opzionale 
				{
					echo "Il campo deve essere lungo almeno {$len} caratteri"; 
					return;
				}
			}
		}
		
		// -------------------------------------
		// il controllo ereg lo facciamo sempre,
		// se è presente is optional e il campo 
		// valore è vuoto, si salta il check
		if( $ereg != "" )
		{
			if( ! ($isOptional && $valore == "")) // se la stringa è presente oppure non è opzionale 
			{
				try
				{
					if( !@preg_match($ereg, $valore))
					{
						echo $warningString;
						if( !startsWith($warningString,"W:"))
							return;
					}
				} catch ( Exception $e )
				{
					echo "Invalid ereg comparison string (0x4533.7)"; 
					return;
				}
			}
		}
		// -------------------------------------
		
		switch($tipo)
		{
		//0 CALCOLIAMO HASH SOLO AL SALVATAGGIO
		//	case "psw_":
		//		$rec['valore'] = hash("sha256", $valore);
		//		break;
			case "em_":
				// se non è opzionale (len email richiesta > 1). Se è opzionale, ed è campo vuoto, non faccio il check.
				if( $valore != "" && !validEmail($valore) )
				{
					echo "Indirizzo email non valido";
					return;			
				}
				if( $denyDuplication )
				{
					$cr = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
					if( isset($cr['valore']) && $cr['valore'] != "" )
					{
						$gbl_tableName = $cr['valore'];
						// SE ESISTE UN ELEMENTO EMAIL DUPLICATO
						if( _dbGet( "SELECT id FROM $gbl_tableName WHERE {$nome}='{$valore}' AND id <> '$element';") != NULL)
						{
							echo "Indirizzo email duplicato";
							return;			
						}
					}
				}
				$rec['valore'] = $valore;
				break;
			case "dt_":
			case "dtt_":
				// SOLO NEL CASO DI VARIABILE INTERO IN DB
				// DEVE ESSERE DICHIARATA NULL
				if( $valore == "" )
					$rec['valore'] = NULL;
				else
					$rec['valore'] = $valore;
				break;
			case "dts_":
			case "dtts_":
			case "psw_":
			case "tx_":
			case "mm_":
			case "nn_":
			case "i_":
			case "anx_":
			default:
				$rec['valore'] = $valore;
				break;
		}
		
		
		
		
		$res = db_sql_insert_2( "tb_parametro", $rec);
	}
	else
	{
		
		//2 nuovo campo ------------------------------------------------------------------------------
		$warningString = $gbl_session['info'][$nome]["info"][0] ?? "Il valore del campo non è valido";
		//2 ------------------------------------------------------------------------------------------
		$denyDuplication = isset($gbl_session['info'][$nome]["deny duplication"][0]) ? $gbl_session['info'][$nome]["deny duplication"][0] : false;
		$len = isset($gbl_session['info'][$nome][5]) ? $gbl_session['info'][$nome][5] : 0;
		$ereg = isset($gbl_session['info'][$nome]["ereg"][0]) ? $gbl_session['info'][$nome]["ereg"][0] : "";
		$isOptional = isset($gbl_session['info'][$nome]["is optional"][0]) ? $gbl_session['info'][$nome]["is optional"][0] : false;
		
		if( $len ) // se abbiamo specificato una lunghezza minima
		{
			if( strlen( $valore) < $len ) // se la lunghezza è inferiore a quanto stabilito 
			{
				if( !$isOptional || $valore != "" ) // se la stringa è presente oppure non è opzionale 
				{
					echo "Il campo deve essere lungo almeno {$len} caratteri"; 
					return;
				}
			}
		}
		
		// -------------------------------------
		// il controllo ereg lo facciamo sempre,
		// se è presente is optional e il campo 
		// valore è vuoto, si salta il check
		if( $ereg != "" )
		{
			if( ! ($isOptional && $valore == "")) // se la stringa è presente oppure non è opzionale 
			{
				try
				{
					if( !@preg_match($ereg, $valore))
					{
						echo $warningString;
						if( !startsWith($warningString,"W:"))
							return;
					}
				} catch ( Exception $e )
				{
					echo "Invalid ereg comparison string (0x4533.7)"; 
					return;
				}
			}
		}
		// -------------------------------------
		
		switch($tipo)
		{
		//0 CALCOLIAMO HASH SOLO AL SALVATAGGIO
		//	case "psw_":
		//		$rec['valore'] = hash("sha256", $valore);
		//		break;
			case "em_":
				// se non è opzionale (len email richiesta > 1). Se è opzionale, ed è campo vuoto, non faccio il check.
				if( $valore != "" && !validEmail($valore) )
				{
					echo "Indirizzo email non valido";
					return;			
				}
				if( $denyDuplication )
				{
					$cr = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
					if( isset($cr['valore']) && $cr['valore'] != "" )
					{
						$gbl_tableName = $cr['valore'];
						// SE ESISTE UN ELEMENTO EMAIL DUPLICATO
						if( _dbGet( "SELECT id FROM $gbl_tableName WHERE {$nome}='{$valore}' AND id <> '$element';") != NULL)
						{
							echo "Indirizzo email duplicato";
							return;			
						}
					}
				}
				$rec['valore'] = $valore;
				break;
			case "dt_":
			case "dtt_":
				// SOLO NEL CASO DI VARIABILE INTERO IN DB
				// DEVE ESSERE DICHIARATA NULL
				if( $valore == "" )
					$rec['valore'] = NULL;
				else
					$rec['valore'] = $valore;
				break;
			case "dts_":
			case "dtts_":
			case "psw_":
			case "tx_":
			case "mm_":
			case "nn_":
			case "i_":
			case "anx_":
			default:
				$rec['valore'] = $valore;
				break;
		}
		
		
		
		
		$res = db_sql_update_2("tb_parametro", $rec, "id", $rec['id']);
	}
	
	if( $res < 0 )
		echo "Errore 0x77674:{$res}, prego informare l'admin: admin@awgp.it";
	
	return; 
	
	
	//	_[AGGIUNGI DB RECORD]
	//	_[MODIFICA DB RECORD]
	
	
	
	
	// ---------------------------------
		]>
	permessi
		USER


ajaxSetFieldToNull
	_do
		<[
	
	global $gbl_tableName;
	global $gbl_masterFunction;
	global $gbl_userId;
	global $gbl_struct; // info da database (real_type real_lenght)
	global $gbl_fx;
	global $gbl_session; // tb_parametro
	global $db_sql; // link database standard
	// -------------------------------------------
	// raccolta dati utente
	// -------------------------------------------
	global $gbl_url;
	global $db_sql_name;
	global $gbl_nomeTipo;
	global $gbl_infoMenu;
	global $gbl_idSessione;
	global $gbl_nomeCampoTitolo;
	global $db_sql_user;
	global $db_sql_password;
	global $db_sql_host;
	global $gbl_userData;
	global $gbl_query;
	global $gbl_stack;
	global $gbl_father;
	global $gbl_anyFilterOn;
	global $gbl_unicode;
	global $gbl_myFullUrl;
	global $gbl_mainDomain;
	global $gbl_subDomain;
	// ------------------------------
	// 0=devId; 1=validity in seconds
	// Array:
	global $gbl_xsm;
	global $gbl_changePasswordDisabled;
	
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
	if( isset( $rec['valore']))
		$gbl_masterFunction = $rec['valore'];
	
	
	if( !isset( $_REQUEST['nome']))
		{echo "Errore sconosciuto 1"; return;}
	
	$nome = base64_decode( $_REQUEST['nome'] );
	$nome = trim(sanitize( $nome,"sql",$db_sql));
	$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='value:{$nome}' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
	$res = 0;
	if( $rec == NULL )
	{
		$rec['nome'] = "value:{$nome}";
		$rec['tb_sessione'] = $gbl_idSessione;
		$rec['tb_utente'] = $gbl_userId;
		$rec['pagina'] = $paginaMaster;
		$rec['valore'] = NULL;
		$res = db_sql_insert_2( "tb_parametro", $rec);
	}
	else
	{
		$rec['valore'] = NULL;
		$res = db_sql_update_2("tb_parametro", $rec, "id", $rec['id']);
	}
	
	if( $res < 0 )
		echo "Errore 0x77674:{$res}, prego informare l'admin: admin@awgp.it";
	
	return; 
	
	
	
	
	// ---------------------------------
		]>
	permessi
		USER


cmdDeleteRow
	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					$gbl_tableName = $rec['valore'];
		
		///		return "table name:" . $gbl_tableName;
		
		
		
			if( !isset( $_REQUEST['nome']))
				{echo "Errore sconosciuto 1"; return;}
		
			if( !isset( $_REQUEST['valore']))
				{echo "Errore sconosciuto 2"; return;}
		
		///	if( !isset( $_REQUEST['tipo']))
		///		{echo "Errore sconosciuto 3"; return;}
		
			$nome = base64_decode( $_REQUEST['nome'] ); // NOME TABELLA
			$valore = base64_decode( $_REQUEST['valore'] ); 
			$element = hex2bin( $valore ); // ID CRIPTATO DELL'ELEMENTO
		
		///	$tipo = base64_decode( $_REQUEST['tipo'] ); /// UNUSED
		/// $nome = json_decode( $nome, true ); /// se è una struttura usiamo la stringify e la decode /// NON USATO
		
			$nome = trim(sanitize( $nome,"sql",$db_sql));
		///	$valore = trim(sanitize( $valore,"sql",$db_sql)); /// NON SERVE
		
		///	$tipo = trim(sanitize( $tipo,"sql",$db_sql)); /// UNUSED
		
			$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
			$element = intval(_decrypta( $element, $key ));
			// ---------------------------
			
				$lst = _dbGet("SHOW TABLES FROM $db_sql_name;");
				$all = array();
				while( isset($lst['Tables_in_' . $db_sql_name]))
				{
					$all[] = $lst['Tables_in_' . $db_sql_name];
					$lst = _dbGet();
				}
			
				foreach( $all as $table )
				{
					try
					{
						if( _dbGet("SELECT id FROM {$table} WHERE $gbl_tableName='$element';") != NULL )
						{
							// L'ELEMENTO CHE VOGLIAMO CANCELLARE E' REFERENZIATO 
							return "L'elemento non è stato eliminato perché la tabella {$table} contiene un suo riferimento.";
						}
					}
					catch (Exception $e)
					{
						// no problem		
					}
				}
			
			// ---------------------------
			// ---------------------------
			
				try
				{
					$valore_x = _dbGet("SELECT valore FROM tb_x_cose WHERE nome LIKE '%readonly:%$gbl_tableName';")['valore'];
					if( $valore_x != NULL && $valore_x != "" )
					{
						$arrei = explode(",",$valore_x);
						if( is_array( $arrei))
						{
							$arrei = array_map('trim', $arrei);
							if( in_array( $element, $arrei))
								return "L'elemento non è stato eliminato perché è dichiarato 'read only' da root";
						}
						// L'ELEMENTO CHE VOGLIAMO CANCELLARE E' DICHIARATO IN SOLA LETTURA
					}
				}
				catch (Exception $e)
				{
					// no problem		
				}
			
			
			// ---------------------------
			if( dbQuery("DELETE FROM $gbl_tableName WHERE id='$element';") > 0)
				{return;}
		
			echo "Nessun elemento eliminato";
			return;
		
		
		
		
		
		]>
	permessi
		USER


cmdAddNewRecord
	getTableName
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					return $rec['valore'];
		
		
		
		
		
		]>
	getElement
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset($rec['valore']) && $rec['valore'] != "" )
					$gbl_tableName = $rec['valore'];
		
		///		return "table name:" . $gbl_tableName;
		
		
		
			// ---------------------------
			// RECUPERO L'ID DELL'ELEMENTO
			if( !isset($_REQUEST['nome']))
				return "";
		
			$element = hex2bin( $_REQUEST['nome'] );
			$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
			$element = intval(_decrypta( $element, $key ));
		
			return $element;
		
		
		
		]>
	isEdit
		false
	_do
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$gbl_struct = array(); // array con dati completi della struttura della tabella
		$gbl_tableName = "{{=getTableName=}}";
		
		// ----------------------------------------------
		// ACQUISISCO LA STRUTTURA DELLA TABELLA
		// ----------------------------------------------
		$q = dbQueryResult("DESCRIBE $gbl_tableName;");
		
		if( is_a($q,"mysqli_result"))
		{
			while($rec = mysqli_fetch_array($q)) 
			{
				// -------------------------------------------
				// COMPILO LA NUOVA STRUTTURA $gbl_struct
				// -------------------------------------------
				$str = array();
				/// NOME
				$str['nome'] = trim($rec[0]);
				/// -----------------
				/// LEN->funzione del tipo oppure della lunghezza dichiarata, in bytes
				/// oppure la length è la lunghezza dei caratteri che possono stare
				
				//1 -------------------------------------------------------------------
				//1 NOTA1: LA LUNGHEZZA È IL NUMERO MASSIMO DI CARATTERI (4 BYTES)
				//1 OPPURE IL NUMERO MASSIMO DI BYTES PER I BLOB E QUINDI NON GUARDA
				//1 IL TIPO INDICATO DAL PREFISSO MA COME E' STATO DICHIARATO
				//1 EFFETTIVAMENTE NEL DATABASE
				//2 NOTA2: PER I TIPI INTERO AL MOMENTO NON MI INTERESSA LA LUNGHEZZA
				/// -------------------------------------------------------------------
				/// RECORD DA DESCRIBE DB
				/// -------------------------------------------------------------------
				/// $rec[0] - nome campo
				/// $rec[1] - tipo con lunghezza tra parentesi
				/// $rec[2] - null (true/false)
				/// $rec[3] - Key, PRI/niente
				/// $rec[4] - default value
				/// $rec[5] - Extra tipo auto_increment/niente
				$len = -1;
				$dbType = "undefined";
				$chunk = explode("(", $rec[1], 2);
				/// -------------------------------------------------------------------
				/// SETTIAMO IL TIPO DA DATABASE
				/// -------------------------------------------------------------------
				if( isset( $chunk[0]))
					$dbType = trim( $chunk[0]);
				/// -------------------------------------------------------------------
				/// SETTIAMO LA LUNGHEZZA
				/// -------------------------------------------------------------------
				if( count( $chunk) >= 2 )
				{
					$chunk = explode(")", $chunk[1]);
					if( isset( $chunk[0]))
						$len = $chunk[0];
				}
				/// -------------------------------------------------------------------
				/// TIPI SUPPORTATI DAL SISTEMA PER LA GESTIONE DELLA LUNGHEZZA MAX
				/// -------------------------------------------------------------------
				/// longblob, mediumblob
				/// mediumtext,longtext
				/// bigint -> leggo la lunghezza
				/// int -> leggo la lunghezza
				/// char, varchar, sono gli unici per i quali occorre controllare la lunghezza
				/// per i tipi blob, mediumtext e longtext, il calcolo è forzoso
				/// -------------------------------------------------------------------
				/// LA LUNGHEZZA VIENE CONSIDERATA PER I TIPI STRINGA (VIENE DIVISA PER 4)
				/// PER I TIPI INTERO NON VIENE CONSIDERATA (-1)
				/// PER I TIPI BLOB, PER VERIFICARE CHE SIA POSSIBILE SALVARE L'OGGETTO
				/// NEL DATABASE
				/// -------------------------------------------------------------------
				if(	$dbType == "char" || $dbType == "varchar" )
				{
					if( $len > 0 )
						$str['len'] = intval($len / 4);
				}
				
				if(	$dbType == "int" || $dbType == "bigint")
				{
					if( $len > 0 )
						$str['len'] = $len;
				}
				
				if(	$dbType == "text" )
					$str['len'] = 16380; // 65535/4 circa
				
				if(	$dbType == "mediumtext" )
					$str['len'] = 4194300; // 16777215/4 circa
				
				if(	$dbType == "longtext" )
					$str['len'] = 1073741820; // 4294967295/4 circa
				
				if(	$dbType == "mediumblob" )
					$str['len'] = 16777215;
				
				if(	$dbType == "longblob" )
					$str['len'] = 4294967295;
				
				/// -----------------
				/// ASSEGNO IL RECORD
				//0 - TEMP
				$str['real_type'] = $dbType;
				//0 - TEMP
				$gbl_struct[$str['nome']] = $str;
				/// -----------------
			}
		}
		else
		{
			echo "Table [$gbl_tableName] not found in database [$db_sql_name] or error in describing table";
			exit();
		}
		
		// CONDIVISA: cmdExportRecord
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		
		
		
		$gbl_session = array();
		
		$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
		
		//2 omnia.info
		//2 omnia.ancillary
		//2 omnia.details
		//2 omnia.subpages
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'omnia.%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
		while( $rec != NULL )
		{
			if( $rec['nome'] == "omnia.info" )
				$gbl_session['info'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.ancillary" )
				$gbl_session['ancillary'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.details" )
				$gbl_session['details'] = json_decode( $rec['valore'], true);
			if( $rec['nome'] == "omnia.subpages" )
				$gbl_session['subpages'] = json_decode( $rec['valore'], true);
		
			$rec = _dbGet();
		}
		
		$gbl_nomeCampoTitolo = isset($gbl_session['ancillary']['dbTitle'][0]) ? $gbl_session['ancillary']['dbTitle'][0]: "";
		
		
		
		$all = array();
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome LIKE 'value:%' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='$gbl_masterFunction';");
		while($rec!=NULL)
		{
			$all[] = $rec;
			$rec = _dbGet();
		}
		
		$rec = array();
		foreach( $all as $one )
		{
			$n = trim(str_replace("value:", "", $one['nome']));
			$v = sanitize(str_replace("value:", "", $one['valore']), "sql", $db_sql);
			$t = isset($gbl_session['info'][$n][2]) ? $gbl_session['info'][$n][2] : "nn_";
			
			
			switch($t)
			{
				case "psw_":
					$rec[$n] = hash("sha256", $v);
					break;
				case "sel_":
					$rec[$n] = intval($v);
					break;
				case "dt_":
					$valore = str_replace("/","-",$v);
					$rec[$n] = intval(strtotime($valore));
					break;		
				case "dts_":
				case "dtts_":
					if( $v != "" )
					{
						$valore = str_replace("/","-",$v);
						$valore = intval(strtotime($valore));
						$rec[$n] = date("Y-m-d H:i:s", $valore);
					}
					else
						$rec[$n] = "";
					break;		
				case "tx_":
				case "mm_":
				case "ck_":
				default:
					$rec[$n] = $v;
				break;
			}
			
			
			
		}
		
		if( <!--isEdit--> )
		{
			$retval = db_sql_update_2($gbl_tableName, $rec, "id", "{{=getElement=}}");
		}
		else
			$retval = db_sql_insert_2($gbl_tableName, $rec);
		
		if( $retval < 0 )
		{
			echo "insert/update error:" . mysqli_errno($db_sql);
			file_put_contents("./temp/temp.log", "\nError:" . mysqli_errno($db_sql) . ": " . mysqli_error($db_sql));
			return;
		}
		
		if( ! <!--isEdit--> )
		/// VEDIAMO SE ABBIAMO QUALCOSA DA ESEGUIRE DOPO AVER AGGIUNTO UN RECORD
		/// PER USARE IL LAST INSERT ID, DEVO CHIAMARLA PRIMA DI CANCELLARE I VALORI!!!
		{
			if( isset( $gbl_session['ancillary']['after new element'][0]))
				eval($gbl_session['ancillary']['after new element'][0]);
		}
		
		/// CANCELLO SOLO SE IL SALVATAGGIO E' ANDATO A BUON FINE
		
		// ------------------------------------------------
		// LE VARIABILI TEMPORANEE IN CUI SALVO I VALORI
		// MODIFICATI O DA SALVARE VENGONO CANCELLATE
		// DALLA TBEDIT, IN OGNI CASO, PER SICUREZZA
		// ELIMINO (SOLO) LE VARIABILI TEMPORANEE IN MODO
		// DA EVITARE REFUSI CON IL PASSAGGIO IMMEDIATO
		// (ANCHE SE POCO PROBABILE) DA UNA PAGINA
		// EDIT AD UNA INSERT O VICEVERSA SENZA
		// PASSARE DA TBEDIT
		// ------------------------------------------------
		dbQuery("DELETE FROM tb_parametro WHERE nome LIKE 'value:%' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='$gbl_masterFunction';");
		
		
		
		
		echo 0;
		return;
		
		
		
		
		]>
	permessi
		USER


cmdModifyRecord
	di tipo
		cmdAddNewRecord
	isEdit
		true
	permessi
		USER


uploadFile
	_exe
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		
		$fileName = $_FILES['file']['name'];
		$fileType = $_FILES['file']['type'];
		$fileError = $_FILES['file']['error'];
		$fileContent = file_get_contents($_FILES['file']['tmp_name']);
		
		if($fileError == UPLOAD_ERR_OK){
		   //Processes your file here
		}else{
		   switch($fileError){
		     case UPLOAD_ERR_INI_SIZE:   
		          $message = 'Superato limite impostato';
		          break;
		     case UPLOAD_ERR_FORM_SIZE:  
		          $message = 'Superato limite impostato';
		          break;
		     case UPLOAD_ERR_PARTIAL:    
		          $message = 'Trasferimento parziale';
		          break;
		     case UPLOAD_ERR_NO_FILE:    
		          $message = 'Nessun file selezionato';
		          break;
		     case UPLOAD_ERR_NO_TMP_DIR: 
		          $message = 'Errore nel direttorio temporaneo';
		          break;
		     case UPLOAD_ERR_CANT_WRITE: 
		          $message= 'Errore di scrittura: permessi?';
		          break;
		     case  UPLOAD_ERR_EXTENSION: 
		          $message = 'Errore upload extension';
		          break;
		     default: $message = 'Errore: caricamento non completato';
		              break;
		    }
		      echo json_encode(array(
		               'error' => true,
		               'message' => $message
		            ));
				return "";
		}
		
		
		
		$nome = base64_decode( $_REQUEST['nome'] );
		$tipo = base64_decode( $_REQUEST['tipo'] );
		
		// COMPRESSIONE DEI FILES
		$valore = gzencode($fileContent,9);
		$valore = base64_encode($valore);
		
		// -----------------------------------------------------------------------------------------------
		//3 TEORICAMENTE VALIDO PER TUTTI GLI ELEMENTI BLOB (?)
		//  I FILE BLOB (DI QUALSIASI TIPO) VENGONO SALVATI CON UN RECORD JSON COME SEGUE:
		//  $BLOB['NOMEFILE'] = NOME DEL FILE;
		//  $BLOB['DATIFILE'] = DATI DEL FILE ZIPPATI E BASE64ATI;
		//  $BLOB['TIPOFILE'] = TIPO DI FILE SALVATO (TIPO DO0), NON DOVREBBE SERVIRE ES: I_ ANX_
		// -----------------------------------------------------------------------------------------------
		$json = array();
		$json['nomefile'] = $fileName;
		$json['datafile'] = $valore;
		$json['tipofile'] = $tipo;
		$json = json_encode( $json );
		$json = sanitize( $json, "sql", $db_sql);
		// -----------------------------------------------------------------------------------------------
		$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='value:{$nome}' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
		$res = 0;
		if( $rec == NULL )
		{
			$rec['nome'] = "value:{$nome}";
			$rec['tb_sessione'] = $gbl_idSessione;
			$rec['tb_utente'] = $gbl_userId;
			$rec['pagina'] = $paginaMaster;
			$rec['valore'] = $json;
			$res = db_sql_insert_2( "tb_parametro", $rec);
		}
		else
		{
			$rec['valore'] = $json;
			$res = db_sql_update_2("tb_parametro", $rec, "id", $rec['id']);
		}
		
		$len = strlen($valore);
		
		if( $res < 0 )
			echo "Errore 0x776.74:{$res}, prego informare l'admin: admin@awgp.it ({$nome}{$paginaMaster}{$len})";
		
		return; 
		
		//	_[AGGIUNGI DB RECORD]
		//	_[MODIFICA DB RECORD]
		
		
		
		
		
		
		]>
	permessi
		USER


cmdRemoveFilter

	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset( $rec['valore']))
			$gbl_masterFunction = $rec['valore'];
		
		// -----------------------------------------------------------------------
		// CARICO TUTTO LO STACK, NON METTO I MIEI DATI; SONO UNA SOTTO FUNZIONE
		// -----------------------------------------------------------------------
		$gbl_stack = array();
		$rec = _dbGet("SELECT id,valore FROM tb_parametro WHERE nome='stack' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		if( isset($rec['valore']) && $rec['valore'] != "" && $rec['valore'] != NULL )
		{
			$idStack = $rec['id'];
			$stack = $rec['valore'];
		}
		// -----------------------------------------------------------------------
		// CONVERSIONE IN VARIABILE
		// -----------------------------------------------------------------------
		$stack = hex2bin( $stack );
		$stack = json_decode( $stack, true );
		if( $stack != NULL )
		{
			$num = count( $stack);
			if( is_array($stack) && $num > 0)
			{
				foreach( $stack as $s )
				{
					if( $s['pagina'] == $gbl_fx )
						break;
					$gbl_stack[] = $s;
				}
			}
		}
		
		// PRENDO L'ULTIMO ELEMENTO
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			$gbl_father = $current['father'];
		}
		// --------------------------------------------------------
		// DECRITTO FATHER
		$gbl_father = hex2bin( $gbl_father);
		$gbl_father = _decrypta($gbl_father, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		
		if( $gbl_father == "***" )
			$gbl_father = "";
		
		

		$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
		dbQuery("DELETE FROM tb_parametro WHERE nome='filters' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");

		
		//1 CONDIVISA DA cmdRemoveFilter, cmdSaveFilter
		
		$back = "#";
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			$back = "index.php?fx=" . $rec['valore'] . $query . $father;
		
		//1 CONDIVISA DA cmdRemoveFilter, cmdSaveFilter
		
		

		header("Location: {$back}");
		exit();
		]>

	permessi
		USER




/// -----------------------------------------
/// TABELLA PRINCIPALE:
/// SALVO I PARAMETRI DI PERSISTENZA
/// -----------------------------------------
ajaxSavePersValue
	_do
		<[
	
	global $gbl_tableName;
	global $gbl_masterFunction;
	global $gbl_userId;
	global $gbl_struct; // info da database (real_type real_lenght)
	global $gbl_fx;
	global $gbl_session; // tb_parametro
	global $db_sql; // link database standard
	// -------------------------------------------
	// raccolta dati utente
	// -------------------------------------------
	global $gbl_url;
	global $db_sql_name;
	global $gbl_nomeTipo;
	global $gbl_infoMenu;
	global $gbl_idSessione;
	global $gbl_nomeCampoTitolo;
	global $db_sql_user;
	global $db_sql_password;
	global $db_sql_host;
	global $gbl_userData;
	global $gbl_query;
	global $gbl_stack;
	global $gbl_father;
	global $gbl_anyFilterOn;
	global $gbl_unicode;
	global $gbl_myFullUrl;
	global $gbl_mainDomain;
	global $gbl_subDomain;
	// ------------------------------
	// 0=devId; 1=validity in seconds
	// Array:
	global $gbl_xsm;
	global $gbl_changePasswordDisabled;
	
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
	if( isset( $rec['valore']))
		$gbl_masterFunction = $rec['valore'];
	
	
	if( !isset( $_REQUEST['nome']))
		{echo "Errore sconosciuto 1"; return;}
	
	if( !isset( $_REQUEST['valore']))
		{echo "Errore sconosciuto 2"; return;}
	
	if( !isset( $_REQUEST['tipo']))
		{echo "Errore sconosciuto 3"; return;}
	
	$tipo = base64_decode( $_REQUEST['tipo'] );
	$nome = base64_decode( $_REQUEST['nome'] );
	/// $nome = json_decode( $nome, true ); /// se è una struttura usiamo la stringify e la decode
	$valore = base64_decode( $_REQUEST['valore'] );
	/// $valore = json_decode( $valore, true ); /// se è una struttura usiamo la stringify e la decode
	
	$nome = trim(sanitize( $nome,"sql",$db_sql));
	$valore = trim(sanitize( $valore,"sql",$db_sql));
	$paginaMaster = trim(sanitize( $gbl_masterFunction, "sql", $db_sql));
	/// $nome = json_decode( $what, true ); /// se è una struttura usiamo la stringify e la decode
	
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='{$nome}' AND tb_sessione='$gbl_idSessione' AND tb_utente='$gbl_userId' AND pagina='{$paginaMaster}';");
	$res = 0;
	if( $rec == NULL )
	{
		$rec['nome'] = "{$nome}";
		$rec['tb_sessione'] = $gbl_idSessione;
		$rec['tb_utente'] = $gbl_userId;
		$rec['pagina'] = $paginaMaster;
		$rec['valore'] = $valore;
		$res = db_sql_insert_2( "tb_parametro", $rec);
	}
	else
	{
		$rec['valore'] = $valore;
		$res = db_sql_update_2("tb_parametro", $rec, "id", $rec['id']);
	}
	
	if( $res < 0 )
		echo "Errore 0x17674:{$res}, prego informare l'admin: admin@awgp.it";
	
	return; 
	
	
	
		]>
	permessi
		USER

///0 ------------------------------------

fxMessaggi

	di tipo
		tbEdit
	getQueryRequested
		return "false";
	resetStack
		true
	getTableName
		return "tb_messaggio";
	info
//		nome campo: [0]Caption, [1]Testo Aiuto, [2]Tipo Campo (tx_, mm_, tb_, i_, tm_, dt_, dts_, dtt_, dtts_, anx_, nn_, opt_, psw_), [3]readonly (readonly or "" or other), [4]frontpage (or "" or other)
//					, [5]minChars(0=anyLenght), [6]fa fa-user->icona a fianco testo, [7]masked oppure unmasked, [8]subtype ( any, text, integer, float, currency, date) per ordine in tabella
//					, [9]initialize with f parameter value (true/false)
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		tb_tipoMessaggio: Tipo messaggio, "Tipo di messaggio da inviare", sel_, no_readonly, frontpage, 1, fa fa-list, unmasked, text, false
			titolo: nome
		titolo: Titolo, "Titolo messaggio", tx_, no_readonly, frontpage, 1, fa fa-list, unmasked, text, false
		testo: Testo, "Testo del messaggio", mm_, no_readonly, no_frontpage, 0, null, unmasked, text, false
		icona: Icona, "Icona messaggio (es: fa fa-user)", tx_, no_readonly, frontpage, 0, fa fa-image, unmasked, text, false
		immagine: Immagine, "Immagine (se prevista)", i_, no_readonly, frontpage, 0, fa fa-picture, unmasked, text, false
		datetime: Data, "Data messaggio", dt_, no_readonly, frontpage, 0, fa fa-calendar, unmasked, text, false
	ancillary
		buttonSave: "Aggiungi", "Aggiungi un nuovo messaggio", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: titolo, "CANCELLAZIONE MESSAGGIO", "Vuoi cancellare i dati per il messaggio"
		dbTitle: titolo
	title
		return "Elenco messaggi";
	getIcon
		return "fa fa-users";


tbUtentiLog

	di tipo
		tbEdit
	permessi
		ADMIN
	getQueryRequested
		return "false";
	resetStack
		true
	getTableName
		return "tb_user_log";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		data: Data evento, "Data dell'evento", dtts_, no_readonly, frontpage, 1, fa fa-picture, unmasked, date, false
		testo: Evento, "Evento", tx_, no_readonly, frontpage, 0, fa fa-picture, unmasked, text, false
		tb_utente: Utente, "Utente collegato all'evento", sel_, no_readonly, frontpage, 0, fa fa-picture, unmasked, text, false
			titolo: nome
	ancillary
		disabled: MODIFY, DELETE, ADD
		buttonSave: "", "", btn-success
		buttonCancel: "Annulla"
		removeWin: name_id, "CANCELLAZIONE EVENTO", "Vuoi rimuovere l'evento"
		dbTitle: data
		defaults: 100, data, DESC
	title
		return "Eventi log utente";
	getIcon
		return "fa fa-bars";




/// --------------
/// PAGINE ESTERNE

// password nuova
createNewPassword

	di tipo
		project data
	permessi
		USER
	getYear
		<[
			return date("Y");
		]>
	getComando
		return "cmdAggiornaPassword";

	getBoxTitle
		return "Creazione Nuova Password";

	infos
		<[
		<p style="font-weight:700;">Nota</p>
		<p>
		La password assegnata è temporanea e deve essere sostituita.
		Vogliate cortesemente inserire una nuova password che sia complessa e lunga almeno 14 caratteri.
		</p>
		]>

	backAddress
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			return "index.php?fx=" . $rec['valore'] . $query . $father;
		
		
		return "index.php";
		
		]>
	getAnyError
		<[
		
		if( !isset( $_REQUEST['i']))
			return "";
		
		$i = intval($_REQUEST['i']);
		
		if( ! $i )
			return "";
		
		return "Notify admin@awgp.it: frmamelogin [$i]";
		
		
		
		
		]>
	_exe
		<[
		$what = <<<EOT
///		ITALIANO
		<!doctype html>
		<html class="fixed">
			<head>
		
				<!-- Basic -->
				<meta charset="UTF-8">
		
				<title>{{=getTitle=}}</title>
				<meta name="keywords" content="{{=getKeywords=}}" />
				<meta name="description" content="{{=getDescription=}}">
				<meta name="author" content="Orazio Rizzo - Creative Software Lab">
		
				<!-- Mobile Metas -->
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		
				<!-- FAVICON -->
				<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
		
				<!-- Web Fonts  -->
				<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		
				<!-- Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
		
				<!-- Theme CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
		
				<!-- Skin CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
		
				<!-- Theme Custom CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
		
				<!-- Head Libs -->
				<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
		
			</head>
			<body>
				<!-- start: page -->
				<section class="body-sign">
					<div class="center-sign">
						<a href="/" class="logo pull-left">
							<img src="<!--relativeDirectory-->{{=getMainIcon=}}" height="54" alt="Porto Admin" />
						</a>
		
						<div class="panel panel-sign">
							<div class="panel-title-sign mt-xl text-right">
								<h2 class="title text-uppercase text-bold m-none"><i class="fa fa-user mr-xs"></i> {{=getBoxTitle=}}</h2>
							</div>
							<div class="panel-body">
								<!--infos-->
								<form action="index.php?fx={{=getComando=}}" method="post">
									<div class="form-group mb-lg">
										<label>Nuova Password</label>
										<div class="input-group input-group-icon">
											<input name="psw1" type="password" class="form-control input-lg" />
											<span class="input-group-addon">
												<span class="icon icon-lg">
													<i class="fa fa-lock"></i>
												</span>
											</span>
										</div>
									</div>
		
									<div class="form-group mb-lg">
										<label class="pull-left">Ripeti Password</label>
										<div class="input-group input-group-icon">
											<input name="psw2" type="password" class="form-control input-lg" />
											<span class="input-group-addon">
												<span class="icon icon-lg">
													<i class="fa fa-lock"></i>
												</span>
											</span>
										</div>
										<div class="clearfix">
										{{=dammiEventualeNota=}}
										</div>
									</div>
		
									<div class="row">
		///							[[_SEZIONE EX REMEMBER ME]]
										<div class="col-sm-12 text-right">
											<a class="mb-xs mt-xs mr-xs btn btn-default" href="{{=backAddress=}}" role="button"><i class="fa fa-arrow-left"></i> Annulla</a>
											<button type="submit" class="btn btn-primary hidden-xs">SALVA</button>
											<button type="submit" class="btn btn-primary btn-block btn-lg visible-xs mt-lg">SALVA</button>
										</div>
									</div>
		
		///							[[_SEZIONE CON LINEA E LOGIN TRAMITE SOCIAL]]
		
		///							[[_SEZIONE CON LINEA E OPZIONE REGISTRAZIONE]]
		
								</form>
							</div>
						</div>
		
						<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a> {{=getYear=}}. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
						<p class="text-center text-muted mt-md mb-md">{{=getAnyError=}}</p>
					</div>
				</section>
				<!-- end: page -->
		
				<!-- Vendor -->
				<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
				<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
				<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
				
				<!-- Theme Base, Components and Settings -->
				<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
				
				<!-- Theme Custom -->
				<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
				
				<!-- Theme Initialization Files -->
				<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
		
			</body>
		</html>
		
EOT;
		return $what;

		]>

	dammiEventualeNota
		<[
			if( isset( $_REQUEST['i']))
			{
				switch($_REQUEST['i'])
				{
					case 55:
						return '<p style="color:maroon;">La password deve essere complessa e lunga almeno 14 caratteri</p>';
					break;
					case 56:
						return '<p style="color:maroon;">Le password non coincidono</p>';
					break;
					case 57:
						return '<p style="color:maroon;">La password è uguale alla precedente</p>';
					break;
					case 58:
						return '<p style="color:maroon;">Si è verificato l\'errore 58, cortesemente inviate una notifica a: admin@awgp.it</p>';
					break;
				}
			}

			return "";
		]>


updatePassword

	di tipo
		createNewPassword
	getComando
		return "cmdAggiornaPassword2";

	getBoxTitle
		return "Aggiorna Password";

	infos
		<[
		<p style="font-weight:700;">Nota</p>
		<p>
		In ottemperanza alle normative sulla sicurezza informatica, è necessario modificare periodicamente la password.
		Vogliate cortesemente inserire una nuova password che sia complessa e lunga almeno 14 caratteri.
		</p>
		]>



// password scaduta
cmdAggiornaPassword

	di tipo
		project data
	permessi
		USER
	getBackAddress
		return "createNewPassword";
	_do
		<[

	
	global $gbl_tableName;
	global $gbl_masterFunction;
	global $gbl_userId;
	global $gbl_struct; // info da database (real_type real_lenght)
	global $gbl_fx;
	global $gbl_session; // tb_parametro
	global $db_sql; // link database standard
	// -------------------------------------------
	// raccolta dati utente
	// -------------------------------------------
	global $gbl_url;
	global $db_sql_name;
	global $gbl_nomeTipo;
	global $gbl_infoMenu;
	global $gbl_idSessione;
	global $gbl_nomeCampoTitolo;
	global $db_sql_user;
	global $db_sql_password;
	global $db_sql_host;
	global $gbl_userData;
	global $gbl_query;
	global $gbl_stack;
	global $gbl_father;
	global $gbl_anyFilterOn;
	global $gbl_unicode;
	global $gbl_myFullUrl;
	global $gbl_mainDomain;
	global $gbl_subDomain;
	// ------------------------------
	// 0=devId; 1=validity in seconds
	// Array:
	global $gbl_xsm;
	global $gbl_changePasswordDisabled;
	

	// verifico che la password sia valida
	if(	!isset($_REQUEST['psw1']) || 
		!isset($_REQUEST['psw2']) ||
		strlen($_REQUEST['psw1']) < 14 ||
		strlen($_REQUEST['psw2']) < 14 )
	{
		// non sono della lunghezza giusta
		header("Location: index.php?fx={{=getBackAddress=}}&i=55");
		exit();
	}

	$psw = $_REQUEST['psw1'];

	if( $psw != $_REQUEST['psw2'] )
	{
		// non coincidono
		header("Location: index.php?fx={{=getBackAddress=}}&i=56");
		exit();
	}

	// carico i dati dell'utente
	$rUser = _dbGet("SELECT id,password_hash FROM tb_utente WHERE id='$gbl_userId';");

	if( $rUser == NULL )
	{
		// errore, debug
		header("Location: index.php?fx={{=getBackAddress=}}&i=58");
		exit();
	}

	// carico sha256 della password vecchia
	$vecchiaHash = $rUser['password_hash'];
	// calcolo sha256 della password nuova 
	$theHash = hash( "sha256", $psw );

	if( $vecchiaHash == $theHash )
	{
		// vecchia == nuova?
		header("Location: index.php?fx={{=getBackAddress=}}&i=57");
		exit();
	}

	// TUTTO OK
	$rUser['password_hash'] = $theHash;
	db_sql_update_2( "tb_utente", $rUser, "id", $rUser['id'] );

	/// QUI SI ARRIVA SIA IN AGGIORNAMENTO E SIA IN CREAZIONE DELLA DURATA PASSWORD
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='password_expiry_date' and tb_utente='$gbl_userId';");

	if( $rec == NULL )
	{
		$rec['nome'] = "password_expiry_date";
		$rec['tb_utente'] = $gbl_userId;
		$rec['valore'] = time() + (3 * 30 * 24 * 60 * 60); // 3 mesi
		$rec['tb_sessione'] = 0;
		db_sql_insert_2( "tb_parametro", $rec);
	}
	else
	{
		$rec['valore'] = time() + (3 * 30 * 24 * 60 * 60); // 3 mesi
		db_sql_update_2( "tb_parametro", $rec, "id", $rec['id'] );
	}

	
	//1 ATTENZIONE CONDIVISA DA "PAGE AGGIORNA PASSWORD DA ROOT"
	
	// $rUser
	$log = array();
	$log['data'] = date("Y-m-d H:i:s", time());  
	$log['tb_utente'] = $rUser['id'];
	$log['testo'] = addslashes("L'utente ha aggiornato la password");
	db_sql_insert_2( "tb_user_log", $log);
	
	
	

	header("Location: index.php");
	exit();

		]>



cmdAggiornaPassword2

	di tipo
		cmdAggiornaPassword
	getBackAddress
		return "updatePassword";


// password modificata da utente
updatePasswordUser

	di tipo
		createNewPassword
	getComando
		return "cmdAggiornaPassword3";

	getBoxTitle
		return "Aggiorna Password";

	infos
		<[
		<p style="font-weight:700;">Nota</p>
		<p>
		Vogliate cortesemente inserire una nuova password che sia complessa e lunga almeno 14 caratteri.
		</p>
		]>



cmdAggiornaPassword3

	di tipo
		cmdAggiornaPassword
	getBackAddress
		return "updatePasswordUser";


passwdRecovery

	di tipo
		project data
	getYear
		<[
			return date("Y");
		]>
	_exe
		<[
		$what = <<<EOT
///		ITALIANO
		<!doctype html>
		<html class="fixed">
			<head>
		
				<!-- Basic -->
				<meta charset="UTF-8">
		
				<title>{{=getTitle=}}</title>
				<meta name="keywords" content="{{=getKeywords=}}" />
				<meta name="description" content="{{=getDescription=}}">
				<meta name="author" content="Orazio Rizzo - Creative Software Lab">
		
				<!-- Mobile Metas -->
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		
				<!-- FAVICON -->
				<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
		
				<!-- Web Fonts  -->
				<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		
				<!-- Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
		
				<!-- Theme CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
		
				<!-- Skin CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
		
				<!-- Theme Custom CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
		
				<!-- Head Libs -->
				<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
		
			</head>
			<body>
				<!-- start: page -->
				<section class="body-sign">
					<div class="center-sign">
						<a href="/" class="logo pull-left">
							<img src="<!--relativeDirectory-->{{=getMainIcon=}}" height="54" alt="Porto Admin" />
						</a>
		
						<div class="panel panel-sign">
							<div class="panel-title-sign mt-xl text-right">
								<h2 class="title text-uppercase text-bold m-none"><i class="fa fa-user mr-xs"></i> Recupero Password</h2>
							</div>
							<div class="panel-body">
								<form action="index.php?fx=cmdPasswdRecovery" method="post">
									<div class="form-group mb-lg">
										<label>Indirizzo Email</label>
										<div class="input-group input-group-icon">
											<input name="username" type="text" value="" class="form-control input-lg" />
											<span class="input-group-addon">
												<span class="icon icon-lg">
													<i class="fa fa-envelope"></i>
												</span>
											</span>
										</div>
									</div>
		
									<div class="form-group mb-lg">
		///								<div class="clearfix">
		///									<label class="pull-left">Password</label>
		///									<a tabindex="-1" href="index.php?fx=passwdRecovery" class="pull-right">Password Persa?</a>
		///								</div>
										<div class="clearfix">
										{{=dammiEventualeNota=}}
										</div>
									</div>
		
									<div class="row">
		///							[[_SEZIONE EX REMEMBER ME]]
										<div class="col-sm-12 text-right">
											<a class="mb-xs mt-xs mr-xs btn btn-default" href="index.php" role="button"><i class="fa fa-arrow-left"></i> Annulla</a>
											<button type="submit" class="btn btn-primary hidden-xs">Recupera</button>
											<button type="submit" class="btn btn-primary btn-block btn-lg visible-xs mt-lg">Recupera</button>
										</div>
									</div>
		
		///							[[_SEZIONE CON LINEA E LOGIN TRAMITE SOCIAL]]
		
		///							[[_SEZIONE CON LINEA E OPZIONE REGISTRAZIONE]]
		
								</form>
							</div>
						</div>
		
						<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a> {{=getYear=}}. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
						<p class="text-center text-muted mt-md mb-md">{{=getAnyError=}}</p>
					</div>
				</section>
				<!-- end: page -->
		
				<!-- Vendor -->
				<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
				<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
				<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
				
				<!-- Theme Base, Components and Settings -->
				<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
				
				<!-- Theme Custom -->
				<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
				
				<!-- Theme Initialization Files -->
				<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
		
			</body>
		</html>
		
EOT;
		return $what;

		]>

	dammiEventualeNota
		<[
			if( isset( $_REQUEST['i']))
			{
				switch($_REQUEST['i'])
				{
					case 1:
					case 13:
						return '<p style="color:maroon;">L\'indirizzo email non è valido</p>';
					break;
					case 2:
						return '<p style="color:maroon;">Indicare l\'indirizzo email</p>';
					break;
					case 5:
						return '<p style="color:maroon;">Errore 500 - il server non ha risposto in tempo, riprova</p>';
					break;
				}
			}

			return "";
		]>
		



cmdPasswdRecovery

	di tipo
		project data
	getYear
		<[
			return date("Y");
		]>
	_exe
		<[
		$what = <<<EOT
///		ITALIANO
		<!doctype html>
		<html class="fixed">
			<head>
		
				<!-- Basic -->
				<meta charset="UTF-8">
		
				<title>{{=getTitle=}}</title>
				<meta name="keywords" content="{{=getKeywords=}}" />
				<meta name="description" content="{{=getDescription=}}">
				<meta name="author" content="Orazio Rizzo - Creative Software Lab">
		
				<!-- Mobile Metas -->
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		
				<!-- FAVICON -->
				<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
		
				<!-- Web Fonts  -->
				<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		
				<!-- Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
		
				<!-- Theme CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
		
				<!-- Skin CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
		
				<!-- Theme Custom CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
		
				<!-- Head Libs -->
				<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
		
			</head>
			<body>
				<!-- start: page -->
				<section class="body-sign">
					<div class="center-sign">
						<a href="/" class="logo pull-left">
							<img src="<!--relativeDirectory-->{{=getMainIcon=}}" height="54" alt="Porto Admin" />
						</a>
		
						<div class="panel panel-sign">
							<div class="panel-title-sign mt-xl text-right">
								<h2 class="title text-uppercase text-bold m-none"><i class="fa fa-user mr-xs"></i> Recupero Password</h2>
							</div>
							<div class="panel-body">
								<form action="index.php" method="post">
									<h3>Info</h3>
									<p>
										Per questioni di sicurezza, la procedura di recupero password deve essere eseguita da un amministratore.
										Vogliate cortesemente rivolgervi al Vs. amministratore per il rilascio di una nuova
										password temporanea.<br>
										Se invece dovete recuperare una password amministratore, vogliate cortesemente inviare una richiesta
										all'indirizzo assistenza@cslab.info indicando l'indirizzo email ed il sistema di appartenenza.<br>
										Grazie.
									</p>
									<div class="form-group mb-lg">
										<div class="clearfix">
										{{=dammiEventualeNota=}}
										</div>
									</div>
		
									<div class="row">
		///							[[_SEZIONE EX REMEMBER ME]]
										<div class="col-sm-12 text-right">
											<button type="submit" class="btn btn-primary hidden-xs">Indietro</button>
											<button type="submit" class="btn btn-primary btn-block btn-lg visible-xs mt-lg">Indietro</button>
										</div>
									</div>
		
		///							[[_SEZIONE CON LINEA E LOGIN TRAMITE SOCIAL]]
		
		///							[[_SEZIONE CON LINEA E OPZIONE REGISTRAZIONE]]
		
								</form>
							</div>
						</div>
		
						<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a> {{=getYear=}}. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
						<p class="text-center text-muted mt-md mb-md">{{=getAnyError=}}</p>
					</div>
				</section>
				<!-- end: page -->
		
				<!-- Vendor -->
				<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
				<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
				<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
				
				<!-- Theme Base, Components and Settings -->
				<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
				
				<!-- Theme Custom -->
				<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
				
				<!-- Theme Initialization Files -->
				<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
		
			</body>
		</html>
		
EOT;
		return $what;

		]>

	dammiEventualeNota
		<[
			if( isset( $_REQUEST['i']))
			{
				switch($_REQUEST['i'])
				{
					case 1:
					case 13:
						return '<p style="color:maroon;">L\'indirizzo email non è valido</p>';
					break;
					case 2:
						return '<p style="color:maroon;">Indicare l\'indirizzo email</p>';
					break;
					case 5:
						return '<p style="color:maroon;">Errore 500 - il server non ha risposto in tempo, riprova</p>';
					break;
				}
			}

			return "";
		]>
		



// RESET PASSWORD DA ROOT (collegato a tbEditUtenti)
frmPasswordReset

	di tipo
		frameMain
	permessi
		USER
	getOctopusMainContent
		<[
		if(!isset($_REQUEST['idCode']))
			return "idCode check";
		$idCode = $_REQUEST['idCode'];
		
			$what = <<<EOT
								<div style="max-width:600px;" class="col-md-12">
									<form method="post" action="index.php?fx=cmdAggiornaPasswordDaRoot&idCode={$idCode}" class="form-horizontal form-bordered">
										<section class="panel">
											<header class="panel-heading">
												<div class="panel-actions">
													<a href="#" class="fa fa-caret-down"></a>
													<a href="#" class="close-all fa fa-times"></a>
												</div>
		
												<h2 class="panel-title">Reset Password Utente</h2>
		
												<p class="testoParagrafo">
													La password per l'utente <code>{{=getUserName=}}</code> sarà resettata. 
													Fornire all'utente la password temporanea che compare qui in basso per consentirne l'accesso
												</p>
											</header>
											<div class="panel-body">
												<div class="form-group">
													<label class="col-sm-5 control-label">Email Utente:</label>
													<div class="col-sm-7">
														<input type="email" name="email" value="{{=getUserEmail=}}" class="cometesto form-control" readonly>
													</div>
												</div>
												<div class="form-group">
													<label class="col-sm-5 control-label">Password Temporanea:</label>
													<div class="col-sm-7">
														<input type="text" name="psw" value="{{=generatePassword=}}" class="monotipo cometesto form-control" readonly>
													</div>
												</div>
											</div>
											<div class="panel-body">
												<div class="col-sm-5">
												</div>
												<div class="col-sm-7">
													<button class="btn btn-primary">Reset Password</button>
													<button type="reset" class="close-all btn btn-default">Annulla</button>
												</div>
											</div>
										</section>
									</form>
								</div>
		
			EOT;
		
		
		return $what;
		]>
	innerWrapperStyle
		style="background-color:#eee";

	backAddress
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
		
		// PRENDO L'ULTIMO ELEMENTO
		$father = "";
		$query = "";
		if( is_array($gbl_stack) && count( $gbl_stack))
		{
			$current = $gbl_stack[ count($gbl_stack)-1];
			if( isset( $current['father']) && $current['father'] != "" )
				$father = "&f=" . $current['father'];
			if( isset( $current['query']) && $current['query'] != "" )
				$query = "&q=" . $current['query'];
		}
		
		if( isset($rec['valore']) && $rec['valore'] != "" )
			return "index.php?fx=" . $rec['valore'] . $query . $father;
		
		
		return "#";
		
		]>

	javascriptInizializzazioneSpecifica
		<[
		<script>
					$(document).on("click", function(e){
						// PULSANTE DI CHIUSURA E X
						if( $(e.target).hasClass("close-all"))
						{
							window.location.href='{{=backAddress=}}';
							return false;
						}
					});
		</script>
		
		]>

	getUserName
		<[
		
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			
					$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
					if( isset($rec['valore']) && $rec['valore'] != "" )
						$gbl_tableName = $rec['valore'];
			
			///		return "table name:" . $gbl_tableName;
			
			
			
				$element = isset( $_REQUEST['idCode']) ? hex2bin( $_REQUEST['idCode'] ) : NULL;
				if( $element == NULL )
					return "invalid";
			
				$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
				$element = intval(_decrypta( $element, $key ));
			
		
			// se non ho il codice del PLC corretto: exit
			if( !$element)
			{
				// non sono della lunghezza giusta
				header("Location: index.php?fx={{=getBackAddress=}}&i=58");
				exit();
			}
		
			$rec = _dbGet("SELECT * FROM tb_utente WHERE id='$element';");
		
			return isset($rec['nome']) ? $rec['nome'] : "";
		
		
		
		
		]>
	getUserEmail
		<[
		
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			
					$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
					if( isset($rec['valore']) && $rec['valore'] != "" )
						$gbl_tableName = $rec['valore'];
			
			///		return "table name:" . $gbl_tableName;
			
			
			
				$element = isset( $_REQUEST['idCode']) ? hex2bin( $_REQUEST['idCode'] ) : NULL;
				if( $element == NULL )
					return "invalid";
			
				$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
				$element = intval(_decrypta( $element, $key ));
			
		
			// se non ho il codice del PLC corretto: exit
			if( !$element)
			{
				// non sono della lunghezza giusta
				header("Location: index.php?fx={{=getBackAddress=}}&i=58");
				exit();
			}
		
			$rec = _dbGet("SELECT * FROM tb_utente WHERE id='$element';");
		
			return isset($rec['email']) ? $rec['email'] : "";
		
		
		
		
		]>
	generatePassword
		<[
			return (time()%9) . (time()%3000) . (time()%19) . "e" . intval((time()%199)) . "U$" . (time()%6) . (time()%676);
		]>

	ADDITIONAL CSS BARE FRAME
		<[
			<style>
				.manina {
					cursor: pointer;
				}
				.cometesto {
					cursor: text !important;
				}
				.testoParagrafo {
					line-height: 1.1em;
					margin-top: 1em;
				}
				.monotipo {
					color: blue;
					font-family: monospace;
					font-size:1.1em;
				}
			</style>
		]>

cmdAggiornaPasswordDaRoot

	di tipo
		project data
	permessi
		USER
	getBackAddress
		return "tbEditUtenti";
	_do
		<[

	
	global $gbl_tableName;
	global $gbl_masterFunction;
	global $gbl_userId;
	global $gbl_struct; // info da database (real_type real_lenght)
	global $gbl_fx;
	global $gbl_session; // tb_parametro
	global $db_sql; // link database standard
	// -------------------------------------------
	// raccolta dati utente
	// -------------------------------------------
	global $gbl_url;
	global $db_sql_name;
	global $gbl_nomeTipo;
	global $gbl_infoMenu;
	global $gbl_idSessione;
	global $gbl_nomeCampoTitolo;
	global $db_sql_user;
	global $db_sql_password;
	global $db_sql_host;
	global $gbl_userData;
	global $gbl_query;
	global $gbl_stack;
	global $gbl_father;
	global $gbl_anyFilterOn;
	global $gbl_unicode;
	global $gbl_myFullUrl;
	global $gbl_mainDomain;
	global $gbl_subDomain;
	// ------------------------------
	// 0=devId; 1=validity in seconds
	// Array:
	global $gbl_xsm;
	global $gbl_changePasswordDisabled;
	
	
			$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome tabella' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
			if( isset($rec['valore']) && $rec['valore'] != "" )
				$gbl_tableName = $rec['valore'];
	
	///		return "table name:" . $gbl_tableName;
	
	
	
		$element = isset( $_REQUEST['idCode']) ? hex2bin( $_REQUEST['idCode'] ) : NULL;
		if( $element == NULL )
			return "invalid";
	
		$key = "AZ$9099" . $gbl_tableName . $gbl_idSessione . $gbl_userId;
		$element = intval(_decrypta( $element, $key ));
	

	// se non ho il codice del PLC corretto: exit
	if( !$element)
	{
		// non sono della lunghezza giusta
		header("Location: index.php?fx={{=getBackAddress=}}&i=58");
		exit();
	}

	// verifico che la password sia valida
	if(	!isset($_REQUEST['psw']) || 
		strlen($_REQUEST['psw']) < 14 )
	{
		// non sono della lunghezza giusta
		header("Location: index.php?fx={{=getBackAddress=}}&i=55");
		exit();
	}

	$psw = $_REQUEST['psw'];

	// carico i dati dell'utente
	$rUser = _dbGet("SELECT id,password_hash FROM tb_utente WHERE id='$element';");

	if( $rUser == NULL )
	{
		// errore, debug
		header("Location: index.php?fx={{=getBackAddress=}}&i=58");
		exit();
	}

	// calcolo sha256 della password nuova 
	$theHash = hash( "sha256", $psw );

	// TUTTO OK
	$rUser['password_hash'] = $theHash;
	db_sql_update_2( "tb_utente", $rUser, "id", $rUser['id'] );

	/// QUI SI ARRIVA SIA IN AGGIORNAMENTO E SIA IN CREAZIONE DELLA DURATA PASSWORD
	$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='password_expiry_date' and tb_utente='$element';");

	if( $rec == NULL )
	{
		$rec['nome'] = "password_expiry_date";
		$rec['tb_utente'] = $element;
		$rec['valore'] = time(); // set già scaduta
		$rec['tb_sessione'] = 0;
		db_sql_insert_2( "tb_parametro", $rec);
	}
	else
	{
		$rec['valore'] = time(); // // set già scaduta
		db_sql_update_2( "tb_parametro", $rec, "id", $rec['id'] );
	}

	
	//1 ATTENZIONE CONDIVISA DA "PAGE AGGIORNA PASSWORD DA ROOT"
	
	// $rUser
	$log = array();
	$log['data'] = date("Y-m-d H:i:s", time());  
	$log['tb_utente'] = $rUser['id'];
	$log['testo'] = addslashes("L'utente ha aggiornato la password");
	db_sql_insert_2( "tb_user_log", $log);
	
	
	

	header("Location: index.php?fx={{=getBackAddress=}}");
	exit();

		]>


// -------------------------------------------------

frameLogin
	di tipo
		project data
	getYear
		<[
			return date("Y");
		]>
	getAnyError
		<[
		
		if( !isset( $_REQUEST['i']))
			return "";
		
		$i = intval($_REQUEST['i']);
		
		if( ! $i )
			return "";
		
		return "Notify admin@awgp.it: frmamelogin [$i]";
		
		
		
		
		]>
	_exe
		<[
		$what = <<<EOT
///		ITALIANO
		<!doctype html>
		<html class="fixed">
			<head>
		
				<!-- Basic -->
				<meta charset="UTF-8">
		
				<title>{{=getTitle=}}</title>
				<meta name="keywords" content="{{=getKeywords=}}" />
				<meta name="description" content="{{=getDescription=}}">
				<meta name="author" content="Orazio Rizzo - Creative Software Lab">
		
				<!-- Mobile Metas -->
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		
				<!-- FAVICON -->
				<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
		
				<!-- Web Fonts  -->
				<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		
				<!-- Vendor CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
				<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
		
				<!-- Theme CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
		
				<!-- Skin CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
		
				<!-- Theme Custom CSS -->
				<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
		
				<!-- Head Libs -->
				<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
		
			</head>
			<body>
				<!-- start: page -->
				<section class="body-sign">
					<div class="center-sign">
						<a href="/" class="logo pull-left">
							<img src="<!--relativeDirectory-->{{=getMainIcon=}}" height="54" alt="Porto Admin" />
						</a>
		
						<div class="panel panel-sign">
							<div class="panel-title-sign mt-xl text-right">
								<h2 class="title text-uppercase text-bold m-none"><i class="fa fa-user mr-xs"></i> Accedi</h2>
							</div>
							<div class="panel-body">
								<form action="index.php?fx=cmdLogin" method="post">
									<div class="form-group mb-lg">
										<label>Indirizzo Email</label>
										<div class="input-group input-group-icon">
											<input name="username" type="text" value="{{=dammiEventualeNomePrecedente=}}" class="form-control input-lg" />
											<span class="input-group-addon">
												<span class="icon icon-lg">
													<i class="fa fa-user"></i>
												</span>
											</span>
										</div>
									</div>
		
									<div class="form-group mb-lg">
										<div class="clearfix">
											<label class="pull-left">Password</label>
											<a tabindex="-1" href="index.php?fx=passwdRecovery" class="pull-right">Password Persa?</a>
										</div>
										<div class="input-group input-group-icon">
											<input name="pwd" type="password" class="form-control input-lg" />
											<span class="input-group-addon">
												<span class="icon icon-lg">
													<i class="fa fa-lock"></i>
												</span>
											</span>
										</div>
										<div class="clearfix">
										{{=dammiEventualeNota=}}
										</div>
									</div>
		
									<div class="row">
		///							[[_SEZIONE EX REMEMBER ME]]
										<div class="col-sm-12 text-right">
											<button type="submit" class="btn btn-primary hidden-xs">Accedi</button>
											<button type="submit" class="btn btn-primary btn-block btn-lg visible-xs mt-lg">Accedi</button>
										</div>
									</div>
		
		///							[[_SEZIONE CON LINEA E LOGIN TRAMITE SOCIAL]]
		
		///							[[_SEZIONE CON LINEA E OPZIONE REGISTRAZIONE]]
		
								</form>
							</div>
						</div>
		
						<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a> {{=getYear=}}. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
						<p class="text-center text-muted mt-md mb-md">{{=getAnyError=}}</p>
					</div>
				</section>
				<!-- end: page -->
		
				<!-- Vendor -->
				<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
				<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
				<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
				<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
				<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
				
				<!-- Theme Base, Components and Settings -->
				<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
				
				<!-- Theme Custom -->
				<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
				
				<!-- Theme Initialization Files -->
				<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
		
			</body>
		</html>
		
EOT;
		return $what;

		]>

	dammiEventualeNomePrecedente
		<[
			if( isset( $_REQUEST['u']))
				return $_REQUEST['u'];

			return "";
		]>

	dammiEventualeNota
		<[
			if( isset( $_REQUEST['i']))
			{
				switch($_REQUEST['i'])
				{
					case 1:
					case 13:
						return '<p style="color:maroon;">Password o utente non valido</p>';
					break;
					case 2:
						return '<p style="color:maroon;">Indicare password e utente</p>';
					break;
					case 5:
						return '<p style="color:maroon;">Errore 500 - il server non ha risposto in tempo, riprova</p>';
					break;
				}
			}

			return "";
		]>
		

pageLogin
	di tipo
		frameLogin

cmdLogin
	di tipo
		project data
	_do
		<[
		
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
		
			if( !isset( $_REQUEST['username']) || !isset( $_REQUEST['pwd']) )
			{
				header("Location: index.php?fx=pageLogin&i=1");
				exit();
			}
		
			$nomeUtente = strtolower( trim($_REQUEST['username']));
		
			if( $_REQUEST['username']=="" || $_REQUEST['pwd']=="" )
			{
				header("Location: index.php?fx=pageLogin&i=2&u=$nomeUtente");
				exit();
			}
			
			// ------------------------------------------------------------------------
			// ACCESSO CADENZATO, UN UTENTE OGNI 700 MILLISECONDI MAX
			// ------------------------------------------------------------------------
			$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='last access time';");
			if( $rec == NULL )
			{
				$rec['nome'] = "last access time";
				$rec['valore'] = intval(microtime(true) * 1000);
				$rec['tb_sessione'] = 0;
				db_sql_insert_2( "tb_parametro", $rec);
			}
			else
			{
				$milliseconds = intval(microtime(true) * 1000);
				if( intval( $rec['valore']) > ($milliseconds - 750) )
				{
					header("Location: index.php?fx=pageLogin&i=5&u={$nomeUtente}");
					exit();
				}
				$rec['valore'] = $milliseconds;
				db_sql_update_2( "tb_parametro", $rec, "id", $rec['id']);
			}
			// ------------------------------------------------------------------------
		
			$theHash = hash( "sha256", $_REQUEST['pwd'] );
		
			$uRec = _dbGet("SELECT * FROM tb_utente WHERE email='" . sanitize(trim($nomeUtente),"sql",$db_sql) . "' AND password_hash='" . sanitize($theHash,"sql", $db_sql) . "';");
		
			if( $uRec == NULL )
			{
				header("Location: index.php?fx=pageLogin&i=13&u=$nomeUtente");
				exit();
			}
		
			$token = getFreshToken( $nomeUtente, $db_sql_name);
			setcookie("tk_" . $gbl_subDomain, $token, [
		    'expires' => time() + 86400,
		    'path' => '/',
		    'domain' => $gbl_mainDomain,
		    'secure' => true,
		    'httponly' => true,
		    'samesite' => 'None',] );
		
			if( isset($_SERVER['REMOTE_ADDR']))
				$ip = $_SERVER['REMOTE_ADDR'];
			else
				$ip = "1.1.1.1";
		
			
			// $rUser
			$log = array();
			$log['data'] = date("Y-m-d H:i:s", time());  
			$log['tb_utente'] = $uRec['id'];
			$log['testo'] = addslashes("L'utente ha fatto un nuovo accesso");
			db_sql_insert_2( "tb_user_log", $log);
			
			
			
		
			/// ----------------------------------------------
			/// CANCELLO I DATI DI SESSIONE DI TUTTO IL MONDO!
			
			/// -----------------------------------------------------------------------------
			/// A PRESCINDERE, CANCELLO TUTTI I PARAMETRI DI SESSIONE SE LA SESSIONE STESSA
			/// E' SCADUTA. SCELGO COME MOMENTO I LOGIN DEI CLIENTI.
			/// TUTTI I LOGIN CAUSANO LA CANCELLAZIONE DELLE VECCHIE SESSIONI SCADUTE
			/// LE SESSIONI DURANO 30 GIORNI E VENGONO RIUTILIZZATE QUINDI NON SI CORRE IL
			/// RISCHIO CHE UNA SESSIONE SIA CANCELLATA PER ERRORE (AD OGNI CHIAMATA DI INDEX
			/// IL TEMPO DI SESSIONE VIENE RIPRISTINATO (A 30 GG).
			/// -----------------------------------------------------------------------------
			$tempo = time();
			$expired = array();
			/// -----------------------------------------------------------------------------
			/// TUTTE LE SESSIONI SCADUTE *** ANCHE QUELLE DI ALTRI UTENTI ***
			$rec = _dbGet("SELECT * FROM tb_sessione WHERE expires < '{$tempo}';");
			while( $rec != NULL)
			{
				$expired[] =  $rec['id'];
				$rec = _dbGet();
			}
			
			foreach( $expired as $idSessione)
				dbQuery("DELETE FROM tb_parametro WHERE tb_sessione='{$idSessione}';");
			
			dbQuery("DELETE FROM tb_sessione WHERE expires < '{$tempo}';");
			
			
			
			
			/// ----------------------------------------------
			/// CREO IL RECORD DI SESSIONE SE NON PRESENTE
			$gbl_userId = $uRec['id'];
			
			$tempo = time();
			
			$unicode = bin2pck("" . time() . $gbl_userId);
			if( isset( $_COOKIE["tkS_" . $gbl_subDomain]))
				$unicode = sanitize($_COOKIE["tkS_" . $gbl_subDomain], "sql", $db_sql);
			
			$rec = _dbGet("SELECT * FROM tb_sessione WHERE unicode='{$unicode}' AND tb_utente='$gbl_userId';"); // "expires" sarà OK, tutti quelli vecchi li ho appena cancellati
			if( $rec == NULL )
			{
				// ---------------------------------------------------------------------
				//  PER QUALCHE RAGIONE HO IL TOKEN MA NON C'E' IL RECORD DI SESSIONE.
				//2 NON POSSO CANCELLARE EVENTUALI RECORD SPURI RESIDUALI TB_PARAMETRO
				// ---------------------------------------------------------------------
				$r = array();
				$r['unicode'] = $unicode; // NON SERVE SANIFICARE
				$r['tb_utente'] = $gbl_userId;
				$r['expires'] = time() + 2592000;
				db_sql_insert_2("tb_sessione", $r);
				setcookie("tkS_" . $gbl_subDomain, $unicode, [
					'expires' => time() + 86400,
					'path' => '/',
					'domain' => $gbl_mainDomain,
					'secure' => true,
					'httponly' => true,
					'samesite' => 'None'] );
			}
			
			
			/// ----------------------------------------------
			/// VERIFICO SE E' IL MOMENTO DI CAMBIARE PASSWORD
			
			/// FASE 1, le password vengono create la prima volta al momento della creazione dell'utente da parte dell'amministratore
			/// in quella fase il tb_parametro[tb_utente] di password_expiry_date non esiste.
			/// per questa ragione, al primo login, verrà chiesto di modificare la password.
			/// La password passata infatti è nota all'amministratore e questo non è corretto.
			$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='password_expiry_date' AND tb_utente=$gbl_userId;");
			
			if( $rec == NULL )
			{
				/// non esiste la password
				header("Location: index.php?fx=createNewPassword");
				exit();
			}
			
			$expired = $rec['valore'];
			
			if( $expired < time() )
			{
				/// la password è scaduta
				header("Location: index.php?fx=updatePassword");
				exit();
			}
			
			
			/// ----------------------------------------------
			header("Location: index.php");
			exit();
		
		]>

cmdLogout
	di tipo
		project data
	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		setcookie("tk_" . $gbl_subDomain, "", time() -3600, "/", "$gbl_mainDomain", true, true);
		setcookie("tkS_" . $gbl_subDomain, "", time() -3600, "/", "$gbl_mainDomain", true, true);

		
		/// -----------------------------------------------------------------------------
		/// A PRESCINDERE, CANCELLO TUTTI I PARAMETRI DI SESSIONE SE LA SESSIONE STESSA
		/// E' SCADUTA. SCELGO COME MOMENTO I LOGIN DEI CLIENTI.
		/// TUTTI I LOGIN CAUSANO LA CANCELLAZIONE DELLE VECCHIE SESSIONI SCADUTE
		/// LE SESSIONI DURANO 30 GIORNI E VENGONO RIUTILIZZATE QUINDI NON SI CORRE IL
		/// RISCHIO CHE UNA SESSIONE SIA CANCELLATA PER ERRORE (AD OGNI CHIAMATA DI INDEX
		/// IL TEMPO DI SESSIONE VIENE RIPRISTINATO (A 30 GG).
		/// -----------------------------------------------------------------------------
		dbQuery("DELETE FROM tb_parametro WHERE tb_sessione='$gbl_idSessione';");
		dbQuery("DELETE FROM tb_sessione WHERE id='$gbl_idSessione';");
		
		
		
		
		header("Location: index.php?fx=pageLogin");
		]>



/// -------------------------------------------------

/// ----------------------------------
/// UPLOAD DOWNLOAD SHOW PICTURES

/// MODIFICATA PER CARICARE JPG e non PNG -> attenzione
/// MODIFICATA PER AVERE CODICE SEMPRE UGUALE (scramble e descramble)
iymage_light
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		// a=  altezza (clean)
		// l=  larghezza (clean)
		// bw= 1 -> BLACK AND WHITE
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		
		/// --------------------------------------------------------------------------------------
		/// DECIDO DI RENDERE VISIBILE L'IMMAGINE ANCHE DA ESTERNO PER IL MOMENTO
		/// --------------------------------------------------------------------------------------
		if( !isset( $_REQUEST['data']))
			exit();
		
		// BASE64
		$data = hex2bin( $_REQUEST['data'] );
		// DECRYPT
		$key = "alfabeta acqua chetaS";
		$data = descramble( $data, $key );
		if( $data == "***" )
			return "-7";
		// JSON DECODE
		$data = json_decode( $data, true);
		// ARRAY
		$table = $data['t'];
		$id = $data['id'];
		$fieldName = $data['f'];
		
		$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
		if( $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
		{
			$the_array = json_decode($rec[$fieldName]);
			// HEX per ora
			$the_picture = base64_decode( $the_array->datafile ?? "" );
			$the_picture = $the_picture != "" ? gzdecode( $the_picture ) : "";
		
			if(( $the_picture == "") || ($the_picture == NULL))
			{
				echo "error 3";
				exit();
			}
		}
		else
			$the_picture = file_get_contents("assets/images/owl.png");
		/// --------------------------------------------------------------------------------------
		
		$l = 0;
		if( isset( $_REQUEST['l']))
			$l = $_REQUEST['l'];
		$a = 0;
		if( isset( $_REQUEST['a']))
			$a = $_REQUEST['a'];
		
		$bw = isset( $_REQUEST['bw'] ) && $_REQUEST['bw'] == "1" ? true : false;
		
		make_thumb($the_picture, $l, $a, $bw);
		
		function resize_image($source_image, $destination_width, $destination_height, $type = 0) { 
		    // $type (1=crop to fit, 2=letterbox) 
		    $source_width = imagesx($source_image); 
		    $source_height = imagesy($source_image); 
		    $source_ratio = $source_width / $source_height; 
		    $destination_ratio = $destination_width / $destination_height; 
		    if ($type == 1) { 
		        // crop to fit 
		        if ($source_ratio > $destination_ratio) { 
		            // source has a wider ratio 
		            $temp_width = (int)($source_height * $destination_ratio); 
		            $temp_height = $source_height; 
		            $source_x = (int)(($source_width - $temp_width) / 2); 
		            $source_y = 0; 
		        } else { 
		            // source has a taller ratio 
		            $temp_width = $source_width; 
		            $temp_height = (int)($source_width / $destination_ratio); 
		            $source_x = 0; 
		            $source_y = (int)(($source_height - $temp_height) / 2); 
		        } 
		        $destination_x = 0; 
		        $destination_y = 0; 
		        $source_width = $temp_width; 
		        $source_height = $temp_height; 
		        $new_destination_width = $destination_width; 
		        $new_destination_height = $destination_height; 
		    } else { 
		        // letterbox 
		        if ($source_ratio < $destination_ratio) { 
		            // source has a taller ratio 
		            $temp_width = (int)($destination_height * $source_ratio); 
		            $temp_height = $destination_height; 
		            $destination_x = (int)(($destination_width - $temp_width) / 2); 
		            $destination_y = 0; 
		        } else { 
		            // source has a wider ratio 
		            $temp_width = $destination_width; 
		            $temp_height = (int)($destination_width / $source_ratio); 
		            $destination_x = 0; 
		            $destination_y = (int)(($destination_height - $temp_height) / 2); 
		        } 
		        $source_x = 0; 
		        $source_y = 0; 
		        $new_destination_width = $temp_width; 
		        $new_destination_height = $temp_height; 
		    } 
		    $destination_image = imagecreatetruecolor(intval($destination_width), intval($destination_height)); 
		    if ($type > 1) { 
		        imagefill($destination_image, 0, 0, imagecolorallocate ($destination_image, 0, 0, 0)); 
		    }
		    imagealphablending($destination_image, false); // setting alpha blending off
		    imagesavealpha($destination_image, true); // save alphablending setting (important)
		
		    imagecopyresampled($destination_image, $source_image, intval($destination_x), intval($destination_y), intval($source_x), intval($source_y), intval($new_destination_width), intval($new_destination_height), intval($source_width), intval($source_height)); 
		    return $destination_image; 
		} 
		
		function make_thumb($src, $destination_width, $destination_height, $bw=false)
		{
		   /* read the source image */
		   $source_image = imagecreatefromstring($src);
		
		   $source_width = imagesx($source_image); 
		   $source_height = imagesy($source_image); 
			
		   if( $destination_width <=0 && $destination_height <= 0) {
			$destination_width = $source_width;
			$destination_height = $source_height;
		   }
		   else
		   {
			if( $destination_width <= 0)
				$destination_width = $source_width*$destination_height/$source_height;
		
			if( $destination_height <= 0)
				$destination_height = $source_height*$destination_width/$source_width;
		
		   }
		
		   $virtual_image = resize_image($source_image, $destination_width, $destination_height, 1); // crop to fit
		
			if( $bw )
				imagefilter($virtual_image, IMG_FILTER_GRAYSCALE);
		
		   header('Content-type: image/jpg'); 
			imagepng($virtual_image, NULL, 6);
		///	imagejpeg($virtual_image, NULL, 80);
			imagedestroy($source_image); 
		   imagedestroy($virtual_image);
		}
		
		]>
	permessi
		ANY

//2 MODIFICATA PER CARICARE PNG e non JPG -> attenzione
//2 MODIFICATA PER AVERE CODICE SEMPRE UGUALE (scramble e descramble)
izmage_light
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		// a=  altezza (clean)
		// l=  larghezza (clean)
		// bw= 1 -> BLACK AND WHITE
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		
		/// --------------------------------------------------------------------------------------
		/// DECIDO DI RENDERE VISIBILE L'IMMAGINE ANCHE DA ESTERNO PER IL MOMENTO
		/// --------------------------------------------------------------------------------------
		if( !isset( $_REQUEST['data']))
			exit();
		
		// BASE64
		$data = hex2bin( $_REQUEST['data'] );
		// DECRYPT
		$key = "alfabeta acqua chetaS";
		$data = descramble( $data, $key );
		if( $data == "***" )
			return "-7";
		// JSON DECODE
		$data = json_decode( $data, true);
		// ARRAY
		$table = $data['t'];
		$id = $data['id'];
		$fieldName = $data['f'];
		
		$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
		if( $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
		{
			$the_array = json_decode($rec[$fieldName]);
			// HEX per ora
			$the_picture = base64_decode( $the_array->datafile ?? "" );
			$the_picture = $the_picture != "" ? gzdecode( $the_picture ) : "";
		
			if(( $the_picture == "") || ($the_picture == NULL))
			{
				echo "error 3";
				exit();
			}
		}
		else
			$the_picture = file_get_contents("assets/images/owl.png");
		/// --------------------------------------------------------------------------------------
		
		$l = 0;
		if( isset( $_REQUEST['l']))
			$l = $_REQUEST['l'];
		$a = 0;
		if( isset( $_REQUEST['a']))
			$a = $_REQUEST['a'];
		
		$bw = isset( $_REQUEST['bw'] ) && $_REQUEST['bw'] == "1" ? true : false;
		
		make_thumb($the_picture, $l, $a, $bw);
		
		function resize_image($source_image, $destination_width, $destination_height, $type = 0) { 
		    // $type (1=crop to fit, 2=letterbox) 
		    $source_width = imagesx($source_image); 
		    $source_height = imagesy($source_image); 
		    $source_ratio = $source_width / $source_height; 
		    $destination_ratio = $destination_width / $destination_height; 
		    if ($type == 1) { 
		        // crop to fit 
		        if ($source_ratio > $destination_ratio) { 
		            // source has a wider ratio 
		            $temp_width = (int)($source_height * $destination_ratio); 
		            $temp_height = $source_height; 
		            $source_x = (int)(($source_width - $temp_width) / 2); 
		            $source_y = 0; 
		        } else { 
		            // source has a taller ratio 
		            $temp_width = $source_width; 
		            $temp_height = (int)($source_width / $destination_ratio); 
		            $source_x = 0; 
		            $source_y = (int)(($source_height - $temp_height) / 2); 
		        } 
		        $destination_x = 0; 
		        $destination_y = 0; 
		        $source_width = $temp_width; 
		        $source_height = $temp_height; 
		        $new_destination_width = $destination_width; 
		        $new_destination_height = $destination_height; 
		    } else { 
		        // letterbox 
		        if ($source_ratio < $destination_ratio) { 
		            // source has a taller ratio 
		            $temp_width = (int)($destination_height * $source_ratio); 
		            $temp_height = $destination_height; 
		            $destination_x = (int)(($destination_width - $temp_width) / 2); 
		            $destination_y = 0; 
		        } else { 
		            // source has a wider ratio 
		            $temp_width = $destination_width; 
		            $temp_height = (int)($destination_width / $source_ratio); 
		            $destination_x = 0; 
		            $destination_y = (int)(($destination_height - $temp_height) / 2); 
		        } 
		        $source_x = 0; 
		        $source_y = 0; 
		        $new_destination_width = $temp_width; 
		        $new_destination_height = $temp_height; 
		    } 
		    $destination_image = imagecreatetruecolor(intval($destination_width), intval($destination_height)); 
		    if ($type > 1) { 
		        imagefill($destination_image, 0, 0, imagecolorallocate ($destination_image, 0, 0, 0)); 
		    }
		    imagealphablending($destination_image, false); // setting alpha blending off
		    imagesavealpha($destination_image, true); // save alphablending setting (important)
		
		    imagecopyresampled($destination_image, $source_image, intval($destination_x), intval($destination_y), intval($source_x), intval($source_y), intval($new_destination_width), intval($new_destination_height), intval($source_width), intval($source_height)); 
		    return $destination_image; 
		} 
		
		function make_thumb($src, $destination_width, $destination_height, $bw=false)
		{
		   /* read the source image */
		   $source_image = imagecreatefromstring($src);
		
		   $source_width = imagesx($source_image); 
		   $source_height = imagesy($source_image); 
			
		   if( $destination_width <=0 && $destination_height <= 0) {
			$destination_width = $source_width;
			$destination_height = $source_height;
		   }
		   else
		   {
			if( $destination_width <= 0)
				$destination_width = $source_width*$destination_height/$source_height;
		
			if( $destination_height <= 0)
				$destination_height = $source_height*$destination_width/$source_width;
		
		   }
		
		   $virtual_image = resize_image($source_image, $destination_width, $destination_height, 1); // crop to fit
		
			if( $bw )
				imagefilter($virtual_image, IMG_FILTER_GRAYSCALE);
		
		   header('Content-type: image/jpg'); 
			imagepng($virtual_image, NULL, 6);
		///	imagejpeg($virtual_image, NULL, 80);
			imagedestroy($source_image); 
		   imagedestroy($virtual_image);
		}
		
		]>
	permessi
		ANY

dlany
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		if( !isset( $_REQUEST['data']))
			exit();
		// BASE64
		$data = hex2bin( $_REQUEST['data'] );
		// DECRYPT
		$key = "alfabeta acqua chetaS";
		$data = _decrypta( $data, $key );
		if( $data == "***" )
			return "-7";
		// JSON DECODE
		$data = json_decode( $data, true);
		// ARRAY
		$table = $data['t'];
		$id = $data['id'];
		$fieldName = $data['f'];
		
		$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
		if( $rec != NULL && $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
		{
			$the_array = json_decode($rec[$fieldName]);
			// HEX per ora
			$the_annex = base64_decode( $the_array->datafile ?? "");
			$the_annex = $the_annex != "" ? gzdecode( $the_annex ) : "";
		
			if(( $the_annex == "") || ($the_annex == NULL))
			{
				echo "error 3";
				exit();
			}
		}
		else
			return "";
		
		if( $the_array->nomefile == "" || $the_annex == NULL )
			return "";
		
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header('Content-Disposition: attachment; filename="' . $the_array->nomefile . '"');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . strlen($the_annex));
		echo $the_annex;
		
		
		
		
		]>
	permessi
		ANY

dlpdfany
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		if( !isset( $_REQUEST['data']))
			exit();
		// BASE64
		$data = hex2bin( $_REQUEST['data'] );
		// DECRYPT
		$key = "alfabeta acqua chetaS";
		$data = _decrypta( $data, $key );
		if( $data == "***" )
			return "-7";
		// JSON DECODE
		$data = json_decode( $data, true);
		// ARRAY
		$table = $data['t'];
		$id = $data['id'];
		$fieldName = $data['f'];
		
		$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
		if( $rec != NULL && $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
		{
			$the_array = json_decode($rec[$fieldName]);
			// HEX per ora
			$the_annex = base64_decode( $the_array->datafile ?? "" );
			$the_annex = $the_annex != "" ? gzdecode( $the_annex ) : "";
		
			if(( $the_annex == "") || ($the_annex == NULL))
			{
				echo "error 3";
				exit();
			}
		}
		else
			return "";
		
		if( $the_array->nomefile == "" || $the_annex == NULL )
			return "";
		
		header('Content-Length: ' . strlen($the_annex));
		header('Content-Type: application/pdf');
		header('Content-Disposition: inline; filename="' . $the_array->nomefile . '"');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		echo $the_annex;
		exit();
		
		
		
		
		]>
	permessi
		ANY

ixmage
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		// a=  altezza (clean)
		// l=  larghezza (clean)
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		
		if( !isset( $_REQUEST['tmp']))
		{
			
			if( !isset( $_REQUEST['data']))
				exit();
			
			// BASE64
			$data = hex2bin( $_REQUEST['data'] );
			// DECRYPT
			$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
			$data = _decrypta( $data, $key );
			if( $data == "***" )
				return "-7 $gbl_idSessione.$gbl_userId";
			// JSON DECODE
			$data = json_decode( $data, true);
			// ARRAY
			$table = $data['t'];
			$id = $data['id'];
			$fieldName = $data['f'];
			
			$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
			if( $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
			{
				$the_array = json_decode($rec[$fieldName]);
				// HEX per ora
				$the_picture = base64_decode( $the_array->datafile ?? "");
				$the_picture = $the_picture != "" ? gzdecode( $the_picture ) : "";
			
				if(( $the_picture == "") || ($the_picture == NULL))
				{
					echo "error 3";
					exit();
				}
			}
			else
				$the_picture = file_get_contents("assets/images/owl.png");
			
		}
		else
		{
			if( $_REQUEST['tmp'] != 2 )
			{
				// ricevo solo il nomePuro, leggo dal database temporaneo
				if( !isset( $_REQUEST['n']))
					return -9;
				$nomePuro = $_REQUEST['n'];
				
				$rec = _dbGet("SELECT * FROM tb_parametro WHERE nome='nome funzione' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione';");
				if( isset( $rec['valore']))
					$gbl_masterFunction = $rec['valore'];
				
				$paginaMaster = sanitize($gbl_masterFunction, "sql", $db_sql);
				$irec = _dbGet("SELECT * FROM tb_parametro WHERE nome='value:{$nomePuro}' AND tb_utente='$gbl_userId' AND tb_sessione='$gbl_idSessione' AND pagina='{$paginaMaster}';");
				if( !isset( $irec['valore']) || $irec['valore'] == "" )
					return -11;
				$the_array = json_decode($irec['valore']);
				$the_picture = base64_decode( $the_array->datafile ?? "");
				$the_picture = $the_picture != "" ? gzdecode( $the_picture ) : "";
				if(( $the_picture == "") || ($the_picture == NULL))
				{
					echo "error 3.3";
					exit();
				}
			}
			else
				$the_picture = file_get_contents("assets/images/owl.png");
		}
		
		$l = 0;
		if( isset( $_REQUEST['l']))
			$l = $_REQUEST['l'];
		$a = 0;
		if( isset( $_REQUEST['a']))
			$a = $_REQUEST['a'];
		
		make_thumb($the_picture, $l, $a);
		
		function resize_image($source_image, $destination_width, $destination_height, $type = 0) { 
		    // $type (1=crop to fit, 2=letterbox) 
		    $source_width = imagesx($source_image); 
		    $source_height = imagesy($source_image); 
		    $source_ratio = $source_width / $source_height; 
		    $destination_ratio = $destination_width / $destination_height; 
		    if ($type == 1) { 
		        // crop to fit 
		        if ($source_ratio > $destination_ratio) { 
		            // source has a wider ratio 
		            $temp_width = (int)($source_height * $destination_ratio); 
		            $temp_height = $source_height; 
		            $source_x = (int)(($source_width - $temp_width) / 2); 
		            $source_y = 0; 
		        } else { 
		            // source has a taller ratio 
		            $temp_width = $source_width; 
		            $temp_height = (int)($source_width / $destination_ratio); 
		            $source_x = 0; 
		            $source_y = (int)(($source_height - $temp_height) / 2); 
		        } 
		        $destination_x = 0; 
		        $destination_y = 0; 
		        $source_width = $temp_width; 
		        $source_height = $temp_height; 
		        $new_destination_width = $destination_width; 
		        $new_destination_height = $destination_height; 
		    } else { 
		        // letterbox 
		        if ($source_ratio < $destination_ratio) { 
		            // source has a taller ratio 
		            $temp_width = (int)($destination_height * $source_ratio); 
		            $temp_height = $destination_height; 
		            $destination_x = (int)(($destination_width - $temp_width) / 2); 
		            $destination_y = 0; 
		        } else { 
		            // source has a wider ratio 
		            $temp_width = $destination_width; 
		            $temp_height = (int)($destination_width / $source_ratio); 
		            $destination_x = 0; 
		            $destination_y = (int)(($destination_height - $temp_height) / 2); 
		        } 
		        $source_x = 0; 
		        $source_y = 0; 
		        $new_destination_width = $temp_width; 
		        $new_destination_height = $temp_height; 
		    } 
		    $destination_image = imagecreatetruecolor(intval($destination_width), intval($destination_height)); 
		    if ($type > 1) { 
		        imagefill($destination_image, 0, 0, imagecolorallocate ($destination_image, 0, 0, 0)); 
		    }
		    imagealphablending($destination_image, false); // setting alpha blending off
		    imagesavealpha($destination_image, true); // save alphablending setting (important)
		
		    imagecopyresampled($destination_image, $source_image, intval($destination_x), intval($destination_y), intval($source_x), intval($source_y), intval($new_destination_width), intval($new_destination_height), intval($source_width), intval($source_height)); 
		    return $destination_image; 
		} 
		
		function make_thumb($src, $destination_width, $destination_height)
		{
		   /* read the source image */
		   $source_image = imagecreatefromstring($src);
		
		   $source_width = imagesx($source_image); 
		   $source_height = imagesy($source_image); 
			
		   if( $destination_width <=0 && $destination_height <= 0) {
			$destination_width = $source_width;
			$destination_height = $source_height;
		   }
		   else
		   {
			if( $destination_width <= 0)
				$destination_width = $source_width*$destination_height/$source_height;
		
			if( $destination_height <= 0)
				$destination_height = $source_height*$destination_width/$source_width;
		
		   }
		
		   $virtual_image = resize_image($source_image, $destination_width, $destination_height, 1); // crop to fit
		
		   header('Content-type: image/png'); 
		   imagepng($virtual_image, NULL, 2);
		   /// imagejpeg($virtual_image, NULL, 80);
		   imagedestroy($source_image); 
		   imagedestroy($virtual_image);
		}
		
		]>
	permessi
		USER
dlanx
	_exe
		<[
		// id= id
		// f=  nome campo
		// t=  nome tabella
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		// ------------------------------------------------------------------------------------
		// Passare una stringa json codificata base64 criptata con un array:
		// t    = table;
		// id   = id;
		// f    = fieldName dell'immagine;
		// ARRAY -> JSON -> ENCRYPT -> BASE64
		// ------------------------------------------------------------------------------------
		if( !isset( $_REQUEST['data']))
			exit();
		
		// BASE64
		$data = hex2bin( $_REQUEST['data'] );
		// DECRYPT
		$key = "alfabeta acqua cheta" . $gbl_idSessione . "." . $gbl_userId;
		$data = _decrypta( $data, $key );
		if( $data == "***" )
			return "-7 $gbl_idSessione.$gbl_userId";
		// JSON DECODE
		$data = json_decode( $data, true);
		// ARRAY
		$table = $data['t'];
		$id = $data['id'];
		$fieldName = $data['f'];
		
		$rec = _dbGet("SELECT $fieldName FROM {$table} WHERE id='{$id}';");
		if( $rec != NULL && $rec[$fieldName] != NULL && $rec[$fieldName] != "" )
		{
			$the_array = json_decode($rec[$fieldName]);
			// HEX per ora
			$the_annex = base64_decode( $the_array->datafile ?? "");
			$the_annex = $the_annex != "" ? gzdecode( $the_annex ) : "";
		
			if(( $the_annex == "") || ($the_annex == NULL))
			{
				echo "error 3";
				exit();
			}
		}
		else
			return "";
		
		if( $the_array->nomefile == "" || $the_annex == NULL )
			return "";
		
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header('Content-Disposition: attachment; filename="' . $the_array->nomefile . '"');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . strlen($the_annex));
		echo $the_annex;
		
		
		
		
		]>
	permessi
		USER

fupload
	permessi
		USER
	_exe
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		if( !isset( $_REQUEST['fn']))
			exit();
		$fn = $_REQUEST['fn'];
		// --------------------------------------------------------
		// DECRITTO PASSED FileName
		$fn = hex2bin( $fn );
		$fn = _decrypta($fn, "AZ$9099" . $gbl_idSessione . $gbl_userId);
		if( $fn == "***" )
			return "";

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header("Content-Transfer-Encoding: Binary"); 
		header('Content-Disposition: attachment; filename="' . basename($fn) . '"');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($fn));
		readfile($fn);
		exit;


		]>

/// ----------------------------------


/// _[PAGINE PROGETTO SPECIFICHE: INTERVENTI]
/// _[PAGINE PROGETTO SPECIFICHE: CRC1]

// _[DASHBOARD ADMIN E ROOT E USER (tutti)]

// ADMINs -----------------------------------------
// _[PAGINE DI CONFIGURAZIONE PER RUOLO ROOT AND ADMIN]
// _[PAGINE DI CONFIGURAZIONE PER RUOLO UTENTE]
// ------------------------------------------------

// NOTIFICHE ROOT
/// fxNotificheRoot
/// _[FX: fxNotificheRoot]

// NOTIFICHE ADMIN
/// fxNotificheAdmin
/// _[FX: fxNotificheAdmin]

// NOTIFICHE USER
/// fxNotificheUser
/// _[FX: fxNotificheUser]

/// _[PAGINE GRAFICI (SONO PREVISTE SOLO PER UTENTE USER)]

edUser_admin

	di tipo
		tbEdit
	permessi
		ADMIN
	getQueryRequested
		return "false";
	getUserId
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		return $gbl_userId;
		]>
	resetStack
		true
	getTableName
		return "tb_utente";
	info
//		nome campo: [0]Caption, [1]Testo Aiuto, [2]Tipo Campo (tx_, mm_, tb_, i_, tm_, dt_, dtt_, anx_, nn_, opt_, psw_), [3]readonly (readonly or "" or other), [4]frontpage (or "" or other)
//					, [5]minChars(0=anyLenght), [6]fa fa-user->icona a fianco testo, [7]masked oppure unmasked, [8]subtype ( any, text, integer, float, currency, date) per ordine in tabella
//					, [9]initialize with f parameter value (true/false)
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome utente, "Nome completo dell'utente, es: Paolo Rossi", tx_, no_readonly, frontpage, 1, fa fa-user, unmasked, text, false
		cf: Codice fiscale, "Codice fiscale es: TINIT-RZZRZO68A40A818X", tx_, no_readonly, frontpage, 1, fa fa-bars, unmasked, text, false
		email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, no_readonly, frontpage, 0, null, unmasked, text, false
			deny duplication: true
		password_hash: Password, "Password utente", psw_, no_readonly, frontpage, 14, fa fa-key, unmasked, any, false
		qualifiche: Qualifiche, "Qualifiche utente separate da uno spazio (es: user, admin ...)", tx_, no_readonly, frontpage, 0, null, unmasked, text, false
		tb_role: Ruolo utente, "Ruolo definito per l'utente. Stabilisce il menù laterale. Es: admin, user", sel_, readonly, frontpage, 0, fa fa-bars, unmasked, text, false
			init: static, 3, hide
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
///			titolo: titolo <- da definirsi se diverso da "titolo"
		tbs_qualifica: Qualifiche Utente, "Qualifiche Utente", sel1_, readonly, frontpage, 0, fa fa-bars, unmasked, text, false
			titolo: nome
			init: static, 1, hide
///			tabella: tb_role <- da definirsi se il nome della tabella è diverso dal nome stesso del campo
///		i_avatar: "Immagine utente", "Immagine dell'utente", i_, no_readonly, frontpage, 0, fa fa-file-image-o, unmasked, any, false
		dt_registrazione: Data di registrazione, "Data di registrazione iniziale", dt_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
		anx_annex: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
//		hidden filter
		hidden filter: "tb_role=3"
//		Indirizzo del pulsante "NEW" o AGGIUNGI
///		addressNew: index.php?fx=whatever
//		disabilita funzionalità. Posizione non rilevante. ["ADD","MODIFY","DELETE","FILTER","EXPORT"]
		disabled: MODIFY, DELETE, ADD
		buttonSave: "Aggiungi", "Aggiungi un nuovo utente alla tabella", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: nome, "CANCELLAZIONE UTENTE", "Vuoi cancellare i dati per l'utente"
//		nome del campo descrittivo principale della tabella
		dbTitle: nome
///		buttonOpt1: fa fa-key, red, index.php?fx=frmPasswordReset, "Reset Password Utente"
//		serve per passare alle funzioni interne il parametro di queryRequested (getQueryRequested) ad esempio per la export. E' false di default
//		queryRequested: false
// [0]: default record numbers (-1 == all) [1]: default field; [2] default ord (DESC/ASC)
//		defaults: 100, id, ASC
///		Titolo della pagina al posto del nome in data project (menu) se presente		
//		headerTitle: "whatever"
//		buttonOpt1: fa fa-user, gray, index.php?fx=whateverFunction(viene aggiunto idCode=encryptedId)
	details
		Quote di iscrizione: type_table, tb_s_doc, "Quote di iscrizione utente", tbEditQuoteDiUtente, tb_utente
///		Documenti utente: type_table, tb_s_doc, "Altri documenti", tbEditDocsDiUtente, tb_utente
///		Tabella Presenze: type_table, tb_presenze, "Elenco Presenze Utente", tbEditPresenzeDiUtente, tb_utente
	subpages
		edit
			info
				email: Email, "Indirizzo email dell'utente. Sarà utilizzato per accedere al sistema", em_, readonly, frontpage, 0, null, unmasked, text, false
				password_hash: Password, "La password non può essere modificata da pannello amministratore, l'utente deve attivare la procedura di recupero password.", psw_, readonly, frontpage, 14, fa fa-key, masked, text, false
	title
		return "Tabella Utenti";
	getIcon
		return "fa fa-users";

tbEditQuoteDiUtente

	di tipo
		tbEdit
	permessi
		ADMIN
	getQueryRequested
		return "true";
	resetStack
		false
	getTableName
		return "tb_s_doc";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome documento, "Nome del documento", tx_, no_readonly, frontpage, 1, fa fa-address-book, unmasked, text, false
		tb_utente: Utente, "Utente a cui è associato questa nota di pagamento", sel_, readonly, frontpage, 0, null, unmasked, text, true
			titolo: nome
		tb_s_tipo_doc: Tipo documento, "Tipo di documento", sel_, readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1, hide
		tb_s_stato_doc: Stato documento, "Stato del documento", sel_, no_readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1
		data: Data documento, "Data del documento", dts_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
			init: current
		doc: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
		hidden filter: "tb_s_tipo_doc=1"
		buttonSave: "Aggiungi un nuovo documento", "Aggiungi un nuovo documento", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: dataLog, "CANCELLAZIONE DOCUMENTO", "Vuoi cancellare questo documento"
		dbTitle: nome
		queryRequested: true
///		buttonOpt1: fa fa-map-marker, #116611, index.php?fx=setPlcPosition, "Posizionamento PLC sulla piantina del sito"
	title
		return "Tabella quote di pagamento";
	getIcon
		return "fa fa-users";






tbTipoDocumenti
	di tipo
		tbEdit
	getQueryRequested
		return "false";
	resetStack
		true
	getTableName
		return "tb_s_tipo_doc";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome del tipo, "Nome del tipo di documento", tx_, no_readonly, frontpage, 1, fa fa-picture, unmasked, text, false
	ancillary
		buttonSave: "Aggiungi", "Aggiungi un nuovo tipo di documento", btn-success
		buttonCancel: "Annulla"
		removeWin: name_id, "CANCELLAZIONE TIPO DOCUMENTO", "Vuoi rimuovere il tipo"
		dbTitle: nome
		/// MODIFY, ADD
		disabled: DELETE

	title
		return "Anagrafica Tipi di Documenti";
	getIcon
		return "fa fa-bars";

/// DOCUMENTI PUBBLICI: GESTIONE ADMIN
edPublicDocs_admin

	di tipo
		tbEdit
	permessi
		ADMIN
	getQueryRequested
		return "false";
	resetStack
		true
	getTableName
		return "tb_s_doc";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome documento, "Nome del documento", tx_, no_readonly, frontpage, 1, fa fa-address-book, unmasked, text, false
		tb_utente: Utente, "Utente a cui è associato questa nota di pagamento", hid_, readonly, no_frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1, hide
		tb_s_tipo_doc: Tipo documento, "Tipo di documento", hid_, readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 5, hide
		tb_s_stato_doc: Stato documento, "Stato del documento", hid_, no_readonly, no_frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1
		data: Data documento, "Data del documento", dts_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
			init: current
		doc: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
		hidden filter: "tb_s_tipo_doc=5"
///		hidden filter: "tb_s_tipo_doc=1 AND tb_utente={{=getUserIdde=}}"
		buttonSave: "Aggiungi un nuovo documento", "Aggiungi un nuovo documento", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: dataLog, "CANCELLAZIONE DOCUMENTO", "Vuoi cancellare questo documento"
		dbTitle: nome
///		queryRequested: true
///		buttonOpt1: fa fa-map-marker, #116611, index.php?fx=setPlcPosition, "Posizionamento PLC sulla piantina del sito"
///		disabled: DELETE, MODIFY, ADD
	title
		return "Elenco documenti pubblici";
	getIcon
		return "fa fa-file-o";



/// ----------------------------------

/// PER SOLI USERS - PRIVATE (per l'utente specifico)
edUserShowPrivateDocs

	di tipo
		tbEdit
	permessi
		USER
	getQueryRequested
		return "false";
	resetStack
		true
	getUserIdde
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			return $gbl_userId;
		]>
	getTableName
		return "tb_s_doc";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome documento, "Nome del documento", tx_, no_readonly, frontpage, 1, fa fa-address-book, unmasked, text, false
		tb_utente: Utente, "Utente a cui è associato questa nota di pagamento", sel_, readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
		tb_s_tipo_doc: Tipo documento, "Tipo di documento", sel_, readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1, hide
		tb_s_stato_doc: Stato documento, "Stato del documento", sel_, no_readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1
		data: Data documento, "Data del documento", dts_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
		doc: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
		hidden filter: "tb_s_tipo_doc=1 AND tb_utente={{=getUserIdde=}}"
		buttonSave: "Aggiungi un nuovo documento", "Aggiungi un nuovo documento", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: dataLog, "CANCELLAZIONE DOCUMENTO", "Vuoi cancellare questo documento"
		dbTitle: nome
///		queryRequested: true
///		buttonOpt1: fa fa-map-marker, #116611, index.php?fx=setPlcPosition, "Posizionamento PLC sulla piantina del sito"
		disabled: DELETE, MODIFY, ADD
	title
		return "Elenco documenti privati";
	getIcon
		return "fa fa-users";




/// PER SOLI USERS - PUBBLICI (per tutti)
edUserShowPublicDocs

	di tipo
		tbEdit
	permessi
		USER
	getQueryRequested
		return "false";
	resetStack
		true
	getUserIdde
		<[
			
			global $gbl_tableName;
			global $gbl_masterFunction;
			global $gbl_userId;
			global $gbl_struct; // info da database (real_type real_lenght)
			global $gbl_fx;
			global $gbl_session; // tb_parametro
			global $db_sql; // link database standard
			// -------------------------------------------
			// raccolta dati utente
			// -------------------------------------------
			global $gbl_url;
			global $db_sql_name;
			global $gbl_nomeTipo;
			global $gbl_infoMenu;
			global $gbl_idSessione;
			global $gbl_nomeCampoTitolo;
			global $db_sql_user;
			global $db_sql_password;
			global $db_sql_host;
			global $gbl_userData;
			global $gbl_query;
			global $gbl_stack;
			global $gbl_father;
			global $gbl_anyFilterOn;
			global $gbl_unicode;
			global $gbl_myFullUrl;
			global $gbl_mainDomain;
			global $gbl_subDomain;
			// ------------------------------
			// 0=devId; 1=validity in seconds
			// Array:
			global $gbl_xsm;
			global $gbl_changePasswordDisabled;
			
			return $gbl_userId;
		]>
	getTableName
		return "tb_s_doc";
	info
		id: Id, "Identificativo Univoco. Assegnato automaticamente", tx_, readonly, frontpage, 0, null, unmasked, integer, false
		nome: Nome documento, "Nome del documento", tx_, no_readonly, frontpage, 1, fa fa-address-book, unmasked, text, false
		tb_utente: Utente, "Utente a cui è associato questa nota di pagamento", sel_, readonly, no_frontpage, 0, null, unmasked, text, false
			titolo: nome
		tb_s_tipo_doc: Tipo documento, "Tipo di documento", sel_, readonly, frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1, hide
		tb_s_stato_doc: Stato documento, "Stato del documento", sel_, no_readonly, no_frontpage, 0, null, unmasked, text, false
			titolo: nome
			init: static, 1
		data: Data documento, "Data del documento", dts_, no_readonly, frontpage, 0, fa fa-bars, unmasked, date, false
		doc: "Allegato", "Allegato", anx_, no_readonly, frontpage, 0, fa fa-file-o, unmasked, text, false
	ancillary
		hidden filter: "tb_s_tipo_doc=5"
///		hidden filter: "tb_s_tipo_doc=1 AND tb_utente={{=getUserIdde=}}"
		buttonSave: "Aggiungi un nuovo documento", "Aggiungi un nuovo documento", btn-success
		buttonCancel: "Annulla"
//		removeWin: campo il cui valore devo mostrare all'utente (non usato, prende il secondo di tabella), nome finestra, testo avviso
		removeWin: dataLog, "CANCELLAZIONE DOCUMENTO", "Vuoi cancellare questo documento"
		dbTitle: nome
///		queryRequested: true
///		buttonOpt1: fa fa-map-marker, #116611, index.php?fx=setPlcPosition, "Posizionamento PLC sulla piantina del sito"
		disabled: DELETE, MODIFY, ADD
	title
		return "Elenco documenti pubblici";
	getIcon
		return "fa fa-users";







/// ATTENZIONE: il file generato è diverso da quello di sistema. Ho modificato tutte le gestione password da 14 a 10.
/// nel caso di modifiche, occorre reinserire manualmente queste modifiche.
/// basta cercare 14 nel file di output e salvarlo su disco DOPO aver fatto la compilazione.

main
	di tipo
		project data
	permessi
		ANY
	generateSpidStructure
		<[
		
			$mapping = $sp->getIdpList();
		
			$ilMapping1 = "";
			if( isset( $mapping && is_array( $mapping) && count( $mapping))
				foreach ($mapping as $key => $value)
					$ilMapping1 .= "'" . $value . "': '" . $key . "',";
		
			$iSupported = "";
			if( isset( $mapping && is_array( $mapping) && count( $mapping))
				foreach ($mapping as $key => $value)
					$iSupported .= "'".$key."',";
		
			$scripto = <<<EOT
				var spid = SPID.init({
					lang: 'it',
					selector: '#spid-button',
					method: 'POST',
						// POST data with the selected IdP will be sent to this URL with the name indicated in fieldName
						// In this case redirect and reuse the provided login example page
					url: 'login',
					fieldName: 'selected_idp',
					// Usiamo il mapping per stabilire la connessione tra idpEntityID
					// e il nome del file XML che contiene i suoi metadati
					mapping: {
						{$ilMapping1}
					},
					// At least one supported IdP must be provided
					supported: [
						{$iSupported}
					],
					// Il campo sarebbe opzionale, ma anche se il mapping contiene testenv, la libreria smart-button sembra 
					// ignorare gli IdP non "ufficiali". extraProviders è quindi obbligatorio se vogliamo usare testenv
					extraProviders: [
										{
											"protocols": ["SAML"],
											"entityName": "Testenv",
											"logo": "spid-idp-testenv2.svg",
											"entityID": "<?php echo $mapping['testenv'] ?>",
											"active": true
										},
						
					],
					protocol: "SAML",
					size: "large"
				});
			EOT;
		
			return $scripto;
		
		
		]>
	BARE FRAME
		<[
			<!doctype html>
			<html class="fixed">
				<head>
			
					<!-- Basic -->
					<meta charset="UTF-8">
					<title>{{=getTitle=}}</title>
					<meta name="keywords" content="{{=getKeywords=}}" />
					<meta name="description" content="{{=getDescription=}}">
					<meta name="author" content="Orazio Rizzo - Creative Software Lab">
			
					<!-- Mobile Metas -->
					<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
			
					<!-- FAVICON -->
					<link rel="shortcut icon" type="image/png" href="<!--relativeDirectory-->{{=getFavicon=}}" />
			
					<!-- Web Fonts  -->
					<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
			
					<!-- Vendor CSS -->
					<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap/css/bootstrap.css" />
					<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/font-awesome/css/font-awesome.css" />
					<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.css" />
					<link rel="stylesheet" href="<!--relativeDirectory-->/vendor/bootstrap-datepicker/css/datepicker3.css" />
			
					<!-- Theme CSS -->
					<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme.css" />
			
					<!-- Skin CSS -->
					<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/skins/default.css" />
			
					<!-- Theme Custom CSS -->
					<link rel="stylesheet" href="<!--relativeDirectory-->/stylesheets/theme-custom.css">
			
			//// SPID ------------------------------------------------------------------------------------------------NEW---------
					<link rel="stylesheet" href="spid-php-lib/cslab/odgtaa/views/spid-smart-button/spid-button.min.css">
			//// SPID ---------------------------------------------------------------------------------------------------------
			       <!-- Load spid-button style and font -->
			/// precedente:
			///   <link rel="stylesheet" href="SPID/spid-sp-access-button/src/production/css/spid-sp-access-button.min.css" />
			/// precedente:
			///		<script src="<!--relativeDirectory-->/vendor/jquery/jquery.js"></script>
			/// nuovo:
					<script src="spid-php-lib/cslab/odgtaa/views/spid-smart-button/spid-button.js"></script>
			//// --------------------------------------------------------------------------------------------------------------
			//// SPID ---------------------------------------------------------------------------------------------------------
			///		<script type="text/javascript" src="SPID/spid-sp-access-button/src/production/js/spid-sp-access-button.min.js"></script>
			//// --------------------------------------------------------------------------------------------------------------
			//// SPID ---------------------------------------------------------------------------------------------------------
			///		<script src="SPID/spid-sp-access-button/src/production/js/spid-idps.js"></script>
			//// --------------------------------------------------------------------------------------------------------------
				<style>
					.spid-idp-button .spid-idp-button-menu li > a img {
						height: 2.8em;
					}
					.spid-idp-button .spid-idp-button-menu li > a {
						font-size: 1.2em;		
						margin-top: 5px;
						margin-bottom: 5px;
						padding-left: 8px;
					}
					.email-button:hover {
						background-color: #003366 !important;
					}
				</style>
				</head>
				<body>
					<!-- start: page -->
					<section class="body-sign">
						<div style="text-align: center;" class="center-sign">
							<div style="width:100%;">
								<a href="https://geologitrentinoaltoadige.it" class="logo">
									<img src="<!--relativeDirectory-->{{=getMainIcon=}}" style="height:45px;" alt="Ordine dei Geologi Trentino Alto Adige" />
								</a>
							</div>
							<h3>Ordine dei Geologi</h3>
							<h5>Trentino Alto Adige - Südtirol</h5>
							<h4 style="font-weight:500;color:black;margin-top:2em;">ACCESSO ALL'AREA RISERVATA</h4>
							<div style="margin: 3em auto;">
								<!-- _[SEZIONE PULSANTE SPID: PRECEDENTE] -->
								
								    <div id ='spid-button' aria-live="polite">
								        <noscript>
								            To use the Spid Smart Button, please enable javascript!
								        </noscript>
								    </div>
								
							</div>
							<div style="margin: 3em auto;">
								
									<div class="email-button" onclick="_goTo('index.php?fx=frameLogin')" style="display: flex; font-size:25px; width:340px; background-color:#06C; color:#FFF; margin: 0 auto; cursor:pointer;">
										<div style="width:90px; margin: 0 -.4em 0 0; padding: 0.6em .8em .5em; border-right: rgba(255,255,255,0.1) 0.1em solid;">
											<i style="margin-top: 0.15em; font-size: 1.5em;" class="fa fa-envelope">
											</i>
										</div>
										<div>
										    <p style="font-family: 'Titillium Web',HelveticaNeue,Helvetica Neue,Helvetica,Arial,Lucida Grande,sans-serif; font-weight:bold;" class="italia-it-button-text"> Entra con EMAIL </p>
										</div>
									</div>
								
							</div>
							<div style="width:100%;">
								<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a> {{=getYear=}}. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
								<p class="text-center text-muted mt-md mb-md">{{=getAnyError=}}</p>
							</div>
						</div>
					</section>
					<!-- end: page -->
			
					<!-- Vendor -->
					<script src="<!--relativeDirectory-->/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
					<script src="<!--relativeDirectory-->/vendor/bootstrap/js/bootstrap.js"></script>
					<script src="<!--relativeDirectory-->/vendor/nanoscroller/nanoscroller.js"></script>
					<script src="<!--relativeDirectory-->/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
					<script src="<!--relativeDirectory-->/vendor/magnific-popup/magnific-popup.js"></script>
					<script src="<!--relativeDirectory-->/vendor/jquery-placeholder/jquery.placeholder.js"></script>
				
					<!-- Head Libs -->
					<script src="<!--relativeDirectory-->/vendor/modernizr/modernizr.js"></script>
			
					<!-- Theme Base, Components and Settings -->
					<script src="<!--relativeDirectory-->/javascripts/theme.js"></script>
					
					<!-- Theme Custom -->
					<script src="<!--relativeDirectory-->/javascripts/theme.custom.js"></script>
					
					<!-- Theme Initialization Files -->
					<script src="<!--relativeDirectory-->/javascripts/theme.init.js"></script>
					<script>
						function _goTo(where){
							window.location.href=where;
						}
					</script>
				</body>
			</html>
			
		]>
	_exe
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		
		if( isset( $_COOKIE['tk_' . $gbl_subDomain]))
		{
			header("Location: index.php?fx=edWelcome");
			exit;
		}
		else
		{
			//1 TORNA ALLA INDEX CHE MANDA ALLA LOGIN PAGE
			header("Location: info.php?i=4");
			exit();
		}
		]>

edMessaggi_admin
	di tipo
		fxMessaggi
	permessi
		ADMIN

edWelcome
	di tipo
		frameMain
	permessi
		USER
	getOctopusMainContent
		<[
		
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		/// _[OCTOPUS CONTENT: MESSAGGI WELCOME]
		// -------------------------------------
		// RACCOLTA PARAMETRI IN INGRESSO,
		// NUMERO DI PAGINA (ix)
		// -------------------------------------
		$ix = 0;
		if( isset($_REQUEST["ix"]))
			$ix = intval($_REQUEST["ix"]);
		// -------------------------------------
		// RACCOLTA PARAMETRI IN INGRESSO,
		// stringa di ricerca (s)
		// -------------------------------------
		$st = "";
		if( isset($_REQUEST["s"]))
			$st = $_REQUEST["s"];
		// --------------------------------------------
		// CARICO TUTTI I MESSAGGI LETTI DA QUESTO
		// UTENTE
		// --------------------------------------------
		$rec = _dbGet("SELECT * FROM tb_messaggioVisualizzato WHERE tb_utente='". sanitize($gbl_userId,"sql",$db_sql) ."'");
		$messaggiLetti = array();
		while( $rec != NULL )
		{
			$messaggiLetti[] = $rec['tb_messaggio'];
			$rec = _dbGet();
		}
		// --------------------------------------------
		// CARICO 5 MESSAGGI
		// --------------------------------------------
		$elencoDeiMessaggi = "";
		$recMessaggi = array();
		$rec = _dbGet("SELECT * FROM tb_messaggio WHERE 1=1 ORDER BY datetime DESC LIMIT 5 OFFSET $ix;");
		while( $rec != NULL )
		{
			if( !isset($rec['tb_tipoMessaggio'] ))
			{
				$rec = _dbGet();
				continue;
			}
		
			if( $st != "" )
			{
				if( !contains(strtolower($rec['titolo']),strtolower($st)) && 
						!contains(strtolower($rec['testo']),strtolower($st)) )
				{
					$rec = _dbGet();
					continue;
				}
			}
		
			$recMessaggi[] = $rec;
			$rec = _dbGet();
		}
		
		foreach( $recMessaggi as $rec )
		{
			$dataOra = dataItaliana2($rec['datetime'], 1);
		
			$isNewMessage = "";
			if( !in_array( $rec['id'], $messaggiLetti))
			{
				$isNewMessage = <<<EOT
					<p class="result-type">
						<span class="label label-primary">New!</span>
					</p>
		EOT;
				$unr = array();
				$unr['tb_messaggio'] = $rec['id'];
				$unr['tb_utente'] = $gbl_userId;
				db_sql_insert_2("tb_messaggioVisualizzato", $unr);
			}
		
			switch( $rec['tb_tipoMessaggio'] )
			{
				case 1:
					
					
					$elencoDeiMessaggi .= <<<EOT
														<li>
															{$isNewMessage}
															<a href="#" class="has-thumb">
																<div class="result-thumb">
																	<i class="{$rec['icona']}"></i>
																</div>
																<div class="result-data">
																	<p class="h3 title text-primary">{$rec['titolo']}</p>
																	<p class="description">
																		<span style="color:#999;"><small>{$dataOra}</small></span>
																		<br/>
																		{$rec['testo']}
																	</p>
																</div>
															</a>
														</li>
					
					EOT;
					
				break;
				case 2:
					
					
					$elencoDeiMessaggi .= <<<EOT
					
														<li>
															{$isNewMessage}
															<a href="#">
																<div class="result-data">
																	<p class="h3 title text-primary">{$rec['titolo']}</p>
																	<p class="description">
																		<span style="color:#999;"><small>{$dataOra}</small></span><br />
																		{$rec['testo']}
																	</p>
																</div>
															</a>
														</li>
					
					EOT;
					
				break;
				default:
				break;
			}
		
			$rec = _dbGet();
		}
		
		$pagination = "";
		// --------------------------------------------
		// CONTO I MESSAGGI
		// --------------------------------------------
		if( $st == "" )
			$numMessaggi = dbQuery("SELECT * FROM tb_messaggio WHERE 1=1;");
		else
			$numMessaggi = dbQuery("SELECT * FROM tb_messaggio WHERE (LOWER(titolo) LIKE LOWER('%" . sanitize($st,"sql",$db_sql) . "%') OR LOWER(testo) LIKE LOWER('%" . sanitize($st,"sql",$db_sql) . "%'));");
		
		if( $ix > ($numMessaggi-1))
			$ix = ($numMessaggi-1);
		
		$numPages = intval($numMessaggi / 5);
		if( intval($numMessaggi % 5))
			$numPages++;
		$numPage = intval($ix / 5);
		
		if( !$numPage )
		{
			$pagination = <<<EOT
				<li class="prev disabled">
					<a href="#">
						<i class="fa fa-chevron-left"></i>
					</a>
				</li>
		EOT;
		}
		else
		{
			$prevPage = ($numPage-1) * 5;
			$pagination = <<<EOT
				<li class="prev">
					<a href="index.php?ix={$prevPage}&s={$st}">
						<i class="fa fa-chevron-left"></i>
					</a>
				</li>
		EOT;
		}	
		
		for( $t=0; $t<$numPages; $t++ )
		{
			$indice = $t * 5;
			$pagina = $t+1;
			if( $t == $numPage )
			{
				$pagination .= <<<EOT
					<li class="active">
						<a href="index.php?ix={$indice}&s={$st}">{$pagina}</a>
					</li>
		EOT;
			}
			else
			{
				$pagination .= <<<EOT
					<li>
						<a href="index.php?ix={$indice}&s={$st}">{$pagina}</a>
					</li>
		EOT;
			}
		}
		
		if( $numPage < ($numPages-1) )
		{
			$nextPage = ($numPage+1) * 5;
			$pagination .= <<<EOT
			<li class="next">
				<a href="index.php?ix={$nextPage}&s={$st}">
					<i class="fa fa-chevron-right"></i>
				</a>
			</li>
		EOT;
		}
		else
		{
			$pagination .= <<<EOT
			<li class="next disabled">
				<a href="#">
					<i class="fa fa-chevron-right"></i>
				</a>
			</li>
		EOT;
		}
		
		
		if( $elencoDeiMessaggi == "" )
			if( $st == "" )
				$elencoDeiMessaggi = "<p>Nessun messaggio presente</p>";
			else
				$elencoDeiMessaggi = "<p>Nessun messaggio selezionato</p>";
		
		$what = <<<EOT
		
							<div class="search-content">
								<div class="search-control-wrapper">
									<form action="index.php?ix={$ix}">
										<div class="form-group">
											<div class="input-group">
												<input type="text" name="s" class="form-control" value="{$st}">
												<span class="input-group-btn">
													<button class="btn btn-primary" type="button">Cerca</button>
												</span>
											</div>
										</div>
									</form>
								</div>
								<div class="tab-content">
									<div id="everything" class="tab-pane active">
										<ul class="list-unstyled search-results-list" style="padding-top: 16px;">
		
										{$elencoDeiMessaggi}				
		
										</ul>
		
										<hr class="solid mb-none" />
		
										<ul class="pagination">
										{$pagination}
										</ul>
									</div>
								</div>
							</div>
							<!-- end: page -->
		EOT;
		
		return $what;
		
		
		
		]>
	innerWrapperStyle
		style="background-color:white;"

/// OVERRIDDEN
cmdLogout
	di tipo
		project data
	_do
		<[
		
		global $gbl_tableName;
		global $gbl_masterFunction;
		global $gbl_userId;
		global $gbl_struct; // info da database (real_type real_lenght)
		global $gbl_fx;
		global $gbl_session; // tb_parametro
		global $db_sql; // link database standard
		// -------------------------------------------
		// raccolta dati utente
		// -------------------------------------------
		global $gbl_url;
		global $db_sql_name;
		global $gbl_nomeTipo;
		global $gbl_infoMenu;
		global $gbl_idSessione;
		global $gbl_nomeCampoTitolo;
		global $db_sql_user;
		global $db_sql_password;
		global $db_sql_host;
		global $gbl_userData;
		global $gbl_query;
		global $gbl_stack;
		global $gbl_father;
		global $gbl_anyFilterOn;
		global $gbl_unicode;
		global $gbl_myFullUrl;
		global $gbl_mainDomain;
		global $gbl_subDomain;
		// ------------------------------
		// 0=devId; 1=validity in seconds
		// Array:
		global $gbl_xsm;
		global $gbl_changePasswordDisabled;
		
		setcookie("tk_" . $gbl_subDomain, "", time() -3600, "/", "$gbl_mainDomain", true, true);
		setcookie("tkS_" . $gbl_subDomain, "", time() -3600, "/", "$gbl_mainDomain", true, true);
		session_unset();
		
		/// -----------------------------------------------------------------------------
		/// A PRESCINDERE, CANCELLO TUTTI I PARAMETRI DI SESSIONE SE LA SESSIONE STESSA
		/// E' SCADUTA. SCELGO COME MOMENTO I LOGIN DEI CLIENTI.
		/// TUTTI I LOGIN CAUSANO LA CANCELLAZIONE DELLE VECCHIE SESSIONI SCADUTE
		/// LE SESSIONI DURANO 30 GIORNI E VENGONO RIUTILIZZATE QUINDI NON SI CORRE IL
		/// RISCHIO CHE UNA SESSIONE SIA CANCELLATA PER ERRORE (AD OGNI CHIAMATA DI INDEX
		/// IL TEMPO DI SESSIONE VIENE RIPRISTINATO (A 30 GG).
		/// -----------------------------------------------------------------------------
		dbQuery("DELETE FROM tb_parametro WHERE tb_sessione='$gbl_idSessione';");
		dbQuery("DELETE FROM tb_sessione WHERE id='$gbl_idSessione';");
		
		
		
		
		header("Location: info.php?i=5");
		exit();
		]>


