
async function main() {
	const providers = await generate_providers_list()
	const part = await read("/var/www/html/spid-php-lib/cslab/odgtaa/views/spid-smart-button/main-body.part")
	const def = part.replace("<<<**CHANGEIT**>>>", providers)
	write(def, "/var/www/html/spid-php-lib/cslab/odgtaa/views/spid-smart-button/spid-button.js")
}

async function generate_providers_list(){
	const fs = require('fs');
	const data = await GET("https://registry.spid.gov.it/entities-idp?&output=json")
	const providers = data.map(el=>{
		return {
			protocols: ["SAML"],
			entityName: el['organization_name'],                                
			logo: el['logo_uri'],                        
			entityID: el['entity_id'],                
			active: !0  
		}
	})
	return JSON.stringify(providers)
}

async function GET(url){
	return new Promise(resolve=>{
		fetch(url).then(res=>{
			resolve(res.json())
		})
	})
}

async function read(path) {
	const fs = require('fs');

	return new Promise(resolve=>{
		fs.readFile(path, 'utf8', (err, data) => {
			if (err) {
				console.error(err);
				resolve(false)
			}
			resolve(data)
		});
	})
}

function write(text, path) {
	const fs = require('fs')

	fs.writeFile(path, text, err => {
		if (err) {
			console.error(err)
			return
		}
		//file written successfully
		console.log(`file ${path} written successfully`)
	})
}

main()
