<?php
$mapping = $sp->getIdpList();
?>

<!doctype html>
<html class="fixed">
	<head>
		<!-- Basic -->
		<meta charset="UTF-8">
		<title><?php echo $c_page_title; ?></title>
		<meta name="keywords" content="<?php echo $c_page_keywords; ?>" />
		<meta name="description" content="<?php echo $c_page_description; ?>" />
		<meta name="author" content="Orazio Rizzo - Creative Software Lab" />

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

		<!-- FAVICON -->
		<link rel="shortcut icon" type="image/png" href="./sia/octopus/assets/images/favicon.png" />

		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="./sia/octopus/assets/vendor/bootstrap/css/bootstrap.css" />
		<link rel="stylesheet" href="./sia/octopus/assets/vendor/font-awesome/css/font-awesome.css" />
		<link rel="stylesheet" href="./sia/octopus/assets/vendor/magnific-popup/magnific-popup.css" />
		<link rel="stylesheet" href="./sia/octopus/assets/vendor/bootstrap-datepicker/css/datepicker3.css" />

		<!-- Theme CSS -->
		<link rel="stylesheet" href="./sia/octopus/assets/stylesheets/theme.css" />

		<!-- Skin CSS -->
		<link rel="stylesheet" href="./sia/octopus/assets/stylesheets/skins/default.css" />

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="./sia/octopus/assets/stylesheets/theme-custom.css">

		<link rel="stylesheet" href="./views/spid-smart-button/spid-button.min.css">
		<script src="./sia/octopus/assets/vendor/jquery/jquery.js"></script>
		<script src="./views/spid-smart-button/spid-button.js"></script>

		<style>
			.spid-idp-button .spid-idp-button-menu li > a img {
				height: 2.8em;
			}
			.spid-idp-button .spid-idp-button-menu li > a {
				font-size: 1.2em;		
				margin-top: 5px;
				margin-bottom: 5px;
				padding-left: 8px;
			}
			.email-button:hover {
				background-color: #003366 !important;
			}
			.agid-spid-enter-icon { visibility: hidden; }
			.agid-spid-enter-text { visibility: hidden; }
			.agid-spid-enter-button-rounded
			{ 
				width:280px !important;
				height:56px !important;
				margin: 0 auto;
				background-color: transparent; 
				border-radius:0;
				background-size: contain;
				background-repeat: no-repeat;
				background-image: url('./views/spid-smart-button/img/new/spid-button-link-link.png');
			}
			.agid-spid-enter-button-rounded:hover
			{ 
				width:280px !important;
				height:56px !important;
				background-image: url('./views/spid-smart-button/img/new/spid-button-link-hover.png');
				background-size: contain;
				background-repeat: no-repeat;
				background-color: #003366;
			}
			.spid-enter-button-container
			{
			}

		</style>
	</head>
	<body>
		<!-- start: page -->
		<section class="body-sign">
			<div style="text-align: center;" class="center-sign">
				<div style="width:100%;">
					<a href="<?php echo $c_home_page_address; ?>" class="logo">
						<img src="./sia/octopus/assets/images/<?php echo $c_main_icon; ?>" style="height:90px;" alt="<?php echo $c_page_title; ?>" />
					</a>
				</div>
				<h3><?php echo $c_titolo; ?></h3>
				<h5><?php echo $c_sottoTitolo; ?></h5>
				<h4 style="font-weight:500;color:black;margin-top:2em;">ACCESSO ALL'AREA RISERVATA</h4>
				<div style="margin: 3em auto;">

					<div id ='spid-button' aria-live="polite">
						<noscript>
							To use the Spid Smart Button, please enable javascript!
						</noscript>
					</div>

				</div>
				<div style="">
					<p>
						SPID è il sistema di accesso che consente di utilizzare, con un'identità digitale unica, i servizi online della Pubblica Amministrazione e dei privati accreditati. Se sei già in possesso di un'identità digitale, accedi con le credenziali del tuo gestore. Se non hai ancora un'identità digitale, richiedila ad uno dei gestori.
					</p>
				</div>
				<div>
					<img src="./sia/assets/images/spid-agid-logo.png" alt="AgID" />
				</div>
				<div style="width:100%;">
					<p class="text-center text-muted mt-md mb-md">&copy; <a href="https://creativesoftwarelab.com">Creative Software Lab</a><?php date("Y"); ?>. All rights reserved. Template by <a href="https://colorlib.com">Colorlib</a>.</p>
					<p class="text-center text-muted mt-md mb-md"><?php echo $c_eventualeErrore; ?></p>
				</div>
			</div>
		</section>
		<!-- end: page -->

		<!-- Vendor -->
		<script src="./sia/octopus/assets/vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
		<script src="./sia/octopus/assets/vendor/bootstrap/js/bootstrap.js"></script>
		<script src="./sia/octopus/assets/vendor/nanoscroller/nanoscroller.js"></script>
		<script src="./sia/octopus/assets/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
		<script src="./sia/octopus/assets/vendor/magnific-popup/magnific-popup.js"></script>
		<script src="./sia/octopus/assets/vendor/jquery-placeholder/jquery.placeholder.js"></script>
	
		<!-- Head Libs -->
		<script src="./sia/octopus/assets/vendor/modernizr/modernizr.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="./sia/octopus/assets/javascripts/theme.js"></script>
		
		<!-- Theme Custom -->
		<script src="./sia/octopus/assets/javascripts/theme.custom.js"></script>
		
		<!-- Theme Initialization Files -->
		<script src="./sia/octopus/assets/javascripts/theme.init.js"></script>
		<script>
			function _goTo(where){
				window.location.href=where;
			}
		</script>
		
		    <script>
		    var spid = SPID.init({
		        lang: 'it',
		        selector: '#spid-button',
		        method: 'POST',
		        // POST data with the selected IdP will be sent to this URL with the name indicated in fieldName
		        // In this case redirect and reuse the provided login example page
		        url: 'login',
		        fieldName: 'selected_idp',
		        // Usiamo il mapping per stabilire la connessione tra idpEntityID
		        // e il nome del file XML che contiene i suoi metadati
		        mapping: {
		            <?php
		            foreach ($mapping as $key => $value) {
		                echo "'" . $value . "': '" . $key . "',";
		            }
		            ?>
		        },
		        // At least one supported IdP must be provided
		        supported: [
		            <?php
		            foreach ($mapping as $key => $value) {
		                echo "'".$key."',";
		            }
		            ?>
		        ],
		        // Il campo sarebbe opzionale, ma anche se il mapping contiene testenv, la libreria smart-button sembra 
		        // ignorare gli IdP non "ufficiali". extraProviders è quindi obbligatorio se vogliamo usare testenv
		        extraProviders: [
		///			_[ARCHIVIO TESTENV]
			],
		        protocol: "SAML",
		        size: "large"
		    });
		    </script>
		
	</body>
</html>



